/*
 * Decompiled with CFR 0.152.
 */
package com.dolthhaven.easeldoesit.common.block;

import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VillagerStatueBlock
extends Block {
    public static EnumProperty<DoubleBlockHalf> HALF = BlockStateProperties.f_61401_;
    public static DirectionProperty FACING = BlockStateProperties.f_61372_;
    private static final VoxelShape TOP_SHAPE_NS;
    private static final VoxelShape TOP_SHAPE_WE;
    private static final VoxelShape BOTTOM_SHAPE_NS;
    private static final VoxelShape BOTTOM_SHAPE_WE;

    public VillagerStatueBlock(BlockBehaviour.Properties props) {
        super(props);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_(HALF, (Comparable)DoubleBlockHalf.LOWER)).m_61124_((Property)FACING, (Comparable)Direction.NORTH));
    }

    protected void m_7926_(@NotNull StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{HALF}).m_61104_(new Property[]{FACING});
    }

    @NotNull
    public BlockState m_6843_(BlockState state, Rotation rotation) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)rotation.m_55954_((Direction)state.m_61143_((Property)FACING)));
    }

    @NotNull
    public BlockState m_6943_(BlockState state, Mirror mirror) {
        return state.m_60717_(mirror.m_54846_((Direction)state.m_61143_((Property)FACING)));
    }

    @NotNull
    public VoxelShape m_5940_(@NotNull BlockState state, @NotNull BlockGetter p_60556_, @NotNull BlockPos p_60557_, @NotNull CollisionContext p_60558_) {
        if (state.m_61143_(HALF) == DoubleBlockHalf.LOWER) {
            return switch ((Direction)state.m_61143_((Property)FACING)) {
                case Direction.NORTH, Direction.SOUTH -> BOTTOM_SHAPE_NS;
                default -> BOTTOM_SHAPE_WE;
            };
        }
        return switch ((Direction)state.m_61143_((Property)FACING)) {
            case Direction.NORTH, Direction.SOUTH -> TOP_SHAPE_NS;
            default -> TOP_SHAPE_WE;
        };
    }

    @Nullable
    public BlockEntity newBlockEntity(@NotNull BlockPos pos, @NotNull BlockState state) {
        return null;
    }

    @NotNull
    public BlockState m_7417_(BlockState state, Direction direction, @NotNull BlockState changedState, @NotNull LevelAccessor level, @NotNull BlockPos changedPos, @NotNull BlockPos p_52899_) {
        DoubleBlockHalf doubleblockhalf = (DoubleBlockHalf)state.m_61143_(HALF);
        if (direction.m_122434_() != Direction.Axis.Y || doubleblockhalf == DoubleBlockHalf.LOWER != (direction == Direction.UP) || changedState.m_60713_((Block)this) && changedState.m_61143_(HALF) != doubleblockhalf) {
            return doubleblockhalf == DoubleBlockHalf.LOWER && direction == Direction.DOWN && !state.m_60710_((LevelReader)level, changedPos) ? Blocks.f_50016_.m_49966_() : super.m_7417_(state, direction, changedState, level, changedPos, p_52899_);
        }
        return Blocks.f_50016_.m_49966_();
    }

    public boolean m_7898_(BlockState state, @NotNull LevelReader level, @NotNull BlockPos pos) {
        if (state.m_61143_(HALF) != DoubleBlockHalf.UPPER) {
            return super.m_7898_(state, level, pos);
        }
        BlockState blockstate = level.m_8055_(pos.m_7495_());
        if (state.m_60734_() != this) {
            return super.m_7898_(state, level, pos);
        }
        return blockstate.m_60713_((Block)this) && blockstate.m_61143_(HALF) == DoubleBlockHalf.LOWER;
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        BlockState placeState;
        BlockPos blockpos = context.m_8083_();
        Level level = context.m_43725_();
        BlockState aboveState = level.m_8055_(blockpos.m_7494_());
        if (!level.m_151570_(blockpos) && aboveState.m_60629_(context) && Objects.nonNull(placeState = super.m_5573_(context))) {
            return (BlockState)placeState.m_61124_((Property)FACING, (Comparable)context.m_8125_().m_122424_());
        }
        return null;
    }

    public void m_6402_(@NotNull Level level, @NotNull BlockPos pos, @NotNull BlockState state, LivingEntity entity, @NotNull ItemStack stack) {
        BlockPos blockpos = pos.m_7494_();
        Direction facing = (Direction)state.m_61143_((Property)FACING);
        level.m_7731_(blockpos, (BlockState)((BlockState)this.m_49966_().m_61124_(HALF, (Comparable)DoubleBlockHalf.UPPER)).m_61124_((Property)FACING, (Comparable)facing), 3);
    }

    public void m_5707_(Level p_52878_, @NotNull BlockPos pos, @NotNull BlockState state, @NotNull Player player) {
        if (!p_52878_.f_46443_) {
            if (player.m_7500_()) {
                VillagerStatueBlock.preventCreativeDropFromBottomPart(p_52878_, pos, state, player);
            } else {
                VillagerStatueBlock.m_49881_((BlockState)state, (Level)p_52878_, (BlockPos)pos, null, (Entity)player, (ItemStack)player.m_21205_());
            }
        }
        super.m_5707_(p_52878_, pos, state, player);
    }

    public void m_6240_(@NotNull Level p_52865_, @NotNull Player p_52866_, @NotNull BlockPos p_52867_, @NotNull BlockState p_52868_, @javax.annotation.Nullable BlockEntity p_52869_, @NotNull ItemStack p_52870_) {
        super.m_6240_(p_52865_, p_52866_, p_52867_, Blocks.f_50016_.m_49966_(), p_52869_, p_52870_);
    }

    protected static void preventCreativeDropFromBottomPart(Level level, BlockPos pos, BlockState state, Player player) {
        BlockPos blockpos;
        BlockState blockstate;
        DoubleBlockHalf doubleblockhalf = (DoubleBlockHalf)state.m_61143_(HALF);
        if (doubleblockhalf == DoubleBlockHalf.UPPER && (blockstate = level.m_8055_(blockpos = pos.m_7495_())).m_60713_(state.m_60734_()) && blockstate.m_61143_(HALF) == DoubleBlockHalf.LOWER) {
            BlockState emptyState = blockstate.m_60819_().m_192917_((Fluid)Fluids.f_76193_) ? Blocks.f_49990_.m_49966_() : Blocks.f_50016_.m_49966_();
            level.m_7731_(blockpos, emptyState, 35);
            level.m_5898_(player, 2001, blockpos, Block.m_49956_((BlockState)blockstate));
        }
    }

    static {
        BOTTOM_SHAPE_NS = Shapes.m_83113_((VoxelShape)Block.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)1.0, (double)15.0), (VoxelShape)Block.m_49796_((double)4.0, (double)1.0, (double)6.0, (double)12.0, (double)16.0, (double)10.0), (BooleanOp)BooleanOp.f_82695_);
        BOTTOM_SHAPE_WE = Shapes.m_83113_((VoxelShape)Block.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)1.0, (double)15.0), (VoxelShape)Block.m_49796_((double)6.0, (double)1.0, (double)4.0, (double)10.0, (double)16.0, (double)12.0), (BooleanOp)BooleanOp.f_82695_);
        TOP_SHAPE_NS = Shapes.m_83113_((VoxelShape)Block.m_49796_((double)4.0, (double)10.0, (double)4.0, (double)12.0, (double)20.0, (double)12.0), (VoxelShape)Block.m_49796_((double)4.0, (double)0.0, (double)5.0, (double)12.0, (double)10.0, (double)11.0), (BooleanOp)BooleanOp.f_82695_);
        TOP_SHAPE_WE = Shapes.m_83113_((VoxelShape)Block.m_49796_((double)4.0, (double)10.0, (double)4.0, (double)12.0, (double)20.0, (double)12.0), (VoxelShape)Block.m_49796_((double)5.0, (double)0.0, (double)4.0, (double)11.0, (double)10.0, (double)12.0), (BooleanOp)BooleanOp.f_82695_);
    }
}

