/*
 * Decompiled with CFR 0.152.
 */
package party.lemons.biomemakeover.network;

import dev.architectury.networking.NetworkManager;
import dev.architectury.networking.simple.BaseS2CMessage;
import dev.architectury.networking.simple.MessageType;
import net.minecraft.client.Minecraft;
import net.minecraft.client.ParticleStatus;
import net.minecraft.client.particle.Particle;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import party.lemons.biomemakeover.init.BMEffects;
import party.lemons.biomemakeover.init.BMItems;
import party.lemons.biomemakeover.init.BMNetwork;
import party.lemons.biomemakeover.util.ClientUtil;

public class S2C_DoLightningSplash
extends BaseS2CMessage {
    private BlockPos pos;
    private boolean doBottle;

    public S2C_DoLightningSplash(boolean doBottle, BlockPos pos) {
        this.pos = pos;
        this.doBottle = doBottle;
    }

    public S2C_DoLightningSplash(FriendlyByteBuf buf) {
        this.doBottle = buf.readBoolean();
        this.pos = buf.m_130135_();
    }

    public MessageType getType() {
        return BMNetwork.LIGHTNING_SPLASH;
    }

    public void write(FriendlyByteBuf buf) {
        buf.writeBoolean(this.doBottle);
        buf.m_130064_(this.pos);
    }

    public void handle(NetworkManager.PacketContext context) {
        context.queue(() -> {
            Vec3 dir = Vec3.m_82539_((Vec3i)this.pos);
            RandomSource random = context.getPlayer().m_217043_();
            Level level = context.getPlayer().m_9236_();
            if (this.doBottle) {
                for (int i = 0; i < 8; ++i) {
                    level.m_7106_((ParticleOptions)new ItemParticleOption(ParticleTypes.f_123752_, new ItemStack((ItemLike)BMItems.LIGHTNING_BOTTLE.get())), dir.f_82479_, dir.f_82480_, dir.f_82481_, random.m_188583_() * 0.15, random.m_188500_() * 0.2, random.m_188583_() * 0.15);
                }
                level.m_5594_(null, this.pos, SoundEvents.f_12436_, SoundSource.NEUTRAL, 1.0f, random.m_188501_() * 0.1f + 0.9f);
            }
            ParticleOptions particleEffect = (ParticleOptions)BMEffects.LIGHTNING_SPARK.get();
            ParticleStatus mode = (ParticleStatus)Minecraft.m_91087_().f_91066_.m_231929_().m_231551_();
            int particleCount = mode == ParticleStatus.ALL ? 100 : (mode == ParticleStatus.DECREASED ? 50 : 10);
            for (int i = 0; i < particleCount; ++i) {
                double direction = random.m_188500_() * 4.0;
                double ac = random.m_188500_() * Math.PI * 2.0;
                double xVel = Math.cos(ac) * direction * 0.1;
                double yVel = 0.01 + random.m_188500_() * 0.5;
                double zVel = Math.sin(ac) * direction * 0.1;
                Particle particle = ClientUtil.spawnParticle(particleEffect, particleEffect.m_6012_().m_123742_(), true, dir.f_82479_ + xVel * 0.01, dir.f_82480_ + 0.3, dir.f_82481_ + zVel * 0.01, xVel, yVel, zVel);
                if (particle == null) continue;
                particle.m_107268_((float)direction);
            }
        });
    }
}

