/*
 * Decompiled with CFR 0.152.
 */
package party.lemons.biomemakeover.level.feature.mansion.room;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePiecesBuilder;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;
import party.lemons.biomemakeover.level.feature.mansion.MansionDetails;
import party.lemons.biomemakeover.level.feature.mansion.MansionFeature;
import party.lemons.biomemakeover.level.feature.mansion.MansionTemplateType;
import party.lemons.biomemakeover.level.feature.mansion.MansionTemplates;
import party.lemons.biomemakeover.level.feature.mansion.RoomType;
import party.lemons.biomemakeover.level.feature.mansion.room.MansionRoom;
import party.lemons.taniwha.util.collections.Grid;

public class BigMansionRoom
extends MansionRoom {
    private boolean isDummy;
    private Direction partnerDirection;
    private BlockPos partnerPos;

    public BigMansionRoom(BlockPos position, Direction partnerDirection, boolean isDummy) {
        super(position, isDummy ? RoomType.ROOM_BIG_DUMMY : RoomType.ROOM_BIG);
        this.isDummy = isDummy;
        this.partnerDirection = partnerDirection;
        this.partnerPos = position.m_121945_(partnerDirection);
    }

    @Override
    public Rotation getRotation(RandomSource random) {
        if (this.isDummy()) {
            return Rotation.NONE;
        }
        switch (this.partnerDirection) {
            case NORTH: {
                return Rotation.COUNTERCLOCKWISE_90;
            }
            case SOUTH: {
                return Rotation.CLOCKWISE_90;
            }
            case WEST: {
                return Rotation.CLOCKWISE_180;
            }
            case EAST: {
                return Rotation.NONE;
            }
        }
        return Rotation.NONE;
    }

    @Override
    public ResourceLocation getTemplate(MansionTemplates templates, RandomSource random) {
        if (this.isDummy()) {
            return MansionTemplateType.EMPTIES.getRandomTemplate(templates, random);
        }
        return MansionTemplateType.ROOMS_BIG.getRandomTemplate(templates, random);
    }

    public boolean isDummy() {
        return this.isDummy;
    }

    @Override
    public void addWalls(MansionDetails details, MansionTemplates templates, RandomSource random, BlockPos wallPos, StructureTemplateManager manager, Grid<MansionRoom> roomGrid, StructurePiecesBuilder children) {
        boolean ground;
        boolean bl = ground = this.getPosition().m_123342_() == 0;
        if (this.getRoomType().hasWalls()) {
            BlockPos cornerPos1;
            if (this.isConnected(Direction.NORTH)) {
                this.addWall(details, Direction.NORTH, manager, children, this.getInnerWall(templates, random), wallPos.m_5484_(Direction.NORTH, 2), Rotation.NONE, ground);
            } else if (!roomGrid.contains(this.getPosition().m_122012_()) || !((MansionRoom)roomGrid.get(this.getPosition().m_122012_())).getRoomType().hasWalls()) {
                children.m_142679_((StructurePiece)new MansionFeature.Piece(details, manager, this.getOuterWall(templates, Direction.NORTH, roomGrid, random), wallPos.m_5484_(Direction.EAST, 11), Rotation.CLOCKWISE_180, ground, true));
            } else if (roomGrid.contains(this.getPosition().m_122012_())) {
                this.addWall(details, Direction.NORTH, manager, children, this.getFlatWall(templates, random), wallPos.m_5484_(Direction.NORTH, 2), Rotation.NONE, ground);
            }
            if (this.isConnected(Direction.WEST)) {
                this.addWall(details, Direction.WEST, manager, children, this.getInnerWall(templates, random), wallPos, Rotation.CLOCKWISE_90, ground);
            } else if (!roomGrid.contains(this.getPosition().m_122024_()) || !((MansionRoom)roomGrid.get(this.getPosition().m_122024_())).getRoomType().hasWalls()) {
                children.m_142679_((StructurePiece)new MansionFeature.Piece(details, manager, this.getOuterWall(templates, Direction.WEST, roomGrid, random), wallPos.m_122012_(), Rotation.CLOCKWISE_90, ground, true));
            } else if (roomGrid.contains(this.getPosition().m_122024_())) {
                this.addWall(details, Direction.WEST, manager, children, this.getFlatWall(templates, random), wallPos, Rotation.CLOCKWISE_90, ground);
            }
            if (!roomGrid.contains(this.getPosition().m_122029_()) || !((MansionRoom)roomGrid.get(this.getPosition().m_122029_())).getRoomType().hasWalls()) {
                children.m_142679_((StructurePiece)new MansionFeature.Piece(details, manager, this.getOuterWall(templates, Direction.EAST, roomGrid, random), wallPos.m_5484_(Direction.EAST, 11).m_122024_().m_122020_(11), Rotation.COUNTERCLOCKWISE_90, ground, true));
            }
            if (!roomGrid.contains(this.getPosition().m_122019_()) || !((MansionRoom)roomGrid.get(this.getPosition().m_122019_())).getRoomType().hasWalls()) {
                children.m_142679_((StructurePiece)new MansionFeature.Piece(details, manager, this.getOuterWall(templates, Direction.SOUTH, roomGrid, random), wallPos.m_5484_(Direction.SOUTH, 10).m_122024_(), Rotation.NONE, ground, true));
            }
            if (roomGrid.contains(cornerPos1 = this.getPosition().m_121945_(Direction.NORTH).m_121945_(Direction.WEST)) && ((MansionRoom)roomGrid.get(cornerPos1)).getRoomType().hasWalls()) {
                children.m_142679_((StructurePiece)new MansionFeature.Piece(details, manager, MansionTemplateType.CORNER_FILLERS.getRandomTemplate(templates, random).toString(), wallPos.m_121945_(Direction.WEST).m_121945_(Direction.NORTH).m_7918_(0, 0, 0), Rotation.NONE, ground, false));
            }
        }
    }

    private void addWall(MansionDetails details, Direction direction, StructureTemplateManager manager, StructurePiecesBuilder children, String wall, BlockPos pos, Rotation rotation, boolean ground) {
        if (direction == this.partnerDirection) {
            return;
        }
        children.m_142679_((StructurePiece)new MansionFeature.Piece(details, manager, wall, pos, rotation, ground, false));
    }
}

