/*
 * Decompiled with CFR 0.152.
 */
package party.lemons.biomemakeover.level;

import com.google.common.collect.Maps;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BellBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ButtonBlock;
import net.minecraft.world.level.block.DaylightDetectorBlock;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.FenceGateBlock;
import net.minecraft.world.level.block.LeverBlock;
import net.minecraft.world.level.block.NoteBlock;
import net.minecraft.world.level.block.TrapDoorBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockSetType;
import net.minecraft.world.level.block.state.properties.NoteBlockInstrument;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.WoodType;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import org.jetbrains.annotations.Nullable;
import party.lemons.biomemakeover.init.BMEffects;
import party.lemons.biomemakeover.network.S2C_DoPoltergeistParticle;
import party.lemons.taniwha.block.BlockSetHolder;
import party.lemons.taniwha.block.WoodTypeHolder;

public class PoltergeistHandler {
    private static final Map<TagKey<Block>, PoltergeistBehaviour> BEHAVIOUR_TAG = Maps.newHashMap();
    private static final Map<Block, PoltergeistBehaviour> BEHAVIOUR_BLOCK = Maps.newHashMap();

    public static void doPoltergeist(Level level, @Nullable Entity poltergeist, BlockPos pos, int range) {
        int volume = range * range * range;
        int geistIndex = level.f_46441_.m_188503_(volume);
        int half = range / 2;
        int pZ = geistIndex % range;
        int pY = geistIndex / range % range;
        int pX = geistIndex / (range * range);
        BlockPos checkPos = new BlockPos((pX += pos.m_123341_()) - half, (pY += pos.m_123342_()) - half, (pZ += pos.m_123343_()) - half);
        if (PoltergeistHandler.doBehaviour(level, poltergeist, checkPos)) {
            RandomSource random = level.f_46441_;
            PoltergeistHandler.doParticles(level, checkPos);
            float pitch = random.m_188501_() * 0.4f + random.m_188501_() > 0.9f ? 0.6f : 0.0f;
            level.m_5594_(null, pos, BMEffects.POLTERGEIST_ACTION.get(), SoundSource.BLOCKS, pitch, 0.6f + random.m_188501_() * 0.4f);
        }
    }

    public static void doParticles(Level world, BlockPos pos) {
        if (!world.m_5776_()) {
            new S2C_DoPoltergeistParticle(pos).sendToChunkListeners(world.m_46745_(pos));
        }
    }

    public static boolean doBehaviour(Level level, @Nullable Entity poltergeist, BlockPos pos) {
        BlockState state = level.m_8055_(pos);
        Block bl = state.m_60734_();
        if (state.m_60795_() || state.m_60713_(Blocks.f_50069_)) {
            return false;
        }
        if (BEHAVIOUR_BLOCK.containsKey(bl)) {
            return BEHAVIOUR_BLOCK.get(bl).handle(level, poltergeist, pos, state);
        }
        for (TagKey<Block> tag : BEHAVIOUR_TAG.keySet()) {
            if (!state.m_204336_(tag)) continue;
            return BEHAVIOUR_TAG.get(tag).handle(level, poltergeist, pos, state);
        }
        return false;
    }

    public static void registerBehaviour(TagKey<Block> blockTag, PoltergeistBehaviour behaviour) {
        BEHAVIOUR_TAG.put(blockTag, behaviour);
    }

    public static void registerBehaviour(Block block, PoltergeistBehaviour behaviour) {
        BEHAVIOUR_BLOCK.put(block, behaviour);
    }

    public static void init() {
    }

    static {
        PoltergeistHandler.registerBehaviour((TagKey<Block>)BlockTags.f_13103_, (Level level, Entity poltergeist, BlockPos pos, BlockState state) -> {
            BlockSetType type = BlockSetHolder.get((Block)state.m_60734_());
            if (type != null && !type.f_278463_()) {
                return false;
            }
            BlockState newState = (BlockState)state.m_61122_((Property)DoorBlock.f_52727_);
            level.m_7731_(pos, newState, 10);
            if (type != null) {
                level.m_5594_(null, pos, (Boolean)state.m_61143_((Property)DoorBlock.f_52727_) != false ? type.f_271141_() : type.f_271502_(), SoundSource.BLOCKS, 1.0f, level.m_213780_().m_188501_() * 0.1f + 0.9f);
            } else {
                int sound = (Boolean)state.m_61143_((Property)DoorBlock.f_52727_) != false ? 1012 : 1006;
                level.m_5898_(null, sound, pos, 0);
            }
            level.m_142346_(poltergeist, (Boolean)state.m_61143_((Property)DoorBlock.f_52727_) != false ? GameEvent.f_157796_ : GameEvent.f_157793_, pos);
            return true;
        });
        PoltergeistHandler.registerBehaviour((TagKey<Block>)BlockTags.f_13093_, (Level level, Entity poltergeist, BlockPos pos, BlockState state) -> {
            if (((Boolean)state.m_61143_((Property)ButtonBlock.f_51045_)).booleanValue()) {
                return false;
            }
            ((ButtonBlock)state.m_60734_()).m_51116_(state, level, pos);
            level.m_5594_(null, pos, SoundEvents.f_12632_, SoundSource.BLOCKS, 0.3f, 0.6f);
            level.m_142346_(poltergeist, GameEvent.f_223702_, pos);
            return true;
        });
        PoltergeistHandler.registerBehaviour((TagKey<Block>)BlockTags.f_13036_, (Level level, Entity poltergeist, BlockPos pos, BlockState state) -> {
            BlockSetType type = BlockSetHolder.get((Block)state.m_60734_());
            if (type != null && !type.f_278463_()) {
                return false;
            }
            BlockState newState = (BlockState)state.m_61122_((Property)TrapDoorBlock.f_57514_);
            level.m_7731_(pos, newState, 2);
            if (((Boolean)newState.m_61143_((Property)TrapDoorBlock.f_57517_)).booleanValue()) {
                level.m_186469_(pos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)level));
            }
            if (type != null) {
                level.m_245803_(poltergeist, pos, (Boolean)newState.m_61143_((Property)TrapDoorBlock.f_57514_) != false ? type.f_271258_() : type.f_271425_(), SoundSource.BLOCKS, 1.0f, level.m_213780_().m_188501_() * 0.1f + 0.9f);
            } else {
                level.m_5898_(null, (Boolean)newState.m_61143_((Property)TrapDoorBlock.f_57514_) != false ? 1007 : 1013, pos, 0);
            }
            level.m_142346_(poltergeist, (Boolean)newState.m_61143_((Property)TrapDoorBlock.f_57514_) != false ? GameEvent.f_157796_ : GameEvent.f_157793_, pos);
            return true;
        });
        PoltergeistHandler.registerBehaviour(Blocks.f_50164_, (Level level, Entity poltergeist, BlockPos pos, BlockState state) -> {
            float pitch = (Boolean)(state = ((LeverBlock)state.m_60734_()).m_54676_(state, level, pos)).m_61143_((Property)LeverBlock.f_54622_) != false ? 0.6f : 0.5f;
            level.m_5594_(null, pos, SoundEvents.f_12088_, SoundSource.BLOCKS, 0.3f, pitch);
            level.m_142346_(poltergeist, (Boolean)state.m_61143_((Property)LeverBlock.f_54622_) != false ? GameEvent.f_223702_ : GameEvent.f_223703_, pos);
            return true;
        });
        PoltergeistHandler.registerBehaviour(Blocks.f_50065_, (Level level, Entity poltergeist, BlockPos pos, BlockState state) -> {
            if (((NoteBlockInstrument)state.m_61143_((Property)NoteBlock.f_55011_)).m_280504_() || level.m_8055_(pos.m_7494_()).m_60795_()) {
                level.m_7696_(pos, state.m_60734_(), 0, 0);
                level.m_142346_(poltergeist, GameEvent.f_223699_, pos);
                return true;
            }
            return false;
        });
        PoltergeistHandler.registerBehaviour((TagKey<Block>)BlockTags.f_13055_, (Level level, Entity poltergeist, BlockPos pos, BlockState state) -> {
            state = (BlockState)state.m_61122_((Property)FenceGateBlock.f_53341_);
            level.m_7731_(pos, state, 10);
            WoodType type = WoodTypeHolder.get((Block)state.m_60734_());
            if (type != null) {
                level.m_5594_(null, pos, (Boolean)state.m_61143_((Property)FenceGateBlock.f_53341_) != false ? type.f_271162_() : type.f_271365_(), SoundSource.BLOCKS, 1.0f, level.m_213780_().m_188501_() * 0.1f + 0.9f);
            }
            level.m_142346_(poltergeist, (Boolean)state.m_61143_((Property)FenceGateBlock.f_53341_) != false ? GameEvent.f_157796_ : GameEvent.f_157793_, pos);
            return true;
        });
        PoltergeistHandler.registerBehaviour(Blocks.f_50329_, (Level level, Entity poltergeist, BlockPos pos, BlockState state) -> {
            BlockState blockState = (BlockState)state.m_61122_((Property)DaylightDetectorBlock.f_52378_);
            level.m_7731_(pos, blockState, 4);
            level.m_220407_(GameEvent.f_157792_, pos, GameEvent.Context.m_223719_((Entity)poltergeist, (BlockState)blockState));
            DaylightDetectorBlock.m_52410_((BlockState)blockState, (Level)level, (BlockPos)pos);
            return true;
        });
        PoltergeistHandler.registerBehaviour(Blocks.f_50680_, (Level level, Entity poltergeist, BlockPos pos, BlockState state) -> {
            ((BellBlock)state.m_60734_()).m_49712_(level, pos, null);
            return true;
        });
    }

    public static interface PoltergeistBehaviour {
        public boolean handle(Level var1, Entity var2, BlockPos var3, BlockState var4);
    }
}

