/*
 * Decompiled with CFR 0.152.
 */
package party.lemons.biomemakeover.init;

import dev.architectury.event.events.common.LifecycleEvent;
import dev.architectury.registry.client.level.entity.EntityModelLayerRegistry;
import dev.architectury.registry.level.biome.BiomeModifications;
import dev.architectury.registry.level.entity.EntityAttributeRegistry;
import dev.architectury.registry.registries.DeferredRegister;
import dev.architectury.registry.registries.RegistrySupplier;
import java.util.function.Predicate;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.IllagerModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.RangedAttribute;
import net.minecraft.world.entity.ambient.Bat;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.WaterAnimal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.Pillager;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.pattern.BlockInWorld;
import net.minecraft.world.level.block.state.pattern.BlockPattern;
import net.minecraft.world.level.block.state.pattern.BlockPatternBuilder;
import net.minecraft.world.level.block.state.predicate.BlockStatePredicate;
import net.minecraft.world.level.levelgen.Heightmap;
import party.lemons.biomemakeover.BiomeMakeover;
import party.lemons.biomemakeover.block.blockentity.render.TapestryRenderer;
import party.lemons.biomemakeover.entity.BlightBatEntity;
import party.lemons.biomemakeover.entity.CowboyEntity;
import party.lemons.biomemakeover.entity.DecayedEntity;
import party.lemons.biomemakeover.entity.DragonflyEntity;
import party.lemons.biomemakeover.entity.GhostEntity;
import party.lemons.biomemakeover.entity.GlowfishEntity;
import party.lemons.biomemakeover.entity.HelmitCrabEntity;
import party.lemons.biomemakeover.entity.LightningBottleEntity;
import party.lemons.biomemakeover.entity.LightningBugEntity;
import party.lemons.biomemakeover.entity.MothEntity;
import party.lemons.biomemakeover.entity.MushroomVillagerEntity;
import party.lemons.biomemakeover.entity.OwlEntity;
import party.lemons.biomemakeover.entity.RootlingEntity;
import party.lemons.biomemakeover.entity.ScuttlerEntity;
import party.lemons.biomemakeover.entity.StoneGolemEntity;
import party.lemons.biomemakeover.entity.TadpoleEntity;
import party.lemons.biomemakeover.entity.ToadEntity;
import party.lemons.biomemakeover.entity.TumbleweedEntity;
import party.lemons.biomemakeover.entity.adjudicator.AdjudicatorEntity;
import party.lemons.biomemakeover.entity.adjudicator.AdjudicatorMimicEntity;
import party.lemons.biomemakeover.entity.render.AdjudicatorModel;
import party.lemons.biomemakeover.entity.render.BlightBatRender;
import party.lemons.biomemakeover.entity.render.CowboyRender;
import party.lemons.biomemakeover.entity.render.DecayedModel;
import party.lemons.biomemakeover.entity.render.DragonflyModel;
import party.lemons.biomemakeover.entity.render.GhostModel;
import party.lemons.biomemakeover.entity.render.HelmitCrabModel;
import party.lemons.biomemakeover.entity.render.LightningBugModel;
import party.lemons.biomemakeover.entity.render.MothModel;
import party.lemons.biomemakeover.entity.render.OwlModel;
import party.lemons.biomemakeover.entity.render.RootlingModel;
import party.lemons.biomemakeover.entity.render.ScuttlerModel;
import party.lemons.biomemakeover.entity.render.StoneGolemModel;
import party.lemons.biomemakeover.entity.render.TadpoleModel;
import party.lemons.biomemakeover.entity.render.ToadModel;
import party.lemons.biomemakeover.entity.render.feature.CowboyHatModel;
import party.lemons.biomemakeover.entity.render.feature.WitchHatModel;
import party.lemons.biomemakeover.init.BMBlocks;
import party.lemons.biomemakeover.init.BMFeatures;
import party.lemons.taniwha.entity.TEntityTypeBuilder;
import party.lemons.taniwha.entity.golem.GolemHandler;
import party.lemons.taniwha.mixin.spawn.SpawnPlacementsInvoker;

public class BMEntities {
    public static final DeferredRegister<EntityType<?>> ENTITIES = DeferredRegister.create((String)"biomemakeover", (ResourceKey)Registries.f_256939_);
    public static final DeferredRegister<Attribute> ATTRIBUTES = DeferredRegister.create((String)"biomemakeover", (ResourceKey)Registries.f_256728_);
    public static final RegistrySupplier<EntityType<TumbleweedEntity>> TUMBLEWEED = ENTITIES.register(BiomeMakeover.ID("tumbleweed"), () -> TEntityTypeBuilder.of(TumbleweedEntity::new, (MobCategory)MobCategory.MISC).sized(0.7f, 0.7f).clientTrackingRange(12).build());
    public static final RegistrySupplier<EntityType<LightningBottleEntity>> LIGHTNING_BOTTLE = ENTITIES.register(BiomeMakeover.ID("lightning_bottle"), () -> TEntityTypeBuilder.of(LightningBottleEntity::new, (MobCategory)MobCategory.MISC).clientTrackingRange(10).updateInterval(4).sized(0.25f, 0.25f).build());
    public static final RegistrySupplier<EntityType<GlowfishEntity>> GLOWFISH = ENTITIES.register(BiomeMakeover.ID("glowfish"), () -> TEntityTypeBuilder.of(GlowfishEntity::new, (MobCategory)MobCategory.WATER_AMBIENT).sized(0.7f, 0.4f).clientTrackingRange(4).build());
    public static final RegistrySupplier<EntityType<BlightBatEntity>> BLIGHTBAT = ENTITIES.register(BiomeMakeover.ID("blightbat"), () -> TEntityTypeBuilder.of(BlightBatEntity::new, (MobCategory)MobCategory.AMBIENT).sized(0.56f, 0.9f).clientTrackingRange(5).build());
    public static final RegistrySupplier<EntityType<MushroomVillagerEntity>> MUSHROOM_TRADER = ENTITIES.register(BiomeMakeover.ID("mushroom_trader"), () -> TEntityTypeBuilder.of(MushroomVillagerEntity::new, (MobCategory)MobCategory.AMBIENT).sized(0.6f, 1.95f).clientTrackingRange(12).build());
    public static final RegistrySupplier<EntityType<ScuttlerEntity>> SCUTTLER = ENTITIES.register(BiomeMakeover.ID("scuttler"), () -> TEntityTypeBuilder.of(ScuttlerEntity::new, (MobCategory)MobCategory.CREATURE).sized(0.8f, 0.6f).clientTrackingRange(12).build());
    public static final RegistrySupplier<EntityType<GhostEntity>> GHOST = ENTITIES.register(BiomeMakeover.ID("ghost"), () -> TEntityTypeBuilder.of(GhostEntity::new, (MobCategory)MobCategory.MONSTER).sized(0.6f, 1.95f).canSpawnFarFromPlayer().clientTrackingRange(12).build());
    public static final RegistrySupplier<EntityType<CowboyEntity>> COWBOY = ENTITIES.register(BiomeMakeover.ID("cowboy"), () -> TEntityTypeBuilder.of(CowboyEntity::new, (MobCategory)MobCategory.MONSTER).sized(0.6f, 1.95f).canSpawnFarFromPlayer().clientTrackingRange(12).build());
    public static final RegistrySupplier<EntityType<DecayedEntity>> DECAYED = ENTITIES.register(BiomeMakeover.ID("decayed"), () -> TEntityTypeBuilder.of(DecayedEntity::new, (MobCategory)MobCategory.MONSTER).sized(0.6f, 1.95f).clientTrackingRange(8).build());
    public static final RegistrySupplier<EntityType<DragonflyEntity>> DRAGONFLY = ENTITIES.register(BiomeMakeover.ID("dragonfly"), () -> TEntityTypeBuilder.of(DragonflyEntity::new, (MobCategory)MobCategory.AMBIENT).sized(0.8f, 0.6f).clientTrackingRange(12).build());
    public static final RegistrySupplier<EntityType<ToadEntity>> TOAD = ENTITIES.register(BiomeMakeover.ID("toad"), () -> TEntityTypeBuilder.of(ToadEntity::new, (MobCategory)MobCategory.CREATURE).sized(0.8f, 0.6f).clientTrackingRange(12).build());
    public static final RegistrySupplier<EntityType<TadpoleEntity>> TADPOLE = ENTITIES.register(BiomeMakeover.ID("tadpole"), () -> TEntityTypeBuilder.of(TadpoleEntity::new, (MobCategory)MobCategory.WATER_CREATURE).sized(0.5f, 0.3f).clientTrackingRange(12).build());
    public static final RegistrySupplier<EntityType<LightningBugEntity>> LIGHTNING_BUG = ENTITIES.register(BiomeMakeover.ID("lightning_bug"), () -> TEntityTypeBuilder.of(LightningBugEntity::new, (MobCategory)MobCategory.AMBIENT).sized(0.4f, 0.4f).clientTrackingRange(12).build());
    public static final RegistrySupplier<EntityType<LightningBugEntity>> LIGHTNING_BUG_ALTERNATE = ENTITIES.register(BiomeMakeover.ID("lightning_bug_alternate"), () -> TEntityTypeBuilder.of((entityType, level) -> new LightningBugEntity(level, true), (MobCategory)MobCategory.AMBIENT).sized(0.4f, 0.4f).clientTrackingRange(12).build());
    public static final RegistrySupplier<EntityType<OwlEntity>> OWL = ENTITIES.register(BiomeMakeover.ID("owl"), () -> TEntityTypeBuilder.of(OwlEntity::new, (MobCategory)MobCategory.CREATURE).sized(0.7f, 0.8f).clientTrackingRange(12).build());
    public static final RegistrySupplier<EntityType<MothEntity>> MOTH = ENTITIES.register(BiomeMakeover.ID("moth"), () -> TEntityTypeBuilder.of(MothEntity::new, (MobCategory)MobCategory.MONSTER).sized(0.8f, 1.2f).clientTrackingRange(12).build());
    public static final RegistrySupplier<EntityType<RootlingEntity>> ROOTLING = ENTITIES.register(BiomeMakeover.ID("rootling"), () -> TEntityTypeBuilder.of(RootlingEntity::new, (MobCategory)MobCategory.CREATURE).sized(0.6f, 1.1f).clientTrackingRange(12).build());
    public static final RegistrySupplier<EntityType<AdjudicatorEntity>> ADJUDICATOR = ENTITIES.register(BiomeMakeover.ID("adjudicator"), () -> TEntityTypeBuilder.of(AdjudicatorEntity::new, (MobCategory)MobCategory.MONSTER).fireImmune().sized(0.6f, 1.95f).clientTrackingRange(12).noSummon().build());
    public static final RegistrySupplier<EntityType<AdjudicatorMimicEntity>> ADJUDICATOR_MIMIC = ENTITIES.register(BiomeMakeover.ID("adjudicator_mimic"), () -> TEntityTypeBuilder.of(AdjudicatorMimicEntity::new, (MobCategory)MobCategory.MONSTER).fireImmune().sized(0.6f, 1.95f).clientTrackingRange(12).noSummon().build());
    public static final RegistrySupplier<EntityType<StoneGolemEntity>> STONE_GOLEM = ENTITIES.register(BiomeMakeover.ID("stone_golem"), () -> TEntityTypeBuilder.of(StoneGolemEntity::new, (MobCategory)MobCategory.MISC).sized(1.6f, 2.5f).clientTrackingRange(12).build());
    public static final RegistrySupplier<EntityType<HelmitCrabEntity>> HELMIT_CRAB = ENTITIES.register(BiomeMakeover.ID("helmit_crab"), () -> TEntityTypeBuilder.of(HelmitCrabEntity::new, (MobCategory)MobCategory.CREATURE).sized(0.825f, 0.5f).clientTrackingRange(12).build());
    public static final RegistrySupplier<Attribute> ATT_PROJECTILE_RESISTANCE = ATTRIBUTES.register(BiomeMakeover.ID("projectile_resistance"), () -> new RangedAttribute("attribute.name.biomemakeover.projectile_resistance", 0.0, 0.0, 30.0));
    public static final TagKey<EntityType<?>> LIGHTNING_BUG_TAG = TagKey.m_203882_((ResourceKey)Registries.f_256939_, (ResourceLocation)BiomeMakeover.ID("lightning_bugs"));
    public static final TagKey<EntityType<?>> OWL_TARGETS = TagKey.m_203882_((ResourceKey)Registries.f_256939_, (ResourceLocation)BiomeMakeover.ID("owl_targets"));
    public static final TagKey<DamageType> GHOST_IMMUNE_DAMAGE = TagKey.m_203882_((ResourceKey)Registries.f_268580_, (ResourceLocation)BiomeMakeover.ID("ghost_immune_to"));
    public static final TagKey<DamageType> SCUTTLER_IMMUNE_DAMAGE = TagKey.m_203882_((ResourceKey)Registries.f_268580_, (ResourceLocation)BiomeMakeover.ID("scuttler_immune_to"));
    public static final TagKey<DamageType> TUMBLEWEED_IMMUNE_DAMAGE = TagKey.m_203882_((ResourceKey)Registries.f_268580_, (ResourceLocation)BiomeMakeover.ID("tumbleweed_immune_to"));

    public static void init() {
        ENTITIES.register();
        ATTRIBUTES.register();
        LifecycleEvent.SETUP.register(() -> GolemHandler.addPattern((BlockPattern)BlockPatternBuilder.m_61243_().m_61247_(new String[]{"~^~", "###", "~#~"}).m_61244_('^', BlockInWorld.m_61169_((Predicate)BlockStatePredicate.m_61287_((Block)Blocks.f_50143_))).m_61244_('#', BlockInWorld.m_61169_((Predicate)BlockStatePredicate.m_61287_((Block)((Block)BMBlocks.CLADDED_STONE.get())))).m_61244_('~', block -> block.m_61168_().m_60795_()).m_61249_(), (BlockPattern)BlockPatternBuilder.m_61243_().m_61247_(new String[]{"~ ~", "###", "~#~"}).m_61244_('#', BlockInWorld.m_61169_((Predicate)BlockStatePredicate.m_61287_((Block)((Block)BMBlocks.CLADDED_STONE.get())))).m_61244_('~', block -> block.m_61168_().m_60795_()).m_61249_(), (GolemHandler.GolemResult)new GolemHandler.SummonGolemResult((EntityType)STONE_GOLEM.get())));
        BMEntities.initAttributes();
    }

    public static void initSpawnsAndAttributes() {
        BMEntities.initSpawns();
    }

    public static void initAttributes() {
        EntityAttributeRegistry.register(GLOWFISH, GlowfishEntity::createAttributes);
        EntityAttributeRegistry.register(BLIGHTBAT, Bat::m_27455_);
        EntityAttributeRegistry.register(MUSHROOM_TRADER, Mob::m_21552_);
        EntityAttributeRegistry.register(SCUTTLER, ScuttlerEntity::createAttributes);
        EntityAttributeRegistry.register(GHOST, Monster::m_33035_);
        EntityAttributeRegistry.register(COWBOY, Pillager::m_33307_);
        EntityAttributeRegistry.register(DECAYED, DecayedEntity::createAttributes);
        EntityAttributeRegistry.register(DRAGONFLY, DragonflyEntity::createAttributes);
        EntityAttributeRegistry.register(TOAD, ToadEntity::createAttributes);
        EntityAttributeRegistry.register(TADPOLE, TadpoleEntity::createAttributes);
        EntityAttributeRegistry.register(LIGHTNING_BUG, LightningBugEntity::createAttributes);
        EntityAttributeRegistry.register(LIGHTNING_BUG_ALTERNATE, LightningBugEntity::createAttributes);
        EntityAttributeRegistry.register(OWL, OwlEntity::createAttributes);
        EntityAttributeRegistry.register(MOTH, MothEntity::createAttributes);
        EntityAttributeRegistry.register(ROOTLING, RootlingEntity::createAttributes);
        EntityAttributeRegistry.register(ADJUDICATOR, AdjudicatorEntity::createAttributes);
        EntityAttributeRegistry.register(ADJUDICATOR_MIMIC, AdjudicatorMimicEntity::createAttributes);
        EntityAttributeRegistry.register(STONE_GOLEM, StoneGolemEntity::createAttributes);
        EntityAttributeRegistry.register(HELMIT_CRAB, HelmitCrabEntity::createAttributes);
    }

    private static void initSpawns() {
        BMEntities.registerSpawn(BMFeatures.MUSHROOM_FIELD_BIOMES, (EntityType)GLOWFISH.get(), MobCategory.WATER_AMBIENT, 7, 2, 7);
        SpawnPlacementsInvoker.callRegister((EntityType)((EntityType)GLOWFISH.get()), (SpawnPlacements.Type)SpawnPlacements.Type.IN_WATER, (Heightmap.Types)Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, WaterAnimal::m_218282_);
        BMEntities.registerSpawn(BMFeatures.BADLANDS_BIOMES, (EntityType)SCUTTLER.get(), MobCategory.CREATURE, 4, 1, 2);
        SpawnPlacementsInvoker.callRegister((EntityType)((EntityType)SCUTTLER.get()), (SpawnPlacements.Type)SpawnPlacements.Type.ON_GROUND, (Heightmap.Types)Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, ScuttlerEntity::checkSpawnRules);
        SpawnPlacementsInvoker.callRegister((EntityType)((EntityType)GHOST.get()), (SpawnPlacements.Type)SpawnPlacements.Type.ON_GROUND, (Heightmap.Types)Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, GhostEntity::checkGhostSpawnRules);
        BMEntities.registerSpawn(BMFeatures.SWAMP_BIOMES, (EntityType)DECAYED.get(), MobCategory.MONSTER, 60, 1, 1);
        SpawnPlacementsInvoker.callRegister((EntityType)((EntityType)DECAYED.get()), (SpawnPlacements.Type)SpawnPlacements.Type.IN_WATER, (Heightmap.Types)Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, DecayedEntity::checkSpawnRules);
        BMEntities.registerSpawn(BMFeatures.SWAMP_BIOMES, (EntityType)DRAGONFLY.get(), MobCategory.AMBIENT, 20, 3, 8);
        SpawnPlacementsInvoker.callRegister((EntityType)((EntityType)DRAGONFLY.get()), (SpawnPlacements.Type)SpawnPlacements.Type.NO_RESTRICTIONS, (Heightmap.Types)Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, DragonflyEntity::checkSpawnRules);
        SpawnPlacementsInvoker.callRegister((EntityType)((EntityType)TOAD.get()), (SpawnPlacements.Type)SpawnPlacements.Type.ON_GROUND, (Heightmap.Types)Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Animal::m_218104_);
        BMEntities.registerSpawn(BMFeatures.SWAMP_BIOMES, (EntityType)LIGHTNING_BUG.get(), MobCategory.AMBIENT, 20, 1, 1);
        SpawnPlacementsInvoker.callRegister((EntityType)((EntityType)LIGHTNING_BUG.get()), (SpawnPlacements.Type)SpawnPlacements.Type.NO_RESTRICTIONS, (Heightmap.Types)Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, LightningBugEntity::checkSpawnRules);
        BMEntities.registerSpawn(BMFeatures.DARK_FOREST_BIOMES, (EntityType)OWL.get(), MobCategory.CREATURE, 20, 1, 4);
        SpawnPlacementsInvoker.callRegister((EntityType)((EntityType)OWL.get()), (SpawnPlacements.Type)SpawnPlacements.Type.ON_GROUND, (Heightmap.Types)Heightmap.Types.MOTION_BLOCKING, OwlEntity::checkSpawnRules);
        BMEntities.registerSpawn(BMFeatures.DARK_FOREST_BIOMES, (EntityType)ROOTLING.get(), MobCategory.CREATURE, 40, 2, 6);
        SpawnPlacementsInvoker.callRegister((EntityType)((EntityType)ROOTLING.get()), (SpawnPlacements.Type)SpawnPlacements.Type.ON_GROUND, (Heightmap.Types)Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, BMEntities::checkDFSpawnRules);
        BMEntities.registerSpawn(BMFeatures.DARK_FOREST_BIOMES, (EntityType)MOTH.get(), MobCategory.MONSTER, 90, 2, 3);
        SpawnPlacementsInvoker.callRegister((EntityType)((EntityType)MOTH.get()), (SpawnPlacements.Type)SpawnPlacements.Type.NO_RESTRICTIONS, (Heightmap.Types)Heightmap.Types.MOTION_BLOCKING, MothEntity::checkSpawnRules);
        BMEntities.registerSpawn(BMFeatures.DARK_FOREST_BIOMES, EntityType.f_20452_, MobCategory.CREATURE, 4, 2, 2);
        BMEntities.registerSpawn(BMFeatures.DARK_FOREST_BIOMES, EntityType.f_20517_, MobCategory.CREATURE, 4, 2, 3);
        BMEntities.registerSpawn(BMFeatures.BEACH_BIOMES, (EntityType)HELMIT_CRAB.get(), MobCategory.CREATURE, 6, 2, 5);
        SpawnPlacementsInvoker.callRegister((EntityType)((EntityType)HELMIT_CRAB.get()), (SpawnPlacements.Type)SpawnPlacements.Type.ON_GROUND, (Heightmap.Types)Heightmap.Types.MOTION_BLOCKING, HelmitCrabEntity::checkSpawnRules);
    }

    private static boolean checkDFSpawnRules(EntityType<?> type, ServerLevelAccessor level, MobSpawnType mobSpawnType, BlockPos pos, RandomSource randomSource) {
        return level.m_8055_(pos.m_7495_()).m_60713_(Blocks.f_50440_) && level.m_45524_(pos, 0) > 2;
    }

    public static void registerModelLayers() {
        LayerDefinition HUMANOID_OVERLAY = LayerDefinition.m_171565_((MeshDefinition)HumanoidModel.m_170681_((CubeDeformation)new CubeDeformation(0.5f), (float)0.0f), (int)64, (int)64);
        LayerDefinition HUMANOID_OVERLAY2 = LayerDefinition.m_171565_((MeshDefinition)HumanoidModel.m_170681_((CubeDeformation)new CubeDeformation(0.5f), (float)0.0f), (int)64, (int)32);
        EntityModelLayerRegistry.register((ModelLayerLocation)TapestryRenderer.LAYER_LOCATION, TapestryRenderer::createBodyLayer);
        EntityModelLayerRegistry.register((ModelLayerLocation)CowboyHatModel.LAYER_LOCATION, CowboyHatModel::createBodyLayer);
        EntityModelLayerRegistry.register((ModelLayerLocation)WitchHatModel.LAYER_LOCATION, WitchHatModel::createBodyLayer);
        EntityModelLayerRegistry.register((ModelLayerLocation)BlightBatRender.BlightBatModel.LAYER_LOCATION, BlightBatRender.BlightBatModel::createBodyLayer);
        EntityModelLayerRegistry.register((ModelLayerLocation)ScuttlerModel.LAYER_LOCATION, ScuttlerModel::createBodyLayer);
        EntityModelLayerRegistry.register((ModelLayerLocation)GhostModel.LAYER_LOCATION, GhostModel::createBodyLayer);
        EntityModelLayerRegistry.register((ModelLayerLocation)CowboyRender.LAYER_LOCATION, IllagerModel::m_170689_);
        EntityModelLayerRegistry.register((ModelLayerLocation)DecayedModel.LAYER_LOCATION, () -> DecayedModel.m_170535_((CubeDeformation)CubeDeformation.f_171458_));
        EntityModelLayerRegistry.register((ModelLayerLocation)DecayedModel.LAYER_LOCATION_2, () -> HUMANOID_OVERLAY);
        EntityModelLayerRegistry.register((ModelLayerLocation)DecayedModel.LAYER_LOCATION_3, () -> HUMANOID_OVERLAY2);
        EntityModelLayerRegistry.register((ModelLayerLocation)DragonflyModel.LAYER_LOCATION, DragonflyModel::createBodyLayer);
        EntityModelLayerRegistry.register((ModelLayerLocation)ToadModel.LAYER_LOCATION, ToadModel::createBodyLayer);
        EntityModelLayerRegistry.register((ModelLayerLocation)TadpoleModel.LAYER_LOCATION, TadpoleModel::createBodyLayer);
        EntityModelLayerRegistry.register((ModelLayerLocation)LightningBugModel.LAYER_LOCATION, LightningBugModel::createBodyLayer);
        EntityModelLayerRegistry.register((ModelLayerLocation)LightningBugModel.LAYER_LOCATION_INNER, LightningBugModel.LightningBugInner::createBodyLayer);
        EntityModelLayerRegistry.register((ModelLayerLocation)LightningBugModel.LAYER_LOCATION_OUTER, LightningBugModel.LightningBugOuter::createBodyLayer);
        EntityModelLayerRegistry.register((ModelLayerLocation)OwlModel.LAYER_LOCATION, OwlModel::createBodyLayer);
        EntityModelLayerRegistry.register((ModelLayerLocation)MothModel.LAYER_LOCATION, MothModel::createBodyLayer);
        EntityModelLayerRegistry.register((ModelLayerLocation)RootlingModel.LAYER_LOCATION, RootlingModel::createBodyLayer);
        EntityModelLayerRegistry.register((ModelLayerLocation)AdjudicatorModel.LAYER_LOCATION, AdjudicatorModel::createBodyLayer);
        EntityModelLayerRegistry.register((ModelLayerLocation)StoneGolemModel.LAYER_LOCATION, StoneGolemModel::createBodyLayer);
        EntityModelLayerRegistry.register((ModelLayerLocation)HelmitCrabModel.LAYER_LOCATION, HelmitCrabModel::createBodyLayer);
    }

    private static void registerSpawn(TagKey<Biome> tag, EntityType<?> type, MobCategory category, int weight, int min, int max) {
        BiomeModifications.addProperties(b -> b.hasTag(tag), (ctx, b) -> b.getSpawnProperties().addSpawn(category, new MobSpawnSettings.SpawnerData(type, weight, min, max)));
    }
}

