/*
 * Decompiled with CFR 0.152.
 */
package party.lemons.biomemakeover.init;

import com.google.common.collect.ImmutableMap;
import dev.architectury.hooks.item.tool.HoeItemHooks;
import dev.architectury.registry.CreativeTabRegistry;
import dev.architectury.registry.fuel.FuelRegistry;
import dev.architectury.registry.registries.DeferredRegister;
import dev.architectury.registry.registries.RegistrySupplier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.HoeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.PlaceOnWaterBlockItem;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.StandingAndWallBlockItem;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BrushableBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.grower.AbstractTreeGrower;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.NoteBlockInstrument;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.material.PushReaction;
import party.lemons.biomemakeover.BiomeMakeover;
import party.lemons.biomemakeover.block.AdjudicatorTapestryBlock;
import party.lemons.biomemakeover.block.AdjudicatorTapestryWallBlock;
import party.lemons.biomemakeover.block.AltarBlock;
import party.lemons.biomemakeover.block.BMMushroomBlock;
import party.lemons.biomemakeover.block.BMTallMushroomBlock;
import party.lemons.biomemakeover.block.BarrelCactusBlock;
import party.lemons.biomemakeover.block.BlackThistleBlock;
import party.lemons.biomemakeover.block.BuddingIlluniteBlock;
import party.lemons.biomemakeover.block.ColorTapestryBlock;
import party.lemons.biomemakeover.block.ColorTapestryWallBlock;
import party.lemons.biomemakeover.block.DirectionalDataBlock;
import party.lemons.biomemakeover.block.EctoplasmComposterBlock;
import party.lemons.biomemakeover.block.FloweredWaterlilyPadBlock;
import party.lemons.biomemakeover.block.GlowshroomPlantBlock;
import party.lemons.biomemakeover.block.IlluniteClusterBlock;
import party.lemons.biomemakeover.block.ItchingIvyBlock;
import party.lemons.biomemakeover.block.IvyBlock;
import party.lemons.biomemakeover.block.LightningBugBottleBlock;
import party.lemons.biomemakeover.block.MothBlossomBlock;
import party.lemons.biomemakeover.block.MushroomRootsBlock;
import party.lemons.biomemakeover.block.MushroomSproutsBlock;
import party.lemons.biomemakeover.block.PeatComposterBlock;
import party.lemons.biomemakeover.block.PeatFarmlandBlock;
import party.lemons.biomemakeover.block.PoltergeistBlock;
import party.lemons.biomemakeover.block.ReedBlock;
import party.lemons.biomemakeover.block.RootlingCropBlock;
import party.lemons.biomemakeover.block.SaguaroCactusBlock;
import party.lemons.biomemakeover.block.SmallLilyPadBlock;
import party.lemons.biomemakeover.block.UnderwaterMushroomPlantBlock;
import party.lemons.biomemakeover.block.WaterSaplingBlock;
import party.lemons.biomemakeover.block.WildMushroomBlock;
import party.lemons.biomemakeover.block.WillowingBranchesBlock;
import party.lemons.biomemakeover.init.BMBoats;
import party.lemons.biomemakeover.init.BMEffects;
import party.lemons.biomemakeover.init.BMTab;
import party.lemons.biomemakeover.level.generate.foliage.AncientOakSaplingGenerator;
import party.lemons.biomemakeover.level.generate.foliage.BalsaSaplingGenerator;
import party.lemons.biomemakeover.level.generate.foliage.SwampCypressSaplingGenerator;
import party.lemons.biomemakeover.level.generate.foliage.WillowSaplingGenerator;
import party.lemons.biomemakeover.util.BMSoundType;
import party.lemons.taniwha.block.BlockHelper;
import party.lemons.taniwha.block.DecorationBlockFactory;
import party.lemons.taniwha.block.WoodBlockFactory;
import party.lemons.taniwha.block.modifier.BlockModifier;
import party.lemons.taniwha.block.modifier.FlammableModifier;
import party.lemons.taniwha.block.modifier.RTypeModifier;
import party.lemons.taniwha.block.rtype.RType;
import party.lemons.taniwha.block.types.TBlock;
import party.lemons.taniwha.block.types.TFlowerPotBlock;
import party.lemons.taniwha.block.types.TLeavesBlock;
import party.lemons.taniwha.block.types.TSaplingBlock;
import party.lemons.taniwha.block.types.TSpreadableBlock;
import party.lemons.taniwha.block.types.TTallFlowerBlock;
import party.lemons.taniwha.hooks.block.entity.BlockEntityHooks;
import party.lemons.taniwha.item.ItemHelper;
import party.lemons.taniwha.util.BlockUtil;

public class BMBlocks {
    public static final TagKey<Block> LILY_PADS = BMBlocks.blockTag("lily_pads");
    public static final TagKey<Block> MOTH_ATTRACTIVE = BMBlocks.blockTag("moth_attractive");
    public static final TagKey<Block> IVY_TAG = BMBlocks.blockTag("ivy");
    public static final TagKey<Block> ITCHING_IVY_TAG = BMBlocks.blockTag("itching_ivy");
    public static final TagKey<Block> ORE_REPLACEABLE = BMBlocks.blockTag("ore_replaceable");
    public static final TagKey<Block> CRAB_SPAWNABLE_ON = BMBlocks.blockTag("crab_spawnable_on");
    public static final TagKey<Block> FISSURE_NO_REPLACE = BMBlocks.blockTag("fissure_no_replace");
    public static final TagKey<Block> BARREL_CACTUS_PLANTABLE = BMBlocks.blockTag("barrel_cactus_plantable_on");
    public static final TagKey<Block> SAGUARO_CACTUS_PLANTABLE = BMBlocks.blockTag("saguaro_cactus_plantable_on");
    public static final Map<RegistrySupplier<Block>, RegistrySupplier<Item>> BLOCK_ITEMS = new HashMap<RegistrySupplier<Block>, RegistrySupplier<Item>>();
    private static final BlockBehaviour.Properties LEAF_PROPERTIES = BMBlocks.properties(0.2f).m_284180_(MapColor.f_283915_).m_60977_().m_60918_(SoundType.f_56740_).m_60955_().m_60922_(BMBlocks::canSpawnOnLeaves).m_60960_(BMBlocks::never).m_60971_(BMBlocks::never).m_278183_().m_278166_(PushReaction.DESTROY).m_60924_(BMBlocks::never);
    private static final BlockBehaviour.Properties THATCH_PROPERTIES = BMBlocks.properties(0.5f).m_280658_(NoteBlockInstrument.BANJO).m_284180_(MapColor.f_283819_).m_60918_(SoundType.f_56740_);
    private static final BlockModifier[] LEAF_MODIFIERS = new BlockModifier[]{RTypeModifier.create((RType)RType.CUTOUT), FlammableModifier.LEAVES};
    private static final DeferredRegister<Block> BLOCKS = DeferredRegister.create((String)"biomemakeover", (ResourceKey)Registries.f_256747_);
    public static final DeferredRegister<Item> ITEMS = DeferredRegister.create((String)"biomemakeover", (ResourceKey)Registries.f_256913_);
    public static final SoundType BM_LILY_PAD_SOUND = new SoundType(1.0f, 1.0f, SoundEvents.f_12543_, SoundEvents.f_12547_, SoundEvents.f_12581_, SoundEvents.f_12545_, SoundEvents.f_12544_);
    public static final SoundType ILLUNITE_SOUND = new BMSoundType(1.0f, 1.0f, BMEffects.ILLUNITE_BREAK, BMEffects.ILLUNITE_STEP, BMEffects.ILLUNITE_PLACE, BMEffects.ILLUNITE_HIT, () -> SoundEvents.f_12445_);
    public static final RegistrySupplier<Block> PURPLE_GLOWSHROOM = BMBlocks.registerBlockItem("purple_glowshroom", () -> new GlowshroomPlantBlock(ResourceKey.m_135785_((ResourceKey)Registries.f_256911_, (ResourceLocation)BiomeMakeover.ID("mushroom_fields/huge_purple_glowshroom")), BMBlocks.properties(0.0f).m_278166_(PushReaction.DESTROY).m_278166_(PushReaction.DESTROY).m_284180_(MapColor.f_283765_).m_60953_(s -> 13).m_60910_().m_60910_().m_60918_(SoundType.f_56711_)).modifiers(new BlockModifier[]{RTypeModifier.CUTOUT}));
    public static final RegistrySupplier<Block> GREEN_GLOWSHROOM = BMBlocks.registerBlockItem("green_glowshroom", () -> new GlowshroomPlantBlock(ResourceKey.m_135785_((ResourceKey)Registries.f_256911_, (ResourceLocation)BiomeMakeover.ID("mushroom_fields/huge_green_glowshroom")), BMBlocks.properties(0.0f).m_278166_(PushReaction.DESTROY).m_278166_(PushReaction.DESTROY).m_284180_(MapColor.f_283769_).m_60953_(s -> 13).m_60910_().m_60955_().m_60918_(SoundType.f_56711_)).modifiers(new BlockModifier[]{RTypeModifier.CUTOUT}));
    public static final RegistrySupplier<Block> ORANGE_GLOWSHROOM = BMBlocks.registerBlockItem("orange_glowshroom", () -> new UnderwaterMushroomPlantBlock(ResourceKey.m_135785_((ResourceKey)Registries.f_256911_, (ResourceLocation)BiomeMakeover.ID("mushroom_fields/huge_orange_glowshroom")), BMBlocks.properties(0.0f).m_278166_(PushReaction.DESTROY).m_278166_(PushReaction.DESTROY).m_284180_(MapColor.f_283761_).m_60953_(s -> 13).m_60910_().m_60955_().m_60918_(SoundType.f_56711_)).modifiers(new BlockModifier[]{RTypeModifier.CUTOUT}));
    public static final RegistrySupplier<Block> PURPLE_GLOWSHROOM_BLOCK = BMBlocks.registerBlockItem("purple_glowshroom_block", () -> new BMMushroomBlock(BMBlocks.properties(0.2f).m_60953_(s -> 15).m_60918_(SoundType.f_56711_).m_280658_(NoteBlockInstrument.BASS).m_284180_(MapColor.f_283765_)));
    public static final RegistrySupplier<Block> GREEN_GLOWSHROOM_BLOCK = BMBlocks.registerBlockItem("green_glowshroom_block", () -> new BMMushroomBlock(BMBlocks.properties(0.2f).m_60953_(s -> 15).m_60918_(SoundType.f_56711_).m_280658_(NoteBlockInstrument.BASS).m_284180_(MapColor.f_283769_)));
    public static final RegistrySupplier<Block> ORANGE_GLOWSHROOM_BLOCK = BMBlocks.registerBlockItem("orange_glowshroom_block", () -> new BMMushroomBlock(BMBlocks.properties(0.2f).m_60953_(s -> 15).m_60918_(SoundType.f_56711_).m_280658_(NoteBlockInstrument.BASS).m_284180_(MapColor.f_283761_)));
    public static final RegistrySupplier<Block> MYCELIUM_SPROUTS = BMBlocks.registerBlockItem("mycelium_sprouts", () -> new MushroomSproutsBlock(BMBlocks.properties(0.0f).m_280170_().m_278166_(PushReaction.DESTROY).m_60910_().m_60910_().m_60966_().m_60918_(SoundType.f_56722_).m_284180_(MapColor.f_283892_)).modifiers(new BlockModifier[]{RTypeModifier.CUTOUT}));
    public static final RegistrySupplier<Block> MYCELIUM_ROOTS = BMBlocks.registerBlockItem("mycelium_roots", () -> new MushroomRootsBlock(BMBlocks.properties(0.0f).m_280170_().m_278166_(PushReaction.DESTROY).m_60910_().m_60910_().m_60966_().m_60918_(SoundType.f_56712_).m_284180_(MapColor.f_283892_)).modifiers(new BlockModifier[]{RTypeModifier.CUTOUT}));
    public static final RegistrySupplier<Block> TALL_BROWN_MUSHROOM = BMBlocks.registerBlockItem("tall_brown_mushroom", () -> new BMTallMushroomBlock(BMBlocks.properties(0.0f).m_278166_(PushReaction.DESTROY).m_60966_().m_60910_().m_60918_(SoundType.f_56711_).m_284180_(MapColor.f_283762_)).modifiers(new BlockModifier[]{RTypeModifier.CUTOUT}));
    public static final RegistrySupplier<Block> TALL_RED_MUSHROOM = BMBlocks.registerBlockItem("tall_red_mushroom", () -> new BMTallMushroomBlock(BMBlocks.properties(0.0f).m_278166_(PushReaction.DESTROY).m_60966_().m_60910_().m_60918_(SoundType.f_56711_).m_284180_(MapColor.f_283913_)).modifiers(new BlockModifier[]{RTypeModifier.CUTOUT}));
    public static final WoodBlockFactory BLIGHTED_BALSA_WOOD_INFO = new WoodBlockFactory("biomemakeover", "blighted_balsa", BMTab.TAB).color(MapColor.f_283856_, MapColor.f_283930_).all(() -> BMBoats.BLIGHTED_BALSA).register(BLOCKS, ITEMS);
    public static final RegistrySupplier<Block> BLIGHTED_BALSA_LEAVES = BMBlocks.registerBlockItem("blighted_balsa_leaves", () -> new TLeavesBlock(BlockUtil.copyProperties((BlockBehaviour.Properties)LEAF_PROPERTIES).m_284180_(MapColor.f_283828_)).modifiers(new BlockModifier[]{RTypeModifier.CUTOUT, FlammableModifier.LEAVES}));
    public static final RegistrySupplier<Block> BLIGHTED_BALSA_SAPLING = BMBlocks.sapling("blighted_balsa_sapling", new BalsaSaplingGenerator(), MapColor.f_283930_);
    public static final RegistrySupplier<Block> GLOWSHROOM_STEM = BMBlocks.registerBlockItem("glowshroom_stem", () -> new BMMushroomBlock(BMBlocks.properties(0.2f).m_284180_(MapColor.f_283744_).m_280658_(NoteBlockInstrument.BASS).m_60953_(s -> 7).m_60918_(SoundType.f_56711_)));
    public static final RegistrySupplier<Block> RED_MUSHROOM_BRICK = BMBlocks.registerBlockItem("red_mushroom_brick", () -> new TBlock(BMBlocks.properties(0.8f).m_60918_(SoundType.f_56711_).m_280658_(NoteBlockInstrument.BASS).m_284180_(MapColor.f_283913_)));
    public static final DecorationBlockFactory RED_MUSHROOM_BRICK_DECORATION = new DecorationBlockFactory("biomemakeover", "red_mushroom_brick", RED_MUSHROOM_BRICK, BMBlocks.properties(0.8f).m_280658_(NoteBlockInstrument.BASS).m_284180_(MapColor.f_283913_).m_60918_(SoundType.f_56711_), BMTab.TAB).all().register(BLOCKS, ITEMS);
    public static final RegistrySupplier<Block> BROWN_MUSHROOM_BRICK = BMBlocks.registerBlockItem("brown_mushroom_brick", () -> new TBlock(BMBlocks.properties(0.8f).m_60918_(SoundType.f_56711_).m_280658_(NoteBlockInstrument.BASS).m_284180_(MapColor.f_283748_)));
    public static final DecorationBlockFactory BROWN_MUSHROOM_BRICK_DECORATION = new DecorationBlockFactory("biomemakeover", "brown_mushroom_brick", BROWN_MUSHROOM_BRICK, BMBlocks.properties(0.8f).m_280658_(NoteBlockInstrument.BASS).m_280658_(NoteBlockInstrument.BASS).m_284180_(MapColor.f_283748_).m_60918_(SoundType.f_56711_), BMTab.TAB).all().register(BLOCKS, ITEMS);
    public static final RegistrySupplier<Block> PURPLE_GLOWSHROOM_BRICK = BMBlocks.registerBlockItem("purple_glowshroom_brick", () -> new TBlock(BMBlocks.properties(0.8f).m_60953_(s -> 13).m_284180_(MapColor.f_283889_).m_280658_(NoteBlockInstrument.BASS).m_60918_(SoundType.f_56711_)));
    public static final DecorationBlockFactory PURPLE_GLOWSROOM_BRICK_DECORATION = new DecorationBlockFactory("biomemakeover", "purple_glowshroom_brick", PURPLE_GLOWSHROOM_BRICK, BMBlocks.properties(0.8f).m_280658_(NoteBlockInstrument.BASS).m_284180_(MapColor.f_283889_).m_60953_(s -> 13).m_60918_(SoundType.f_56711_), BMTab.TAB).all().register(BLOCKS, ITEMS);
    public static final RegistrySupplier<Block> GREEN_GLOWSHROOM_BRICK = BMBlocks.registerBlockItem("green_glowshroom_brick", () -> new TBlock(BMBlocks.properties(0.8f).m_60953_(s -> 13).m_60918_(SoundType.f_56711_).m_280658_(NoteBlockInstrument.BASS).m_284180_(MapColor.f_283769_)));
    public static final DecorationBlockFactory GREEN_GLOWSROOM_BRICK_DECORATION = new DecorationBlockFactory("biomemakeover", "green_glowshroom_brick", GREEN_GLOWSHROOM_BRICK, BMBlocks.properties(0.8f).m_280658_(NoteBlockInstrument.BASS).m_284180_(MapColor.f_283769_).m_60953_(s -> 13).m_60918_(SoundType.f_56711_), BMTab.TAB).all().register(BLOCKS, ITEMS);
    public static final RegistrySupplier<Block> ORANGE_GLOWSHROOM_BRICK = BMBlocks.registerBlockItem("orange_glowshroom_brick", () -> new TBlock(BMBlocks.properties(0.8f).m_280658_(NoteBlockInstrument.BASS).m_60953_(s -> 13).m_60918_(SoundType.f_56711_).m_284180_(MapColor.f_283750_)));
    public static final DecorationBlockFactory ORANGE_GLOWSROOM_BRICK_DECORATION = new DecorationBlockFactory("biomemakeover", "orange_glowshroom_brick", ORANGE_GLOWSHROOM_BRICK, BMBlocks.properties(0.8f).m_280658_(NoteBlockInstrument.BASS).m_284180_(MapColor.f_283750_).m_60953_(s -> 13).m_60918_(SoundType.f_56711_), BMTab.TAB).all().register(BLOCKS, ITEMS);
    public static final RegistrySupplier<Block> GLOWSHROOM_STEM_BRICK = BMBlocks.registerBlockItem("glowshroom_stem_brick", () -> new TBlock(BMBlocks.properties(0.8f).m_60953_(s -> 7).m_280658_(NoteBlockInstrument.BASS).m_60918_(SoundType.f_56711_).m_284180_(MapColor.f_283744_)));
    public static final DecorationBlockFactory GLOWSHROOM_STEM_BRICK_DECORATION = new DecorationBlockFactory("biomemakeover", "glowshroom_stem_brick", GLOWSHROOM_STEM_BRICK, BMBlocks.properties(0.8f).m_280658_(NoteBlockInstrument.BASS).m_60953_(s -> 7).m_284180_(MapColor.f_283744_).m_60918_(SoundType.f_56711_), BMTab.TAB).all().register(BLOCKS, ITEMS);
    public static final RegistrySupplier<Block> MUSHROOM_STEM_BRICK = BMBlocks.registerBlockItem("mushroom_stem_brick", () -> new TBlock(BMBlocks.properties(0.8f).m_280658_(NoteBlockInstrument.BASS).m_60918_(SoundType.f_56711_).m_284180_(MapColor.f_283930_)));
    public static final DecorationBlockFactory MUSHROOM_STEM_BRICK_DECORATION = new DecorationBlockFactory("biomemakeover", "mushroom_stem_brick", MUSHROOM_STEM_BRICK, BMBlocks.properties(0.8f).m_280658_(NoteBlockInstrument.BASS).m_284180_(MapColor.f_283930_).m_60918_(SoundType.f_56711_), BMTab.TAB).all().register(BLOCKS, ITEMS);
    public static final RegistrySupplier<Block> BLIGHTED_COBBLESTONE = BMBlocks.registerBlockItem("blighted_cobblestone", () -> new TBlock(BMBlocks.properties(2.0f).m_280658_(NoteBlockInstrument.BASEDRUM).m_60918_(SoundType.f_56742_).m_284180_(MapColor.f_283947_).m_60999_()));
    public static final DecorationBlockFactory BLIGHTED_COBBLESTONE_DECORATION = new DecorationBlockFactory("biomemakeover", "blighted_cobblestone", BLIGHTED_COBBLESTONE, BMBlocks.properties(2.0f).m_280658_(NoteBlockInstrument.BASEDRUM).m_284180_(MapColor.f_283947_).m_60999_().m_60918_(SoundType.f_56742_), BMTab.TAB).all().register(BLOCKS, ITEMS);
    public static final RegistrySupplier<Block> BLIGHTED_STONE_BRICKS = BMBlocks.registerBlockItem("blighted_stone_bricks", () -> new TBlock(BMBlocks.properties(2.0f).m_60918_(SoundType.f_56742_).m_280658_(NoteBlockInstrument.BASEDRUM).m_284180_(MapColor.f_283947_).m_60999_()));
    public static final DecorationBlockFactory BLIGHTED_STONE_BRICKS_DECORATION = new DecorationBlockFactory("biomemakeover", "blighted_stone_bricks", BLIGHTED_STONE_BRICKS, BMBlocks.properties(2.0f).m_280658_(NoteBlockInstrument.BASEDRUM).m_284180_(MapColor.f_283947_).m_60999_().m_60918_(SoundType.f_56742_), BMTab.TAB).all().register(BLOCKS, ITEMS);
    public static final RegistrySupplier<Block> PAYDIRT = BMBlocks.registerBlockItem("paydirt", () -> new TBlock(BMBlocks.properties(1.4f).m_60999_().m_60918_(SoundType.f_56739_).m_284180_(MapColor.f_283861_)));
    public static final RegistrySupplier<Block> TUMBLEWEED = BLOCKS.register(BiomeMakeover.ID("tumbleweed"), () -> new Block(BMBlocks.properties(0.0f).m_284180_(MapColor.f_283832_)));
    public static final RegistrySupplier<Block> SAGUARO_CACTUS = BMBlocks.registerBlockItem("saguaro_cactus", () -> new SaguaroCactusBlock(BMBlocks.properties(0.4f).m_284180_(MapColor.f_283784_).m_278166_(PushReaction.DESTROY).m_60918_(SoundType.f_56745_).m_60977_()).modifiers(new BlockModifier[]{RTypeModifier.CUTOUT}));
    public static final RegistrySupplier<Block> BARREL_CACTUS = BMBlocks.registerBlockItem("barrel_cactus", () -> new BarrelCactusBlock(false, BMBlocks.properties(0.0f).m_284180_(MapColor.f_283915_).m_278166_(PushReaction.DESTROY).m_60977_().m_60918_(SoundType.f_56745_).m_60955_().m_60966_().m_60910_()).modifiers(new BlockModifier[]{RTypeModifier.CUTOUT}));
    public static final RegistrySupplier<Block> BARREL_CACTUS_FLOWERED = BMBlocks.registerBlockItem("barrel_cactus_flowered", () -> new BarrelCactusBlock(true, BMBlocks.properties(0.0f).m_278166_(PushReaction.DESTROY).m_284180_(MapColor.f_283765_).m_60918_(SoundType.f_56745_).m_60955_().m_60966_().m_60910_()).modifiers(new BlockModifier[]{RTypeModifier.CUTOUT}));
    public static final RegistrySupplier<Block> POLTERGEIST = BMBlocks.registerBlockItem("poltergeist", () -> new PoltergeistBlock(BMBlocks.properties(1.0f).m_278166_(PushReaction.BLOCK).m_60953_(bs -> (Boolean)bs.m_61143_((Property)PoltergeistBlock.ENABLED) != false ? 7 : 0).m_60955_().m_284180_(MapColor.f_283898_).m_60918_(SoundType.f_56727_)).modifiers(new BlockModifier[]{RTypeModifier.CUTOUT}));
    public static final RegistrySupplier<Block> ECTOPLASM_COMPOSTER = BLOCKS.register(BiomeMakeover.ID("ectoplasm_composter"), () -> new EctoplasmComposterBlock(BMBlocks.properties(0.6f).m_278183_().m_60918_(SoundType.f_56736_).m_284180_(MapColor.f_283825_)));
    public static final RegistrySupplier<Block> PEAT_COMPOSTER = BLOCKS.register(BiomeMakeover.ID("peat_composter"), () -> new PeatComposterBlock(BMBlocks.properties(0.6f).m_280658_(NoteBlockInstrument.BASS).m_60918_(SoundType.f_56736_).m_278183_().m_284180_(MapColor.f_283825_)));
    public static final WoodBlockFactory WILLOW_WOOD_INFO = new WoodBlockFactory("biomemakeover", "willow", BMTab.TAB).color(MapColor.f_283861_, MapColor.f_283761_).all(() -> BMBoats.WILLOW).register(BLOCKS, ITEMS);
    public static final WoodBlockFactory SWAMP_CYPRESS_WOOD_INFO = new WoodBlockFactory("biomemakeover", "swamp_cypress", BMTab.TAB).color(MapColor.f_283774_, MapColor.f_283895_).all(() -> BMBoats.SWAMP_CYPRESS).register(BLOCKS, ITEMS);
    public static final RegistrySupplier<Block> WILLOWING_BRANCHES = BMBlocks.registerBlockItem("willowing_branches", () -> new WillowingBranchesBlock(BMBlocks.properties(0.1f).m_222979_(BlockBehaviour.OffsetType.XZ).m_278166_(PushReaction.DESTROY).m_60977_().m_60918_(SoundType.f_56760_).m_60910_().m_60955_().m_278183_().m_284180_(MapColor.f_283915_)).modifiers(new BlockModifier[]{RTypeModifier.create((RType)RType.CUTOUT_MIPPED), new FlammableModifier(15, 100)}));
    public static final RegistrySupplier<Block> WILLOW_SAPLING = BMBlocks.registerBlockItem("willow_sapling", () -> new WaterSaplingBlock(new WillowSaplingGenerator(), 1, BMBlocks.properties(0.0f).m_60910_().m_60977_().m_278166_(PushReaction.DESTROY).m_60966_().m_284180_(MapColor.f_283915_).m_60918_(SoundType.f_56740_)).modifiers(new BlockModifier[]{RTypeModifier.CUTOUT}));
    public static final RegistrySupplier<Block> SWAMP_CYPRESS_SAPLING = BMBlocks.registerBlockItem("swamp_cypress_sapling", () -> new WaterSaplingBlock(new SwampCypressSaplingGenerator(), 3, BMBlocks.properties(0.0f).m_278166_(PushReaction.DESTROY).m_60910_().m_60977_().m_284180_(MapColor.f_283915_).m_60966_().m_60918_(SoundType.f_56740_)).modifiers(new BlockModifier[]{RTypeModifier.CUTOUT}));
    public static final RegistrySupplier<Block> PEAT = BMBlocks.registerBlockItem("peat", () -> new TBlock(BMBlocks.properties(0.5f).m_60918_(SoundType.f_56752_).m_284180_(MapColor.f_283861_)));
    public static final RegistrySupplier<Block> DRIED_PEAT = BMBlocks.registerBlockItem("dried_peat", () -> new TBlock(BMBlocks.properties(1.0f).m_60918_(SoundType.f_56720_).m_284180_(MapColor.f_283774_)));
    public static final RegistrySupplier<Block> MOSSY_PEAT = BMBlocks.registerBlockItem("mossy_peat", () -> new TSpreadableBlock(BMBlocks.properties(0.5f).m_60977_().m_60918_(SoundType.f_56752_), PEAT));
    public static final RegistrySupplier<Block> PEAT_FARMLAND = BMBlocks.registerBlockItem("peat_farmland", () -> new PeatFarmlandBlock(BMBlocks.properties(0.5f).m_60918_(SoundType.f_56752_).m_284180_(MapColor.f_283784_).m_60977_().m_60955_()));
    public static final RegistrySupplier<Block> DRIED_PEAT_BRICKS = BMBlocks.registerBlockItem("dried_peat_bricks", () -> new TBlock(BMBlocks.properties(2.0f).m_60918_(SoundType.f_56742_).m_284180_(MapColor.f_283774_).m_280658_(NoteBlockInstrument.BASEDRUM).m_60999_()));
    public static final DecorationBlockFactory DRIED_PEAT_BRICKS_DECORATION = new DecorationBlockFactory("biomemakeover", "dried_peat_bricks", DRIED_PEAT_BRICKS, BMBlocks.properties(2.0f).m_280658_(NoteBlockInstrument.BASEDRUM).m_284180_(MapColor.f_283774_).m_60918_(SoundType.f_56720_).m_60999_().m_60918_(SoundType.f_56742_), BMTab.TAB).all().register(BLOCKS, ITEMS);
    public static final RegistrySupplier<Block> MOSSY_DRIED_PEAT_BRICKS = BMBlocks.registerBlockItem("mossy_dried_peat_bricks", () -> new TBlock(BMBlocks.properties(2.0f).m_60918_(SoundType.f_56742_).m_280658_(NoteBlockInstrument.BASEDRUM).m_284180_(MapColor.f_283774_).m_60999_()));
    public static final DecorationBlockFactory MOSSY_DRIED_PEAT_BRICKS_DECORATION = new DecorationBlockFactory("biomemakeover", "mossy_dried_peat_brick", MOSSY_DRIED_PEAT_BRICKS, BMBlocks.properties(2.0f).m_280658_(NoteBlockInstrument.BASEDRUM).m_284180_(MapColor.f_283774_).m_60918_(SoundType.f_56720_).m_60999_().m_60918_(SoundType.f_56742_), BMTab.TAB).all().register(BLOCKS, ITEMS);
    public static final RegistrySupplier<Block> CRACKED_DRIED_PEAT_BRICKS = BMBlocks.registerBlockItem("cracked_dried_peat_bricks", () -> new TBlock(BMBlocks.properties(2.0f).m_284180_(MapColor.f_283774_).m_280658_(NoteBlockInstrument.BASEDRUM).m_60918_(SoundType.f_56742_).m_60999_()));
    public static final DecorationBlockFactory CRACKED_DRIED_PEAT_BRICKS_DECORATION = new DecorationBlockFactory("biomemakeover", "cracked_dried_peat_brick", CRACKED_DRIED_PEAT_BRICKS, BMBlocks.properties(2.0f).m_280658_(NoteBlockInstrument.BASEDRUM).m_284180_(MapColor.f_283774_).m_60918_(SoundType.f_56720_).m_60999_().m_60918_(SoundType.f_56742_), BMTab.TAB).all().register(BLOCKS, ITEMS);
    public static final RegistrySupplier<Block> SWAMP_AZALEA = BMBlocks.registerBlockItem("buttonbush", () -> new TTallFlowerBlock(BMBlocks.properties(0.0f).m_278166_(PushReaction.DESTROY).m_60910_().m_60966_().m_60918_(SoundType.f_56740_).m_284180_(MapColor.f_283930_)).modifiers(new BlockModifier[]{RTypeModifier.CUTOUT, FlammableModifier.TALL_FLOWER}));
    public static final RegistrySupplier<Block> MARIGOLD = BMBlocks.registerBlockItem("marigold", () -> new TTallFlowerBlock(BMBlocks.properties(0.0f).m_278166_(PushReaction.DESTROY).m_60910_().m_60966_().m_60918_(SoundType.f_56740_).m_284180_(MapColor.f_283750_)).modifiers(new BlockModifier[]{RTypeModifier.CUTOUT, FlammableModifier.TALL_FLOWER}));
    public static final RegistrySupplier<Block> BLACK_THISTLE = BMBlocks.registerBlockItem("black_thistle", () -> new BlackThistleBlock(BMBlocks.properties(0.0f).m_278166_(PushReaction.DESTROY).m_60910_().m_60966_().m_60918_(SoundType.f_56740_).m_284180_(MapColor.f_283771_)).modifiers(new BlockModifier[]{RTypeModifier.CUTOUT, FlammableModifier.TALL_FLOWER}));
    public static final RegistrySupplier<Block> FOXGLOVE = BMBlocks.registerBlockItem("foxglove", () -> new TTallFlowerBlock(BMBlocks.properties(0.0f).m_278166_(PushReaction.DESTROY).m_60910_().m_60966_().m_60918_(SoundType.f_56740_).m_284180_(MapColor.f_283765_)).modifiers(new BlockModifier[]{RTypeModifier.CUTOUT, FlammableModifier.TALL_FLOWER}));
    public static final RegistrySupplier<Block> CATTAIL = BMBlocks.registerBlockItem("cattail", () -> new ReedBlock(BMBlocks.properties(0.0f).m_222979_(BlockBehaviour.OffsetType.XZ).m_278166_(PushReaction.DESTROY).m_60966_().m_60910_().m_60918_(SoundType.f_56740_).m_284180_(MapColor.f_283769_)).modifiers(new BlockModifier[]{RTypeModifier.CUTOUT}));
    public static final RegistrySupplier<Block> REED = BMBlocks.registerBlockItem("reed", () -> new ReedBlock(BMBlocks.properties(0.0f).m_222979_(BlockBehaviour.OffsetType.XZ).m_278166_(PushReaction.DESTROY).m_60966_().m_60910_().m_60918_(SoundType.f_56740_).m_284180_(MapColor.f_283769_)).modifiers(new BlockModifier[]{RTypeModifier.CUTOUT}));
    public static final RegistrySupplier<Block> REED_THATCH = BMBlocks.registerBlockItem("reed_thatch", () -> new TBlock(THATCH_PROPERTIES).modifiers(new BlockModifier[]{FlammableModifier.create((int)20, (int)30)}));
    public static final DecorationBlockFactory REED_THATCH_DECORATION = new DecorationBlockFactory("biomemakeover", "reed_thatch", REED_THATCH, THATCH_PROPERTIES, BMTab.TAB, out -> ((RegistrySupplier)out.getSecond()).listen(i -> FuelRegistry.register((int)73, (ItemLike[])new ItemLike[]{i}))).modifiers(new BlockModifier[]{FlammableModifier.create((int)20, (int)30)}).slab().stair().register(BLOCKS, ITEMS);
    public static final RegistrySupplier<Block> SMALL_LILY_PAD = BMBlocks.registerLilyPad("small_lily_pad", () -> new SmallLilyPadBlock(BMBlocks.properties(0.0f).m_278166_(PushReaction.DESTROY).m_60966_().m_60918_(BM_LILY_PAD_SOUND).m_284180_(MapColor.f_283915_)).modifiers(new BlockModifier[]{RTypeModifier.CUTOUT}), true);
    public static final RegistrySupplier<Block> WATER_LILY = BMBlocks.registerLilyPad("water_lily", () -> new FloweredWaterlilyPadBlock(BMBlocks.properties(0.0f).m_278166_(PushReaction.DESTROY).m_60966_().m_60918_(BM_LILY_PAD_SOUND).m_284180_(MapColor.f_283765_)).modifiers(new BlockModifier[]{RTypeModifier.CUTOUT}), true);
    public static final RegistrySupplier<Block> WILLOW_LEAVES = BMBlocks.registerBlockItem("willow_leaves", () -> new TLeavesBlock(LEAF_PROPERTIES.m_284180_(MapColor.f_283778_)).modifiers(new BlockModifier[]{RTypeModifier.create((RType)RType.CUTOUT_MIPPED), FlammableModifier.LEAVES}));
    public static final RegistrySupplier<Block> SWAMP_CYPRESS_LEAVES = BMBlocks.registerBlockItem("swamp_cypress_leaves", () -> new TLeavesBlock(BlockUtil.copyProperties((BlockBehaviour.Properties)LEAF_PROPERTIES).m_284180_(MapColor.f_283856_)).modifiers(new BlockModifier[]{RTypeModifier.create((RType)RType.CUTOUT_MIPPED), FlammableModifier.LEAVES}));
    public static final RegistrySupplier<Block> LIGHTNING_BUG_BOTTLE = BMBlocks.registerBlockItem("lightning_bug_bottle", () -> new LightningBugBottleBlock(BMBlocks.properties(0.5f).m_278166_(PushReaction.DESTROY).m_60953_(b -> 15).m_60955_().m_284180_(MapColor.f_283808_)).modifiers(new BlockModifier[]{RTypeModifier.CUTOUT}));
    public static final RegistrySupplier<Block> ILLUNITE_CLUSTER = BMBlocks.registerBlockItem("illunite_cluster", () -> new IlluniteClusterBlock(7, 3, 15, BMBlocks.properties(0.5f).m_60918_(ILLUNITE_SOUND).m_278166_(PushReaction.DESTROY).m_284180_(MapColor.f_283933_).m_60955_().m_60982_(BMBlocks::always).m_60991_(BMBlocks::always)).modifiers(new BlockModifier[]{RTypeModifier.CUTOUT}));
    public static final RegistrySupplier<Block> LARGE_ILLUNITE_BUD = BMBlocks.registerBlockItem("large_illunite_bud", () -> new IlluniteClusterBlock(5, 3, 13, BMBlocks.properties(0.5f).m_60918_(ILLUNITE_SOUND).m_278166_(PushReaction.DESTROY).m_284180_(MapColor.f_283933_).m_60955_().m_60982_(BMBlocks::always).m_60991_(BMBlocks::always)).modifiers(new BlockModifier[]{RTypeModifier.CUTOUT}));
    public static final RegistrySupplier<Block> MEDIUM_ILLUNITE_BUD = BMBlocks.registerBlockItem("medium_illunite_bud", () -> new IlluniteClusterBlock(4, 3, 7, BMBlocks.properties(0.5f).m_60918_(ILLUNITE_SOUND).m_278166_(PushReaction.DESTROY).m_284180_(MapColor.f_283933_).m_60955_().m_60982_(BMBlocks::always).m_60991_(BMBlocks::always)).modifiers(new BlockModifier[]{RTypeModifier.CUTOUT}));
    public static final RegistrySupplier<Block> SMALL_ILLUNITE_BUD = BMBlocks.registerBlockItem("small_illunite_bud", () -> new IlluniteClusterBlock(3, 4, 5, BMBlocks.properties(0.5f).m_60918_(ILLUNITE_SOUND).m_278166_(PushReaction.DESTROY).m_284180_(MapColor.f_283933_).m_60955_().m_60982_(BMBlocks::always).m_60991_(BMBlocks::always)).modifiers(new BlockModifier[]{RTypeModifier.CUTOUT}));
    public static final RegistrySupplier<Block> ILLUNITE_BLOCK = BMBlocks.registerBlockItem("illunite_block", () -> new TBlock(BMBlocks.properties(1.5f).m_284180_(MapColor.f_283933_).m_60999_().m_60918_(ILLUNITE_SOUND)));
    public static final RegistrySupplier<Block> BUDDING_ILLUNITE = BMBlocks.registerBlockItem("budding_illunite", () -> new BuddingIlluniteBlock(BMBlocks.properties(1.5f).m_284180_(MapColor.f_283933_).m_222994_().m_60977_().m_60918_(ILLUNITE_SOUND)));
    public static final RegistrySupplier<Block> MESMERITE = BMBlocks.registerBlockItem("mesmerite", () -> new TBlock(BMBlocks.properties(1.5f).m_280658_(NoteBlockInstrument.BASEDRUM).m_284180_(MapColor.f_283828_)));
    public static final DecorationBlockFactory MESMERITE_DECORATION = new DecorationBlockFactory("biomemakeover", "mesmerite", MESMERITE, BMBlocks.properties(1.5f).m_280658_(NoteBlockInstrument.BASEDRUM).m_284180_(MapColor.f_283828_), BMTab.TAB).all().register(BLOCKS, ITEMS);
    public static final RegistrySupplier<Block> POLISHED_MESMERITE = BMBlocks.registerBlockItem("polished_mesmerite", () -> new TBlock(BMBlocks.properties(1.5f).m_280658_(NoteBlockInstrument.BASEDRUM).m_284180_(MapColor.f_283828_)));
    public static final DecorationBlockFactory POLISHED_MESMERITE_DECORATION = new DecorationBlockFactory("biomemakeover", "polished_mesmerite", POLISHED_MESMERITE, BMBlocks.properties(1.5f).m_280658_(NoteBlockInstrument.BASEDRUM).m_284180_(MapColor.f_283828_), BMTab.TAB).all().register(BLOCKS, ITEMS);
    public static final WoodBlockFactory ANCIENT_OAK_WOOD_INFO = new WoodBlockFactory("biomemakeover", "ancient_oak", BMTab.TAB).color(MapColor.f_283771_, MapColor.f_283774_).all(() -> BMBoats.ANCIENT_OAK).register(BLOCKS, ITEMS);
    public static final RegistrySupplier<Block> ANCIENT_OAK_SAPLING = BMBlocks.sapling("ancient_oak_sapling", (AbstractTreeGrower)new AncientOakSaplingGenerator(), MapColor.f_283915_);
    public static final RegistrySupplier<Block> ANCIENT_OAK_LEAVES = BMBlocks.registerBlockItem("ancient_oak_leaves", () -> new TLeavesBlock(LEAF_PROPERTIES).modifiers(new BlockModifier[]{RTypeModifier.create((RType)RType.CUTOUT_MIPPED), FlammableModifier.LEAVES}));
    public static final RegistrySupplier<Block> ALTAR = BMBlocks.registerBlockItem("altar", () -> new AltarBlock(BMBlocks.properties(5.0f).m_60953_(st -> (Boolean)st.m_61143_((Property)AltarBlock.ACTIVE) != false ? 5 : 1).m_280658_(NoteBlockInstrument.BASEDRUM).m_60999_().m_284180_(MapColor.f_283927_).m_60955_()).modifiers(new BlockModifier[]{RTypeModifier.CUTOUT}));
    public static final RegistrySupplier<Block> CLADDED_STONE = BMBlocks.registerBlockItem("cladded_stone", () -> new TBlock(BMBlocks.properties(1.5f, 6.0f).m_60999_().m_280658_(NoteBlockInstrument.BASEDRUM).m_284180_(MapColor.f_283947_)));
    public static final RegistrySupplier<Block> CRUDE_CLADDING_BLOCK = BMBlocks.registerBlockItem("crude_cladding_block", () -> new TBlock(BMBlocks.properties(5.0f, 7.0f).m_280658_(NoteBlockInstrument.IRON_XYLOPHONE).m_60918_(SoundType.f_56725_).m_60999_().m_284180_(MapColor.f_283749_)));
    public static final RegistrySupplier<Block> ROOTLING_CROP = BMBlocks.register("rootling_crop", () -> new RootlingCropBlock(BMBlocks.properties(0.0f).m_60910_().m_60977_().m_60966_().m_60918_(SoundType.f_56758_).m_284180_(MapColor.f_283915_).m_278166_(PushReaction.DESTROY)).modifiers(new BlockModifier[]{RTypeModifier.CUTOUT}));
    public static final RegistrySupplier<Block> IVY = BMBlocks.registerBlockItem("ivy", () -> new IvyBlock(BMBlocks.properties(0.15f).m_60910_().m_60977_().m_280170_().m_60918_(SoundType.f_56760_).m_278166_(PushReaction.DESTROY).m_284180_(MapColor.f_283915_)).modifiers(new BlockModifier[]{RTypeModifier.CUTOUT, FlammableModifier.IVY}));
    public static final RegistrySupplier<Block> ITCHING_IVY = BMBlocks.registerBlockItem("itching_ivy", () -> new ItchingIvyBlock(BMBlocks.properties(0.15f).m_280170_().m_60956_(0.5f).m_60910_().m_284180_(MapColor.f_283915_).m_278166_(PushReaction.DESTROY).m_60977_().m_60918_(SoundType.f_56760_)).modifiers(new BlockModifier[]{RTypeModifier.CUTOUT, FlammableModifier.IVY}));
    public static final RegistrySupplier<Block> MOTH_BLOSSOM = BMBlocks.registerBlockItem("moth_blossom", () -> new MothBlossomBlock(BMBlocks.properties(0.25f).m_60956_(0.5f).m_60910_().m_60977_().m_60918_(SoundType.f_56760_).m_284180_(MapColor.f_283750_).m_278166_(PushReaction.DESTROY)).modifiers(new BlockModifier[]{RTypeModifier.CUTOUT, FlammableModifier.IVY}));
    public static final RegistrySupplier<Block> WILD_MUSHROOMS = BMBlocks.registerBlockItem("wild_mushrooms", () -> new WildMushroomBlock(BMBlocks.properties(0.0f).m_60910_().m_60966_().m_60977_().m_60955_().m_60918_(SoundType.f_56711_).m_284180_(MapColor.f_283930_).m_278166_(PushReaction.DESTROY)).modifiers(new BlockModifier[]{RTypeModifier.CUTOUT, FlammableModifier.IVY}));
    public static final RegistrySupplier<Block> SUSPICIOUS_RED_SAND = BMBlocks.registerBlockItem("suspicious_red_sand", () -> new BrushableBlock(Blocks.f_49993_, BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283761_).m_280658_(NoteBlockInstrument.SNARE).m_60978_(0.25f).m_60918_(SoundType.f_271168_).m_278166_(PushReaction.DESTROY), SoundEvents.f_271174_, SoundEvents.f_271452_));
    public static final TapestryInfo TAPESTRIES = TapestryInfo.create();
    public static final TerracottaBrickInfo TERRACOTTA_BRICKS = TerracottaBrickInfo.create();
    public static final RegistrySupplier<Block> CRACKED_BRICKS = BMBlocks.registerBlockItem("cracked_bricks", () -> new TBlock(BMBlocks.properties(2.0f, 6.0f).m_60999_().m_280658_(NoteBlockInstrument.BASEDRUM).m_284180_(MapColor.f_283913_)));
    public static final DecorationBlockFactory CRACKED_BRICKS_DECORATION = new DecorationBlockFactory("biomemakeover", "cracked_brick", CRACKED_BRICKS, BMBlocks.properties(2.0f, 6.0f).m_60999_().m_280658_(NoteBlockInstrument.BASEDRUM).m_284180_(MapColor.f_283913_), BMTab.TAB).all().register(BLOCKS, ITEMS);
    public static final RegistrySupplier<Block> POTTED_MYCELIUM_ROOTS = BMBlocks.pottedPlant("mycelium_roots", MYCELIUM_ROOTS);
    public static final RegistrySupplier<Block> POTTED_PURPLE_GLOWSHROOM = BMBlocks.litPottedPlant("purple_glowshroom", PURPLE_GLOWSHROOM, 13);
    public static final RegistrySupplier<Block> POTTED_GREEN_GLOWSHROOM = BMBlocks.litPottedPlant("green_glowshroom", GREEN_GLOWSHROOM, 13);
    public static final RegistrySupplier<Block> POTTED_ORANGE_GLOWSHROOM = BMBlocks.litPottedPlant("orange_glowshroom", ORANGE_GLOWSHROOM, 13);
    public static final RegistrySupplier<Block> POTTED_SAGUARO_CACTUS = BMBlocks.pottedPlant("saguaro_cactus", SAGUARO_CACTUS);
    public static final RegistrySupplier<Block> POTTED_BARREL_CACTUS = BMBlocks.pottedPlant("barrel_cactus", BARREL_CACTUS);
    public static final RegistrySupplier<Block> POTTED_FLOWERED_BARREL_CACTUS = BMBlocks.pottedPlant("flowered_barrel_cactus", BARREL_CACTUS_FLOWERED);
    public static final RegistrySupplier<Block> POTTED_WILLOW_SAPLING = BMBlocks.pottedPlant("willow_sapling", WILLOW_SAPLING);
    public static final RegistrySupplier<Block> POTTED_SWAMP_CYPRESS_SAPLING = BMBlocks.pottedPlant("swamp_cypress_sapling", SWAMP_CYPRESS_SAPLING);
    public static final RegistrySupplier<Block> POTTED_WILD_MUSHROOMS = BMBlocks.pottedPlant("wild_mushrooms", WILD_MUSHROOMS);
    public static final RegistrySupplier<Block> DIRECTIONAL_DATA = BMBlocks.registerBlockItem("directional_data", () -> new DirectionalDataBlock(BlockBehaviour.Properties.m_284310_().m_60978_(-1.0f).m_222994_()), false);

    public static void init() {
        BLOCKS.register();
        ITEMS.register();
        DIRECTIONAL_DATA.listen(b -> {
            HoeItemHooks.addTillable((Block)((Block)PEAT.get()), HoeItem::m_150856_, (Consumer)HoeItem.m_150858_((BlockState)((Block)PEAT_FARMLAND.get()).m_49966_()), c -> ((Block)PEAT_FARMLAND.get()).m_49966_());
            HoeItemHooks.addTillable((Block)((Block)MOSSY_PEAT.get()), HoeItem::m_150856_, (Consumer)HoeItem.m_150858_((BlockState)((Block)PEAT_FARMLAND.get()).m_49966_()), c -> ((Block)PEAT_FARMLAND.get()).m_49966_());
        });
        SUSPICIOUS_RED_SAND.listen(b -> BlockEntityHooks.addAdditionalBlock((BlockEntityType)BlockEntityType.f_271323_, (Block[])new Block[]{b}));
    }

    public static Boolean canSpawnOnLeaves(BlockState blockState, BlockGetter blockGetter, BlockPos blockPos, EntityType<?> type) {
        return type == EntityType.f_20505_ || type == EntityType.f_20508_;
    }

    public static RegistrySupplier<Block> registerBlockItemPot(String id, Supplier<Block> block) {
        RegistrySupplier<Block> baseBlock = BMBlocks.registerBlockItem(id, block);
        BMBlocks.pottedPlant(id, baseBlock);
        return baseBlock;
    }

    public static RegistrySupplier<Block> registerBlockItem(String id, Supplier<Block> block) {
        return BMBlocks.registerBlockItem(id, block, true);
    }

    public static RegistrySupplier<Block> registerBlockItem(String id, Supplier<Block> block, boolean tab) {
        RegistrySupplier<Block> bl = BMBlocks.registerBlock(BLOCKS, BiomeMakeover.ID(id), block);
        RegistrySupplier it = ItemHelper.registerItem(ITEMS, (ResourceLocation)BiomeMakeover.ID(id), () -> new BlockItem((Block)bl.get(), new Item.Properties()));
        BMBlocks.initBlockItem(bl, (RegistrySupplier<Item>)it);
        if (tab) {
            CreativeTabRegistry.append(BMTab.TAB, (Supplier[])new RegistrySupplier[]{it});
        }
        return bl;
    }

    public static RegistrySupplier<Block> registerBlock(DeferredRegister<Block> register, ResourceLocation location, Supplier<Block> blockSupplier) {
        return BlockHelper.registerBlock(register, (ResourceLocation)location, blockSupplier);
    }

    public static RegistrySupplier<Block> register(String id, Supplier<Block> block) {
        return BMBlocks.registerBlock(BLOCKS, BiomeMakeover.ID(id), block);
    }

    private static RegistrySupplier<Block> pottedPlant(String base_name, RegistrySupplier<Block> baseBlock) {
        return BMBlocks.register("potted_" + base_name, () -> new TFlowerPotBlock((Block)baseBlock.get(), BMBlocks.properties(0.0f).m_284180_(MapColor.f_283808_).m_60966_().m_60955_().m_278166_(PushReaction.DESTROY)).modifiers(new BlockModifier[]{RTypeModifier.CUTOUT}));
    }

    private static RegistrySupplier<Block> litPottedPlant(String base_name, RegistrySupplier<Block> baseBlock, int light) {
        return BMBlocks.register("potted_" + base_name, () -> new TFlowerPotBlock((Block)baseBlock.get(), BMBlocks.properties(0.0f).m_284180_(MapColor.f_283808_).m_60953_(s -> light).m_60966_().m_60955_().m_278166_(PushReaction.DESTROY)).modifiers(new BlockModifier[]{RTypeModifier.CUTOUT}));
    }

    private static RegistrySupplier<Block> sapling(String name, AbstractTreeGrower grower, MapColor color) {
        RegistrySupplier<Block> sapling = BMBlocks.registerBlockItem(name, () -> new TSaplingBlock(grower, BlockBehaviour.Properties.m_284310_().m_60910_().m_284180_(color).m_60977_().m_60966_().m_60918_(SoundType.f_56740_).m_278166_(PushReaction.DESTROY)).modifiers(new BlockModifier[]{RTypeModifier.CUTOUT}));
        BMBlocks.pottedPlant(name, sapling);
        return sapling;
    }

    private static RegistrySupplier<Block> leaves(String name) {
        return BMBlocks.registerBlockItem(name, () -> new TLeavesBlock(LEAF_PROPERTIES).modifiers(LEAF_MODIFIERS));
    }

    public static BlockBehaviour.Properties properties(float strength) {
        return BMBlocks.properties(strength, strength);
    }

    public static BlockBehaviour.Properties properties(float breakSpeed, float explosionResist) {
        return BlockBehaviour.Properties.m_284310_().m_60913_(breakSpeed, explosionResist);
    }

    private static boolean always(BlockState state, BlockGetter world, BlockPos pos) {
        return true;
    }

    public static RegistrySupplier<Block> registerLilyPad(String id, Supplier<Block> block, boolean tab) {
        RegistrySupplier<Block> bl = BMBlocks.register(id, block);
        RegistrySupplier it = ItemHelper.registerItem(ITEMS, (ResourceLocation)BiomeMakeover.ID(id), () -> new PlaceOnWaterBlockItem((Block)bl.get(), new Item.Properties()));
        BMBlocks.initBlockItem(bl, (RegistrySupplier<Item>)it);
        if (tab) {
            CreativeTabRegistry.append(BMTab.TAB, (Supplier[])new RegistrySupplier[]{it});
        }
        return bl;
    }

    private static void initBlockItem(RegistrySupplier<Block> block, RegistrySupplier<Item> item) {
        BLOCK_ITEMS.put(block, item);
    }

    private static TagKey<Block> blockTag(String path) {
        return BMBlocks.blockTag(BiomeMakeover.ID(path));
    }

    private static TagKey<Block> blockTag(ResourceLocation id) {
        return TagKey.m_203882_((ResourceKey)Registries.f_256747_, (ResourceLocation)id);
    }

    private static boolean never(BlockState blockState, BlockGetter blockGetter, BlockPos blockPos, EntityType<?> entityType) {
        return false;
    }

    private static boolean never(BlockState state, BlockGetter blockGetter, BlockPos pos) {
        return false;
    }

    public static final class TapestryInfo {
        private final List<RegistrySupplier<Block>> allBlocks;
        private final List<RegistrySupplier<Block>> wallBlocks;
        private final List<RegistrySupplier<Block>> floorBlocks;
        private final RegistrySupplier<Block> adjudicator;

        static TapestryInfo create() {
            return new TapestryInfo();
        }

        private TapestryInfo() {
            ArrayList<RegistrySupplier<Block>> allBlocks = new ArrayList<RegistrySupplier<Block>>();
            ArrayList<RegistrySupplier<Block>> wallBlocks = new ArrayList<RegistrySupplier<Block>>();
            ArrayList<RegistrySupplier<Block>> floorBlocks = new ArrayList<RegistrySupplier<Block>>();
            HashSet<RegistrySupplier<Block>> allBlocksSet = new HashSet<RegistrySupplier<Block>>();
            HashSet<RegistrySupplier<Block>> wallBlocksSet = new HashSet<RegistrySupplier<Block>>();
            HashSet<RegistrySupplier<Block>> floorBlocksSet = new HashSet<RegistrySupplier<Block>>();
            for (DyeColor dye : DyeColor.values()) {
                RegistrySupplier tapestryBlock = BLOCKS.register(BiomeMakeover.ID(dye.m_41065_() + "_tapestry"), () -> new ColorTapestryBlock(dye, BMBlocks.properties(1.0f).m_280658_(NoteBlockInstrument.BASS).m_60910_().m_60918_(SoundType.f_56736_)));
                RegistrySupplier wallBlock = BLOCKS.register(BiomeMakeover.ID(dye.m_41065_() + "_wall_tapestry"), () -> new ColorTapestryWallBlock(dye, BMBlocks.properties(1.0f).m_280658_(NoteBlockInstrument.BASS).m_60910_().m_60918_(SoundType.f_56736_).m_60916_((Block)tapestryBlock.get())));
                RegistrySupplier it = ItemHelper.registerItem(ITEMS, (ResourceLocation)BiomeMakeover.ID(dye.m_41065_() + "_tapestry"), () -> new StandingAndWallBlockItem((Block)tapestryBlock.get(), (Block)wallBlock.get(), new Item.Properties().m_41487_(16).m_41497_(Rarity.UNCOMMON), Direction.DOWN));
                CreativeTabRegistry.append(BMTab.TAB, (Supplier[])new RegistrySupplier[]{it});
                BMBlocks.initBlockItem((RegistrySupplier<Block>)tapestryBlock, (RegistrySupplier<Item>)it);
                BMBlocks.initBlockItem((RegistrySupplier<Block>)wallBlock, (RegistrySupplier<Item>)it);
                TapestryInfo.addIfNew(allBlocks, allBlocksSet, (RegistrySupplier<Block>)tapestryBlock);
                TapestryInfo.addIfNew(allBlocks, allBlocksSet, (RegistrySupplier<Block>)wallBlock);
                TapestryInfo.addIfNew(floorBlocks, floorBlocksSet, (RegistrySupplier<Block>)tapestryBlock);
                TapestryInfo.addIfNew(wallBlocks, wallBlocksSet, (RegistrySupplier<Block>)wallBlock);
            }
            this.adjudicator = BLOCKS.register(BiomeMakeover.ID("adjudicator_tapestry"), () -> new AdjudicatorTapestryBlock(BMBlocks.properties(1.0f).m_280606_().m_280658_(NoteBlockInstrument.BASS).m_60910_().m_60918_(SoundType.f_56736_)));
            RegistrySupplier adjWall = BLOCKS.register(BiomeMakeover.ID("adjudicator_wall_tapestry"), () -> new AdjudicatorTapestryWallBlock(BMBlocks.properties(1.0f).m_280606_().m_280658_(NoteBlockInstrument.BASS).m_60910_().m_60918_(SoundType.f_56736_).m_60916_((Block)this.adjudicator.get())));
            RegistrySupplier it = ItemHelper.registerItem(ITEMS, (ResourceLocation)BiomeMakeover.ID("adjudicator_tapestry"), () -> new StandingAndWallBlockItem((Block)this.adjudicator.get(), (Block)adjWall.get(), new Item.Properties().m_41487_(16).m_41497_(Rarity.EPIC), Direction.DOWN));
            BMBlocks.initBlockItem((RegistrySupplier<Block>)adjWall, (RegistrySupplier<Item>)it);
            BMBlocks.initBlockItem(this.adjudicator, (RegistrySupplier<Item>)it);
            allBlocks.add(this.adjudicator);
            allBlocks.add(adjWall);
            this.allBlocks = Collections.unmodifiableList(allBlocks);
            this.wallBlocks = Collections.unmodifiableList(wallBlocks);
            this.floorBlocks = Collections.unmodifiableList(floorBlocks);
        }

        private static void addIfNew(List<RegistrySupplier<Block>> list, Set<RegistrySupplier<Block>> set, RegistrySupplier<Block> block) {
            if (set.add(block)) {
                list.add(block);
            }
        }

        public List<RegistrySupplier<Block>> getWallBlocks() {
            return this.wallBlocks;
        }

        public List<RegistrySupplier<Block>> getFloorBlocks() {
            return this.floorBlocks;
        }

        public List<RegistrySupplier<Block>> getBlocks() {
            return this.allBlocks;
        }

        public RegistrySupplier<Block> getAdjudicatorTapestry() {
            return this.adjudicator;
        }
    }

    public static final class TerracottaBrickInfo {
        private TerracottaBrickInfo() {
        }

        public static TerracottaBrickInfo create() {
            return new TerracottaBrickInfo().init();
        }

        public TerracottaBrickInfo init() {
            RegistrySupplier<Block> tBlock = BMBlocks.registerBlockItem("terracotta_bricks", () -> new TBlock(BMBlocks.properties(2.0f).m_284180_(MapColor.f_283750_).m_280658_(NoteBlockInstrument.BASEDRUM).m_60999_().m_60918_(SoundType.f_56742_)));
            DecorationBlockFactory terracottaBrick = new DecorationBlockFactory("biomemakeover", "terracotta_brick", tBlock, BMBlocks.properties(2.0f).m_284180_(MapColor.f_283750_).m_280658_(NoteBlockInstrument.BASEDRUM).m_60999_().m_60918_(SoundType.f_56742_), BMTab.TAB).all().register(BLOCKS, ITEMS);
            ImmutableMap colors = ImmutableMap.builder().put((Object)DyeColor.WHITE, (Object)MapColor.f_283919_).put((Object)DyeColor.ORANGE, (Object)MapColor.f_283895_).put((Object)DyeColor.MAGENTA, (Object)MapColor.f_283850_).put((Object)DyeColor.LIGHT_BLUE, (Object)MapColor.f_283791_).put((Object)DyeColor.YELLOW, (Object)MapColor.f_283843_).put((Object)DyeColor.LIME, (Object)MapColor.f_283778_).put((Object)DyeColor.PINK, (Object)MapColor.f_283870_).put((Object)DyeColor.GRAY, (Object)MapColor.f_283861_).put((Object)DyeColor.LIGHT_GRAY, (Object)MapColor.f_283907_).put((Object)DyeColor.CYAN, (Object)MapColor.f_283846_).put((Object)DyeColor.PURPLE, (Object)MapColor.f_283892_).put((Object)DyeColor.BLUE, (Object)MapColor.f_283908_).put((Object)DyeColor.BROWN, (Object)MapColor.f_283774_).put((Object)DyeColor.GREEN, (Object)MapColor.f_283856_).put((Object)DyeColor.RED, (Object)MapColor.f_283798_).put((Object)DyeColor.BLACK, (Object)MapColor.f_283771_).build();
            for (DyeColor dye : DyeColor.values()) {
                RegistrySupplier<Block> bl = BMBlocks.registerBlockItem(dye.m_41065_() + "_terracotta_bricks", () -> TerracottaBrickInfo.lambda$init$1((Map)colors, dye));
                DecorationBlockFactory decorationBlockFactory = new DecorationBlockFactory("biomemakeover", dye.m_41065_() + "_terracotta_brick", bl, BMBlocks.properties(2.0f).m_284180_((MapColor)colors.get(dye)).m_60999_().m_280658_(NoteBlockInstrument.BASEDRUM).m_60918_(SoundType.f_56742_), BMTab.TAB).all().register(BLOCKS, ITEMS);
            }
            return this;
        }

        private static /* synthetic */ Block lambda$init$1(Map colors, DyeColor dye) {
            return new TBlock(BMBlocks.properties(2.0f).m_284180_((MapColor)colors.get(dye)).m_60999_().m_280658_(NoteBlockInstrument.BASEDRUM).m_60918_(SoundType.f_56742_));
        }
    }
}

