/*
 * Decompiled with CFR 0.152.
 */
package party.lemons.biomemakeover.entity.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.block.Block;
import org.joml.Quaternionf;
import party.lemons.biomemakeover.entity.TumbleweedEntity;
import party.lemons.biomemakeover.init.BMBlocks;

public class TumbleweedRender
extends EntityRenderer<TumbleweedEntity> {
    public TumbleweedRender(EntityRendererProvider.Context context) {
        super(context);
    }

    public void render(TumbleweedEntity entity, float f, float delta, PoseStack poseStack, MultiBufferSource multiBufferSource, int i) {
        super.m_7392_((Entity)entity, f, delta, poseStack, multiBufferSource, i);
        poseStack.m_85836_();
        poseStack.m_85837_(0.0, 0.5, 0.0);
        poseStack.m_252781_(TumbleweedRender.slerp(entity.prevQuaternion, entity.quaternion, delta));
        poseStack.m_252781_(Axis.f_252436_.m_252977_(-90.0f));
        poseStack.m_85837_(-0.5, -0.5, 0.5);
        poseStack.m_252781_(Axis.f_252436_.m_252977_(90.0f));
        Minecraft.m_91087_().m_91289_().m_110912_(((Block)BMBlocks.TUMBLEWEED.get()).m_49966_(), poseStack, multiBufferSource, i, OverlayTexture.f_118083_);
        poseStack.m_85849_();
    }

    public static Quaternionf slerp(Quaternionf v0, Quaternionf v1, float t) {
        float dot = v0.dot(v1);
        if (dot < 0.0f) {
            v1 = new Quaternionf(-v1.x(), -v1.y(), -v1.z(), -v1.w());
            dot = -dot;
        }
        if (dot > 0.9995f) {
            float x = Mth.m_14179_((float)t, (float)v0.x(), (float)v1.x());
            float y = Mth.m_14179_((float)t, (float)v0.y(), (float)v1.y());
            float z = Mth.m_14179_((float)t, (float)v0.z(), (float)v1.z());
            float w = Mth.m_14179_((float)t, (float)v0.w(), (float)v1.w());
            return new Quaternionf(x, y, z, w);
        }
        float angle01 = (float)Math.acos(dot);
        float angle0t = angle01 * t;
        float sin0t = Mth.m_14031_((float)angle0t);
        float sin01 = Mth.m_14031_((float)angle01);
        float sin1t = Mth.m_14031_((float)(angle01 - angle0t));
        float s1 = sin0t / sin01;
        float s0 = sin1t / sin01;
        return new Quaternionf(s0 * v0.x() + s1 * v1.x(), s0 * v0.y() + s1 * v1.y(), s0 * v0.z() + s1 * v1.z(), s0 * v0.w() + s1 * v1.w());
    }

    public ResourceLocation getTextureLocation(TumbleweedEntity entity) {
        return TextureAtlas.f_118259_;
    }
}

