/*
 * Decompiled with CFR 0.152.
 */
package party.lemons.biomemakeover.entity.render;

import com.google.common.collect.ImmutableList;
import net.minecraft.client.model.AgeableListModel;
import net.minecraft.client.model.HeadedModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import party.lemons.biomemakeover.BiomeMakeover;
import party.lemons.biomemakeover.entity.OwlEntity;

public class OwlModel
extends AgeableListModel<OwlEntity>
implements HeadedModel {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(BiomeMakeover.ID("owl"), "main");
    private final ModelPart chest;
    private final ModelPart head;
    private final ModelPart wing_left;
    private final ModelPart wing_left_connection;
    private final ModelPart wing_tip_left;
    private final ModelPart wing_right;
    private final ModelPart wing_right_connection;
    private final ModelPart wing_tip_right;
    private final ModelPart leg_right;
    private final ModelPart leg_left;
    private final ModelPart foot_right;
    private final ModelPart foot_left;

    public OwlModel(ModelPart root) {
        super(true, 14.0f, 0.0f, 2.0f, 2.0f, 24.0f);
        this.chest = root.m_171324_("chest");
        this.head = root.m_171324_("head_connection");
        this.wing_left_connection = this.chest.m_171324_("wing_left_connection");
        this.wing_right_connection = this.chest.m_171324_("wing_right_connection");
        this.wing_left = this.wing_left_connection.m_171324_("wing_left");
        this.wing_right = this.wing_right_connection.m_171324_("wing_right");
        this.wing_tip_left = this.wing_left.m_171324_("wing_tip_left");
        this.wing_tip_right = this.wing_right.m_171324_("wing_tip_right");
        this.leg_left = this.chest.m_171324_("leg_left");
        this.leg_right = this.chest.m_171324_("leg_right");
        this.foot_right = this.leg_right.m_171324_("foot_right");
        this.foot_left = this.leg_left.m_171324_("foot_left");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition chest = partdefinition.m_171599_("chest", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-3.0f, -5.575f, -3.3125f, 6.0f, 8.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)14.975f, (float)0.3125f));
        PartDefinition chest_lower_r1 = chest.m_171599_("chest_lower_r1", CubeListBuilder.m_171558_().m_171514_(21, 21).m_171488_(-3.0f, -1.0f, -3.0f, 6.0f, 6.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)1.425f, (float)0.6875f, (float)0.2182f, (float)0.0f, (float)0.0f));
        PartDefinition wing_left_connection = chest.m_171599_("wing_left_connection", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)3.0f, (float)-5.575f, (float)0.6875f));
        PartDefinition wing_left = wing_left_connection.m_171599_("wing_left", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)-3.0f));
        PartDefinition wing_upper_r1 = wing_left.m_171599_("wing_upper_r1", CubeListBuilder.m_171558_().m_171514_(0, 28).m_171488_(0.0f, -1.0f, -2.0f, 2.0f, 11.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)1.0f, (float)2.0f, (float)0.2618f, (float)0.0f, (float)0.0f));
        PartDefinition wing_tip_left = wing_left.m_171599_("wing_tip_left", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.5f, (float)9.0f, (float)7.0f));
        PartDefinition wing_tip_r1 = wing_tip_left.m_171599_("wing_tip_r1", CubeListBuilder.m_171558_().m_171514_(18, 34).m_171488_(0.0f, -1.0f, -2.0f, 1.0f, 8.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-0.5f, (float)-4.0f, (float)-2.0f, (float)0.5672f, (float)0.0f, (float)0.0f));
        PartDefinition wing_right_connection = chest.m_171599_("wing_right_connection", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)-3.0f, (float)-5.575f, (float)0.6875f));
        PartDefinition wing_right = wing_right_connection.m_171599_("wing_right", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)-3.0f));
        PartDefinition wing_upper_r2 = wing_right.m_171599_("wing_upper_r2", CubeListBuilder.m_171558_().m_171514_(28, 0).m_171488_(-2.0f, -1.0f, -2.0f, 2.0f, 11.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)1.0f, (float)2.0f, (float)0.2618f, (float)0.0f, (float)0.0f));
        PartDefinition wing_tip_right = wing_right.m_171599_("wing_tip_right", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)-0.5f, (float)9.0f, (float)7.0f));
        PartDefinition wing_tip_r2 = wing_tip_right.m_171599_("wing_tip_r2", CubeListBuilder.m_171558_().m_171514_(28, 34).m_171488_(-1.0f, -1.0f, -2.0f, 1.0f, 8.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.5f, (float)-4.0f, (float)-2.0f, (float)0.5672f, (float)0.0f, (float)0.0f));
        PartDefinition leg_right = chest.m_171599_("leg_right", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)-1.5f, (float)6.925f, (float)1.6875f));
        PartDefinition thigh_right_r1 = leg_right.m_171599_("thigh_right_r1", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-1.0f, -1.0f, -1.0f, 2.0f, 3.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)0.0f, (float)0.4363f, (float)0.0f, (float)0.0f));
        PartDefinition foot_right = leg_right.m_171599_("foot_right", CubeListBuilder.m_171558_().m_171514_(16, 4).m_171488_(-1.5f, -0.5f, -3.0f, 3.0f, 0.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)2.5f, (float)0.0f));
        PartDefinition leg_left = chest.m_171599_("leg_left", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)1.5f, (float)6.925f, (float)1.6875f));
        PartDefinition thigh_left_r1 = leg_left.m_171599_("thigh_left_r1", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-1.0f, -1.0f, -1.0f, 2.0f, 3.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)0.0f, (float)0.4363f, (float)0.0f, (float)0.0f));
        PartDefinition foot_left = leg_left.m_171599_("foot_left", CubeListBuilder.m_171558_().m_171514_(16, 0).m_171488_(-1.5f, -0.5f, -1.0f, 3.0f, 0.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)2.5f, (float)-2.0f));
        PartDefinition tail = chest.m_171599_("tail", CubeListBuilder.m_171558_(), PartPose.m_171423_((float)0.0f, (float)5.925f, (float)5.1875f, (float)0.3054f, (float)0.0f, (float)0.0f));
        PartDefinition tail_r1 = tail.m_171599_("tail_r1", CubeListBuilder.m_171558_().m_171514_(38, 38).m_171488_(-3.0f, -0.5f, 0.0f, 6.0f, 5.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)0.0f, (float)0.5236f, (float)0.0f, (float)0.0f));
        PartDefinition head_connection = partdefinition.m_171599_("head_connection", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)6.4f, (float)1.0f));
        PartDefinition head = head_connection.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(0, 16).m_171488_(-4.0f, -6.0f, -3.0f, 8.0f, 6.0f, 6.0f, new CubeDeformation(0.0f)).m_171514_(0, 5).m_171488_(-0.6f, -2.0f, -5.0f, 1.0f, 1.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)3.0f, (float)0.0f));
        PartDefinition beak_lower = head.m_171599_("beak_lower", CubeListBuilder.m_171558_().m_171514_(4, 5).m_171488_(-2.1f, -14.5f, -5.0f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)1.5f, (float)13.5f, (float)1.0f));
        PartDefinition brow_left = head.m_171599_("brow_left", CubeListBuilder.m_171558_().m_171514_(11, 28).m_171488_(0.0f, -0.5f, -0.5f, 4.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)1.0f, (float)-4.5f, (float)-3.5f));
        PartDefinition brow_right = head.m_171599_("brow_right", CubeListBuilder.m_171558_().m_171514_(11, 30).m_171488_(-4.0f, -0.5f, -0.5f, 4.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-1.0f, (float)-4.5f, (float)-3.5f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    public void setupAnim(OwlEntity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        float pi = (float)Math.PI;
        if (entity.getStandingState() != OwlEntity.StandingState.FLYING) {
            this.head.f_104203_ = -0.2618f + headPitch * 0.0175f;
            this.head.f_104204_ = netHeadYaw * 0.0175f;
            this.wing_tip_left.f_104205_ = 0.0f;
            this.wing_tip_right.f_104205_ = 0.0f;
            this.leg_right.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f)) * 1.4f * limbSwingAmount;
            this.leg_left.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f + pi)) * 1.4f * limbSwingAmount;
            this.wing_right_connection.f_104204_ = Mth.m_14089_((float)(limbSwing * 0.6662f)) * 0.5f * limbSwingAmount;
            this.wing_left_connection.f_104204_ = Mth.m_14089_((float)(limbSwing * 0.6662f + pi)) * 1.0f * limbSwingAmount;
            if (entity.m_21825_()) {
                this.leg_right.f_104203_ = -1.5708f;
                this.leg_left.f_104203_ = -1.5708f;
            }
        } else {
            this.wing_left_connection.f_104204_ = Mth.m_14089_((float)(limbSwing / 2.0f)) / 2.0f;
            this.wing_tip_left.f_104205_ = -(Mth.m_14031_((float)(limbSwing / 2.0f)) / 4.0f);
            this.wing_right_connection.f_104204_ = -(Mth.m_14089_((float)(limbSwing / 2.0f)) / 2.0f);
            this.wing_tip_right.f_104205_ = Mth.m_14031_((float)(limbSwing / 2.0f)) / 4.0f;
            this.leg_right.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f)) * 1.0f * limbSwingAmount;
            this.leg_left.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f + pi)) * 1.0f * limbSwingAmount;
        }
    }

    public void prepareMobModel(OwlEntity entity, float limbAngle, float limbDistance, float delta) {
        super.m_6839_((Entity)entity, limbAngle, limbDistance, delta);
        switch (entity.getStandingState()) {
            case STANDING: {
                break;
            }
        }
        float rad90 = 1.5708f;
        float rad155 = 2.70526f;
        float rad70 = 1.22173f;
        float wingAngle = limbAngle;
        float rad40 = 0.698132f;
        float leanProgress = entity.m_20998_(delta) / 7.0f;
        this.setRotationAngle(this.wing_right, 0.0f, rad70 * leanProgress, rad90 * leanProgress);
        this.setRotationAngle(this.wing_left, 0.0f, -rad70 * leanProgress, -rad90 * leanProgress);
        this.setRotationAngle(this.wing_tip_left, -rad155 * leanProgress, 0.0f, 0.0f);
        this.setRotationAngle(this.wing_tip_right, -rad155 * leanProgress, 0.0f, 0.0f);
        this.setRotationAngle(this.foot_left, rad90 * leanProgress, 0.0f, 0.0f);
        this.setRotationAngle(this.foot_right, rad90 * leanProgress, 0.0f, 0.0f);
        this.setRotationAngle(this.head, -rad40 * leanProgress, 0.0f, 0.0f);
    }

    protected Iterable<ModelPart> m_5607_() {
        return ImmutableList.of((Object)this.head);
    }

    protected Iterable<ModelPart> m_5608_() {
        return ImmutableList.of((Object)this.chest);
    }

    public void setRotationAngle(ModelPart part, float x, float y, float z) {
        part.f_104203_ = x;
        part.f_104204_ = y;
        part.f_104205_ = z;
    }

    public ModelPart m_5585_() {
        return this.head;
    }
}

