/*
 * Decompiled with CFR 0.152.
 */
package party.lemons.biomemakeover.entity.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.model.ArmedModel;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.ZombieModel;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.renderer.ItemInHandRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.AbstractZombieRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.ItemInHandLayer;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import party.lemons.biomemakeover.BiomeMakeover;
import party.lemons.biomemakeover.entity.DecayedEntity;
import party.lemons.biomemakeover.entity.render.DecayedModel;

public class DecayedRender
extends AbstractZombieRenderer<DecayedEntity, DecayedModel> {
    public static final ResourceLocation TEXTURE = BiomeMakeover.ID("textures/entity/decayed_inner_layer.png");

    public DecayedRender(EntityRendererProvider.Context context) {
        super(context, (ZombieModel)new DecayedModel(context.m_174023_(DecayedModel.LAYER_LOCATION)), (ZombieModel)new DecayedModel(context.m_174023_(DecayedModel.LAYER_LOCATION_2)), (ZombieModel)new DecayedModel(context.m_174023_(DecayedModel.LAYER_LOCATION_3)));
        this.m_115326_(new DecayedOverlayFeatureRenderer((RenderLayerParent<DecayedEntity, DecayedModel>)this, context.m_174027_()));
        this.f_115291_.removeIf(l -> l instanceof ItemInHandLayer);
        this.m_115326_((RenderLayer)new DecayedItemInHandLayer((RenderLayerParent<DecayedEntity, DecayedModel>)this, context.m_234598_()));
    }

    protected void setupRotations(DecayedEntity decayed, PoseStack poseStack, float f, float g, float h) {
        super.m_7523_((LivingEntity)decayed, poseStack, f, g, h);
        float i = decayed.m_20998_(h);
        if (i > 0.0f) {
            poseStack.m_252781_(Axis.f_252529_.m_252977_(Mth.m_14179_((float)i, (float)decayed.m_146909_(), (float)(-10.0f - decayed.m_146909_()))));
        }
    }

    public ResourceLocation getTextureLocation(DecayedEntity mob) {
        return TEXTURE;
    }

    private static class DecayedOverlayFeatureRenderer
    extends RenderLayer<DecayedEntity, DecayedModel> {
        private static final ResourceLocation TEXTURE = BiomeMakeover.ID("textures/entity/decayed_outer_layer.png");
        private final DecayedModel model;

        public DecayedOverlayFeatureRenderer(RenderLayerParent<DecayedEntity, DecayedModel> renderLayerParent, EntityModelSet entityModelSet) {
            super(renderLayerParent);
            this.model = new DecayedModel(entityModelSet.m_171103_(DecayedModel.LAYER_LOCATION_2));
        }

        public void render(PoseStack poseStack, MultiBufferSource multiBufferSource, int i, DecayedEntity drowned, float f, float g, float h, float j, float k, float l) {
            DecayedOverlayFeatureRenderer.m_117359_((EntityModel)this.m_117386_(), (EntityModel)this.model, (ResourceLocation)TEXTURE, (PoseStack)poseStack, (MultiBufferSource)multiBufferSource, (int)i, (LivingEntity)drowned, (float)f, (float)g, (float)j, (float)k, (float)l, (float)h, (float)1.0f, (float)1.0f, (float)1.0f);
        }
    }

    private static class DecayedItemInHandLayer
    extends ItemInHandLayer<DecayedEntity, DecayedModel> {
        private final ItemInHandRenderer itemInHandRenderer;

        public DecayedItemInHandLayer(RenderLayerParent<DecayedEntity, DecayedModel> renderLayerParent, ItemInHandRenderer itemInHandRenderer) {
            super(renderLayerParent, itemInHandRenderer);
            this.itemInHandRenderer = itemInHandRenderer;
        }

        private boolean usingShield(LivingEntity entity) {
            return entity.m_21211_().m_41720_() == Items.f_42740_;
        }

        protected void m_117184_(LivingEntity livingEntity, ItemStack itemStack, ItemDisplayContext transformType, HumanoidArm humanoidArm, PoseStack poseStack, MultiBufferSource multiBufferSource, int i) {
            if (itemStack.m_41619_()) {
                return;
            }
            if (this.usingShield(livingEntity)) {
                poseStack.m_85836_();
                ((DecayedModel)this.m_117386_()).m_6002_(humanoidArm, poseStack);
                poseStack.m_252781_(Axis.f_252529_.m_252977_(-90.0f));
                poseStack.m_252781_(Axis.f_252436_.m_252977_(180.0f));
                boolean isLeft = humanoidArm == HumanoidArm.LEFT;
                poseStack.m_85837_((double)(2.0f * (isLeft ? 1.0f : -1.0f) / 16.0f), 0.3, -0.625);
                Axis dirY = isLeft ? Axis.f_252392_ : Axis.f_252436_;
                Axis dirZ = isLeft ? Axis.f_252403_ : Axis.f_252393_;
                Axis dirX = Axis.f_252495_;
                poseStack.m_252781_(dirY.m_252977_(60.0f));
                poseStack.m_252781_(dirZ.m_252977_(0.0f));
                poseStack.m_252781_(dirX.m_252977_(25.0f));
                this.itemInHandRenderer.m_269530_(livingEntity, itemStack, transformType, isLeft, poseStack, multiBufferSource, i);
                poseStack.m_85849_();
            } else {
                poseStack.m_85836_();
                ((ArmedModel)this.m_117386_()).m_6002_(humanoidArm, poseStack);
                poseStack.m_252781_(Axis.f_252529_.m_252977_(-90.0f));
                poseStack.m_252781_(Axis.f_252436_.m_252977_(180.0f));
                boolean isLeft = humanoidArm == HumanoidArm.LEFT;
                poseStack.m_85837_((double)((float)(isLeft ? -1 : 1) / 16.0f), 0.125, -0.625);
                this.itemInHandRenderer.m_269530_(livingEntity, itemStack, transformType, isLeft, poseStack, multiBufferSource, i);
                poseStack.m_85849_();
            }
        }
    }
}

