/*
 * Decompiled with CFR 0.152.
 */
package party.lemons.biomemakeover.entity.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import party.lemons.biomemakeover.BiomeMakeover;
import party.lemons.biomemakeover.entity.BlightBatEntity;
import party.lemons.biomemakeover.init.BMBlocks;

public class BlightBatRender
extends MobRenderer<BlightBatEntity, BlightBatModel> {
    private static final ResourceLocation TEXTURE = BiomeMakeover.ID("textures/entity/glowbat.png");

    public BlightBatRender(EntityRendererProvider.Context context) {
        super(context, (EntityModel)new BlightBatModel(context.m_174023_(BlightBatModel.LAYER_LOCATION)), 0.25f);
        this.m_115326_(new BlightBatLayer((RenderLayerParent<BlightBatEntity, BlightBatModel>)this));
    }

    public ResourceLocation getTextureLocation(BlightBatEntity entity) {
        return TEXTURE;
    }

    protected int getBlockLightLevel(BlightBatEntity entity, BlockPos blockPos) {
        return 15;
    }

    protected void scale(BlightBatEntity livingEntity, PoseStack poseStack, float f) {
        poseStack.m_85841_(0.35f, 0.35f, 0.35f);
    }

    protected void setupRotations(BlightBatEntity bat, PoseStack poseStack, float f, float g, float h) {
        if (bat.m_27452_()) {
            poseStack.m_85837_(0.0, (double)-0.1f, 0.0);
        } else {
            poseStack.m_85837_(0.0, (double)(Mth.m_14089_((float)(f * 0.3f)) * 0.1f), 0.0);
        }
        super.m_7523_((LivingEntity)bat, poseStack, f, g, h);
    }

    public static class BlightBatModel
    extends HierarchicalModel<BlightBatEntity> {
        public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(BiomeMakeover.ID("blightbat"), "main");
        private final ModelPart root;
        private final ModelPart head;
        private final ModelPart body;
        private final ModelPart rightWing;
        private final ModelPart leftWing;
        private final ModelPart rightWingTip;
        private final ModelPart leftWingTip;

        public BlightBatModel(ModelPart modelPart) {
            this.root = modelPart;
            this.head = modelPart.m_171324_("head");
            this.body = modelPart.m_171324_("body");
            this.rightWing = this.body.m_171324_("right_wing");
            this.rightWingTip = this.rightWing.m_171324_("right_wing_tip");
            this.leftWing = this.body.m_171324_("left_wing");
            this.leftWingTip = this.leftWing.m_171324_("left_wing_tip");
        }

        public static LayerDefinition createBodyLayer() {
            MeshDefinition meshDefinition = new MeshDefinition();
            PartDefinition partDefinition = meshDefinition.m_171576_();
            PartDefinition partDefinition2 = partDefinition.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171481_(-3.0f, -3.0f, -3.0f, 6.0f, 6.0f, 6.0f), PartPose.f_171404_);
            partDefinition2.m_171599_("right_ear", CubeListBuilder.m_171558_().m_171514_(24, 0).m_171481_(-4.0f, -6.0f, -2.0f, 3.0f, 4.0f, 1.0f), PartPose.f_171404_);
            partDefinition2.m_171599_("left_ear", CubeListBuilder.m_171558_().m_171514_(24, 0).m_171480_().m_171481_(1.0f, -6.0f, -2.0f, 3.0f, 4.0f, 1.0f), PartPose.f_171404_);
            PartDefinition partDefinition3 = partDefinition.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(0, 16).m_171481_(-3.0f, 4.0f, -3.0f, 6.0f, 12.0f, 6.0f).m_171514_(0, 34).m_171481_(-5.0f, 16.0f, 0.0f, 10.0f, 6.0f, 1.0f), PartPose.f_171404_);
            PartDefinition partDefinition4 = partDefinition3.m_171599_("right_wing", CubeListBuilder.m_171558_().m_171514_(42, 0).m_171481_(-12.0f, 1.0f, 1.5f, 10.0f, 16.0f, 1.0f), PartPose.f_171404_);
            partDefinition4.m_171599_("right_wing_tip", CubeListBuilder.m_171558_().m_171514_(24, 16).m_171481_(-8.0f, 1.0f, 0.0f, 8.0f, 12.0f, 1.0f), PartPose.m_171419_((float)-12.0f, (float)1.0f, (float)1.5f));
            PartDefinition partDefinition5 = partDefinition3.m_171599_("left_wing", CubeListBuilder.m_171558_().m_171514_(42, 0).m_171480_().m_171481_(2.0f, 1.0f, 1.5f, 10.0f, 16.0f, 1.0f), PartPose.f_171404_);
            partDefinition5.m_171599_("left_wing_tip", CubeListBuilder.m_171558_().m_171514_(24, 16).m_171480_().m_171481_(0.0f, 1.0f, 0.0f, 8.0f, 12.0f, 1.0f), PartPose.m_171419_((float)12.0f, (float)1.0f, (float)1.5f));
            return LayerDefinition.m_171565_((MeshDefinition)meshDefinition, (int)64, (int)64);
        }

        public ModelPart m_142109_() {
            return this.root;
        }

        public void setupAnim(BlightBatEntity bat, float f, float g, float h, float i, float j) {
            if (bat.m_27452_()) {
                this.head.f_104203_ = j * ((float)Math.PI / 180);
                this.head.f_104204_ = (float)Math.PI - i * ((float)Math.PI / 180);
                this.head.f_104205_ = (float)Math.PI;
                this.head.m_104227_(0.0f, -2.0f, 0.0f);
                this.rightWing.m_104227_(-3.0f, 0.0f, 3.0f);
                this.leftWing.m_104227_(3.0f, 0.0f, 3.0f);
                this.body.f_104203_ = (float)Math.PI;
                this.rightWing.f_104203_ = -0.15707964f;
                this.rightWing.f_104204_ = -1.2566371f;
                this.rightWingTip.f_104204_ = -1.7278761f;
                this.leftWing.f_104203_ = this.rightWing.f_104203_;
                this.leftWing.f_104204_ = -this.rightWing.f_104204_;
                this.leftWingTip.f_104204_ = -this.rightWingTip.f_104204_;
            } else {
                this.head.f_104203_ = j * ((float)Math.PI / 180);
                this.head.f_104204_ = i * ((float)Math.PI / 180);
                this.head.f_104205_ = 0.0f;
                this.head.m_104227_(0.0f, 0.0f, 0.0f);
                this.rightWing.m_104227_(0.0f, 0.0f, 0.0f);
                this.leftWing.m_104227_(0.0f, 0.0f, 0.0f);
                this.body.f_104203_ = 0.7853982f + Mth.m_14089_((float)(h * 0.1f)) * 0.15f;
                this.body.f_104204_ = 0.0f;
                this.rightWing.f_104204_ = Mth.m_14089_((float)(h * 74.48451f * ((float)Math.PI / 180))) * (float)Math.PI * 0.25f;
                this.leftWing.f_104204_ = -this.rightWing.f_104204_;
                this.rightWingTip.f_104204_ = this.rightWing.f_104204_ * 0.5f;
                this.leftWingTip.f_104204_ = -this.rightWing.f_104204_ * 0.5f;
            }
        }
    }

    private static class BlightBatLayer
    extends RenderLayer<BlightBatEntity, BlightBatModel> {
        public BlightBatLayer(RenderLayerParent<BlightBatEntity, BlightBatModel> renderLayerParent) {
            super(renderLayerParent);
        }

        public void render(PoseStack pose, MultiBufferSource multiBufferSource, int i, BlightBatEntity e, float f, float g, float h, float j, float k, float l) {
            if (!e.m_6162_() && !e.m_20145_()) {
                BlockRenderDispatcher blockRenderManager = Minecraft.m_91087_().m_91289_();
                BlockState shroom = ((Block)BMBlocks.PURPLE_GLOWSHROOM.get()).m_49966_();
                int m = LivingEntityRenderer.m_115338_((LivingEntity)e, (float)0.0f);
                pose.m_85836_();
                ((BlightBatModel)this.m_117386_()).m_142109_().m_171324_("head").m_104299_(pose);
                pose.m_85837_(0.0, -0.7, 0.0);
                pose.m_252781_(Axis.f_252436_.m_252977_(-78.0f));
                pose.m_85841_(-1.0f, -1.0f, 1.0f);
                pose.m_85837_(-0.5, -0.5, -0.5);
                blockRenderManager.m_110912_(shroom, pose, multiBufferSource, i, m);
                pose.m_85849_();
            }
        }
    }
}

