/*
 * Decompiled with CFR 0.152.
 */
package party.lemons.biomemakeover.entity.adjudicator.phase;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.projectile.EvokerFangs;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.shapes.VoxelShape;
import party.lemons.biomemakeover.entity.adjudicator.AdjudicatorEntity;
import party.lemons.biomemakeover.entity.adjudicator.AdjudicatorState;
import party.lemons.biomemakeover.entity.adjudicator.phase.AttackingPhase;
import party.lemons.biomemakeover.init.BMEffects;

public class FangAttackingPhase
extends AttackingPhase {
    public FangAttackingPhase(ResourceLocation id, AdjudicatorEntity adjudicator) {
        super(id, adjudicator);
    }

    @Override
    public void onEnterPhase() {
        super.onEnterPhase();
        this.adjudicator.setState(AdjudicatorState.SUMMONING);
        this.adjudicator.m_5496_(BMEffects.ADJUDICATOR_SPELL_1.get(), 1.0f, 1.0f);
    }

    @Override
    protected Goal getAttackGoal() {
        return new AdjudicatorFangGoal(this.adjudicator);
    }

    static class AdjudicatorFangGoal
    extends Goal {
        protected int spellCooldown;
        protected int startTime;
        private AdjudicatorEntity adjudicator;

        public AdjudicatorFangGoal(AdjudicatorEntity adjudicator) {
            this.adjudicator = adjudicator;
        }

        public boolean m_8036_() {
            LivingEntity livingEntity = this.adjudicator.m_5448_();
            return livingEntity != null && livingEntity.m_6084_();
        }

        public boolean m_8045_() {
            LivingEntity livingEntity = this.adjudicator.m_5448_();
            return livingEntity != null && livingEntity.m_6084_() && this.spellCooldown > 0;
        }

        public void m_8056_() {
            this.spellCooldown = 20;
            this.startTime = this.adjudicator.f_19797_ + this.startTimeDelay();
        }

        public void m_8037_() {
            --this.spellCooldown;
            if (this.spellCooldown == 0) {
                this.castSpell();
                this.spellCooldown = this.startTimeDelay();
            }
        }

        protected int getSpellTicks() {
            return 20;
        }

        protected int startTimeDelay() {
            return 40;
        }

        protected void castSpell() {
            LivingEntity target = this.adjudicator.m_5448_();
            double minY = Math.min(target.m_20186_(), this.adjudicator.m_20186_());
            double maxY = Math.max(target.m_20186_(), this.adjudicator.m_20186_()) + 1.0;
            float f = (float)Mth.m_14136_((double)(target.m_20189_() - this.adjudicator.m_20189_()), (double)(target.m_20185_() - this.adjudicator.m_20185_()));
            if ((double)this.adjudicator.m_20270_((Entity)target) < 24.0) {
                float h;
                int j;
                for (j = 0; j < 5; ++j) {
                    h = (float)((double)f + (double)j * Math.PI * (double)0.4f);
                    this.conjureFangs(this.adjudicator.m_20185_() + (double)Mth.m_14089_((float)h) * 1.5, this.adjudicator.m_20189_() + (double)Mth.m_14031_((float)h) * 1.5, minY, maxY, h, 0);
                }
                for (j = 0; j < 8; ++j) {
                    h = (float)((double)f + (double)j * Math.PI * 2.0 / 8.0 + 1.2566370964050293);
                    this.conjureFangs(this.adjudicator.m_20185_() + (double)Mth.m_14089_((float)h) * 2.5, this.adjudicator.m_20189_() + (double)Mth.m_14031_((float)h) * 2.5, minY, maxY, h, 3);
                }
            } else {
                for (int j = 0; j < 16; ++j) {
                    double l = 1.25 * (double)(j + 1);
                    int m = 1 * j;
                    this.conjureFangs(this.adjudicator.m_20185_() + (double)Mth.m_14089_((float)f) * l, this.adjudicator.m_20189_() + (double)Mth.m_14031_((float)f) * l, minY, maxY, f, m);
                }
            }
        }

        private void conjureFangs(double x, double z, double maxY, double y, float yaw, int warmup) {
            BlockPos blockPos = new BlockPos((int)x, (int)y, (int)z);
            boolean bl = false;
            double d = 0.0;
            do {
                BlockState blockState2;
                VoxelShape voxelShape;
                BlockPos blockPos2 = blockPos.m_7495_();
                BlockState blockState = this.adjudicator.m_9236_().m_8055_(blockPos2);
                if (!blockState.m_60783_((BlockGetter)this.adjudicator.m_9236_(), blockPos2, Direction.UP)) continue;
                if (!this.adjudicator.m_9236_().m_46859_(blockPos) && !(voxelShape = (blockState2 = this.adjudicator.m_9236_().m_8055_(blockPos)).m_60812_((BlockGetter)this.adjudicator.m_9236_(), blockPos)).m_83281_()) {
                    d = voxelShape.m_83297_(Direction.Axis.Y);
                }
                bl = true;
                break;
            } while ((blockPos = blockPos.m_7495_()).m_123342_() >= Mth.m_14107_((double)maxY) - 1);
            if (bl) {
                this.adjudicator.m_9236_().m_7967_((Entity)new EvokerFangs(this.adjudicator.m_9236_(), x, (double)blockPos.m_123342_() + d, z, yaw, warmup, (LivingEntity)this.adjudicator));
            }
        }
    }
}

