/*
 * Decompiled with CFR 0.152.
 */
package party.lemons.biomemakeover.entity;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.animal.AbstractFish;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import party.lemons.biomemakeover.entity.ToadEntity;
import party.lemons.biomemakeover.init.BMEntities;
import party.lemons.biomemakeover.init.BMItems;
import party.lemons.biomemakeover.util.extension.Stuntable;

public class TadpoleEntity
extends AbstractFish
implements Stuntable {
    private int babyTime = -6000;
    private boolean stunted = false;

    public TadpoleEntity(EntityType<? extends AbstractFish> entityType, Level level) {
        super(entityType, level);
    }

    public void m_8119_() {
        super.m_8119_();
        if (!this.m_9236_().m_5776_()) {
            if (!this.isStunted()) {
                ++this.babyTime;
            }
            if (!this.m_6162_()) {
                ToadEntity toad = (ToadEntity)((EntityType)BMEntities.TOAD.get()).m_20615_(this.m_9236_());
                toad.m_7678_(this.m_20185_(), this.m_20186_(), this.m_20189_(), this.f_20883_, this.m_146909_());
                toad.m_7292_(new MobEffectInstance(MobEffects.f_19608_, 200, 0));
                ((ServerLevel)this.m_9236_()).m_47205_((Entity)toad);
                this.m_142687_(Entity.RemovalReason.DISCARDED);
            }
        }
    }

    protected InteractionResult m_6071_(Player player, InteractionHand hand) {
        ItemStack itemStack = player.m_21120_(hand);
        if (!itemStack.m_41619_() && itemStack.m_41720_() == Items.f_42518_) {
            if (this.m_6162_()) {
                itemStack.m_41774_(1);
                this.growUp(Math.abs(this.babyTime / 20));
                return InteractionResult.m_19078_((boolean)this.m_9236_().m_5776_());
            }
            if (this.m_9236_().m_5776_()) {
                return InteractionResult.CONSUME;
            }
        }
        return super.m_6071_(player, hand);
    }

    public void growUp(int age) {
        this.babyTime += age;
    }

    public void m_6863_(boolean baby) {
        this.babyTime = baby ? -24000 : 0;
    }

    public boolean m_6162_() {
        return this.babyTime < 0;
    }

    public void m_7380_(CompoundTag compoundTag) {
        super.m_7380_(compoundTag);
        compoundTag.m_128405_("BabyTime", this.babyTime);
        compoundTag.m_128379_("Stunted", this.isStunted());
    }

    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        if (tag.m_128441_("BabyTime")) {
            this.babyTime = tag.m_128451_("BabyTime");
        }
        this.setStunted(tag.m_128471_("Stunted"));
    }

    protected SoundEvent m_5699_() {
        return SoundEvents.f_12528_;
    }

    public ItemStack m_28282_() {
        return new ItemStack((ItemLike)BMItems.TADPOLE_BUCKET.get());
    }

    public static AttributeSupplier.Builder createAttributes() {
        return TadpoleEntity.m_21552_().m_22268_(Attributes.f_22276_, 10.0);
    }

    @Override
    public boolean isStunted() {
        return this.stunted;
    }

    @Override
    public void setStunted(boolean stunted) {
        this.stunted = stunted;
    }
}

