/*
 * Decompiled with CFR 0.152.
 */
package party.lemons.biomemakeover.entity;

import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.FlyingMoveControl;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.navigation.FlyingPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.animal.FlyingAnimal;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import org.jetbrains.annotations.Nullable;
import party.lemons.biomemakeover.entity.ToadTargetEntity;
import party.lemons.biomemakeover.entity.ai.FlyWanderGoal;
import party.lemons.biomemakeover.init.BMEffects;
import party.lemons.biomemakeover.util.RandomUtil;

public class DragonflyEntity
extends ToadTargetEntity
implements FlyingAnimal {
    public boolean hasPlayedLoop = false;
    private static final EntityDataAccessor<Integer> VARIANT = SynchedEntityData.m_135353_(DragonflyEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);

    public DragonflyEntity(EntityType<? extends ToadTargetEntity> entityType, Level level) {
        super(entityType, level);
        this.f_21342_ = new FlyingMoveControl((Mob)this, 20, true);
        this.m_21441_(BlockPathTypes.DANGER_FIRE, -1.0f);
        this.m_21441_(BlockPathTypes.WATER, -1.0f);
        this.m_21441_(BlockPathTypes.WATER_BORDER, 16.0f);
        this.m_21441_(BlockPathTypes.COCOA, -1.0f);
        this.m_21441_(BlockPathTypes.FENCE, -1.0f);
    }

    public static boolean checkSpawnRules(EntityType<DragonflyEntity> dragonflyEntityEntityType, ServerLevelAccessor serverLevelAccessor, MobSpawnType mobSpawnType, BlockPos pos, RandomSource randomSource) {
        return serverLevelAccessor.m_8055_(pos.m_7495_()).m_204336_(BlockTags.f_184228_) && serverLevelAccessor.m_45524_(pos, 0) > 8;
    }

    public static AttributeSupplier.Builder createAttributes() {
        return DragonflyEntity.m_21552_().m_22268_(Attributes.f_22280_, 0.6).m_22268_(Attributes.f_22276_, 10.0).m_22268_(Attributes.f_22279_, 0.25);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.m_20088_().m_135372_(VARIANT, (Object)2);
    }

    public float m_5610_(BlockPos blockPos, LevelReader levelReader) {
        return levelReader.m_8055_(blockPos).m_60795_() ? 10.0f : 0.0f;
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(8, (Goal)new FlyWanderGoal(this));
        this.f_21345_.m_25352_(9, (Goal)new FloatGoal((Mob)this));
    }

    public void m_7380_(CompoundTag compoundTag) {
        super.m_7380_(compoundTag);
        compoundTag.m_128405_("Variant", this.getVariant());
    }

    public void m_7378_(CompoundTag compoundTag) {
        super.m_7378_(compoundTag);
        this.m_20088_().m_135381_(VARIANT, (Object)compoundTag.m_128451_("Variant"));
    }

    public int getVariant() {
        return (Integer)this.m_20088_().m_135370_(VARIANT);
    }

    public boolean m_142535_(float f, float g, DamageSource damageSource) {
        return false;
    }

    protected void m_7840_(double d, boolean bl, BlockState blockState, BlockPos blockPos) {
    }

    public boolean m_29443_() {
        return true;
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor serverLevelAccessor, DifficultyInstance difficultyInstance, MobSpawnType mobSpawnType, @Nullable SpawnGroupData spawnGroupData, @Nullable CompoundTag compoundTag) {
        int variant = RandomUtil.randomBias(0, 5);
        this.m_20088_().m_135381_(VARIANT, (Object)variant);
        return super.m_6518_(serverLevelAccessor, difficultyInstance, mobSpawnType, spawnGroupData, compoundTag);
    }

    protected void m_7355_(BlockPos blockPos, BlockState blockState) {
    }

    @Nullable
    protected SoundEvent m_7515_() {
        return null;
    }

    @Nullable
    protected SoundEvent m_7975_(DamageSource damageSource) {
        return BMEffects.DRAGONFLY_HURT.get();
    }

    @Nullable
    protected SoundEvent m_5592_() {
        return BMEffects.DRAGONFLY_DEATH.get();
    }

    protected float m_6121_() {
        return 0.4f;
    }

    protected PathNavigation m_6037_(Level level) {
        FlyingPathNavigation birdNavigation = new FlyingPathNavigation((Mob)this, level){

            public boolean m_6342_(BlockPos blockPos) {
                return !this.f_26495_.m_8055_(blockPos.m_7495_()).m_60795_();
            }
        };
        birdNavigation.m_26443_(true);
        birdNavigation.m_7008_(false);
        birdNavigation.m_26440_(false);
        return birdNavigation;
    }
}

