/*
 * Decompiled with CFR 0.152.
 */
package party.lemons.biomemakeover.entity;

import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MoveToBlockGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.ZombieAttackGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.navigation.WaterBoundPathNavigation;
import net.minecraft.world.entity.ai.util.DefaultRandomPos;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.animal.Turtle;
import net.minecraft.world.entity.animal.axolotl.Axolotl;
import net.minecraft.world.entity.monster.Drowned;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.entity.monster.ZombifiedPiglin;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.ShieldItem;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import party.lemons.biomemakeover.init.BMEffects;
import party.lemons.biomemakeover.init.BMEnchantments;

public class DecayedEntity
extends Zombie {
    private static final EntityDataAccessor<Boolean> SHIELD_DOWN = SynchedEntityData.m_135353_(DecayedEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private boolean targetingUnderwater;
    protected final WaterBoundPathNavigation waterNavigation;
    protected final GroundPathNavigation landNavigation;
    private int shieldDisableTime = 0;
    private int shieldHealth = 30;
    private boolean isDummy = false;

    public DecayedEntity(EntityType<? extends Zombie> entityType, Level level) {
        super(entityType, level);
        this.f_21342_ = new DecayedMoveControl(this);
        this.m_21441_(BlockPathTypes.WATER, 0.0f);
        this.waterNavigation = new WaterBoundPathNavigation((Mob)this, level);
        this.landNavigation = new GroundPathNavigation((Mob)this, level);
    }

    protected void m_8099_() {
        super.m_8099_();
    }

    protected void m_6878_() {
        this.f_21345_.m_25352_(1, (Goal)new GoToWaterGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(2, (Goal)new ZombieAttackGoal((Zombie)this, 1.0, false));
        this.f_21345_.m_25352_(5, (Goal)new LeaveWaterGoal(this, 1.0));
        this.f_21345_.m_25352_(6, (Goal)new SwimUpGoal(this, 1.0, this.m_9236_().m_5736_()));
        this.f_21345_.m_25352_(7, (Goal)new RandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[]{Drowned.class}).m_26044_(new Class[]{ZombifiedPiglin.class}));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, 10, true, false, e -> true));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, AbstractVillager.class, false));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, IronGolem.class, true));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, Axolotl.class, true, false));
        this.f_21346_.m_25352_(5, (Goal)new NearestAttackableTargetGoal((Mob)this, Turtle.class, 10, true, false, Turtle.f_30122_));
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22277_, 16.0).m_22268_(Attributes.f_22279_, (double)0.23f).m_22268_(Attributes.f_22281_, 3.0).m_22268_(Attributes.f_22284_, 2.0).m_22266_(Attributes.f_22287_);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.m_20088_().m_135372_(SHIELD_DOWN, (Object)false);
    }

    protected void m_8024_() {
        super.m_8024_();
        if (this.m_5912_() && !((Boolean)this.m_20088_().m_135370_(SHIELD_DOWN)).booleanValue()) {
            this.m_6672_(InteractionHand.OFF_HAND);
        } else {
            this.m_5810_();
        }
        if (!this.m_9236_().m_5776_() && this.shieldDisableTime > 0) {
            if (!((Boolean)this.m_20088_().m_135370_(SHIELD_DOWN)).booleanValue()) {
                this.m_20088_().m_135381_(SHIELD_DOWN, (Object)true);
            }
            --this.shieldDisableTime;
            if (this.shieldDisableTime <= 0) {
                this.m_20088_().m_135381_(SHIELD_DOWN, (Object)false);
            }
        }
    }

    public void m_7909_(float amount) {
        if (this.m_9236_().m_5776_() || !(this.f_20935_.m_41720_() instanceof ShieldItem)) {
            return;
        }
        this.shieldHealth = (int)((float)this.shieldHealth - amount);
        if (this.shieldHealth <= 0) {
            this.m_5810_();
            this.m_21008_(InteractionHand.OFF_HAND, ItemStack.f_41583_);
            this.m_5496_(SoundEvents.f_12347_, 0.8f, 0.8f + this.f_19796_.m_188501_() * 0.4f);
        } else {
            this.m_5496_(SoundEvents.f_12346_, 1.0f, 0.8f + this.f_19796_.m_188501_() * 0.4f);
            this.shieldDisableTime = Math.max((int)(13.0f + amount * 3.0f), this.shieldDisableTime);
        }
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor level, DifficultyInstance difficulty, MobSpawnType spawnReason, @Nullable SpawnGroupData spawnGroupData, @Nullable CompoundTag compoundTag) {
        spawnGroupData = super.m_6518_(level, difficulty, spawnReason, spawnGroupData, compoundTag);
        this.m_21559_(this.f_19796_.m_188499_());
        if (this.f_19796_.m_188501_() < 0.15f * (difficulty.m_19057_() + 1.0f)) {
            float stopChance;
            int armourLevel = 0;
            float f = stopChance = this.m_9236_().m_46791_() == Difficulty.HARD ? 0.05f : 0.1f;
            if (this.f_19796_.m_188501_() < 0.2f) {
                ++armourLevel;
            }
            if (this.f_19796_.m_188501_() < 0.2f) {
                ++armourLevel;
            }
            if (this.f_19796_.m_188501_() < 0.2f) {
                ++armourLevel;
            }
            boolean stop = true;
            for (EquipmentSlot equipmentSlot : EquipmentSlot.values()) {
                Item item;
                if (equipmentSlot.m_20743_() != EquipmentSlot.Type.ARMOR) continue;
                ItemStack itemStack = this.m_6844_(equipmentSlot);
                if (!stop && this.f_19796_.m_188501_() < stopChance) break;
                stop = false;
                if (!itemStack.m_41619_() || (item = DecayedEntity.m_21412_((EquipmentSlot)equipmentSlot, (int)armourLevel)) == null) continue;
                ItemStack stack = new ItemStack((ItemLike)item);
                stack.m_41663_(BMEnchantments.DECAY_CURSE.get(), 1 + this.f_19796_.m_188503_(4));
                this.m_8061_(equipmentSlot, stack);
            }
        }
        ItemStack shield = new ItemStack((ItemLike)Items.f_42740_);
        shield.m_41663_(BMEnchantments.DECAY_CURSE.get(), 1 + this.f_19796_.m_188503_(4));
        this.m_8061_(EquipmentSlot.OFFHAND, shield);
        return spawnGroupData;
    }

    public boolean hasShield() {
        for (InteractionHand hand : InteractionHand.values()) {
            ItemStack st = this.m_21120_(hand);
            if (st.m_41619_() || st.m_41720_() != Items.f_42740_) continue;
            return true;
        }
        return false;
    }

    public ItemStack getShieldStack() {
        for (InteractionHand hand : InteractionHand.values()) {
            ItemStack st = this.m_21120_(hand);
            if (st.m_41619_() || st.m_41720_() != Items.f_42740_) continue;
            return st;
        }
        return ItemStack.f_41583_;
    }

    public boolean m_34330_() {
        return false;
    }

    protected SoundEvent m_7515_() {
        return this.m_20069_() ? BMEffects.DECAYED_AMBIENT_WATER.get() : BMEffects.DECAYED_AMBIENT.get();
    }

    protected SoundEvent m_7975_(DamageSource source) {
        return this.m_20069_() ? BMEffects.DECAYED_HURT_WATER.get() : BMEffects.DECAYED_HURT.get();
    }

    protected SoundEvent m_5592_() {
        return this.m_20069_() ? BMEffects.DECAYED_DEATH_WATER.get() : BMEffects.DECAYED_DEATH.get();
    }

    protected SoundEvent m_7660_() {
        return BMEffects.DECAYED_STEP.get();
    }

    protected SoundEvent m_5501_() {
        return BMEffects.DECAYED_SWIM.get();
    }

    protected ItemStack m_5728_() {
        return ItemStack.f_41583_;
    }

    protected boolean m_7593_() {
        return false;
    }

    public boolean m_6063_() {
        return !this.m_6069_();
    }

    public boolean m_6914_(LevelReader levelReader) {
        return levelReader.m_45784_((Entity)this);
    }

    boolean wantsToSwim() {
        if (this.targetingUnderwater) {
            return true;
        }
        LivingEntity livingEntity = this.m_5448_();
        return livingEntity != null && livingEntity.m_20069_();
    }

    public void m_7023_(Vec3 vec3) {
        if (this.m_21515_() && this.m_20069_() && this.wantsToSwim()) {
            this.m_19920_(0.01f, vec3);
            this.m_6478_(MoverType.SELF, this.m_20184_());
            this.m_20256_(this.m_20184_().m_82490_(0.9));
        } else {
            super.m_7023_(vec3);
        }
    }

    public void m_5844_() {
        if (!this.m_9236_().f_46443_) {
            if (this.m_20069_()) {
                this.m_274367_(1.0f);
            } else {
                this.m_274367_(0.5f);
            }
            if (this.m_21515_() && this.m_20069_() && this.wantsToSwim()) {
                this.f_21344_ = this.waterNavigation;
                this.m_20282_(true);
            } else {
                this.f_21344_ = this.landNavigation;
                this.m_20282_(false);
            }
        }
    }

    public void setDummy() {
        this.isDummy = true;
    }

    public boolean isDummy() {
        return this.isDummy;
    }

    public void setTargetingUnderwater(boolean targetingUnderwater) {
        this.targetingUnderwater = targetingUnderwater;
    }

    public void m_7380_(CompoundTag compoundTag) {
        super.m_7380_(compoundTag);
        compoundTag.m_128405_("ShieldHealth", this.shieldHealth);
    }

    public void m_7378_(CompoundTag compoundTag) {
        super.m_7378_(compoundTag);
        if (compoundTag.m_128441_("ShieldHealth")) {
            this.shieldHealth = compoundTag.m_128451_("ShieldHealth");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected boolean closeToNextPos() {
        double d;
        Path path = this.m_21573_().m_26570_();
        if (path == null) return false;
        BlockPos blockPos = path.m_77406_();
        if (blockPos == null) return false;
        double d2 = this.m_20275_(blockPos.m_123341_(), blockPos.m_123342_(), blockPos.m_123343_());
        if (!(d < 4.0)) return false;
        return true;
    }

    public float m_20998_(float f) {
        if (this.isDummy()) {
            return 3.0f;
        }
        return super.m_20998_(f);
    }

    public static boolean checkSpawnRules(EntityType<DecayedEntity> entityType, ServerLevelAccessor serverLevelAccessor, MobSpawnType mobSpawnType, BlockPos blockPos, RandomSource random) {
        boolean validReasons = serverLevelAccessor.m_46791_() != Difficulty.PEACEFUL && Drowned.m_219009_((ServerLevelAccessor)serverLevelAccessor, (BlockPos)blockPos, (RandomSource)random) && (mobSpawnType == MobSpawnType.SPAWNER || serverLevelAccessor.m_6425_(blockPos).m_205070_(FluidTags.f_13131_));
        return random.m_188503_(3) == 0 && validReasons && blockPos.m_123342_() <= serverLevelAccessor.m_5736_();
    }

    static class DecayedMoveControl
    extends MoveControl {
        private final DecayedEntity drowned;

        public DecayedMoveControl(DecayedEntity drowned) {
            super((Mob)drowned);
            this.drowned = drowned;
        }

        public void m_8126_() {
            LivingEntity livingEntity = this.drowned.m_5448_();
            if (this.drowned.wantsToSwim() && this.drowned.m_20069_()) {
                if (livingEntity != null && livingEntity.m_20186_() > this.drowned.m_20186_() || this.drowned.targetingUnderwater) {
                    this.drowned.m_20256_(this.drowned.m_20184_().m_82520_(0.0, 0.002, 0.0));
                }
                if (this.f_24981_ != MoveControl.Operation.MOVE_TO || this.drowned.m_21573_().m_26571_()) {
                    this.drowned.m_7910_(0.0f);
                    return;
                }
                double d = this.f_24975_ - this.drowned.m_20185_();
                double e = this.f_24976_ - this.drowned.m_20186_();
                double f = this.f_24977_ - this.drowned.m_20189_();
                double g = Math.sqrt(d * d + e * e + f * f);
                e /= g;
                float h = (float)(Mth.m_14136_((double)f, (double)d) * 57.2957763671875) - 90.0f;
                this.drowned.m_146922_(this.m_24991_(this.drowned.m_146908_(), h, 90.0f));
                this.drowned.f_20883_ = this.drowned.m_146908_();
                float i = (float)(this.f_24978_ * this.drowned.m_21133_(Attributes.f_22279_));
                float j = Mth.m_14179_((float)0.125f, (float)this.drowned.m_6113_(), (float)i);
                this.drowned.m_7910_(j);
                this.drowned.m_20256_(this.drowned.m_20184_().m_82520_((double)j * d * 0.005, (double)j * e * 0.1, (double)j * f * 0.005));
            } else {
                if (!this.drowned.m_20096_()) {
                    this.drowned.m_20256_(this.drowned.m_20184_().m_82520_(0.0, -0.008, 0.0));
                }
                super.m_8126_();
            }
        }
    }

    static class GoToWaterGoal
    extends RandomStrollGoal {
        public GoToWaterGoal(PathfinderMob mob, double speed) {
            super(mob, speed);
        }

        public boolean m_8036_() {
            return !this.f_25725_.m_20069_() && super.m_8036_();
        }

        public boolean m_8045_() {
            return !this.f_25725_.m_20069_() && super.m_8045_();
        }
    }

    static class LeaveWaterGoal
    extends MoveToBlockGoal {
        private final DecayedEntity decayed;

        public LeaveWaterGoal(DecayedEntity decayed, double speed) {
            super((PathfinderMob)decayed, speed, 8, 2);
            this.decayed = decayed;
        }

        public boolean m_8036_() {
            return super.m_8036_() && !this.decayed.m_9236_().m_46461_() && this.decayed.m_20069_() && this.decayed.m_20186_() >= (double)(this.decayed.m_9236_().m_5736_() - 3);
        }

        public boolean m_8045_() {
            return super.m_8045_();
        }

        protected boolean m_6465_(LevelReader levelReader, BlockPos pos) {
            BlockPos blockPos = pos.m_7494_();
            return levelReader.m_46859_(blockPos) && levelReader.m_46859_(blockPos.m_7494_()) && levelReader.m_8055_(pos).m_60634_((BlockGetter)levelReader, pos, (Entity)this.decayed);
        }

        public void m_8056_() {
            this.decayed.setTargetingUnderwater(false);
            this.decayed.f_21344_ = (PathNavigation)this.decayed.landNavigation;
            super.m_8056_();
        }

        public void m_8041_() {
            super.m_8041_();
        }
    }

    static class SwimUpGoal
    extends Goal {
        private final DecayedEntity drowned;
        private final double speedModifier;
        private final int seaLevel;
        private boolean stuck;

        public SwimUpGoal(DecayedEntity drowned, double d, int i) {
            this.drowned = drowned;
            this.speedModifier = d;
            this.seaLevel = i;
        }

        public boolean m_8036_() {
            return !this.drowned.m_9236_().m_46461_() && this.drowned.m_20069_() && this.drowned.m_20186_() < (double)(this.seaLevel - 2);
        }

        public boolean m_8045_() {
            return this.m_8036_() && !this.stuck;
        }

        public void m_8037_() {
            if (this.drowned.m_20186_() < (double)(this.seaLevel - 1) && (this.drowned.m_21573_().m_26571_() || this.drowned.closeToNextPos())) {
                Vec3 vec3 = DefaultRandomPos.m_148412_((PathfinderMob)this.drowned, (int)4, (int)8, (Vec3)new Vec3(this.drowned.m_20185_(), (double)(this.seaLevel - 1), this.drowned.m_20189_()), (double)1.5707963705062866);
                if (vec3 == null) {
                    this.stuck = true;
                    return;
                }
                this.drowned.m_21573_().m_26519_(vec3.f_82479_, vec3.f_82480_, vec3.f_82481_, this.speedModifier);
            }
        }

        public void m_8056_() {
            this.drowned.setTargetingUnderwater(true);
            this.stuck = false;
        }

        public void m_8041_() {
            this.drowned.setTargetingUnderwater(false);
        }
    }
}

