/*
 * Decompiled with CFR 0.152.
 */
package party.lemons.biomemakeover.crafting.witch.menu;

import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import party.lemons.biomemakeover.BiomeMakeover;
import party.lemons.biomemakeover.crafting.witch.QuestRarity;
import party.lemons.biomemakeover.crafting.witch.WitchQuest;
import party.lemons.biomemakeover.crafting.witch.WitchQuestList;
import party.lemons.biomemakeover.crafting.witch.menu.WitchMenu;
import party.lemons.biomemakeover.network.C2S_HandleCompleteQuest;

public class WitchScreen
extends AbstractContainerScreen<WitchMenu> {
    private static final ResourceLocation TEXTURE = BiomeMakeover.ID("textures/gui/witch.png");
    private static final Component QUESTS_TEXT = Component.m_237115_((String)"witch.quests");
    private static final Component SEPARATOR = Component.m_237113_((String)" - ");
    private static final Component DEPRECATED_TEXT = Component.m_237115_((String)"merchant.deprecated");
    private final QuestButton[] questButtons = new QuestButton[3];
    private final Inventory inventory;

    public WitchScreen(WitchMenu handler, Inventory inventory, Component title) {
        super((AbstractContainerMenu)handler, inventory, title);
        this.f_97726_ = 174;
        this.f_97727_ = 182;
        this.f_97730_ = 110;
        this.f_97731_ = this.f_97727_ - 92;
        this.inventory = inventory;
    }

    private void clickQuest(int index, WitchQuest quest) {
        if (quest.hasItems((Container)this.f_96541_.f_91074_.m_150109_())) {
            new C2S_HandleCompleteQuest(index).sendToServer();
        }
    }

    protected void m_7856_() {
        super.m_7856_();
        this.updateQuests();
    }

    protected void updateQuests() {
        for (int i = 0; i < this.questButtons.length; ++i) {
            this.m_169411_((GuiEventListener)this.questButtons[i]);
            this.questButtons[i] = null;
        }
        int xx = 3 + (this.f_96543_ - this.f_97726_) / 2;
        int j = (this.f_96544_ - this.f_97727_) / 2;
        int yy = j + 16 + 2;
        WitchQuestList quests = ((WitchMenu)this.m_6262_()).getQuests();
        for (int i = 0; i < quests.size(); ++i) {
            int index = i;
            this.questButtons[i] = (QuestButton)this.m_142416_((GuiEventListener)new QuestButton(xx, yy + i * 26, (WitchQuest)quests.get(index), b -> this.clickQuest(index, (WitchQuest)quests.get(index))));
        }
    }

    protected void m_280003_(GuiGraphics g, int mouseX, int mouseY) {
        g.m_280614_(this.f_96547_, this.f_96539_, 49 + this.f_97726_ / 2 - this.f_96547_.m_92852_((FormattedText)this.f_96539_) / 2, 6, 0x404040, false);
        g.m_280614_(this.f_96547_, this.inventory.m_5446_(), this.f_97730_, this.f_97731_, 0x404040, false);
        int l = this.f_96547_.m_92852_((FormattedText)QUESTS_TEXT);
        g.m_280614_(this.f_96547_, QUESTS_TEXT, 5 - l / 2 + 48, 6, 0x404040, false);
    }

    protected void m_7286_(GuiGraphics g, float delta, int mouseX, int mouseY) {
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int k = (this.f_96543_ - this.f_97726_) / 2;
        int l = (this.f_96544_ - this.f_97727_) / 2;
        g.m_280398_(TEXTURE, k, l, 0, 0.0f, 0.0f, this.f_97726_, this.f_97727_, 512, 256);
    }

    public void m_88315_(GuiGraphics matrices, int mouseX, int mouseY, float delta) {
        this.m_280273_(matrices);
        super.m_88315_(matrices, mouseX, mouseY, delta);
        this.m_280072_(matrices, mouseX, mouseY);
        for (QuestButton questButton : this.questButtons) {
            if (questButton == null || !questButton.m_198029_()) continue;
            questButton.renderToolTip(matrices, mouseX, mouseY);
        }
    }

    class QuestButton
    extends Button {
        private final WitchQuest quest;
        private final QuestRarity questRarity;

        public QuestButton(int x, int y, WitchQuest quest, Button.OnPress action) {
            super(x, y, 104, 26, (Component)Component.m_237119_(), action, Button.f_252438_);
            this.quest = quest;
            this.questRarity = QuestRarity.getRarityFromQuest(quest);
        }

        public void m_87963_(GuiGraphics g, int x, int y, float delta) {
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            int drawTextureIndex = 1;
            if (this.quest.hasItems((Container)Minecraft.m_91087_().f_91074_.m_150109_())) {
                ++drawTextureIndex;
                if (this.m_198029_()) {
                    ++drawTextureIndex;
                }
            }
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            RenderSystem.enableDepthTest();
            g.m_280163_(TEXTURE, this.m_252754_(), this.m_252907_(), 174.0f, (float)(drawTextureIndex * 26), this.f_93618_, this.f_93619_, 512, 256);
            int rarityY = 7 + this.questRarity.ordinal() * 5;
            g.m_280163_(TEXTURE, this.m_252754_() + 4, this.m_252907_() + 11, 278.0f, (float)rarityY, 5, 5, 512, 256);
            int itemXX = this.m_252754_() + 11;
            ItemRenderer itemRenderer = WitchScreen.this.f_96541_.m_91291_();
            for (ItemStack stack : this.quest.getRequiredItems()) {
                g.m_280480_(stack, itemXX, this.m_252907_() + 5);
                g.m_280302_(((WitchScreen)WitchScreen.this).f_96541_.f_91062_, stack, itemXX, this.m_252907_() + 5, String.valueOf(stack.m_41613_()));
                itemXX += 18;
            }
        }

        public void renderToolTip(GuiGraphics g, int mouseX, int mouseY) {
            int xx = mouseX - this.m_252754_();
            int yy = mouseY - this.m_252907_();
            if (this.m_198029_() && xx > 5 && yy < 19) {
                if (xx > 2 && xx < 9) {
                    g.m_280557_(WitchScreen.this.f_96547_, this.questRarity.getTooltipText(), mouseX, mouseY);
                }
                if (xx > 11) {
                    g.m_280168_().m_85836_();
                    g.m_280168_().m_85837_(0.0, 0.0, 400.0);
                    int index = (xx -= 11) / 18;
                    if (index < this.quest.getRequiredItems().length) {
                        int bgX = this.m_252754_() + 11 + index * 18;
                        int bgY = this.m_252907_() + 5;
                        RenderSystem.colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)false);
                        g.m_280024_(bgX, bgY, bgX + 16, bgY + 16, -2130706433, -2130706433);
                        RenderSystem.colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
                        g.m_280153_(WitchScreen.this.f_96547_, this.quest.getRequiredItems()[index], mouseX, mouseY);
                    }
                    g.m_280168_().m_85849_();
                }
            }
        }
    }
}

