/*
 * Decompiled with CFR 0.152.
 */
package party.lemons.biomemakeover.crafting.witch.data.reward;

import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Lifecycle;
import dev.architectury.registry.registries.DeferredRegister;
import dev.architectury.registry.registries.Registrar;
import dev.architectury.registry.registries.RegistrarManager;
import dev.architectury.registry.registries.RegistrySupplier;
import java.util.Optional;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;
import party.lemons.biomemakeover.BiomeMakeover;
import party.lemons.biomemakeover.crafting.witch.data.reward.ItemQuestRewardItem;
import party.lemons.biomemakeover.crafting.witch.data.reward.PotionQuestRewardItem;

public abstract class QuestRewardItem {
    public static final ResourceKey<Registry<RewardItemType<?>>> KEY = ResourceKey.m_135788_((ResourceLocation)BiomeMakeover.ID("quest_reward_item_type"));
    public static final Registrar<RewardItemType<?>> REGISTRY = RegistrarManager.get((String)"biomemakeover").builder(KEY.m_135782_(), (Object[])new RewardItemType[0]).build();
    public static final DeferredRegister<RewardItemType<?>> REWARD_TYPES = DeferredRegister.create((String)"biomemakeover", KEY);
    public static final RegistrySupplier<RewardItemType<?>> ITEM = REWARD_TYPES.register(BiomeMakeover.ID("item"), () -> new RewardItemType<ItemQuestRewardItem>(ItemQuestRewardItem.CODEC));
    public static final RegistrySupplier<RewardItemType<?>> POTION = REWARD_TYPES.register(BiomeMakeover.ID("potion"), () -> new RewardItemType<PotionQuestRewardItem>(PotionQuestRewardItem.CODEC));
    public static final Codec<QuestRewardItem> CODEC = QuestRewardItem.byNameCodec().dispatch(QuestRewardItem::type, RewardItemType::codec);

    public static Codec<RewardItemType<?>> byNameCodec() {
        Codec codec = ResourceLocation.f_135803_.flatXmap(resourceLocation -> Optional.ofNullable((RewardItemType)REGISTRY.get(resourceLocation)).map(DataResult::success).orElseGet(() -> DataResult.error(() -> "Unknown registry key in " + REGISTRY.key() + ": " + resourceLocation)), object -> REGISTRY.getKey(object).map(ResourceKey::m_135782_).map(DataResult::success).orElseGet(() -> DataResult.error(() -> "Unknown registry element in " + REGISTRY.key() + ":" + object)));
        Codec codec2 = ExtraCodecs.m_184421_(object -> REGISTRY.getKey(object).isPresent() ? REGISTRY.getRawId(object) : -1, arg_0 -> REGISTRY.byRawId(arg_0), (int)-1);
        return ExtraCodecs.m_184368_((Codec)ExtraCodecs.m_184425_((Codec)codec, (Codec)codec2), e -> Lifecycle.stable(), e -> Lifecycle.stable());
    }

    public static void init() {
        REWARD_TYPES.register();
    }

    abstract RewardItemType<?> type();

    public abstract ItemStack getReward(RandomSource var1);

    public record RewardItemType<T extends QuestRewardItem>(Codec<T> codec) {
    }
}

