/*
 * Decompiled with CFR 0.152.
 */
package party.lemons.biomemakeover.block;

import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;
import party.lemons.biomemakeover.block.blockentity.PoltergeistBlockEntity;
import party.lemons.biomemakeover.init.BMAdvancements;
import party.lemons.biomemakeover.init.BMEffects;
import party.lemons.biomemakeover.init.BMPotions;
import party.lemons.biomemakeover.level.PoltergeistHandler;
import party.lemons.taniwha.block.types.TBlock;

public class PoltergeistBlock
extends TBlock
implements EntityBlock {
    private static final VoxelShape INSIDE = PoltergeistBlock.m_49796_((double)2.0, (double)4.0, (double)2.0, (double)14.0, (double)16.0, (double)14.0);
    private static final VoxelShape SUPPORT_SHAPE = Shapes.m_83113_((VoxelShape)Shapes.m_83144_(), (VoxelShape)Block.m_49796_((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)16.0, (double)14.0), (BooleanOp)BooleanOp.f_82685_);
    protected static final VoxelShape SHAPE = Shapes.m_83113_((VoxelShape)Shapes.m_83144_(), (VoxelShape)Shapes.m_83124_((VoxelShape)PoltergeistBlock.m_49796_((double)0.0, (double)0.0, (double)4.0, (double)16.0, (double)3.0, (double)12.0), (VoxelShape[])new VoxelShape[]{PoltergeistBlock.m_49796_((double)4.0, (double)0.0, (double)0.0, (double)12.0, (double)3.0, (double)16.0), PoltergeistBlock.m_49796_((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)3.0, (double)14.0), INSIDE}), (BooleanOp)BooleanOp.f_82685_);
    public static BooleanProperty ENABLED = BlockStateProperties.f_61431_;

    public PoltergeistBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_((Property)ENABLED, (Comparable)Boolean.valueOf(true)));
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos blockPos, BlockState blockState) {
        return new PoltergeistBlockEntity(blockPos, blockState);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState blockState, BlockEntityType<T> blockEntityType) {
        return PoltergeistBlockEntity.getTicker(level, blockState);
    }

    public VoxelShape m_5940_(BlockState blockState, BlockGetter blockGetter, BlockPos blockPos, CollisionContext collisionContext) {
        return SHAPE;
    }

    public VoxelShape m_6079_(BlockState blockState, BlockGetter blockGetter, BlockPos blockPos) {
        return INSIDE;
    }

    public VoxelShape m_7947_(BlockState blockState, BlockGetter blockGetter, BlockPos blockPos) {
        return SUPPORT_SHAPE;
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext ctx) {
        return (BlockState)this.m_49966_().m_61124_((Property)ENABLED, (Comparable)Boolean.valueOf(!ctx.m_43725_().m_276867_(ctx.m_8083_())));
    }

    public void m_6861_(BlockState blockState, Level level, BlockPos blockPos, Block block, BlockPos blockPos2, boolean bl) {
        boolean currentlyEnabled;
        if (!level.m_5776_() && (currentlyEnabled = ((Boolean)blockState.m_61143_((Property)ENABLED)).booleanValue()) == level.m_276867_(blockPos)) {
            if (currentlyEnabled) {
                level.m_186460_(blockPos, (Block)this, 4);
            } else {
                level.m_7731_(blockPos, (BlockState)blockState.m_61122_((Property)ENABLED), 2);
                this.doToggleEffects(level, blockPos);
            }
        }
    }

    public void m_213897_(BlockState blockState, ServerLevel serverLevel, BlockPos blockPos, RandomSource random) {
        if (((Boolean)blockState.m_61143_((Property)ENABLED)).booleanValue() && serverLevel.m_276867_(blockPos)) {
            serverLevel.m_7731_(blockPos, (BlockState)blockState.m_61122_((Property)ENABLED), 2);
            this.doToggleEffects((Level)serverLevel, blockPos);
        }
    }

    private void doToggleEffects(Level world, BlockPos pos) {
        world.m_5594_(null, pos, BMEffects.POLTERGEIST_TOGGLE.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
        PoltergeistHandler.doParticles(world, pos);
    }

    public void m_7892_(BlockState blockState, Level level, BlockPos blockPos, Entity entity) {
        int maxTime = 900;
        int maxLevel = 4;
        if (((Boolean)blockState.m_61143_((Property)ENABLED)).booleanValue() && entity.m_20186_() < (double)blockPos.m_123342_() + 0.8 && entity.m_20191_().f_82292_ > (double)blockPos.m_123342_() + 0.25 && entity instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            MobEffectInstance instance = living.m_21124_(BMPotions.POSSESSED.get());
            if (instance == null) {
                living.m_7292_(new MobEffectInstance(BMPotions.POSSESSED.get(), 200, 0));
            } else if (instance.m_19557_() < 900 || instance.m_19564_() < 4) {
                int nextLevel = instance.m_19564_();
                if (nextLevel <= 4 && living.m_217043_().m_188503_(100) == 0) {
                    ++nextLevel;
                }
                MobEffectInstance newEffect = new MobEffectInstance(BMPotions.POSSESSED.get(), instance.m_19557_() + 2, nextLevel);
                instance.m_19558_(newEffect);
            }
            if (living instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)living;
                BMAdvancements.POLTERGEIST_YOURSELF.trigger(player);
            }
        }
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{ENABLED});
    }
}

