/*
 * Decompiled with CFR 0.152.
 */
package party.lemons.biomemakeover.block;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.PipeBlock;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;
import party.lemons.taniwha.block.types.TBlock;
import party.lemons.taniwha.util.MathUtils;

public class IvyShapedBlock
extends TBlock {
    private static final VoxelShape UP_SHAPE = Block.m_49796_((double)0.0, (double)15.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    private static final VoxelShape DOWN_SHAPE = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)1.0, (double)16.0);
    private static final VoxelShape EAST_SHAPE = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)16.0, (double)16.0);
    private static final VoxelShape WEST_SHAPE = Block.m_49796_((double)15.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    private static final VoxelShape SOUTH_SHAPE = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)1.0);
    private static final VoxelShape NORTH_SHAPE = Block.m_49796_((double)0.0, (double)0.0, (double)15.0, (double)16.0, (double)16.0, (double)16.0);
    private static final Map<Direction, BooleanProperty> FACING_PROPERTIES = PipeBlock.f_55154_;
    private static final Map<Direction, VoxelShape> DIRECTION_TO_SHAPE = (Map)Util.m_137469_((Object)Maps.newEnumMap(Direction.class), enumMap -> {
        enumMap.put(Direction.NORTH, SOUTH_SHAPE);
        enumMap.put(Direction.EAST, WEST_SHAPE);
        enumMap.put(Direction.SOUTH, NORTH_SHAPE);
        enumMap.put(Direction.WEST, EAST_SHAPE);
        enumMap.put(Direction.UP, UP_SHAPE);
        enumMap.put(Direction.DOWN, DOWN_SHAPE);
    });
    protected final ImmutableMap<BlockState, VoxelShape> shapes;

    public IvyShapedBlock(BlockBehaviour.Properties settings) {
        super(settings);
        this.m_49959_(IvyShapedBlock.createDefaultState((StateDefinition<Block, BlockState>)this.m_49965_()));
        this.shapes = this.collectVoxelShapes((StateDefinition<Block, BlockState>)this.m_49965_());
    }

    public static BooleanProperty getPropertyForDirection(Direction direction) {
        return FACING_PROPERTIES.get(direction);
    }

    protected static BlockState createDefaultState(StateDefinition<Block, BlockState> stateManager) {
        BlockState blockState = (BlockState)stateManager.m_61090_();
        for (BooleanProperty property : FACING_PROPERTIES.values()) {
            if (!blockState.m_61138_((Property)property)) continue;
            blockState = (BlockState)blockState.m_61124_((Property)property, (Comparable)Boolean.valueOf(false));
        }
        return blockState;
    }

    public BlockState m_7417_(BlockState state, Direction direction, BlockState newState, LevelAccessor level, BlockPos pos, BlockPos posFrom) {
        BlockState returnState;
        if (this.hasDirection(state, direction) && !IvyShapedBlock.isValidPlaceFace((LevelReader)level, direction, posFrom, newState)) {
            returnState = this.getStateWithoutDirection(state, IvyShapedBlock.getPropertyForDirection(direction));
            if (!level.m_5776_()) {
                level.m_46796_(2001, pos, Block.m_49956_((BlockState)((BlockState)this.m_49966_().m_61124_((Property)IvyShapedBlock.getPropertyForDirection(direction), (Comparable)Boolean.valueOf(true)))));
            }
        } else {
            returnState = state;
        }
        if (!this.hasAnySide(returnState)) {
            level.m_7731_(pos, Blocks.f_50016_.m_49966_(), 3);
            return state;
        }
        return returnState;
    }

    private boolean hasAnySide(BlockState state) {
        for (Direction d : Direction.values()) {
            if (!this.hasDirection(state, d)) continue;
            return true;
        }
        return false;
    }

    public boolean hasAdjacentSide(Direction direction, BlockState state) {
        for (Direction d : Direction.values()) {
            if (!MathUtils.isAdjacentDirection((Direction)d, (Direction)direction) || !this.hasDirection(state, d)) continue;
            return true;
        }
        return false;
    }

    public BlockState getStateWithoutDirection(BlockState state, BooleanProperty directionProperty) {
        return (BlockState)state.m_61124_((Property)directionProperty, (Comparable)Boolean.valueOf(false));
    }

    public VoxelShape m_5909_(BlockState blockState, BlockGetter blockGetter, BlockPos blockPos, CollisionContext collisionContext) {
        return (VoxelShape)this.shapes.get((Object)blockState);
    }

    public VoxelShape m_5940_(BlockState blockState, BlockGetter blockGetter, BlockPos blockPos, CollisionContext collisionContext) {
        return (VoxelShape)this.shapes.get((Object)blockState);
    }

    public static VoxelShape getDownShape() {
        return DOWN_SHAPE;
    }

    public boolean m_7898_(BlockState state, LevelReader level, BlockPos pos) {
        boolean canPlace = false;
        for (Direction direction : Direction.values()) {
            if (!this.hasDirection(state, direction)) continue;
            BlockPos blockPos = pos.m_121945_(direction);
            if (!IvyShapedBlock.isValidPlaceFace(level, direction, blockPos, level.m_8055_(blockPos))) {
                return true;
            }
            canPlace = true;
        }
        return canPlace;
    }

    protected ImmutableMap<BlockState, VoxelShape> collectVoxelShapes(StateDefinition<Block, BlockState> stateDefinition) {
        return (ImmutableMap)stateDefinition.m_61056_().stream().collect(ImmutableMap.toImmutableMap(Function.identity(), s -> IvyShapedBlock.calculateShape(s, this)));
    }

    protected Direction getRandomStateSide(BlockState state, RandomSource random) {
        List<Direction> dirs = Arrays.stream(Direction.values()).filter(d -> (Boolean)state.m_61143_((Property)IvyShapedBlock.getPropertyForDirection(d))).toList();
        if (dirs.isEmpty()) {
            return null;
        }
        return dirs.get(random.m_188503_(dirs.size()));
    }

    protected static VoxelShape mergeVoxelShapes(BlockState blockState) {
        VoxelShape shape = Shapes.m_83040_();
        for (Direction direction : Direction.values()) {
            if (!IvyShapedBlock.isValidDirectionForState(blockState, direction)) continue;
            shape = Shapes.m_83110_((VoxelShape)shape, (VoxelShape)DIRECTION_TO_SHAPE.get(direction));
        }
        return shape;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        for (Direction direction : Direction.values()) {
            builder.m_61104_(new Property[]{IvyShapedBlock.getPropertyForDirection(direction)});
        }
    }

    @Nullable
    public BlockState getPlacementState(BlockState blockState, Level worldAccess, BlockPos blockPos, Direction direction) {
        BlockState placeState;
        if (blockState.m_60713_((Block)this)) {
            if (this.hasDirection(blockState, direction)) {
                return null;
            }
            placeState = blockState;
        } else {
            placeState = this.m_49966_();
        }
        BlockPos placeSide = blockPos.m_121945_(direction);
        return IvyShapedBlock.isValidPlaceFace((LevelReader)worldAccess, direction, placeSide, worldAccess.m_8055_(placeSide)) ? (BlockState)placeState.m_61124_((Property)IvyShapedBlock.getPropertyForDirection(direction), (Comparable)Boolean.valueOf(true)) : null;
    }

    public BlockState m_6843_(BlockState state, Rotation rotation) {
        return this.getStateWithDirections(state, arg_0 -> ((Rotation)rotation).m_55954_(arg_0));
    }

    public BlockState m_6943_(BlockState state, Mirror mirror) {
        return this.getStateWithDirections(state, arg_0 -> ((Mirror)mirror).m_54848_(arg_0));
    }

    private BlockState getStateWithDirections(BlockState blockState, Function<Direction, Direction> function) {
        BlockState state = blockState;
        for (Direction direction : Direction.values()) {
            state = (BlockState)state.m_61124_((Property)IvyShapedBlock.getPropertyForDirection(function.apply(direction)), (Comparable)((Boolean)blockState.m_61143_((Property)IvyShapedBlock.getPropertyForDirection(direction))));
        }
        return state;
    }

    public boolean hasDirection(BlockState blockState, Direction direction) {
        BooleanProperty booleanProperty = IvyShapedBlock.getPropertyForDirection(direction);
        return (Boolean)blockState.m_61143_((Property)booleanProperty);
    }

    public static boolean isValidPlaceFace(LevelReader blockView, Direction direction, BlockPos blockPos, BlockState blockState) {
        return Block.m_49918_((VoxelShape)blockState.m_60812_((BlockGetter)blockView, blockPos), (Direction)direction.m_122424_());
    }

    private static boolean isValidDirectionForState(BlockState blockState, Direction direction) {
        BooleanProperty booleanProperty = IvyShapedBlock.getPropertyForDirection(direction);
        return blockState.m_61138_((Property)booleanProperty) && (Boolean)blockState.m_61143_((Property)booleanProperty) != false;
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext ctx) {
        Level world = ctx.m_43725_();
        BlockPos blockPos = ctx.m_8083_();
        BlockState blockState = world.m_8055_(blockPos);
        return Arrays.stream(ctx.m_6232_()).map(direction -> this.getPlacementState(blockState, world, blockPos, (Direction)direction)).filter(Objects::nonNull).findFirst().orElse(null);
    }

    private static VoxelShape calculateShape(BlockState blockState, IvyShapedBlock block) {
        VoxelShape voxelShape = Shapes.m_83040_();
        for (Direction direction : Direction.values()) {
            if (!block.hasDirection(blockState, direction)) continue;
            voxelShape = Shapes.m_83110_((VoxelShape)voxelShape, (VoxelShape)DIRECTION_TO_SHAPE.get(direction));
        }
        return voxelShape.m_83281_() ? Shapes.m_83144_() : voxelShape;
    }
}

