/*
 * Decompiled with CFR 0.152.
 */
package party.lemons.biomemakeover.block;

import java.util.Locale;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.AmethystClusterBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import party.lemons.biomemakeover.init.BMEffects;
import party.lemons.taniwha.block.modifier.BlockModifier;
import party.lemons.taniwha.block.modifier.BlockWithModifiers;
import party.lemons.taniwha.registry.Modifier;
import party.lemons.taniwha.registry.ModifierContainer;

public class IlluniteClusterBlock
extends AmethystClusterBlock
implements BlockWithModifiers<IlluniteClusterBlock> {
    public static final EnumProperty<Type> TYPE = EnumProperty.m_61587_((String)"type", Type.class);
    private ModifierContainer<Block> modifierContainer;

    public IlluniteClusterBlock(int xzSize, int ySize, int light, BlockBehaviour.Properties properties) {
        super(xzSize, ySize, properties.m_60977_().m_60953_(v -> {
            switch ((Type)((Object)((Object)v.m_61143_(TYPE)))) {
                case DAY: {
                    return 2;
                }
                case NIGHT: {
                    return light;
                }
                case UNKNOWN: {
                    return 2;
                }
            }
            return 0;
        }));
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_((Property)f_152006_, (Comparable)Direction.UP)).m_61124_(TYPE, (Comparable)((Object)Type.DAY))).m_61124_((Property)f_152005_, (Comparable)Boolean.valueOf(false)));
    }

    public void m_213897_(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        Type expectedType = this.getType((Level)level);
        if (state.m_61143_(TYPE) != expectedType) {
            level.m_7731_(pos, (BlockState)state.m_61124_(TYPE, (Comparable)((Object)expectedType)), 3);
        }
        level.m_186460_(new BlockPos((Vec3i)pos), (Block)this, 20 + random.m_188503_(150));
    }

    private Type getType(Level world) {
        if (world.m_6042_().m_63967_()) {
            return Type.UNKNOWN;
        }
        if (world.m_46462_()) {
            return Type.NIGHT;
        }
        return Type.DAY;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{TYPE});
    }

    public void m_213898_(BlockState blockState, ServerLevel serverLevel, BlockPos blockPos, RandomSource random) {
        this.scheduleUpdates((LevelAccessor)serverLevel, blockPos, random);
    }

    public BlockState m_7417_(BlockState blockState, Direction direction, BlockState blockState2, LevelAccessor levelAccessor, BlockPos blockPos, BlockPos blockPos2) {
        this.scheduleUpdates(levelAccessor, blockPos, levelAccessor.m_213780_());
        return super.m_7417_(blockState, direction, blockState2, levelAccessor, blockPos, blockPos2);
    }

    public void scheduleUpdates(LevelAccessor world, BlockPos pos, RandomSource random) {
        if (!world.m_183326_().m_183582_(pos, (Object)this)) {
            world.m_186460_(new BlockPos((Vec3i)pos), (Block)this, 20 + random.m_188503_(150));
        }
    }

    public void m_7742_(BlockState blockState, LevelAccessor levelAccessor, BlockPos blockPos, int i, int j) {
        super.m_7742_(blockState, levelAccessor, blockPos, i, j);
        this.scheduleUpdates(levelAccessor, blockPos, levelAccessor.m_213780_());
    }

    public void m_5581_(Level level, BlockState blockState, BlockHitResult blockHitResult, Projectile projectile) {
        if (!level.f_46443_) {
            BlockPos blockPos = blockHitResult.m_82425_();
            level.m_5594_(null, blockPos, BMEffects.ILLUNITE_HIT.get(), SoundSource.BLOCKS, 1.0f, 0.5f + level.f_46441_.m_188501_() * 1.2f);
            level.m_5594_(null, blockPos, BMEffects.ILLUNITE_STEP.get(), SoundSource.BLOCKS, 1.0f, 0.5f + level.f_46441_.m_188501_() * 1.2f);
        }
    }

    public ModifierContainer<Block> getModifierContainer() {
        return this.modifierContainer;
    }

    public IlluniteClusterBlock modifiers(BlockModifier ... modifiers) {
        this.modifierContainer = new ModifierContainer((Object)this, (Modifier[])modifiers);
        return this;
    }

    public static enum Type implements StringRepresentable
    {
        DAY,
        NIGHT,
        UNKNOWN;


        public String m_7912_() {
            return this.name().toLowerCase(Locale.ROOT);
        }
    }
}

