/*
 * Decompiled with CFR 0.152.
 */
package party.lemons.biomemakeover;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import dev.architectury.registry.client.level.entity.EntityRendererRegistry;
import dev.architectury.registry.client.rendering.BlockEntityRendererRegistry;
import dev.architectury.registry.menu.MenuRegistry;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.color.block.BlockColor;
import net.minecraft.client.model.HorseModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.ThrownItemRenderer;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import party.lemons.biomemakeover.block.blockentity.AltarBlockEntity;
import party.lemons.biomemakeover.block.blockentity.render.AltarRenderer;
import party.lemons.biomemakeover.block.blockentity.render.LightningBugBottleRenderer;
import party.lemons.biomemakeover.block.blockentity.render.TapestryRenderer;
import party.lemons.biomemakeover.crafting.AltarScreen;
import party.lemons.biomemakeover.crafting.DirectionDataScreen;
import party.lemons.biomemakeover.crafting.witch.menu.WitchScreen;
import party.lemons.biomemakeover.entity.render.AdjudicatorMimicRender;
import party.lemons.biomemakeover.entity.render.AdjudicatorRender;
import party.lemons.biomemakeover.entity.render.BlightBatRender;
import party.lemons.biomemakeover.entity.render.CowboyRender;
import party.lemons.biomemakeover.entity.render.DecayedRender;
import party.lemons.biomemakeover.entity.render.DragonflyRender;
import party.lemons.biomemakeover.entity.render.GhostRender;
import party.lemons.biomemakeover.entity.render.GlowfishRender;
import party.lemons.biomemakeover.entity.render.HelmitCrabRender;
import party.lemons.biomemakeover.entity.render.LightningBugRender;
import party.lemons.biomemakeover.entity.render.MothRender;
import party.lemons.biomemakeover.entity.render.MushroomTraderRender;
import party.lemons.biomemakeover.entity.render.OwlRender;
import party.lemons.biomemakeover.entity.render.RootlingRender;
import party.lemons.biomemakeover.entity.render.ScuttlerRender;
import party.lemons.biomemakeover.entity.render.StoneGolemRender;
import party.lemons.biomemakeover.entity.render.TadpoleRender;
import party.lemons.biomemakeover.entity.render.ToadRender;
import party.lemons.biomemakeover.entity.render.TumbleweedRender;
import party.lemons.biomemakeover.entity.render.feature.CowboyHatRenderLayer;
import party.lemons.biomemakeover.init.BMBlockEntities;
import party.lemons.biomemakeover.init.BMBlocks;
import party.lemons.biomemakeover.init.BMEntities;
import party.lemons.biomemakeover.init.BMFeatures;
import party.lemons.biomemakeover.init.BMScreens;
import party.lemons.biomemakeover.util.extension.HorseHat;
import party.lemons.biomemakeover.util.sound.AltarCursingSoundInstance;
import party.lemons.taniwha.client.color.ColorProviderHelper;
import party.lemons.taniwha.client.color.FoliageBlockColorProvider;
import party.lemons.taniwha.client.color.FoliageShiftBlockColorProvider;
import party.lemons.taniwha.client.color.TemperatureGradientColorProvider;
import party.lemons.taniwha.client.model.RenderLayerInjector;

public class BiomeMakeoverClient {
    @OnlyIn(value=Dist.CLIENT)
    public static void init() {
        BMEntities.registerModelLayers();
        BMBlockEntities.DIRECTIONAL_DATA.listen(b -> {
            BlockEntityRendererRegistry.register((BlockEntityType)((BlockEntityType)BMBlockEntities.TAPESTRY.get()), TapestryRenderer::new);
            BlockEntityRendererRegistry.register((BlockEntityType)((BlockEntityType)BMBlockEntities.ALTAR.get()), AltarRenderer::new);
            BlockEntityRendererRegistry.register((BlockEntityType)((BlockEntityType)BMBlockEntities.LIGHTNING_BUG_BOTTLE.get()), LightningBugBottleRenderer::new);
        });
        BiomeMakeoverClient.initColors();
        BMScreens.DIRECTIONAL_DATA.listen(b -> {
            MenuRegistry.registerScreenFactory((MenuType)((MenuType)BMScreens.WITCH.get()), WitchScreen::new);
            MenuRegistry.registerScreenFactory((MenuType)((MenuType)BMScreens.ALTAR.get()), AltarScreen::new);
            MenuRegistry.registerScreenFactory((MenuType)((MenuType)BMScreens.DIRECTIONAL_DATA.get()), DirectionDataScreen::new);
        });
        BiomeMakeoverClient.registerModels();
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void registerModels() {
        EntityRendererRegistry.register(BMEntities.TUMBLEWEED, TumbleweedRender::new);
        EntityRendererRegistry.register(BMEntities.LIGHTNING_BOTTLE, ThrownItemRenderer::new);
        EntityRendererRegistry.register(BMEntities.GLOWFISH, GlowfishRender::new);
        EntityRendererRegistry.register(BMEntities.BLIGHTBAT, BlightBatRender::new);
        EntityRendererRegistry.register(BMEntities.MUSHROOM_TRADER, MushroomTraderRender::new);
        EntityRendererRegistry.register(BMEntities.SCUTTLER, ScuttlerRender::new);
        EntityRendererRegistry.register(BMEntities.GHOST, GhostRender::new);
        EntityRendererRegistry.register(BMEntities.COWBOY, CowboyRender::new);
        EntityRendererRegistry.register(BMEntities.DECAYED, DecayedRender::new);
        EntityRendererRegistry.register(BMEntities.DRAGONFLY, DragonflyRender::new);
        EntityRendererRegistry.register(BMEntities.TOAD, ToadRender::new);
        EntityRendererRegistry.register(BMEntities.TADPOLE, TadpoleRender::new);
        EntityRendererRegistry.register(BMEntities.LIGHTNING_BUG, LightningBugRender::new);
        EntityRendererRegistry.register(BMEntities.LIGHTNING_BUG_ALTERNATE, LightningBugRender::new);
        EntityRendererRegistry.register(BMEntities.OWL, OwlRender::new);
        EntityRendererRegistry.register(BMEntities.MOTH, MothRender::new);
        EntityRendererRegistry.register(BMEntities.ROOTLING, RootlingRender::new);
        EntityRendererRegistry.register(BMEntities.ADJUDICATOR, AdjudicatorRender::new);
        EntityRendererRegistry.register(BMEntities.ADJUDICATOR_MIMIC, AdjudicatorMimicRender::new);
        EntityRendererRegistry.register(BMEntities.STONE_GOLEM, StoneGolemRender::new);
        EntityRendererRegistry.register(BMEntities.HELMIT_CRAB, HelmitCrabRender::new);
        RenderLayerInjector.inject((EntityType)EntityType.f_20457_, ctx -> new CowboyHatRenderLayer((RenderLayerParent)ctx.entityRenderer(), ctx.modelSet()){

            protected boolean hasHat(LivingEntity entity) {
                return ((HorseHat)entity).hasHat();
            }

            @Override
            protected void setup(PoseStack poseStack) {
                poseStack.m_85841_(1.05f, 1.05f, 1.05f);
                ((ModelPart)((HorseModel)this.m_117386_()).m_5607_().iterator().next()).m_104299_(poseStack);
                poseStack.m_252880_(0.0f, -0.4f, 0.0f);
                poseStack.m_252781_(Axis.f_252529_.m_252977_(-25.0f));
            }
        });
    }

    private static void initColors() {
        ColorProviderHelper.registerSimpleBlockWithItem((BlockColor)new FoliageBlockColorProvider(), (Supplier[])new Supplier[]{BMBlocks.ANCIENT_OAK_LEAVES, BMBlocks.IVY});
        ColorProviderHelper.registerSimpleBlockWithItem((BlockColor)new TemperatureGradientColorProvider(new int[]{7509088, 8694639, 10529647}), (Supplier[])new Supplier[]{BMBlocks.SWAMP_CYPRESS_LEAVES});
        ColorProviderHelper.registerSimpleBlockWithItem((BlockColor)new FoliageShiftBlockColorProvider(0, 0, 0){

            protected int[] getColorBoosts(BlockAndTintGetter world, BlockState state, BlockPos pos, int tintIndex) {
                if (world instanceof ClientLevel && pos != null && ((ClientLevel)world).m_204166_(pos).m_203656_(BMFeatures.SWAMP_BIOMES)) {
                    return new int[]{-20, 40, -20};
                }
                return super.getColorBoosts(world, state, pos, tintIndex);
            }
        }, (Supplier[])new Supplier[]{BMBlocks.SMALL_LILY_PAD, () -> Blocks.f_50196_, BMBlocks.WATER_LILY});
        ColorProviderHelper.registerSimpleBlockWithItem((BlockColor)new FoliageShiftBlockColorProvider(0, 0, 0){

            protected int[] getColorBoosts(BlockAndTintGetter world, BlockState state, BlockPos pos, int tintIndex) {
                if (world instanceof ClientLevel && ((ClientLevel)world).m_204166_(pos).m_203656_(BMFeatures.SWAMP_BIOMES)) {
                    return new int[]{-10, 15, -10};
                }
                return super.getColorBoosts(world, state, pos, tintIndex);
            }
        }, (Supplier[])new Supplier[]{BMBlocks.WILLOW_LEAVES, BMBlocks.WILLOWING_BRANCHES});
        ColorProviderHelper.registerSimpleBlockWithItem((BlockColor)new FoliageShiftBlockColorProvider(35, -10, -5), (Supplier[])new Supplier[]{BMBlocks.MOTH_BLOSSOM, BMBlocks.ITCHING_IVY});
    }

    public static void curseSound(AltarBlockEntity altar) {
        AltarCursingSoundInstance sound = new AltarCursingSoundInstance(altar, altar.m_58904_().m_213780_());
        Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)sound);
    }
}

