/*
 * Decompiled with CFR 0.152.
 */
package de.rubixdev.inventorio.player.inventory;

import de.rubixdev.inventorio.player.inventory.PlayerInventoryExtension;
import de.rubixdev.inventorio.util.GeneralConstants;
import de.rubixdev.inventorio.util.RandomStuff;
import java.util.Iterator;
import java.util.function.Predicate;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ProjectileWeaponItem;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0003\b&\u0018\u00002\u00020\u0001B\u0011\b\u0004\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0017\u0010\b\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\b\u0010\tJ\u0015\u0010\f\u001a\u00020\u000b2\u0006\u0010\n\u001a\u00020\u0006\u00a2\u0006\u0004\b\f\u0010\rJ\u0015\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\n\u001a\u00020\u0006\u00a2\u0006\u0004\b\u000e\u0010\rJ\u0015\u0010\u0011\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000f\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u0015\u0010\u0013\u001a\u00020\u000b2\u0006\u0010\n\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0013\u0010\rJ\u001f\u0010\u0016\u001a\u00020\u00152\u0006\u0010\n\u001a\u00020\u00062\u0006\u0010\u0014\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b\u0016\u0010\u0017\u00a8\u0006\u0018"}, d2={"Lde/rubixdev/inventorio/player/inventory/PlayerInventoryInjects;", "Lde/rubixdev/inventorio/player/inventory/PlayerInventoryExtension;", "Lnet/minecraft/world/entity/player/Player;", "player", "<init>", "(Lnet/minecraft/world/entity/player/Player;)V", "Lnet/minecraft/world/item/ItemStack;", "bowStack", "getActiveArrowType", "(Lnet/minecraft/world/item/ItemStack;)Lnet/minecraft/world/item/ItemStack;", "sourceStack", "", "insertOnlySimilarStack", "(Lnet/minecraft/world/item/ItemStack;)Z", "insertStackIntoEmptySlot", "", "xpAmount", "mendToolBeltItems", "(I)I", "removeOne", "targetStack", "", "transfer", "(Lnet/minecraft/world/item/ItemStack;Lnet/minecraft/world/item/ItemStack;)V", "inventorio-mc1.20.1-forge"})
@SourceDebugExtension(value={"SMAP\nPlayerInventoryInjects.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PlayerInventoryInjects.kt\nde/rubixdev/inventorio/player/inventory/PlayerInventoryInjects\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,112:1\n288#2,2:113\n*S KotlinDebug\n*F\n+ 1 PlayerInventoryInjects.kt\nde/rubixdev/inventorio/player/inventory/PlayerInventoryInjects\n*L\n34#1:113,2\n*E\n"})
public abstract class PlayerInventoryInjects
extends PlayerInventoryExtension {
    protected PlayerInventoryInjects(@NotNull Player player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        super(player);
    }

    public final int mendToolBeltItems(int xpAmount) {
        int xpLeft = xpAmount;
        for (ItemStack itemStack : this.toolBelt) {
            Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"itemStack");
            if (!RandomStuff.isNotEmpty(itemStack) || !itemStack.m_41768_()) continue;
            Enchantment enchantment = Enchantments.f_44962_;
            Intrinsics.checkNotNullExpressionValue((Object)enchantment, (String)"MENDING");
            if (RandomStuff.getLevelOn(enchantment, itemStack) <= 0) continue;
            int damageRestored = Math.min(xpAmount * 2, itemStack.m_41773_());
            itemStack.m_41721_(itemStack.m_41773_() - damageRestored);
            xpLeft = xpAmount - damageRestored / 2;
            return xpLeft > 0 ? this.mendToolBeltItems(xpLeft) : 0;
        }
        return xpLeft;
    }

    @Nullable
    public final ItemStack getActiveArrowType(@NotNull ItemStack bowStack) {
        Object v1;
        block2: {
            Intrinsics.checkNotNullParameter((Object)bowStack, (String)"bowStack");
            if (!(bowStack.m_41720_() instanceof ProjectileWeaponItem)) {
                return null;
            }
            Item item = bowStack.m_41720_();
            Intrinsics.checkNotNull((Object)item, (String)"null cannot be cast to non-null type net.minecraft.item.RangedWeaponItem");
            Predicate predicate = ((ProjectileWeaponItem)item).m_6442_();
            Iterable $this$firstOrNull$iv = (Iterable)this.stacks;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                ItemStack it = (ItemStack)element$iv;
                boolean bl = false;
                if (!predicate.test(it)) continue;
                v1 = element$iv;
                break block2;
            }
            v1 = null;
        }
        return v1;
    }

    public final boolean insertOnlySimilarStack(@NotNull ItemStack sourceStack) {
        int n;
        Intrinsics.checkNotNullParameter((Object)sourceStack, (String)"sourceStack");
        if (!sourceStack.m_41753_()) {
            return false;
        }
        Object object = GeneralConstants.INVENTORY_HOTBAR_RANGE;
        int i = object.getFirst();
        if (i <= (n = object.getLast())) {
            while (true) {
                Object object2 = this.getPlayer().m_150109_().f_35974_.get(i);
                Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"player.inventory.main[i]");
                ItemStack hotbarStack = (ItemStack)object2;
                if (this.areItemsSimilar(sourceStack, hotbarStack) && hotbarStack.m_41613_() < hotbarStack.m_41741_()) {
                    return false;
                }
                if (i == n) break;
                ++i;
            }
        }
        for (ItemStack utilityStack : this.utilityBelt) {
            Intrinsics.checkNotNullExpressionValue((Object)utilityStack, (String)"utilityStack");
            if (!this.areItemsSimilar(sourceStack, utilityStack)) continue;
            this.transfer(sourceStack, utilityStack);
            if (!sourceStack.m_41619_()) continue;
            return true;
        }
        object = this.getAvailableDeepPocketsRange();
        int index = object.getFirst();
        if (index <= (n = object.getLast())) {
            while (true) {
                ItemStack targetStack = (ItemStack)this.deepPockets.get(index);
                Intrinsics.checkNotNullExpressionValue((Object)targetStack, (String)"targetStack");
                if (this.areItemsSimilar(sourceStack, targetStack)) {
                    this.transfer(sourceStack, targetStack);
                    if (sourceStack.m_41619_()) {
                        return true;
                    }
                }
                if (index == n) break;
                ++index;
            }
        }
        return false;
    }

    public final boolean insertStackIntoEmptySlot(@NotNull ItemStack sourceStack) {
        Intrinsics.checkNotNullParameter((Object)sourceStack, (String)"sourceStack");
        IntRange intRange = this.getAvailableDeepPocketsRange();
        int index = intRange.getFirst();
        int n = intRange.getLast();
        if (index <= n) {
            while (true) {
                if (((ItemStack)this.deepPockets.get(index)).m_41619_()) {
                    this.deepPockets.set(index, sourceStack.m_41777_());
                    sourceStack.m_41764_(0);
                    this.m_6596_();
                    return true;
                }
                if (index == n) break;
                ++index;
            }
        }
        return false;
    }

    private final void transfer(ItemStack sourceStack, ItemStack targetStack) {
        int j = Math.min(sourceStack.m_41613_(), targetStack.m_41741_() - targetStack.m_41613_());
        if (j > 0) {
            targetStack.m_41769_(j);
            sourceStack.m_41774_(j);
            this.m_6596_();
        }
    }

    public final boolean removeOne(@NotNull ItemStack sourceStack) {
        Intrinsics.checkNotNullParameter((Object)sourceStack, (String)"sourceStack");
        Iterator iterator = this.stacks.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            int index = n++;
            ItemStack stack = (ItemStack)iterator.next();
            if (stack != sourceStack) continue;
            this.stacks.set(index, (Object)ItemStack.f_41583_);
            return true;
        }
        return false;
    }
}

