/*
 * Decompiled with CFR 0.152.
 */
package de.rubixdev.inventorio.player.inventory;

import de.rubixdev.inventorio.config.GlobalSettings;
import de.rubixdev.inventorio.config.PlayerSettings;
import de.rubixdev.inventorio.packet.InventorioNetworking;
import de.rubixdev.inventorio.player.PlayerInventoryAddon;
import de.rubixdev.inventorio.player.inventory.PlayerInventoryInjects;
import de.rubixdev.inventorio.util.RandomStuff;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.Util;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0011\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\n\n\u0002\u0010\t\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0007\b&\u0018\u00002\u00020\u0001B\u0011\b\u0004\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\r\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u000f\u0010\t\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0004\b\t\u0010\bJ\r\u0010\n\u001a\u00020\u0006\u00a2\u0006\u0004\b\n\u0010\bJ\u0013\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00060\u000b\u00a2\u0006\u0004\b\f\u0010\rJ\r\u0010\u000e\u001a\u00020\u0006\u00a2\u0006\u0004\b\u000e\u0010\bJ\r\u0010\u000f\u001a\u00020\u0006\u00a2\u0006\u0004\b\u000f\u0010\bJ\u0015\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0010\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u0015\u0010\u0014\u001a\u00020\u00112\u0006\u0010\u0010\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0014\u0010\u0013J\r\u0010\u0015\u001a\u00020\u0011\u00a2\u0006\u0004\b\u0015\u0010\u0016R*\u0010\u0018\u001a\u00020\u00062\u0006\u0010\u0017\u001a\u00020\u00068\u0006@FX\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u0018\u0010\u0019\u001a\u0004\b\u001a\u0010\b\"\u0004\b\u001b\u0010\u0013R*\u0010\u001e\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001c8\u0006@DX\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u001e\u0010\u001f\u001a\u0004\b \u0010!\"\u0004\b\"\u0010#R*\u0010%\u001a\u00020$2\u0006\u0010\u0017\u001a\u00020$8\u0006@FX\u0086\u000e\u00a2\u0006\u0012\n\u0004\b%\u0010&\u001a\u0004\b'\u0010(\"\u0004\b)\u0010*\u00a8\u0006+"}, d2={"Lde/rubixdev/inventorio/player/inventory/PlayerInventoryHandFeatures;", "Lde/rubixdev/inventorio/player/inventory/PlayerInventoryInjects;", "Lnet/minecraft/world/entity/player/Player;", "player", "<init>", "(Lnet/minecraft/world/entity/player/Player;)V", "Lnet/minecraft/world/item/ItemStack;", "getActualMainHandItem", "()Lnet/minecraft/world/item/ItemStack;", "getDisplayedMainHandStack", "getDisplayedOffHandStack", "", "getDisplayedUtilities", "()[Lnet/minecraft/world/item/ItemStack;", "getSelectedHotbarStack", "getSelectedUtilityStack", "itemStack", "", "setSelectedHotbarStack", "(Lnet/minecraft/world/item/ItemStack;)V", "setSelectedUtilityStack", "swapItemsInHands", "()V", "value", "displayTool", "Lnet/minecraft/world/item/ItemStack;", "getDisplayTool", "setDisplayTool", "", "<set-?>", "displayToolTimeStamp", "J", "getDisplayToolTimeStamp", "()J", "setDisplayToolTimeStamp", "(J)V", "", "swappedHands", "Z", "getSwappedHands", "()Z", "setSwappedHands", "(Z)V", "inventorio-mc1.20.1-forge"})
public abstract class PlayerInventoryHandFeatures
extends PlayerInventoryInjects {
    private long displayToolTimeStamp;
    @NotNull
    private ItemStack displayTool;
    private boolean swappedHands;

    protected PlayerInventoryHandFeatures(@NotNull Player player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        super(player);
        ItemStack itemStack = ItemStack.f_41583_;
        Intrinsics.checkNotNull((Object)itemStack);
        this.displayTool = itemStack;
        if (player.m_9236_().f_46443_) {
            this.setSwappedHands(PlayerSettings.swappedHands.getBoolValue());
        }
    }

    public final long getDisplayToolTimeStamp() {
        return this.displayToolTimeStamp;
    }

    protected final void setDisplayToolTimeStamp(long l) {
        this.displayToolTimeStamp = l;
    }

    @NotNull
    public final ItemStack getDisplayTool() {
        return this.displayTool;
    }

    public final void setDisplayTool(@NotNull ItemStack value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.displayTool = value;
        this.displayToolTimeStamp = RandomStuff.isNotEmpty(value) ? Util.m_137550_() + (long)1000 : 0L;
    }

    public final boolean getSwappedHands() {
        return this.swappedHands;
    }

    public final void setSwappedHands(boolean value) {
        boolean bl = this.swappedHands = GlobalSettings.allowSwappedHands.getBoolValue() && value;
        if (this.getPlayer().m_9236_().f_46443_) {
            InventorioNetworking.Companion.getInstance().c2sSetSwappedHandsMode(value);
        }
    }

    @Nullable
    public final ItemStack getDisplayedMainHandStack() {
        return RandomStuff.isNotEmpty(this.displayTool) ? this.displayTool : (this.swappedHands ? this.getSelectedUtilityStack() : null);
    }

    @NotNull
    public final ItemStack getDisplayedOffHandStack() {
        if (!this.swappedHands) {
            return this.getSelectedUtilityStack();
        }
        return this.getSelectedHotbarStack();
    }

    @NotNull
    public final ItemStack getActualMainHandItem() {
        return this.swappedHands ? this.getSelectedUtilityStack() : this.getSelectedHotbarStack();
    }

    @NotNull
    public final ItemStack getSelectedHotbarStack() {
        if (Inventory.m_36045_((int)this.getPlayer().m_150109_().f_35977_)) {
            ItemStack itemStack = this.getPlayer().m_150109_().m_8020_(this.getPlayer().m_150109_().f_35977_);
            Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"player.inventory.getStac\u2026r.inventory.selectedSlot)");
            return itemStack;
        }
        ItemStack itemStack = ItemStack.f_41583_;
        Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"EMPTY");
        return itemStack;
    }

    @NotNull
    public final ItemStack getSelectedUtilityStack() {
        Object e = this.utilityBelt.get(this.getSelectedUtility());
        Intrinsics.checkNotNullExpressionValue(e, (String)"utilityBelt[selectedUtility]");
        return (ItemStack)e;
    }

    public final void setSelectedHotbarStack(@NotNull ItemStack itemStack) {
        Intrinsics.checkNotNullParameter((Object)itemStack, (String)"itemStack");
        if (Inventory.m_36045_((int)this.getPlayer().m_150109_().f_35977_)) {
            this.getPlayer().m_150109_().m_6836_(this.getPlayer().m_150109_().f_35977_, itemStack);
        }
    }

    public final void setSelectedUtilityStack(@NotNull ItemStack itemStack) {
        Intrinsics.checkNotNullParameter((Object)itemStack, (String)"itemStack");
        this.utilityBelt.set(this.getSelectedUtility(), itemStack);
    }

    @NotNull
    public final ItemStack[] getDisplayedUtilities() {
        boolean skipEmptySlots = PlayerSettings.skipEmptyUtilitySlots.getBoolValue();
        ItemStack[] itemStackArray = new ItemStack[]{this.findNextUtility(-1, skipEmptySlots).getFirst(), this.getSelectedUtilityStack(), this.findNextUtility(1, skipEmptySlots).getFirst()};
        return itemStackArray;
    }

    public final void swapItemsInHands() {
        PlayerInventoryAddon playerInventoryAddon = PlayerInventoryAddon.Companion.getInventoryAddon(this.getPlayer());
        if (!(playerInventoryAddon != null && (playerInventoryAddon = playerInventoryAddon.getDisplayTool()) != null ? playerInventoryAddon.m_41619_() : false)) {
            return;
        }
        ItemStack offHandStack = this.getSelectedUtilityStack();
        this.setSelectedUtilityStack(this.getSelectedHotbarStack());
        this.setSelectedHotbarStack(offHandStack);
    }
}

