/*
 * Decompiled with CFR 0.152.
 */
package de.rubixdev.inventorio.player.inventory;

import de.rubixdev.inventorio.mixin.client.accessor.MinecraftClientAccessor;
import de.rubixdev.inventorio.packet.InventorioNetworking;
import de.rubixdev.inventorio.player.inventory.PlayerInventoryHandFeatures;
import de.rubixdev.inventorio.util.RandomStuff;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import net.minecraft.client.Minecraft;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.FireworkRocketEntity;
import net.minecraft.world.item.FireworkRocketItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TieredItem;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.AbstractGlassBlock;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\b\b&\u0018\u00002\u00020\u0001B\u0011\b\u0004\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\r\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0015\u0010\f\u001a\u00020\u000b2\u0006\u0010\n\u001a\u00020\t\u00a2\u0006\u0004\b\f\u0010\rJ\u0017\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\n\u001a\u00020\tH\u0002\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u000f\u0010\u0012\u001a\u00020\u0011H\u0002\u00a2\u0006\u0004\b\u0012\u0010\u0013J\r\u0010\u0014\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0014\u0010\bJ\r\u0010\u0015\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0015\u0010\bJ\u0017\u0010\u0017\u001a\u00020\u00112\u0006\u0010\u0016\u001a\u00020\u000eH\u0002\u00a2\u0006\u0004\b\u0017\u0010\u0018\u00a8\u0006\u0019"}, d2={"Lde/rubixdev/inventorio/player/inventory/PlayerInventoryExtraStuff;", "Lde/rubixdev/inventorio/player/inventory/PlayerInventoryHandFeatures;", "Lnet/minecraft/world/entity/player/Player;", "player", "<init>", "(Lnet/minecraft/world/entity/player/Player;)V", "", "fireRocketFromInventory", "()V", "Lnet/minecraft/world/level/block/state/BlockState;", "block", "", "getMiningSpeedMultiplier", "(Lnet/minecraft/world/level/block/state/BlockState;)F", "Lnet/minecraft/world/item/ItemStack;", "getMostPreferredTool", "(Lnet/minecraft/world/level/block/state/BlockState;)Lnet/minecraft/world/item/ItemStack;", "", "playerAttackConditions", "()Z", "postPlayerAttack", "prePlayerAttack", "itemStack", "tryFireRocket", "(Lnet/minecraft/world/item/ItemStack;)Z", "inventorio-mc1.20.1-forge"})
@SourceDebugExtension(value={"SMAP\nPlayerInventoryExtraStuff.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PlayerInventoryExtraStuff.kt\nde/rubixdev/inventorio/player/inventory/PlayerInventoryExtraStuff\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,127:1\n12474#2,2:128\n12474#2,2:146\n1963#3,14:130\n288#3,2:144\n*S KotlinDebug\n*F\n+ 1 PlayerInventoryExtraStuff.kt\nde/rubixdev/inventorio/player/inventory/PlayerInventoryExtraStuff\n*L\n33#1:128,2\n68#1:146,2\n47#1:130,14\n57#1:144,2\n*E\n"})
public abstract class PlayerInventoryExtraStuff
extends PlayerInventoryHandFeatures {
    protected PlayerInventoryExtraStuff(@NotNull Player player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        super(player);
    }

    public final float getMiningSpeedMultiplier(@NotNull BlockState block) {
        Intrinsics.checkNotNullParameter((Object)block, (String)"block");
        ItemStack tool = this.getMostPreferredTool(block);
        if (!Intrinsics.areEqual((Object)tool, (Object)this.getActualMainHandItem())) {
            boolean bl;
            block3: {
                StackTraceElement[] stackTraceElementArray = Thread.currentThread().getStackTrace();
                Intrinsics.checkNotNullExpressionValue((Object)stackTraceElementArray, (String)"currentThread().stackTrace");
                Object[] $this$any$iv = stackTraceElementArray;
                boolean $i$f$any = false;
                for (Object element$iv : $this$any$iv) {
                    StackTraceElement it = (StackTraceElement)element$iv;
                    boolean bl2 = false;
                    String string = it.getClassName();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it.className");
                    if (!StringsKt.startsWith$default((String)string, (String)"snownee.jade.addon", (boolean)false, (int)2, null)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
            if (!bl) {
                this.setDisplayTool(tool);
            }
        }
        return Math.max(1.0f, tool.m_41691_(block));
    }

    private final ItemStack getMostPreferredTool(BlockState block) {
        ItemStack result;
        ItemStack itemStack;
        Object v0;
        if (this.getActualMainHandItem().m_41720_() instanceof TieredItem || this.findFittingToolBeltIndex(this.getActualMainHandItem()) != -1) {
            return this.getActualMainHandItem();
        }
        Iterable $this$maxByOrNull$iv = this.toolBelt;
        boolean $i$f$maxByOrNull = false;
        Iterator iterator$iv = $this$maxByOrNull$iv.iterator();
        if (!iterator$iv.hasNext()) {
            v0 = null;
        } else {
            Object maxElem$iv = iterator$iv.next();
            if (!iterator$iv.hasNext()) {
                v0 = maxElem$iv;
            } else {
                ItemStack it = (ItemStack)maxElem$iv;
                boolean bl = false;
                float maxValue$iv = it.m_41691_(block);
                do {
                    Object e$iv = iterator$iv.next();
                    ItemStack it2 = (ItemStack)e$iv;
                    $i$a$-maxByOrNull-PlayerInventoryExtraStuff$getMostPreferredTool$result$1 = false;
                    float v$iv = it2.m_41691_(block);
                    if (Float.compare(maxValue$iv, v$iv) >= 0) continue;
                    maxElem$iv = e$iv;
                    maxValue$iv = v$iv;
                } while (iterator$iv.hasNext());
                v0 = maxElem$iv;
            }
        }
        if ((itemStack = (ItemStack)v0) == null) {
            itemStack = ItemStack.f_41583_;
        }
        if ((result = itemStack).m_41691_(block) > 1.0f) {
            Intrinsics.checkNotNullExpressionValue((Object)result, (String)"result");
            return result;
        }
        boolean isGlass = block.m_60734_() instanceof AbstractGlassBlock;
        if (isGlass) {
            ItemStack itemStack2;
            Object v3;
            block11: {
                Iterable $this$firstOrNull$iv = this.toolBelt;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    ItemStack it = (ItemStack)element$iv;
                    boolean bl = false;
                    Enchantment enchantment = Enchantments.f_44985_;
                    Intrinsics.checkNotNullExpressionValue((Object)enchantment, (String)"SILK_TOUCH");
                    Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                    if (!(RandomStuff.getLevelOn(enchantment, it) > 0)) continue;
                    v3 = element$iv;
                    break block11;
                }
                v3 = null;
            }
            if ((itemStack2 = (ItemStack)v3) == null) {
                ItemStack itemStack3 = ItemStack.f_41583_;
                itemStack2 = itemStack3;
                Intrinsics.checkNotNullExpressionValue((Object)itemStack3, (String)"EMPTY");
            }
            return itemStack2;
        }
        ItemStack itemStack4 = ItemStack.f_41583_;
        Intrinsics.checkNotNullExpressionValue((Object)itemStack4, (String)"EMPTY");
        return itemStack4;
    }

    private final boolean playerAttackConditions() {
        boolean bl;
        block2: {
            if (this.getActualMainHandItem().m_41720_() instanceof TieredItem || this.findFittingToolBeltIndex(this.getActualMainHandItem()) != -1) {
                return false;
            }
            StackTraceElement[] stackTraceElementArray = Thread.currentThread().getStackTrace();
            Intrinsics.checkNotNullExpressionValue((Object)stackTraceElementArray, (String)"currentThread().stackTrace");
            Object[] $this$any$iv = stackTraceElementArray;
            boolean $i$f$any = false;
            for (Object element$iv : $this$any$iv) {
                StackTraceElement it = (StackTraceElement)element$iv;
                boolean bl2 = false;
                String string = it.getClassName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it.className");
                if (!StringsKt.startsWith$default((String)string, (String)"org.violetmoon.quark.content.tools.entity.rang", (boolean)false, (int)2, null)) continue;
                bl = true;
                break block2;
            }
            bl = false;
        }
        return !bl;
    }

    public final void prePlayerAttack() {
        if (!this.playerAttackConditions()) {
            return;
        }
        this.getPlayer().f_20911_ = true;
        ItemStack swordStack = this.findFittingToolBeltStack(new ItemStack((ItemLike)Items.f_42388_));
        this.setDisplayTool(!swordStack.m_41619_() ? swordStack : this.findFittingToolBeltStack(new ItemStack((ItemLike)Items.f_42391_)));
        this.getPlayer().m_21204_().m_22178_(this.getDisplayTool().m_41638_(EquipmentSlot.MAINHAND));
    }

    public final void postPlayerAttack() {
        if (!this.playerAttackConditions()) {
            return;
        }
        this.getPlayer().m_21204_().m_22161_(this.getDisplayTool().m_41638_(EquipmentSlot.MAINHAND));
    }

    public final void fireRocketFromInventory() {
        if (!this.getPlayer().m_21255_()) {
            return;
        }
        for (ItemStack itemStack : this.getPlayer().m_150109_().f_35974_) {
            Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"itemStack");
            if (!this.tryFireRocket(itemStack)) continue;
            return;
        }
        for (ItemStack itemStack : this.stacks) {
            Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"itemStack");
            if (!this.tryFireRocket(itemStack)) continue;
            return;
        }
    }

    private final boolean tryFireRocket(ItemStack itemStack) {
        if (itemStack.m_41720_() instanceof FireworkRocketItem) {
            CompoundTag compoundTag = itemStack.m_41737_("Fireworks");
            if (!(compoundTag != null && (compoundTag = compoundTag.m_128437_("Explosions", 10)) != null ? !compoundTag.isEmpty() : false)) {
                ItemStack copyStack = itemStack.m_41777_();
                if (!this.getPlayer().m_150110_().f_35937_) {
                    itemStack.m_41774_(1);
                }
                if (this.getPlayer().m_9236_().f_46443_) {
                    this.setDisplayTool(itemStack);
                    InventorioNetworking.Companion.getInstance().c2sUseBoostRocket();
                    Minecraft minecraft = Minecraft.m_91087_();
                    Intrinsics.checkNotNull((Object)minecraft, (String)"null cannot be cast to non-null type de.rubixdev.inventorio.mixin.client.accessor.MinecraftClientAccessor");
                    ((MinecraftClientAccessor)minecraft).setItemUseCooldown(4);
                } else {
                    this.getPlayer().m_9236_().m_7967_((Entity)new FireworkRocketEntity(this.getPlayer().m_9236_(), copyStack, (LivingEntity)this.getPlayer()));
                }
                return true;
            }
        }
        return false;
    }
}

