/*
 * Decompiled with CFR 0.152.
 */
package de.rubixdev.inventorio.player;

import de.rubixdev.inventorio.player.PlayerInventoryAddon;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001d\u0010\t\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\t\u0010\nJ-\u0010\u0010\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u00042\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\u000f\u001a\u00020\u000eH\u0002\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u001d\u0010\u0012\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0012\u0010\nJ\u001d\u0010\u0015\u001a\u00020\u000e2\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\f0\u0013H\u0002\u00a2\u0006\u0004\b\u0015\u0010\u0016\u00a8\u0006\u0017"}, d2={"Lde/rubixdev/inventorio/player/PlayerAddonSerializer;", "", "<init>", "()V", "Lde/rubixdev/inventorio/player/PlayerInventoryAddon;", "inventoryAddon", "Lnet/minecraft/nbt/CompoundTag;", "inventorioTag", "", "deserialize", "(Lde/rubixdev/inventorio/player/PlayerInventoryAddon;Lnet/minecraft/nbt/CompoundTag;)V", "", "Lnet/minecraft/world/item/ItemStack;", "inventorySection", "Lnet/minecraft/nbt/ListTag;", "sectionTag", "deserializeSection", "(Lde/rubixdev/inventorio/player/PlayerInventoryAddon;Ljava/util/List;Lnet/minecraft/nbt/ListTag;)V", "serialize", "", "section", "serializeSection", "(Ljava/util/List;)Lnet/minecraft/nbt/ListTag;", "inventorio-mc1.20.1-forge"})
public final class PlayerAddonSerializer {
    @NotNull
    public static final PlayerAddonSerializer INSTANCE = new PlayerAddonSerializer();

    private PlayerAddonSerializer() {
    }

    public final void serialize(@NotNull PlayerInventoryAddon inventoryAddon, @NotNull CompoundTag inventorioTag) {
        Intrinsics.checkNotNullParameter((Object)((Object)inventoryAddon), (String)"inventoryAddon");
        Intrinsics.checkNotNullParameter((Object)inventorioTag, (String)"inventorioTag");
        inventorioTag.m_128405_("SelectedUtilitySlot", inventoryAddon.getSelectedUtility());
        inventorioTag.m_128365_("DeepPockets", (Tag)this.serializeSection(inventoryAddon.deepPockets));
        inventorioTag.m_128365_("UtilityBelt", (Tag)this.serializeSection(inventoryAddon.utilityBelt));
        inventorioTag.m_128365_("ToolBelt", (Tag)this.serializeSection(inventoryAddon.toolBelt));
    }

    private final ListTag serializeSection(List<ItemStack> section) {
        ListTag resultTag = new ListTag();
        Iterator<ItemStack> iterator = section.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            int slotIndex = n++;
            ItemStack itemStack = iterator.next();
            if (itemStack.m_41619_()) continue;
            CompoundTag itemTag = new CompoundTag();
            itemTag.m_128405_("Slot", slotIndex);
            itemStack.m_41739_(itemTag);
            resultTag.add((Object)itemTag);
        }
        return resultTag;
    }

    public final void deserialize(@NotNull PlayerInventoryAddon inventoryAddon, @NotNull CompoundTag inventorioTag) {
        Intrinsics.checkNotNullParameter((Object)((Object)inventoryAddon), (String)"inventoryAddon");
        Intrinsics.checkNotNullParameter((Object)inventorioTag, (String)"inventorioTag");
        inventoryAddon.setSelectedUtility(inventorioTag.m_128451_("SelectedUtilitySlot"));
        List list = inventoryAddon.utilityBelt;
        ListTag listTag = inventorioTag.m_128437_("UtilityBelt", 10);
        Intrinsics.checkNotNullExpressionValue((Object)listTag, (String)"inventorioTag.getList(\"UtilityBelt\", 10)");
        this.deserializeSection(inventoryAddon, list, listTag);
        List list2 = inventoryAddon.toolBelt;
        ListTag listTag2 = inventorioTag.m_128437_("ToolBelt", 10);
        Intrinsics.checkNotNullExpressionValue((Object)listTag2, (String)"inventorioTag.getList(\"ToolBelt\", 10)");
        this.deserializeSection(inventoryAddon, list2, listTag2);
        List list3 = inventoryAddon.deepPockets;
        ListTag listTag3 = inventorioTag.m_128437_("DeepPockets", 10);
        Intrinsics.checkNotNullExpressionValue((Object)listTag3, (String)"inventorioTag.getList(\"DeepPockets\", 10)");
        this.deserializeSection(inventoryAddon, list3, listTag3);
    }

    private final void deserializeSection(PlayerInventoryAddon inventoryAddon, List<ItemStack> inventorySection, ListTag sectionTag) {
        int n = inventorySection.size();
        for (int i = 0; i < n; ++i) {
            ItemStack itemStack = ItemStack.f_41583_;
            Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"EMPTY");
            inventorySection.set(i, itemStack);
        }
        for (Tag itemTag : sectionTag) {
            Intrinsics.checkNotNull((Object)itemTag, (String)"null cannot be cast to non-null type net.minecraft.nbt.NbtCompound");
            CompoundTag compoundTag = (CompoundTag)itemTag;
            ItemStack itemStack = ItemStack.m_41712_((CompoundTag)compoundTag);
            int slotIndex = compoundTag.m_128451_("Slot");
            boolean bl = 0 <= slotIndex ? slotIndex < inventorySection.size() : false;
            if (bl) {
                Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"itemStack");
                inventorySection.set(slotIndex, itemStack);
                continue;
            }
            inventoryAddon.getPlayer().m_36176_(itemStack, false);
        }
    }
}

