/*
 * Decompiled with CFR 0.152.
 */
package de.rubixdev.inventorio.player;

import de.rubixdev.inventorio.ScreenTypeProvider;
import de.rubixdev.inventorio.api.ToolBeltSlotTemplate;
import de.rubixdev.inventorio.client.ui.InventorioScreen;
import de.rubixdev.inventorio.config.GlobalSettings;
import de.rubixdev.inventorio.mixin.accessor.CraftingScreenHandlerAccessor;
import de.rubixdev.inventorio.mixin.accessor.SlotAccessor;
import de.rubixdev.inventorio.packet.InventorioNetworking;
import de.rubixdev.inventorio.player.PlayerInventoryAddon;
import de.rubixdev.inventorio.slot.ArmorSlot;
import de.rubixdev.inventorio.slot.BlockedSlot;
import de.rubixdev.inventorio.slot.DeepPocketsSlot;
import de.rubixdev.inventorio.slot.ToolBeltSlot;
import de.rubixdev.inventorio.util.GeneralConstants;
import de.rubixdev.inventorio.util.IntProgressionIndices;
import de.rubixdev.inventorio.util.IntProgressionIterator;
import de.rubixdev.inventorio.util.RandomStuff;
import de.rubixdev.inventorio.util.RangeIteratorKt;
import de.rubixdev.inventorio.util.UIConstants;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Consumer;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntProgression;
import kotlin.ranges.IntRange;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.player.StackedContents;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.inventory.RecipeBookMenu;
import net.minecraft.world.inventory.RecipeBookType;
import net.minecraft.world.inventory.ResultContainer;
import net.minecraft.world.inventory.ResultSlot;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.inventory.TransientCraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0080\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0013\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0016\u0018\u0000 W2\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0001:\u0001WB\u0017\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0017\u0010\u000b\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\u0003H\u0016\u00a2\u0006\u0004\b\u000b\u0010\fJ\u001f\u0010\u000b\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u000fH\u0016\u00a2\u0006\u0004\b\u000b\u0010\u0011J\u0017\u0010\u0014\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\u0012H\u0016\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u000f\u0010\u0017\u001a\u00020\u0016H\u0016\u00a2\u0006\u0004\b\u0017\u0010\u0018J\r\u0010\u001a\u001a\u00020\u0019\u00a2\u0006\u0004\b\u001a\u0010\u001bJ\u000f\u0010\u001c\u001a\u00020\u0019H\u0002\u00a2\u0006\u0004\b\u001c\u0010\u001bJ\u000f\u0010\u001e\u001a\u00020\u001dH\u0016\u00a2\u0006\u0004\b\u001e\u0010\u001fJ\u000f\u0010 \u001a\u00020\u0003H\u0016\u00a2\u0006\u0004\b \u0010!J\u000f\u0010\"\u001a\u00020\u0003H\u0016\u00a2\u0006\u0004\b\"\u0010!J\u000f\u0010#\u001a\u00020\u0003H\u0016\u00a2\u0006\u0004\b#\u0010!J\u000f\u0010$\u001a\u00020\u0003H\u0016\u00a2\u0006\u0004\b$\u0010!J\r\u0010%\u001a\u00020\u0003\u00a2\u0006\u0004\b%\u0010!J\u000f\u0010&\u001a\u00020\u0019H\u0002\u00a2\u0006\u0004\b&\u0010\u001bJ\u000f\u0010'\u001a\u00020\u0019H\u0002\u00a2\u0006\u0004\b'\u0010\u001bJ!\u0010*\u001a\u00020\n2\u0010\u0010)\u001a\f\u0012\b\b\u0000\u0012\u0004\u0018\u00010\u00020(H\u0016\u00a2\u0006\u0004\b*\u0010+J\u0017\u0010,\u001a\u00020\u00162\u0006\u0010\u0013\u001a\u00020\u0012H\u0016\u00a2\u0006\u0004\b,\u0010-J\u0017\u0010/\u001a\u00020\u00162\u0006\u0010\u0006\u001a\u00020.H\u0016\u00a2\u0006\u0004\b/\u00100J/\u00106\u001a\u00020\u00162\u0006\u00101\u001a\u00020\u00032\u0006\u00102\u001a\u00020\u00032\u0006\u00104\u001a\u0002032\u0006\u00105\u001a\u00020\u0012H\u0016\u00a2\u0006\u0004\b6\u00107J\u0017\u0010:\u001a\u00020\u00162\u0006\u00109\u001a\u000208H\u0016\u00a2\u0006\u0004\b:\u0010;J\u001f\u0010=\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\u00122\u0006\u0010<\u001a\u00020\u0003H\u0016\u00a2\u0006\u0004\b=\u0010>J\u001f\u0010@\u001a\u00020\r2\u0006\u0010<\u001a\u00020\u00032\u0006\u0010?\u001a\u00020\rH\u0002\u00a2\u0006\u0004\b@\u0010AJ\u000f\u0010B\u001a\u00020\u0016H\u0003\u00a2\u0006\u0004\bB\u0010\u0018J)\u0010D\u001a\u00020\u00162\u0006\u0010\u0010\u001a\u00020\u00032\u0006\u0010C\u001a\u00020\u00032\b\u0010\u000e\u001a\u0004\u0018\u00010\rH\u0016\u00a2\u0006\u0004\bD\u0010EJ\u0017\u0010G\u001a\u00020\n2\b\u0010F\u001a\u0004\u0018\u00010\u000f\u00a2\u0006\u0004\bG\u0010HJ\r\u0010I\u001a\u00020\u0016\u00a2\u0006\u0004\bI\u0010\u0018R\u0014\u0010J\u001a\u00020\u00028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\bJ\u0010KR\u0014\u0010M\u001a\u00020L8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\bM\u0010NR\u0017\u0010\u0006\u001a\u00020\u00058\u0006\u00a2\u0006\f\n\u0004\b\u0006\u0010O\u001a\u0004\bP\u0010QR\u0017\u0010S\u001a\u00020R8\u0006\u00a2\u0006\f\n\u0004\bS\u0010T\u001a\u0004\bU\u0010V\u00a8\u0006X"}, d2={"Lde/rubixdev/inventorio/player/InventorioScreenHandler;", "Lnet/minecraft/world/inventory/RecipeBookMenu;", "Lnet/minecraft/world/inventory/TransientCraftingContainer;", "", "syncId", "Lnet/minecraft/world/entity/player/Inventory;", "inventory", "<init>", "(ILnet/minecraft/world/entity/player/Inventory;)V", "index", "", "canInsertIntoSlot", "(I)Z", "Lnet/minecraft/world/item/ItemStack;", "stack", "Lnet/minecraft/world/inventory/Slot;", "slot", "(Lnet/minecraft/world/item/ItemStack;Lnet/minecraft/world/inventory/Slot;)Z", "Lnet/minecraft/world/entity/player/Player;", "player", "canUse", "(Lnet/minecraft/world/entity/player/Player;)Z", "", "clearCraftingSlots", "()V", "Lkotlin/ranges/IntRange;", "getAvailableDeepPocketsRange", "()Lkotlin/ranges/IntRange;", "getAvailableUtilityBeltRange", "Lnet/minecraft/world/inventory/RecipeBookType;", "getCategory", "()Lnet/minecraft/world/inventory/RecipeBookType;", "getCraftingHeight", "()I", "getCraftingResultSlotIndex", "getCraftingSlotCount", "getCraftingWidth", "getToolBeltSlotCount", "getUnavailableDeepPocketsRange", "getUnavailableUtilityBeltRange", "Lnet/minecraft/world/item/crafting/Recipe;", "recipe", "matches", "(Lnet/minecraft/world/item/crafting/Recipe;)Z", "onClosed", "(Lnet/minecraft/world/entity/player/Player;)V", "Lnet/minecraft/world/Container;", "onContentChanged", "(Lnet/minecraft/world/Container;)V", "slotIndex", "clickData", "Lnet/minecraft/world/inventory/ClickType;", "actionType", "playerEntity", "onSlotClick", "(IILnet/minecraft/world/inventory/ClickType;Lnet/minecraft/world/entity/player/Player;)V", "Lnet/minecraft/world/entity/player/StackedContents;", "finder", "populateRecipeFinder", "(Lnet/minecraft/world/entity/player/StackedContents;)V", "sourceIndex", "quickMove", "(Lnet/minecraft/world/entity/player/Player;I)Lnet/minecraft/world/item/ItemStack;", "stackDynamic", "quickMoveInner", "(ILnet/minecraft/world/item/ItemStack;)Lnet/minecraft/world/item/ItemStack;", "refreshSlotPositions", "revision", "setStackInSlot", "(IILnet/minecraft/world/item/ItemStack;)V", "sourceSlot", "tryTransferToUtilityBeltSlot", "(Lnet/minecraft/world/inventory/Slot;)Z", "updateDeepPocketsCapacity", "craftingInput", "Lnet/minecraft/world/inventory/TransientCraftingContainer;", "Lnet/minecraft/world/inventory/ResultContainer;", "craftingResult", "Lnet/minecraft/world/inventory/ResultContainer;", "Lnet/minecraft/world/entity/player/Inventory;", "getInventory", "()Lnet/minecraft/world/entity/player/Inventory;", "Lde/rubixdev/inventorio/player/PlayerInventoryAddon;", "inventoryAddon", "Lde/rubixdev/inventorio/player/PlayerInventoryAddon;", "getInventoryAddon", "()Lde/rubixdev/inventorio/player/PlayerInventoryAddon;", "Companion", "inventorio-mc1.20.1-forge"})
@SourceDebugExtension(value={"SMAP\nInventorioScreenHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 InventorioScreenHandler.kt\nde/rubixdev/inventorio/player/InventorioScreenHandler\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,444:1\n215#2,2:445\n*S KotlinDebug\n*F\n+ 1 InventorioScreenHandler.kt\nde/rubixdev/inventorio/player/InventorioScreenHandler\n*L\n120#1:445,2\n*E\n"})
public class InventorioScreenHandler
extends RecipeBookMenu<TransientCraftingContainer> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Inventory inventory;
    @NotNull
    private final PlayerInventoryAddon inventoryAddon;
    @NotNull
    private final TransientCraftingContainer craftingInput;
    @NotNull
    private final ResultContainer craftingResult;
    @JvmField
    @NotNull
    public static final IntRange craftingGridRange = RangeIteratorKt.expandBy(0, 5);
    @JvmField
    @NotNull
    public static final IntRange armorSlotsRange = RangeIteratorKt.expandBy(craftingGridRange.getLast() + 1, 4);
    @JvmField
    @NotNull
    public static final IntRange mainInventoryRange = RangeIteratorKt.expandBy(armorSlotsRange.getLast() + 1, 36);
    @JvmField
    @NotNull
    public static final IntRange deepPocketsRange = RangeIteratorKt.expandBy(mainInventoryRange.getLast() + 1, 27);
    @JvmField
    @NotNull
    public static final IntRange utilityBeltRange = RangeIteratorKt.expandBy(deepPocketsRange.getLast() + 1, 8);
    @JvmField
    @NotNull
    public static final IntRange toolBeltRange = RangeIteratorKt.expandBy(utilityBeltRange.getLast() + 1, PlayerInventoryAddon.Companion.getToolBeltTemplates$inventorio_mc1_20_1_forge().size());
    @JvmField
    @NotNull
    public static final IntRange mainInventoryWithoutHotbarRange = new IntRange(mainInventoryRange.getFirst(), mainInventoryRange.getLast() - 9);
    @JvmField
    @NotNull
    public static final IntRange hotbarRange = new IntRange(mainInventoryWithoutHotbarRange.getLast() + 1, mainInventoryRange.getLast());
    @NotNull
    private static final Map<ResourceLocation, Consumer<InventorioScreenHandler>> openConsumers = new LinkedHashMap();
    @NotNull
    private static final EquipmentSlot[] armorSlots;

    public InventorioScreenHandler(int syncId, @NotNull Inventory inventory) {
        int relativeIndex;
        int absoluteIndex;
        Object object;
        int relativeIndex2;
        Intrinsics.checkNotNullParameter((Object)inventory, (String)"inventory");
        super(ScreenTypeProvider.Companion.getINSTANCE().getScreenHandlerType(), syncId);
        this.inventory = inventory;
        Player player = this.inventory.f_35978_;
        Intrinsics.checkNotNullExpressionValue((Object)player, (String)"inventory.player");
        PlayerInventoryAddon playerInventoryAddon = PlayerInventoryAddon.Companion.getInventoryAddon(player);
        Intrinsics.checkNotNull((Object)((Object)playerInventoryAddon));
        this.inventoryAddon = playerInventoryAddon;
        this.craftingInput = new TransientCraftingContainer((AbstractContainerMenu)this, 2, 2);
        this.craftingResult = new ResultContainer();
        if (GlobalSettings.allow2x2CraftingGrid.getBoolValue()) {
            this.m_38897_((Slot)new ResultSlot(this.inventory.f_35978_, (CraftingContainer)this.craftingInput, (Container)this.craftingResult, 0, 174, 28));
            for (i = 0; i < 4; ++i) {
                this.m_38897_(new Slot((Container)this.craftingInput, i, 118 + i % 2 * 18, 18 + i / 2 * 18));
            }
        } else {
            this.m_38897_(new BlockedSlot((Container)this.inventory, 0, 174, 28));
            for (i = 0; i < 4; ++i) {
                this.m_38897_(new BlockedSlot((Container)this.craftingInput, i, 118 + i % 2 * 18, 18 + i / 2 * 18));
            }
        }
        IntProgressionIterator i = RangeIteratorKt.withRelativeIndex((IntProgression)armorSlotsRange);
        while (i.hasNext()) {
            relativeIndex2 = i.next().component2();
            this.m_38897_(new ArmorSlot((Container)this.inventory, 39 - relativeIndex2, 8, 8 + relativeIndex2 * 18, armorSlots[relativeIndex2]));
        }
        i = RangeIteratorKt.withRelativeIndex((IntProgression)mainInventoryWithoutHotbarRange);
        while (i.hasNext()) {
            relativeIndex2 = i.next().component2();
            this.m_38897_(new Slot((Container)this.inventory, relativeIndex2 + 9, 8 + relativeIndex2 % 9 * 18, 84 + relativeIndex2 / 9 * 18));
        }
        i = RangeIteratorKt.withRelativeIndex((IntProgression)hotbarRange);
        while (i.hasNext()) {
            relativeIndex2 = i.next().component2();
            this.m_38897_(new Slot((Container)this.inventory, relativeIndex2, 8 + relativeIndex2 * 18, 142));
        }
        i = RangeIteratorKt.withRelativeIndex((IntProgression)GeneralConstants.INVENTORY_ADDON_DEEP_POCKETS_RANGE);
        while (i.hasNext()) {
            object = i.next();
            absoluteIndex = ((IntProgressionIndices)object).component1();
            relativeIndex = ((IntProgressionIndices)object).component2();
            this.m_38897_(new DeepPocketsSlot((Container)this.inventoryAddon, absoluteIndex, UIConstants.SLOT_INVENTORY_DEEP_POCKETS.x + relativeIndex % 9 * 18, UIConstants.SLOT_INVENTORY_DEEP_POCKETS.y + relativeIndex / 9 * 18));
        }
        i = RangeIteratorKt.withRelativeIndex((IntProgression)GeneralConstants.INVENTORY_ADDON_UTILITY_BELT_RANGE);
        while (i.hasNext()) {
            object = i.next();
            absoluteIndex = ((IntProgressionIndices)object).component1();
            relativeIndex = ((IntProgressionIndices)object).component2();
            this.m_38897_(new DeepPocketsSlot((Container)this.inventoryAddon, absoluteIndex, UIConstants.SLOT_UTILITY_BELT_COLUMN_1.x + 18 * (relativeIndex / 4), UIConstants.SLOT_UTILITY_BELT_COLUMN_1.y + 18 * (relativeIndex % 4)));
        }
        int deepPocketsRowCount = this.inventoryAddon.getDeepPocketsRowCount();
        object = PlayerInventoryAddon.Companion.getToolBeltTemplates$inventorio_mc1_20_1_forge().iterator();
        absoluteIndex = 0;
        while (object.hasNext()) {
            relativeIndex = absoluteIndex++;
            ToolBeltSlotTemplate toolBeltTemplate = (ToolBeltSlotTemplate)object.next();
            this.m_38897_(new ToolBeltSlot(toolBeltTemplate, this.inventoryAddon, relativeIndex + GeneralConstants.INVENTORY_ADDON_TOOL_BELT_INDEX_OFFSET, ToolBeltSlot.Companion.getSlotPosition((int)deepPocketsRowCount, (int)relativeIndex, (int)this.getToolBeltSlotCount()).x, ToolBeltSlot.Companion.getSlotPosition((int)deepPocketsRowCount, (int)relativeIndex, (int)this.getToolBeltSlotCount()).y));
        }
        this.updateDeepPocketsCapacity();
        Map<ResourceLocation, Consumer<InventorioScreenHandler>> $this$forEach$iv = openConsumers;
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<ResourceLocation, Consumer<InventorioScreenHandler>>> iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<ResourceLocation, Consumer<InventorioScreenHandler>> element$iv;
            Map.Entry<ResourceLocation, Consumer<InventorioScreenHandler>> it = element$iv = iterator.next();
            boolean bl = false;
            try {
                it.getValue().accept(this);
            }
            catch (Throwable e) {
                RandomStuff.getLogger().error("Inventory Screen Handler Open Consumer '" + it.getKey() + "' has failed: ", e);
            }
        }
    }

    @NotNull
    public final Inventory getInventory() {
        return this.inventory;
    }

    @NotNull
    public final PlayerInventoryAddon getInventoryAddon() {
        return this.inventoryAddon;
    }

    @NotNull
    public ItemStack m_7648_(@NotNull Player player, int sourceIndex) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Object object = this.f_38839_.get(sourceIndex);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"slots[sourceIndex]");
        Slot sourceSlot = (Slot)object;
        ItemStack stackDynamic = sourceSlot.m_7993_();
        Intrinsics.checkNotNullExpressionValue((Object)stackDynamic, (String)"stackDynamic");
        ItemStack stackStatic = this.quickMoveInner(sourceIndex, stackDynamic);
        if (RandomStuff.isNotEmpty(stackStatic)) {
            if (stackDynamic.m_41619_()) {
                sourceSlot.m_269060_(ItemStack.f_41583_);
            } else {
                sourceSlot.m_6654_();
            }
            if (stackDynamic.m_41613_() == stackStatic.m_41613_()) {
                ItemStack itemStack = ItemStack.f_41583_;
                Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"EMPTY");
                return itemStack;
            }
            sourceSlot.m_142406_(player, stackDynamic);
        }
        return stackStatic;
    }

    private final ItemStack quickMoveInner(int sourceIndex, ItemStack stackDynamic) {
        IntRange availableDeepPocketsRange;
        ItemStack stackStatic;
        block18: {
            block17: {
                stackStatic = stackDynamic.m_41777_();
                availableDeepPocketsRange = this.getAvailableDeepPocketsRange();
                IntRange intRange = mainInventoryRange;
                int n = intRange.getFirst();
                if (sourceIndex <= intRange.getLast() ? n <= sourceIndex : false) break block17;
                int n2 = availableDeepPocketsRange.getFirst();
                boolean bl = sourceIndex <= availableDeepPocketsRange.getLast() ? n2 <= sourceIndex : false;
                if (!bl) break block18;
            }
            if (Mob.m_147233_((ItemStack)stackStatic).m_20743_() == EquipmentSlot.Type.ARMOR && RandomStuff.insertItem$default((AbstractContainerMenu)this, stackDynamic, armorSlotsRange, false, 4, null)) {
                this.updateDeepPocketsCapacity();
                Intrinsics.checkNotNullExpressionValue((Object)stackStatic, (String)"stackStatic");
                return stackStatic;
            }
            if (RandomStuff.insertItem$default((AbstractContainerMenu)this, stackDynamic, toolBeltRange, false, 4, null)) {
                Intrinsics.checkNotNullExpressionValue((Object)stackStatic, (String)"stackStatic");
                return stackStatic;
            }
        }
        int n = sourceIndex;
        IntRange intRange = hotbarRange;
        int n3 = intRange.getFirst();
        boolean bl = n <= intRange.getLast() ? n3 <= n : false;
        if (bl) {
            if (RandomStuff.insertItem$default((AbstractContainerMenu)this, stackDynamic, mainInventoryWithoutHotbarRange, false, 4, null) || !availableDeepPocketsRange.isEmpty() && RandomStuff.insertItem$default((AbstractContainerMenu)this, stackDynamic, availableDeepPocketsRange, false, 4, null)) {
                Intrinsics.checkNotNullExpressionValue((Object)stackStatic, (String)"stackStatic");
                return stackStatic;
            }
        } else {
            intRange = mainInventoryWithoutHotbarRange;
            n3 = intRange.getFirst();
            boolean bl2 = n <= intRange.getLast() ? n3 <= n : false;
            if (bl2) {
                if (!availableDeepPocketsRange.isEmpty() && RandomStuff.insertItem$default((AbstractContainerMenu)this, stackDynamic, availableDeepPocketsRange, false, 4, null) || RandomStuff.insertItem$default((AbstractContainerMenu)this, stackDynamic, hotbarRange, false, 4, null)) {
                    Intrinsics.checkNotNullExpressionValue((Object)stackStatic, (String)"stackStatic");
                    return stackStatic;
                }
            } else {
                int n4 = availableDeepPocketsRange.getFirst();
                boolean bl3 = n <= availableDeepPocketsRange.getLast() ? n4 <= n : false;
                if (bl3) {
                    if (RandomStuff.insertItem$default((AbstractContainerMenu)this, stackDynamic, mainInventoryRange, false, 4, null)) {
                        Intrinsics.checkNotNullExpressionValue((Object)stackStatic, (String)"stackStatic");
                        return stackStatic;
                    }
                } else if (RandomStuff.insertItem$default((AbstractContainerMenu)this, stackDynamic, mainInventoryRange, false, 4, null) || !availableDeepPocketsRange.isEmpty() && RandomStuff.insertItem$default((AbstractContainerMenu)this, stackDynamic, availableDeepPocketsRange, false, 4, null)) {
                    IntRange intRange2 = craftingGridRange;
                    n3 = intRange2.getFirst();
                    boolean bl4 = sourceIndex <= intRange2.getLast() ? n3 <= sourceIndex : false;
                    if (bl4) {
                        this.m_6199_((Container)this.craftingInput);
                        this.m_6199_((Container)this.craftingResult);
                    }
                    Intrinsics.checkNotNullExpressionValue((Object)stackStatic, (String)"stackStatic");
                    return stackStatic;
                }
            }
        }
        ItemStack itemStack = ItemStack.f_41583_;
        Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"EMPTY");
        return itemStack;
    }

    public void m_150399_(int slotIndex, int clickData, @NotNull ClickType actionType, @NotNull Player playerEntity) {
        Intrinsics.checkNotNullParameter((Object)actionType, (String)"actionType");
        Intrinsics.checkNotNullParameter((Object)playerEntity, (String)"playerEntity");
        super.m_150399_(slotIndex, clickData, actionType, playerEntity);
        IntRange intRange = armorSlotsRange;
        int n = intRange.getFirst();
        boolean bl = slotIndex <= intRange.getLast() ? n <= slotIndex : false;
        if (bl) {
            this.updateDeepPocketsCapacity();
        } else {
            intRange = utilityBeltRange;
            n = intRange.getFirst();
            boolean bl2 = slotIndex <= intRange.getLast() ? n <= slotIndex : false;
            if (bl2 && this.inventoryAddon.getSelectedUtilityStack().m_41619_()) {
                this.inventoryAddon.setSelectedUtility(slotIndex - utilityBeltRange.getFirst());
            }
        }
    }

    public final boolean tryTransferToUtilityBeltSlot(@Nullable Slot sourceSlot) {
        if (sourceSlot == null) {
            return false;
        }
        ItemStack itemStackDynamic = sourceSlot.m_7993_();
        IntRange beltRange = this.getAvailableUtilityBeltRange();
        int n = beltRange.getFirst();
        int n2 = beltRange.getLast();
        int n3 = sourceSlot.f_40219_;
        if (!(n <= n3 ? n3 <= n2 : false)) {
            if (this.m_38903_(itemStackDynamic, beltRange.getFirst(), beltRange.getLast() + 1, false)) {
                if (this.inventoryAddon.getPlayer().m_9236_().f_46443_) {
                    InventorioNetworking.Companion.getInstance().c2sMoveItemToUtilityBelt(sourceSlot.f_40219_);
                }
                return true;
            }
            return false;
        }
        IntRange deepPocketsRange = this.getAvailableDeepPocketsRange();
        if (this.m_38903_(itemStackDynamic, mainInventoryRange.getFirst(), mainInventoryRange.getLast() + 1, false) || this.m_38903_(itemStackDynamic, deepPocketsRange.getFirst(), deepPocketsRange.getLast() + 1, false)) {
            if (this.inventoryAddon.getPlayer().m_9236_().f_46443_) {
                InventorioNetworking.Companion.getInstance().c2sMoveItemToUtilityBelt(sourceSlot.f_40219_);
            }
            return true;
        }
        return false;
    }

    public final void updateDeepPocketsCapacity() {
        DeepPocketsSlot slot;
        int n;
        Player player = this.inventoryAddon.getPlayer();
        IntRange intRange = this.getAvailableDeepPocketsRange();
        int i = intRange.getFirst();
        if (i <= (n = intRange.getLast())) {
            while (true) {
                Intrinsics.checkNotNull((Object)this.m_38853_(i), (String)"null cannot be cast to non-null type de.rubixdev.inventorio.slot.DeepPocketsSlot");
                ((DeepPocketsSlot)this.m_38853_(i)).canTakeItems = true;
                if (i == n) break;
                ++i;
            }
        }
        if ((i = (intRange = this.getAvailableUtilityBeltRange()).getFirst()) <= (n = intRange.getLast())) {
            while (true) {
                Intrinsics.checkNotNull((Object)this.m_38853_(i), (String)"null cannot be cast to non-null type de.rubixdev.inventorio.slot.DeepPocketsSlot");
                ((DeepPocketsSlot)this.m_38853_(i)).canTakeItems = true;
                if (i == n) break;
                ++i;
            }
        }
        if ((i = (intRange = this.getUnavailableDeepPocketsRange()).getFirst()) <= (n = intRange.getLast())) {
            while (true) {
                Slot slot2 = this.m_38853_(i);
                Intrinsics.checkNotNull((Object)slot2, (String)"null cannot be cast to non-null type de.rubixdev.inventorio.slot.DeepPocketsSlot");
                slot = (DeepPocketsSlot)slot2;
                player.m_7197_(slot.m_7993_(), false, true);
                slot.m_269060_(ItemStack.f_41583_);
                slot.canTakeItems = false;
                if (i == n) break;
                ++i;
            }
        }
        if ((i = (intRange = this.getUnavailableUtilityBeltRange()).getFirst()) <= (n = intRange.getLast())) {
            while (true) {
                Slot slot3 = this.m_38853_(i);
                Intrinsics.checkNotNull((Object)slot3, (String)"null cannot be cast to non-null type de.rubixdev.inventorio.slot.DeepPocketsSlot");
                slot = (DeepPocketsSlot)slot3;
                player.m_7197_(slot.m_7993_(), false, true);
                slot.m_269060_(ItemStack.f_41583_);
                slot.canTakeItems = false;
                if (this.inventoryAddon.getSelectedUtility() >= 4) {
                    PlayerInventoryAddon playerInventoryAddon = this.inventoryAddon;
                    playerInventoryAddon.setSelectedUtility(playerInventoryAddon.getSelectedUtility() - 4);
                }
                if (i == n) break;
                ++i;
            }
        }
        if (this.inventoryAddon.getPlayer().m_9236_().f_46443_) {
            this.refreshSlotPositions();
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private final void refreshSlotPositions() {
        SlotAccessor slot;
        int relativeIndex;
        int absoluteIndex;
        IntProgressionIndices intProgressionIndices;
        Object object = Minecraft.m_91087_().f_91080_;
        InventorioScreen inventorioScreen = object instanceof InventorioScreen ? (InventorioScreen)((Object)object) : null;
        if (inventorioScreen != null) {
            inventorioScreen.onRefresh();
        }
        int deepPocketsRowCount = this.inventoryAddon.getDeepPocketsRowCount();
        object = RangeIteratorKt.withRelativeIndex((IntProgression)mainInventoryWithoutHotbarRange);
        while (((IntProgressionIterator)object).hasNext()) {
            intProgressionIndices = ((IntProgressionIterator)object).next();
            absoluteIndex = intProgressionIndices.component1();
            relativeIndex = intProgressionIndices.component2();
            Slot slot2 = this.m_38853_(absoluteIndex);
            Intrinsics.checkNotNull((Object)slot2, (String)"null cannot be cast to non-null type de.rubixdev.inventorio.mixin.accessor.SlotAccessor");
            slot = (SlotAccessor)slot2;
            slot.setX(UIConstants.SLOTS_INVENTORY_MAIN((int)deepPocketsRowCount).x + 18 * (relativeIndex % 9));
            slot.setY(UIConstants.SLOTS_INVENTORY_MAIN((int)deepPocketsRowCount).y + 18 * (relativeIndex / 9));
        }
        object = RangeIteratorKt.withRelativeIndex((IntProgression)hotbarRange);
        while (((IntProgressionIterator)object).hasNext()) {
            intProgressionIndices = ((IntProgressionIterator)object).next();
            absoluteIndex = intProgressionIndices.component1();
            relativeIndex = intProgressionIndices.component2();
            Slot slot3 = this.m_38853_(absoluteIndex);
            Intrinsics.checkNotNull((Object)slot3, (String)"null cannot be cast to non-null type de.rubixdev.inventorio.mixin.accessor.SlotAccessor");
            slot = (SlotAccessor)slot3;
            slot.setX(UIConstants.SLOTS_INVENTORY_HOTBAR((int)deepPocketsRowCount).x + 18 * relativeIndex);
            slot.setY(UIConstants.SLOTS_INVENTORY_HOTBAR((int)deepPocketsRowCount).y);
        }
        object = RangeIteratorKt.withRelativeIndex((IntProgression)toolBeltRange);
        while (((IntProgressionIterator)object).hasNext()) {
            intProgressionIndices = ((IntProgressionIterator)object).next();
            absoluteIndex = intProgressionIndices.component1();
            relativeIndex = intProgressionIndices.component2();
            Slot slot4 = this.m_38853_(absoluteIndex);
            Intrinsics.checkNotNull((Object)slot4, (String)"null cannot be cast to non-null type de.rubixdev.inventorio.mixin.accessor.SlotAccessor");
            slot = (SlotAccessor)slot4;
            slot.setX(ToolBeltSlot.Companion.getSlotPosition((int)deepPocketsRowCount, (int)relativeIndex, (int)this.getToolBeltSlotCount()).x);
            slot.setY(ToolBeltSlot.Companion.getSlotPosition((int)deepPocketsRowCount, (int)relativeIndex, (int)this.getToolBeltSlotCount()).y);
        }
    }

    private final IntRange getAvailableUtilityBeltRange() {
        return RangeIteratorKt.expandBy(utilityBeltRange.getFirst(), this.inventoryAddon.getAvailableUtilityBeltSize());
    }

    private final IntRange getUnavailableUtilityBeltRange() {
        return new IntRange(this.getAvailableUtilityBeltRange().getLast() + 1, utilityBeltRange.getLast());
    }

    @NotNull
    public final IntRange getAvailableDeepPocketsRange() {
        return RangeIteratorKt.expandBy(deepPocketsRange.getFirst(), this.inventoryAddon.getDeepPocketsRowCount() * 9);
    }

    private final IntRange getUnavailableDeepPocketsRange() {
        return new IntRange(this.getAvailableDeepPocketsRange().getLast() + 1, deepPocketsRange.getLast());
    }

    public final int getToolBeltSlotCount() {
        return PlayerInventoryAddon.Companion.getToolBeltTemplates$inventorio_mc1_20_1_forge().size();
    }

    public boolean m_142157_(int index) {
        return index != this.m_6636_();
    }

    public void m_5816_(@NotNull StackedContents finder) {
        Intrinsics.checkNotNullParameter((Object)finder, (String)"finder");
        this.craftingInput.m_5809_(finder);
    }

    public void m_6650_() {
        this.craftingResult.m_6211_();
        this.craftingInput.m_6211_();
    }

    public boolean m_6032_(@NotNull Recipe<? super TransientCraftingContainer> recipe) {
        Intrinsics.checkNotNullParameter(recipe, (String)"recipe");
        return recipe.m_5818_((Container)this.craftingInput, this.inventory.f_35978_.m_9236_());
    }

    public void m_6199_(@NotNull Container inventory) {
        Intrinsics.checkNotNullParameter((Object)inventory, (String)"inventory");
        CraftingScreenHandlerAccessor.updateTheResult((AbstractContainerMenu)this, this.inventory.f_35978_.m_9236_(), this.inventory.f_35978_, (CraftingContainer)this.craftingInput, this.craftingResult);
    }

    public void m_6877_(@NotNull Player player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        super.m_6877_(player);
        this.craftingResult.m_6211_();
        if (!player.m_9236_().f_46443_) {
            this.m_150411_(player, (Container)this.craftingInput);
        }
    }

    public boolean m_6875_(@NotNull Player player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        return true;
    }

    public boolean m_5882_(@NotNull ItemStack stack, @NotNull Slot slot) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        Intrinsics.checkNotNullParameter((Object)slot, (String)"slot");
        return slot.f_40218_ != this.craftingResult && super.m_5882_(stack, slot);
    }

    public int m_6636_() {
        return 0;
    }

    public int m_6635_() {
        return this.craftingInput.m_39347_();
    }

    public int m_6656_() {
        return this.craftingInput.m_39346_();
    }

    public int m_6653_() {
        return 5;
    }

    @NotNull
    public RecipeBookType m_5867_() {
        return RecipeBookType.CRAFTING;
    }

    public void m_182406_(int slot, int revision, @Nullable ItemStack stack) {
        super.m_182406_(slot, revision, stack);
    }

    @Nullable
    public static final InventorioScreenHandler getInventorioScreenHandler(@NotNull Player $this$getInventorioScreenHandler) {
        return Companion.getInventorioScreenHandler($this$getInventorioScreenHandler);
    }

    @JvmStatic
    public static final void registerOpenConsumer(@NotNull ResourceLocation customIdentifier, @NotNull Consumer<InventorioScreenHandler> screenHandlerConsumer) {
        Companion.registerOpenConsumer(customIdentifier, screenHandlerConsumer);
    }

    @JvmStatic
    public static final void open(@NotNull Player player) {
        Companion.open(player);
    }

    static {
        EquipmentSlot[] equipmentSlotArray = new EquipmentSlot[]{EquipmentSlot.HEAD, EquipmentSlot.CHEST, EquipmentSlot.LEGS, EquipmentSlot.FEET};
        armorSlots = equipmentSlotArray;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010%\n\u0002\b\t\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0017\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0007\u00a2\u0006\u0004\b\u0007\u0010\bJ%\u0010\u000e\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\t2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u0007\u00a2\u0006\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00110\u00108\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0015\u001a\u00020\u00148\u0006X\u0087\u0004\u00a2\u0006\u0006\n\u0004\b\u0015\u0010\u0016R\u0014\u0010\u0017\u001a\u00020\u00148\u0006X\u0087\u0004\u00a2\u0006\u0006\n\u0004\b\u0017\u0010\u0016R\u0014\u0010\u0018\u001a\u00020\u00148\u0006X\u0087\u0004\u00a2\u0006\u0006\n\u0004\b\u0018\u0010\u0016R\u0014\u0010\u0019\u001a\u00020\u00148\u0006X\u0087\u0004\u00a2\u0006\u0006\n\u0004\b\u0019\u0010\u0016R\u0014\u0010\u001a\u001a\u00020\u00148\u0006X\u0087\u0004\u00a2\u0006\u0006\n\u0004\b\u001a\u0010\u0016R\u0014\u0010\u001b\u001a\u00020\u00148\u0006X\u0087\u0004\u00a2\u0006\u0006\n\u0004\b\u001b\u0010\u0016R&\u0010\u001d\u001a\u0014\u0012\u0004\u0012\u00020\t\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0\u000b0\u001c8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u001d\u0010\u001eR\u0014\u0010\u001f\u001a\u00020\u00148\u0006X\u0087\u0004\u00a2\u0006\u0006\n\u0004\b\u001f\u0010\u0016R\u0014\u0010 \u001a\u00020\u00148\u0006X\u0087\u0004\u00a2\u0006\u0006\n\u0004\b \u0010\u0016R \u0010$\u001a\u0004\u0018\u00010\f*\u00020\u00048FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b#\u0010\b\u001a\u0004\b!\u0010\"\u00a8\u0006%"}, d2={"Lde/rubixdev/inventorio/player/InventorioScreenHandler$Companion;", "", "<init>", "()V", "Lnet/minecraft/world/entity/player/Player;", "player", "", "open", "(Lnet/minecraft/world/entity/player/Player;)V", "Lnet/minecraft/resources/ResourceLocation;", "customIdentifier", "Ljava/util/function/Consumer;", "Lde/rubixdev/inventorio/player/InventorioScreenHandler;", "screenHandlerConsumer", "registerOpenConsumer", "(Lnet/minecraft/resources/ResourceLocation;Ljava/util/function/Consumer;)V", "", "Lnet/minecraft/world/entity/EquipmentSlot;", "armorSlots", "[Lnet/minecraft/world/entity/EquipmentSlot;", "Lkotlin/ranges/IntRange;", "armorSlotsRange", "Lkotlin/ranges/IntRange;", "craftingGridRange", "deepPocketsRange", "hotbarRange", "mainInventoryRange", "mainInventoryWithoutHotbarRange", "", "openConsumers", "Ljava/util/Map;", "toolBeltRange", "utilityBeltRange", "getInventorioScreenHandler", "(Lnet/minecraft/world/entity/player/Player;)Lde/rubixdev/inventorio/player/InventorioScreenHandler;", "getInventorioScreenHandler$annotations", "inventorioScreenHandler", "inventorio-mc1.20.1-forge"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final InventorioScreenHandler getInventorioScreenHandler(@NotNull Player $this$inventorioScreenHandler) {
            Intrinsics.checkNotNullParameter((Object)$this$inventorioScreenHandler, (String)"<this>");
            AbstractContainerMenu abstractContainerMenu = $this$inventorioScreenHandler.f_36096_;
            return abstractContainerMenu instanceof InventorioScreenHandler ? (InventorioScreenHandler)abstractContainerMenu : null;
        }

        @JvmStatic
        public static /* synthetic */ void getInventorioScreenHandler$annotations(Player player) {
        }

        @JvmStatic
        public final void registerOpenConsumer(@NotNull ResourceLocation customIdentifier, @NotNull Consumer<InventorioScreenHandler> screenHandlerConsumer) {
            Intrinsics.checkNotNullParameter((Object)customIdentifier, (String)"customIdentifier");
            Intrinsics.checkNotNullParameter(screenHandlerConsumer, (String)"screenHandlerConsumer");
            if (openConsumers.containsKey(customIdentifier)) {
                throw new IllegalStateException("The Identifier '" + customIdentifier + "' has already been taken");
            }
            openConsumers.put(customIdentifier, screenHandlerConsumer);
        }

        @JvmStatic
        public final void open(@NotNull Player player) {
            Intrinsics.checkNotNullParameter((Object)player, (String)"player");
            player.m_5893_((MenuProvider)new SimpleMenuProvider(Companion::open$lambda$0, (Component)Component.m_237115_((String)"container.crafting")));
        }

        private static final AbstractContainerMenu open$lambda$0(int syncId, Inventory playerInventory, Player player) {
            Inventory inventory = playerInventory;
            Intrinsics.checkNotNull((Object)inventory);
            return (AbstractContainerMenu)new InventorioScreenHandler(syncId, inventory);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

