/*
 * Decompiled with CFR 0.152.
 */
package de.rubixdev.inventorio.packet;

import de.rubixdev.inventorio.player.PlayerInventoryAddon;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Supplier;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.network.NetworkEvent;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010$\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u001d\b\u0016\u0012\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0002\u00a2\u0006\u0004\b\u0006\u0010\u0007B\u0011\b\u0016\u0012\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0004\b\u0006\u0010\nJ\u001b\u0010\u000f\u001a\u00020\u000e2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\f0\u000b\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u0015\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0004\b\u0011\u0010\nR\"\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u00028\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u0005\u0010\u0012\u00a8\u0006\u0013"}, d2={"Lde/rubixdev/inventorio/packet/UpdateAddonStacksS2CPacket;", "", "", "", "Lnet/minecraft/world/item/ItemStack;", "updatedStacks", "<init>", "(Ljava/util/Map;)V", "Lnet/minecraft/network/FriendlyByteBuf;", "buf", "(Lnet/minecraft/network/FriendlyByteBuf;)V", "Ljava/util/function/Supplier;", "Lnet/minecraftforge/network/NetworkEvent$Context;", "supplier", "", "consume", "(Ljava/util/function/Supplier;)V", "write", "Ljava/util/Map;", "inventorio-mc1.20.1-forge"})
public final class UpdateAddonStacksS2CPacket {
    @NotNull
    private Map<Integer, ItemStack> updatedStacks;

    public UpdateAddonStacksS2CPacket(@NotNull Map<Integer, ItemStack> updatedStacks) {
        Intrinsics.checkNotNullParameter(updatedStacks, (String)"updatedStacks");
        this.updatedStacks = updatedStacks;
    }

    public UpdateAddonStacksS2CPacket(@NotNull FriendlyByteBuf buf) {
        Intrinsics.checkNotNullParameter((Object)buf, (String)"buf");
        int size = buf.readInt();
        Map updatedStacks = new LinkedHashMap();
        for (int i = 0; i < size; ++i) {
            ItemStack itemStack;
            Map map = updatedStacks;
            Integer n = buf.readInt();
            Intrinsics.checkNotNullExpressionValue((Object)buf.m_130267_(), (String)"buf.readItemStack()");
            map.put(n, itemStack);
        }
        this.updatedStacks = updatedStacks;
    }

    public final void write(@NotNull FriendlyByteBuf buf) {
        Intrinsics.checkNotNullParameter((Object)buf, (String)"buf");
        buf.writeInt(this.updatedStacks.size());
        for (Map.Entry<Integer, ItemStack> entry : this.updatedStacks.entrySet()) {
            int index = ((Number)entry.getKey()).intValue();
            ItemStack stack = entry.getValue();
            buf.writeInt(index);
            buf.m_130055_(stack);
        }
    }

    public final void consume(@NotNull Supplier<NetworkEvent.Context> supplier) {
        Intrinsics.checkNotNullParameter(supplier, (String)"supplier");
        supplier.get().enqueueWork(() -> UpdateAddonStacksS2CPacket.consume$lambda$0(this));
        supplier.get().setPacketHandled(true);
    }

    private static final void consume$lambda$0(UpdateAddonStacksS2CPacket this$0) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
            PlayerInventoryAddon playerInventoryAddon = PlayerInventoryAddon.Client.INSTANCE.getLocal();
            if (playerInventoryAddon == null) break block0;
            playerInventoryAddon.receiveStacksUpdateS2C(this$0.updatedStacks);
        }
    }
}

