/*
 * Decompiled with CFR 0.152.
 */
package de.rubixdev.inventorio.mixin;

import de.rubixdev.inventorio.packet.InventorioNetworking;
import de.rubixdev.inventorio.util.MixinHelpers;
import net.minecraft.network.Connection;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.players.PlayerList;
import net.minecraft.world.entity.player.Player;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={PlayerList.class})
public class PlayerManagerMixin {
    @Inject(method={"m_11261_(Lnet/minecraft/network/Connection;Lnet/minecraft/server/level/ServerPlayer;)V"}, at={@At(value="RETURN")}, require=0)
    private void inventorioSetPlayerSettings(Connection connection, ServerPlayer player, CallbackInfo ci) {
        InventorioNetworking.getInstance().s2cSelectUtilitySlot(player);
        InventorioNetworking.getInstance().s2cGlobalSettings(player);
    }

    @Inject(method={"m_11236_(Lnet/minecraft/server/level/ServerPlayer;Z)Lnet/minecraft/server/level/ServerPlayer;"}, at={@At(value="RETURN")}, require=0)
    private void inventorioSetPlayerSettings(ServerPlayer oldPlayer, boolean alive, CallbackInfoReturnable<ServerPlayer> cir) {
        ServerPlayer newPlayer = (ServerPlayer)cir.getReturnValue();
        MixinHelpers.withInventoryAddon((Player)newPlayer, newAddon -> MixinHelpers.withInventoryAddon((Player)oldPlayer, oldAddon -> {
            newAddon.setSwappedHands(oldAddon.getSwappedHands());
            newAddon.setSelectedUtility(oldAddon.getSelectedUtility());
        }));
        InventorioNetworking.getInstance().s2cSelectUtilitySlot(newPlayer);
    }

    @Inject(method={"m_11292_(Lnet/minecraft/server/level/ServerPlayer;)V"}, at={@At(value="RETURN")})
    private void sendSelectedUtility(ServerPlayer player, CallbackInfo ci) {
        InventorioNetworking.getInstance().s2cSelectUtilitySlot(player);
    }
}

