/*
 * Decompiled with CFR 0.152.
 */
package de.rubixdev.inventorio.mixin;

import com.llamalad7.mixinextras.injector.ModifyReturnValue;
import de.rubixdev.inventorio.client.control.InventorioKeyHandler;
import de.rubixdev.inventorio.player.inventory.PlayerInventoryExtension;
import de.rubixdev.inventorio.util.MixinHelpers;
import net.minecraft.tags.TagKey;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Inventory.class}, priority=-5000)
public abstract class PlayerInventoryMixin {
    @Shadow
    @Final
    public Player f_35978_;

    @Inject(method={"m_36006_(Lnet/minecraft/world/entity/player/Inventory;)V"}, at={@At(value="RETURN")})
    private void inventorioClonePlayerInventory(Inventory sourceInventory, CallbackInfo ci) {
        MixinHelpers.withInventoryAddon(this.f_35978_, thisAddon -> MixinHelpers.withInventoryAddon(sourceInventory.f_35978_, thisAddon::cloneFrom));
    }

    @Inject(method={"m_36056_()Lnet/minecraft/world/item/ItemStack;"}, at={@At(value="RETURN")}, cancellable=true)
    private void inventorioGetMainHandStack(CallbackInfoReturnable<ItemStack> cir) {
        MixinHelpers.withInventoryAddon(this.f_35978_, inventorioAddon -> {
            ItemStack mainHandStack = inventorioAddon.getDisplayedMainHandStack();
            if (mainHandStack != null) {
                cir.setReturnValue((Object)mainHandStack);
            }
        });
    }

    @Inject(method={"m_36020_(Lnet/minecraft/world/level/block/state/BlockState;)F"}, at={@At(value="RETURN")}, cancellable=true)
    private void inventorioGetBlockBreakingSpeed(BlockState block, CallbackInfoReturnable<Float> cir) {
        MixinHelpers.withInventoryAddon(this.f_35978_, inventorioAddon -> cir.setReturnValue((Object)Float.valueOf(inventorioAddon.getMiningSpeedMultiplier(block))));
    }

    @Inject(method={"m_36040_(ILnet/minecraft/world/item/ItemStack;)Z"}, at={@At(value="HEAD")}, cancellable=true)
    private void inventorioInsertSimilarStackIntoAddon(int slot, ItemStack originalStack, CallbackInfoReturnable<Boolean> cir) {
        MixinHelpers.withInventoryAddon(this.f_35978_, inventorioAddon -> {
            if (slot == -1 && inventorioAddon != null && inventorioAddon.insertOnlySimilarStack(originalStack)) {
                cir.setReturnValue((Object)true);
            }
        });
    }

    @ModifyReturnValue(method={"m_36040_(ILnet/minecraft/world/item/ItemStack;)Z"}, at={@At(value="RETURN")})
    private boolean inventorioInsertStackIntoAddon(boolean original, int slot, ItemStack originalStack) {
        return original || Boolean.TRUE.equals(MixinHelpers.withInventoryAddonReturning(this.f_35978_, addon -> slot == -1 && addon.insertStackIntoEmptySlot(originalStack)));
    }

    @Inject(method={"m_36057_(Lnet/minecraft/world/item/ItemStack;)V"}, at={@At(value="HEAD")}, cancellable=true)
    private void inventorioRemoveOneFromAddon(ItemStack stack, CallbackInfo ci) {
        MixinHelpers.withInventoryAddon(this.f_35978_, inventorioAddon -> {
            if (inventorioAddon != null && inventorioAddon.removeOne(stack)) {
                ci.cancel();
            }
        });
    }

    @Inject(method={"m_36071_()V"}, at={@At(value="RETURN")})
    private void inventorioDropAllFromAddon(CallbackInfo ci) {
        MixinHelpers.withInventoryAddon(this.f_35978_, PlayerInventoryExtension::dropAll);
    }

    @Inject(method={"m_6211_()V"}, at={@At(value="RETURN")})
    private void inventorioClearAddon(CallbackInfo ci) {
        MixinHelpers.withInventoryAddon(this.f_35978_, SimpleContainer::m_6211_);
    }

    @Inject(method={"m_35988_(D)V"}, at={@At(value="HEAD")}, cancellable=true)
    @OnlyIn(value=Dist.CLIENT)
    private void inventorioScrollInHotbar(double scrollAmount, CallbackInfo ci) {
        if (InventorioKeyHandler.INSTANCE.scrollInHotbar(this.f_35978_, scrollAmount)) {
            ci.cancel();
        }
    }

    @ModifyReturnValue(method={"m_36063_(Lnet/minecraft/world/item/ItemStack;)Z"}, at={@At(value="RETURN")})
    private boolean searchAddon(boolean original, ItemStack stack) {
        return original || Boolean.TRUE.equals(MixinHelpers.withInventoryAddonReturning(this.f_35978_, addon -> addon.contains(stack)));
    }

    @ModifyReturnValue(method={"m_204075_(Lnet/minecraft/tags/TagKey;)Z"}, at={@At(value="RETURN")})
    private boolean searchAddon(boolean original, TagKey<Item> tag) {
        return original || Boolean.TRUE.equals(MixinHelpers.withInventoryAddonReturning(this.f_35978_, addon -> addon.contains(tag)));
    }
}

