/*
 * Decompiled with CFR 0.152.
 */
package de.rubixdev.inventorio.mixin;

import com.llamalad7.mixinextras.injector.ModifyReturnValue;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.mojang.authlib.GameProfile;
import de.rubixdev.inventorio.player.InventorioScreenHandler;
import de.rubixdev.inventorio.player.PlayerAddonSerializer;
import de.rubixdev.inventorio.player.PlayerInventoryAddon;
import de.rubixdev.inventorio.util.MixinHelpers;
import de.rubixdev.inventorio.util.PlayerDuck;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Player.class})
public abstract class PlayerEntityMixin
implements PlayerDuck {
    @Unique
    public PlayerInventoryAddon inventorioAddon;

    @Shadow
    public abstract Inventory m_150109_();

    @Inject(method={"<init>(Lnet/minecraft/world/level/Level;Lnet/minecraft/core/BlockPos;FLcom/mojang/authlib/GameProfile;)V"}, at={@At(value="RETURN")})
    private void inventorioCreateAddon(Level world, BlockPos pos, float yaw, GameProfile gameProfile, CallbackInfo ci) {
        Player thisPlayer = (Player)this;
        this.inventorioAddon = new PlayerInventoryAddon(thisPlayer);
    }

    @Inject(method={"m_6844_(Lnet/minecraft/world/entity/EquipmentSlot;)Lnet/minecraft/world/item/ItemStack;"}, at={@At(value="HEAD")}, cancellable=true)
    private void inventorioDisplayOffhand(EquipmentSlot slot, CallbackInfoReturnable<ItemStack> cir) {
        if (slot == EquipmentSlot.OFFHAND) {
            cir.setReturnValue((Object)this.inventorioAddon.getDisplayedOffHandStack());
        }
    }

    @WrapOperation(method={"m_8061_(Lnet/minecraft/world/entity/EquipmentSlot;Lnet/minecraft/world/item/ItemStack;)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/core/NonNullList;set(ILjava/lang/Object;)Ljava/lang/Object;", ordinal=0)})
    private <E> E inventorioEquipMainHand(NonNullList<E> instance, int index, E element, Operation<E> original) {
        if (this.inventorioAddon.getSwappedHands()) {
            this.inventorioAddon.setSelectedUtilityStack((ItemStack)element);
            return (E)ItemStack.f_41583_;
        }
        return (E)original.call(new Object[]{instance, index, element});
    }

    @Redirect(method={"m_8061_(Lnet/minecraft/world/entity/EquipmentSlot;Lnet/minecraft/world/item/ItemStack;)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/core/NonNullList;set(ILjava/lang/Object;)Ljava/lang/Object;", ordinal=1))
    private <E> E inventorioEquipOffhand(NonNullList<E> defaultedList, int index, E stack) {
        ItemStack itemStack = (ItemStack)stack;
        if (this.inventorioAddon.getSwappedHands()) {
            this.inventorioAddon.setSelectedHotbarStack(itemStack);
        } else {
            this.inventorioAddon.setSelectedUtilityStack(itemStack);
        }
        return (E)ItemStack.f_41583_;
    }

    @Inject(method={"m_8061_(Lnet/minecraft/world/entity/EquipmentSlot;Lnet/minecraft/world/item/ItemStack;)V"}, at={@At(value="RETURN")})
    private void inventorioOnEquipArmor(EquipmentSlot slot, ItemStack stack, CallbackInfo ci) {
        if (slot.m_20743_() == EquipmentSlot.Type.ARMOR) {
            MixinHelpers.withScreenHandler((Player)this, InventorioScreenHandler::updateDeepPocketsCapacity);
        }
    }

    @ModifyReturnValue(method={"m_6298_(Lnet/minecraft/world/item/ItemStack;)Lnet/minecraft/world/item/ItemStack;"}, at={@At(value="RETURN")})
    private ItemStack inventorioGetArrowType(ItemStack original, ItemStack bowStack) {
        if (!original.m_41619_()) {
            return original;
        }
        ItemStack arrowStack = this.inventorioAddon.getActiveArrowType(bowStack);
        return arrowStack != null ? arrowStack : original;
    }

    @Inject(method={"m_5706_(Lnet/minecraft/world/entity/Entity;)V"}, at={@At(value="HEAD")})
    private void inventorioPreAttack(Entity target, CallbackInfo ci) {
        if (target.m_6097_()) {
            this.inventorioAddon.prePlayerAttack();
        }
    }

    @Inject(method={"m_5706_(Lnet/minecraft/world/entity/Entity;)V"}, at={@At(value="RETURN")})
    private void inventorioPostAttack(Entity target, CallbackInfo ci) {
        if (target.m_6097_()) {
            this.inventorioAddon.postPlayerAttack();
        }
    }

    @Inject(method={"m_7378_(Lnet/minecraft/nbt/CompoundTag;)V"}, at={@At(value="RETURN")})
    private void inventorioDeserializePlayerAddon(CompoundTag tag, CallbackInfo ci) {
        PlayerAddonSerializer.INSTANCE.deserialize(this.inventorioAddon, tag.m_128469_("Inventorio"));
    }

    @Inject(method={"m_7380_(Lnet/minecraft/nbt/CompoundTag;)V"}, at={@At(value="RETURN")})
    private void inventorioSerializePlayerAddon(CompoundTag tag, CallbackInfo ci) {
        CompoundTag inventorioTag = new CompoundTag();
        PlayerAddonSerializer.INSTANCE.serialize(this.inventorioAddon, inventorioTag);
        tag.m_128365_("Inventorio", (Tag)inventorioTag);
    }

    @Inject(method={"m_8107_()V"}, at={@At(value="RETURN")})
    private void inventorioTick(CallbackInfo ci) {
        this.inventorioAddon.tick();
    }

    @Override
    @Nullable
    public PlayerInventoryAddon inventorio$getInventorioAddon() {
        return this.inventorioAddon;
    }
}

