/*
 * Decompiled with CFR 0.152.
 */
package de.rubixdev.inventorio.client.ui;

import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.systems.RenderSystem;
import de.rubixdev.inventorio.config.PlayerSettings;
import de.rubixdev.inventorio.player.PlayerInventoryAddon;
import de.rubixdev.inventorio.util.HUDConstants;
import de.rubixdev.inventorio.util.RandomStuff;
import de.rubixdev.inventorio.util.SegmentedHotbar;
import de.rubixdev.inventorio.util.UIConstants;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportCategory;
import net.minecraft.ReportedException;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.multiplayer.MultiPlayerGameMode;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GameType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix4f;

@OnlyIn(value=Dist.CLIENT)
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c7\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J/\u0010\f\u001a\u00020\u000b2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\bH\u0002\u00a2\u0006\u0004\b\f\u0010\rJ\u000f\u0010\u000f\u001a\u00020\u000eH\u0002\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u0015\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u0015\u0010\u0013\u001a\u00020\u000b2\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0013\u0010\u0012J/\u0010\u0014\u001a\u00020\u000b2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\bH\u0002\u00a2\u0006\u0004\b\u0014\u0010\rJ\u0015\u0010\u0015\u001a\u00020\u000e2\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0015\u0010\u0016R\u0014\u0010\u0018\u001a\u00020\u00178\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0018\u0010\u0019R\u0014\u0010\u001a\u001a\u00020\u00178\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u001a\u0010\u0019R\u0014\u0010\u001c\u001a\u00020\u001b8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u001c\u0010\u001d\u00a8\u0006\u001e"}, d2={"Lde/rubixdev/inventorio/client/ui/HotbarHUDRenderer;", "", "<init>", "()V", "Lnet/minecraft/client/gui/GuiGraphics;", "drawContext", "Lnet/minecraft/world/item/ItemStack;", "stack", "", "x", "y", "", "drawSmallItem", "(Lnet/minecraft/client/gui/GuiGraphics;Lnet/minecraft/world/item/ItemStack;II)V", "", "isHidden", "()Z", "renderFunctionOnlySelector", "(Lnet/minecraft/client/gui/GuiGraphics;)V", "renderHotbarAddons", "renderItem", "renderSegmentedHotbar", "(Lnet/minecraft/client/gui/GuiGraphics;)Z", "Lnet/minecraft/resources/ResourceLocation;", "WIDGETS_TEXTURE", "Lnet/minecraft/resources/ResourceLocation;", "WIDGETS_TEXTURE_DARK", "Lnet/minecraft/client/Minecraft;", "client", "Lnet/minecraft/client/Minecraft;", "inventorio-mc1.20.1-forge"})
@SourceDebugExtension(value={"SMAP\nHotbarHUDRenderer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HotbarHUDRenderer.kt\nde/rubixdev/inventorio/client/ui/HotbarHUDRenderer\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,297:1\n12474#2,2:298\n*S KotlinDebug\n*F\n+ 1 HotbarHUDRenderer.kt\nde/rubixdev/inventorio/client/ui/HotbarHUDRenderer\n*L\n163#1:298,2\n*E\n"})
public final class HotbarHUDRenderer {
    @NotNull
    public static final HotbarHUDRenderer INSTANCE = new HotbarHUDRenderer();
    @NotNull
    private static final ResourceLocation WIDGETS_TEXTURE = new ResourceLocation("inventorio", "textures/gui/widgets.png");
    @NotNull
    private static final ResourceLocation WIDGETS_TEXTURE_DARK = new ResourceLocation("inventorio", "textures/gui/widgets_dark.png");
    @NotNull
    private static final Minecraft client;

    private HotbarHUDRenderer() {
    }

    public final boolean renderSegmentedHotbar(@NotNull GuiGraphics drawContext) {
        Intrinsics.checkNotNullParameter((Object)drawContext, (String)"drawContext");
        if (PlayerSettings.segmentedHotbar.getValue() == SegmentedHotbar.OFF || PlayerSettings.segmentedHotbar.getValue() == SegmentedHotbar.ONLY_FUNCTION || this.isHidden()) {
            return false;
        }
        Entity entity = HotbarHUDRenderer.client.f_91075_;
        Player player = entity instanceof Player ? (Player)entity : null;
        if (player == null) {
            return false;
        }
        Player playerEntity = player;
        Inventory inventory = playerEntity.m_150109_();
        int scaledWidthHalved = client.m_91268_().m_85445_() / 2 - 30;
        int scaledHeight = client.m_91268_().m_85446_();
        int selectedSection = PlayerInventoryAddon.Client.selectedHotbarSection;
        ResourceLocation texture = PlayerSettings.darkTheme.getBoolValue() ? WIDGETS_TEXTURE_DARK : WIDGETS_TEXTURE;
        drawContext.m_280163_(texture, scaledWidthHalved - HUDConstants.HUD_SEGMENTED_HOTBAR.x, scaledHeight - HUDConstants.HUD_SEGMENTED_HOTBAR.y, HUDConstants.CANVAS_SEGMENTED_HOTBAR.x, HUDConstants.CANVAS_SEGMENTED_HOTBAR.y, HUDConstants.HUD_SEGMENTED_HOTBAR.width, HUDConstants.HUD_SEGMENTED_HOTBAR.height, UIConstants.CANVAS_WIDGETS_TEXTURE_SIZE.x, UIConstants.CANVAS_WIDGETS_TEXTURE_SIZE.y);
        if (selectedSection == -1) {
            drawContext.m_280163_(texture, scaledWidthHalved - HUDConstants.HUD_SECTION_SELECTION.x - 4 + inventory.f_35977_ * HUDConstants.SLOT_HOTBAR_SIZE.width + 4 * (inventory.f_35977_ / 3), scaledHeight - HUDConstants.HUD_SECTION_SELECTION.y, HUDConstants.CANVAS_VANILLA_SELECTION_FRAME_POS.x, HUDConstants.CANVAS_VANILLA_SELECTION_FRAME_POS.y, HUDConstants.CANVAS_VANILLA_SELECTION_FRAME_SIZE.width, HUDConstants.CANVAS_VANILLA_SELECTION_FRAME_SIZE.height, UIConstants.CANVAS_WIDGETS_TEXTURE_SIZE.x, UIConstants.CANVAS_WIDGETS_TEXTURE_SIZE.y);
        } else {
            drawContext.m_280163_(texture, scaledWidthHalved - HUDConstants.HUD_SECTION_SELECTION.x + HUDConstants.HUD_SECTION_SELECTION.width * selectedSection - 4, scaledHeight - HUDConstants.HUD_SECTION_SELECTION.y, HUDConstants.CANVAS_SECTION_SELECTION_FRAME.x, HUDConstants.CANVAS_SECTION_SELECTION_FRAME.y, HUDConstants.HUD_SECTION_SELECTION.width, HUDConstants.HUD_SECTION_SELECTION.height, UIConstants.CANVAS_WIDGETS_TEXTURE_SIZE.x, UIConstants.CANVAS_WIDGETS_TEXTURE_SIZE.y);
        }
        for (int slotNum = 0; slotNum < 9; ++slotNum) {
            int x = scaledWidthHalved - HUDConstants.HUD_SECTION_SELECTION.x + slotNum * HUDConstants.SLOT_HOTBAR_SIZE.width + 4 * (slotNum / 3);
            int y = scaledHeight - HUDConstants.SLOT_HOTBAR_SIZE.height;
            ItemStack itemStack = inventory.m_8020_(slotNum);
            drawContext.m_280480_(itemStack, x, y);
            drawContext.m_280370_(HotbarHUDRenderer.client.f_91062_, itemStack, x, y);
        }
        return true;
    }

    private final boolean isHidden() {
        block3: {
            block2: {
                if (HotbarHUDRenderer.client.f_91072_ == null) break block2;
                MultiPlayerGameMode multiPlayerGameMode = HotbarHUDRenderer.client.f_91072_;
                if ((multiPlayerGameMode != null ? multiPlayerGameMode.m_105295_() : null) != GameType.SPECTATOR && !HotbarHUDRenderer.client.f_91066_.f_92062_) break block3;
            }
            return true;
        }
        Entity entity = HotbarHUDRenderer.client.f_91075_;
        Player player = entity instanceof Player ? (Player)entity : null;
        return player == null || !player.m_6084_() || player.f_36095_ == null;
    }

    public final void renderHotbarAddons(@NotNull GuiGraphics drawContext) {
        int leftHandedDisplayToolOffset;
        int segmentedModeOffset;
        int scaledHeight;
        int scaledWidthHalved;
        ItemStack selectedHotbarItem;
        PlayerInventoryAddon inventoryAddon;
        block11: {
            ResourceLocation texture;
            int leftHandedUtilityBeltOffset;
            ItemStack[] utilBeltDisplay;
            block10: {
                boolean bl;
                block9: {
                    boolean rightHanded;
                    Intrinsics.checkNotNullParameter((Object)drawContext, (String)"drawContext");
                    if (this.isHidden()) {
                        return;
                    }
                    PlayerInventoryAddon playerInventoryAddon = PlayerInventoryAddon.Client.INSTANCE.getLocal();
                    if (playerInventoryAddon == null) {
                        return;
                    }
                    inventoryAddon = playerInventoryAddon;
                    Player player = inventoryAddon.getPlayer();
                    utilBeltDisplay = inventoryAddon.getDisplayedUtilities();
                    selectedHotbarItem = inventoryAddon.getSelectedHotbarStack();
                    scaledWidthHalved = client.m_91268_().m_85445_() / 2 - 30;
                    scaledHeight = client.m_91268_().m_85446_();
                    boolean drawSegmentedHotbar = PlayerSettings.segmentedHotbar.getValue() == SegmentedHotbar.ONLY_VISUAL || PlayerSettings.segmentedHotbar.getValue() == SegmentedHotbar.ON;
                    segmentedModeOffset = drawSegmentedHotbar ? 4 : 0;
                    boolean bl2 = rightHanded = player.m_5737_() == HumanoidArm.RIGHT;
                    if (inventoryAddon.getSwappedHands()) {
                        rightHanded = !rightHanded;
                    }
                    leftHandedUtilityBeltOffset = rightHanded ? 0 : 254 + segmentedModeOffset * 2;
                    leftHandedDisplayToolOffset = rightHanded ? 0 : -228 - segmentedModeOffset * 2;
                    texture = PlayerSettings.darkTheme.getBoolValue() ? WIDGETS_TEXTURE_DARK : WIDGETS_TEXTURE;
                    RenderSystem.disableDepthTest();
                    RenderSystem.enableBlend();
                    if (RandomStuff.isNotEmpty(inventoryAddon.getDisplayTool()) && !Intrinsics.areEqual((Object)inventoryAddon.getDisplayTool(), (Object)selectedHotbarItem)) {
                        drawContext.m_280163_(texture, scaledWidthHalved + leftHandedDisplayToolOffset + HUDConstants.HUD_ACTIVE_TOOL_FRAME.x + segmentedModeOffset, scaledHeight - HUDConstants.HUD_ACTIVE_TOOL_FRAME.y, HUDConstants.CANVAS_ACTIVE_TOOL_FRAME.x, HUDConstants.CANVAS_ACTIVE_TOOL_FRAME.y, HUDConstants.HUD_ACTIVE_TOOL_FRAME.width, HUDConstants.HUD_ACTIVE_TOOL_FRAME.height, UIConstants.CANVAS_WIDGETS_TEXTURE_SIZE.x, UIConstants.CANVAS_WIDGETS_TEXTURE_SIZE.y);
                    }
                    if (!PlayerSettings.skipEmptyUtilitySlots.getBoolValue()) break block10;
                    ItemStack[] $this$any$iv = utilBeltDisplay;
                    boolean $i$f$any = false;
                    int n = $this$any$iv.length;
                    for (int i = 0; i < n; ++i) {
                        ItemStack element$iv;
                        ItemStack it = element$iv = $this$any$iv[i];
                        boolean bl3 = false;
                        if (!RandomStuff.isNotEmpty(it)) continue;
                        bl = true;
                        break block9;
                    }
                    bl = false;
                }
                if (!bl) break block11;
            }
            drawContext.m_280163_(texture, scaledWidthHalved + leftHandedUtilityBeltOffset - HUDConstants.HUD_UTILITY_BELT.x - segmentedModeOffset, scaledHeight - HUDConstants.HUD_UTILITY_BELT.y, HUDConstants.CANVAS_UTILITY_BELT_BCG.x, HUDConstants.CANVAS_UTILITY_BELT_BCG.y, HUDConstants.HUD_UTILITY_BELT.width, HUDConstants.HUD_UTILITY_BELT.height, UIConstants.CANVAS_WIDGETS_TEXTURE_SIZE.x, UIConstants.CANVAS_WIDGETS_TEXTURE_SIZE.y);
            this.drawSmallItem(drawContext, utilBeltDisplay[0], (scaledWidthHalved + leftHandedUtilityBeltOffset - segmentedModeOffset) * 10 / 8 - HUDConstants.SLOT_UTILITY_BELT_1.x, Mth.m_14165_((double)((double)(scaledHeight - HUDConstants.SLOT_UTILITY_BELT_1.y) / 0.8)));
            this.drawSmallItem(drawContext, utilBeltDisplay[2], (scaledWidthHalved + leftHandedUtilityBeltOffset - segmentedModeOffset) * 10 / 8 - HUDConstants.SLOT_UTILITY_BELT_2.x, Mth.m_14165_((double)((double)(scaledHeight - HUDConstants.SLOT_UTILITY_BELT_2.y) / 0.8)));
            RenderSystem.applyModelViewMatrix();
            RenderSystem.disableDepthTest();
            RenderSystem.enableBlend();
            texture = PlayerSettings.darkTheme.getBoolValue() ? WIDGETS_TEXTURE_DARK : WIDGETS_TEXTURE;
            drawContext.m_280163_(texture, scaledWidthHalved + leftHandedUtilityBeltOffset - HUDConstants.HUD_UTILITY_BELT.x - segmentedModeOffset, scaledHeight - HUDConstants.HUD_UTILITY_BELT.y, HUDConstants.CANVAS_UTILITY_BELT.x, HUDConstants.CANVAS_UTILITY_BELT.y, HUDConstants.HUD_UTILITY_BELT.width, HUDConstants.HUD_UTILITY_BELT.height, UIConstants.CANVAS_WIDGETS_TEXTURE_SIZE.x, UIConstants.CANVAS_WIDGETS_TEXTURE_SIZE.y);
            this.renderItem(drawContext, utilBeltDisplay[1], scaledWidthHalved + leftHandedUtilityBeltOffset - HUDConstants.SLOT_UTILITY_BELT_3.x - segmentedModeOffset, scaledHeight - HUDConstants.SLOT_UTILITY_BELT_3.y);
        }
        if (RandomStuff.isNotEmpty(inventoryAddon.getDisplayTool()) && !Intrinsics.areEqual((Object)inventoryAddon.getDisplayTool(), (Object)selectedHotbarItem)) {
            this.renderItem(drawContext, inventoryAddon.getDisplayTool(), scaledWidthHalved + leftHandedDisplayToolOffset + HUDConstants.SLOT_ACTIVE_TOOL_FRAME.x + segmentedModeOffset, scaledHeight - HUDConstants.SLOT_ACTIVE_TOOL_FRAME.y);
        }
        RenderSystem.enableBlend();
    }

    private final void renderItem(GuiGraphics drawContext, ItemStack stack, int x, int y) {
        if (RandomStuff.isNotEmpty(stack)) {
            drawContext.m_280480_(stack, x, y);
            drawContext.m_280370_(HotbarHUDRenderer.client.f_91062_, stack, x, y);
        }
    }

    public final void renderFunctionOnlySelector(@NotNull GuiGraphics drawContext) {
        Intrinsics.checkNotNullParameter((Object)drawContext, (String)"drawContext");
        int selectedSection = PlayerInventoryAddon.Client.selectedHotbarSection;
        if (selectedSection != -1 && PlayerSettings.segmentedHotbar.getValue() == SegmentedHotbar.ONLY_FUNCTION) {
            int scaledWidthHalved = client.m_91268_().m_85445_() / 2 - 30;
            int scaledHeight = client.m_91268_().m_85446_();
            ResourceLocation texture = PlayerSettings.darkTheme.getBoolValue() ? WIDGETS_TEXTURE_DARK : WIDGETS_TEXTURE;
            drawContext.m_280163_(texture, scaledWidthHalved - HUDConstants.HUD_SECTION_SELECTION.x + (HUDConstants.HUD_SECTION_SELECTION.width - 4) * selectedSection, scaledHeight - HUDConstants.HUD_SECTION_SELECTION.y, HUDConstants.CANVAS_SECTION_SELECTION_FRAME.x, HUDConstants.CANVAS_SECTION_SELECTION_FRAME.y, HUDConstants.HUD_SECTION_SELECTION.width, HUDConstants.HUD_SECTION_SELECTION.height, UIConstants.CANVAS_WIDGETS_TEXTURE_SIZE.x, UIConstants.CANVAS_WIDGETS_TEXTURE_SIZE.y);
        }
    }

    private final void drawSmallItem(GuiGraphics drawContext, ItemStack stack, int x, int y) {
        if (!stack.m_41619_()) {
            BakedModel bakedModel = client.m_91291_().m_174264_(stack, null, null, 0);
            drawContext.m_280168_().m_85836_();
            drawContext.m_280168_().m_85841_(0.8f, 0.8f, 0.8f);
            drawContext.m_280168_().m_252880_((float)(x + 8), (float)(y + 8), 150.0f);
            try {
                boolean bl;
                drawContext.m_280168_().m_252931_(new Matrix4f().scaling(1.0f, -1.0f, 1.0f));
                drawContext.m_280168_().m_85841_(16.0f, 16.0f, 16.0f);
                boolean bl2 = bl = !bakedModel.m_7547_();
                if (bl) {
                    Lighting.m_84930_();
                }
                client.m_91291_().m_115143_(stack, ItemDisplayContext.GUI, false, drawContext.m_280168_(), (MultiBufferSource)drawContext.m_280091_(), 0xF000F0, OverlayTexture.f_118083_, bakedModel);
                drawContext.m_280262_();
                if (bl) {
                    Lighting.m_84931_();
                }
            }
            catch (Throwable var12) {
                CrashReport crashReport = CrashReport.m_127521_((Throwable)var12, (String)"Rendering item");
                CrashReportCategory crashReportSection = crashReport.m_127514_("Item being rendered");
                crashReportSection.m_128165_("Item Type", () -> HotbarHUDRenderer.drawSmallItem$lambda$1(stack));
                crashReportSection.m_128165_("Item Damage", () -> HotbarHUDRenderer.drawSmallItem$lambda$2(stack));
                crashReportSection.m_128165_("Item NBT", () -> HotbarHUDRenderer.drawSmallItem$lambda$3(stack));
                crashReportSection.m_128165_("Item Foil", () -> HotbarHUDRenderer.drawSmallItem$lambda$4(stack));
                throw new ReportedException(crashReport);
            }
            drawContext.m_280168_().m_85849_();
        }
    }

    private static final String drawSmallItem$lambda$1(ItemStack $stack) {
        Intrinsics.checkNotNullParameter((Object)$stack, (String)"$stack");
        return $stack.m_41720_().toString();
    }

    private static final String drawSmallItem$lambda$2(ItemStack $stack) {
        Intrinsics.checkNotNullParameter((Object)$stack, (String)"$stack");
        return String.valueOf($stack.m_41773_());
    }

    private static final String drawSmallItem$lambda$3(ItemStack $stack) {
        Intrinsics.checkNotNullParameter((Object)$stack, (String)"$stack");
        return String.valueOf($stack.m_41783_());
    }

    private static final String drawSmallItem$lambda$4(ItemStack $stack) {
        Intrinsics.checkNotNullParameter((Object)$stack, (String)"$stack");
        return String.valueOf($stack.m_41790_());
    }

    static {
        Minecraft minecraft = Minecraft.m_91087_();
        Intrinsics.checkNotNull((Object)minecraft);
        client = minecraft;
    }
}

