/*
 * Decompiled with CFR 0.152.
 */
package de.rubixdev.inventorio.client.control;

import de.rubixdev.inventorio.client.configscreen.GlobalSettingsScreen;
import de.rubixdev.inventorio.client.configscreen.PlayerSettingsScreen;
import de.rubixdev.inventorio.client.control.InventorioControls;
import de.rubixdev.inventorio.config.PlayerSettings;
import de.rubixdev.inventorio.mixin.client.accessor.MinecraftClientAccessor;
import de.rubixdev.inventorio.player.PlayerInventoryAddon;
import de.rubixdev.inventorio.util.RandomStuff;
import de.rubixdev.inventorio.util.ScrollWheelUtilityBeltMode;
import de.rubixdev.inventorio.util.SegmentedHotbar;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.MultiPlayerGameMode;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

@OnlyIn(value=Dist.CLIENT)
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u00c7\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001b\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\b\u0010\tJ\u001d\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\f\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u001d\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00020\u0011\u00a2\u0006\u0004\b\u0013\u0010\u0014J\r\u0010\u0016\u001a\u00020\u0015\u00a2\u0006\u0004\b\u0016\u0010\u0003\u00a8\u0006\u0017"}, d2={"Lde/rubixdev/inventorio/client/control/InventorioKeyHandler;", "", "<init>", "()V", "Lnet/minecraft/world/entity/player/Player;", "player", "", "Lnet/minecraft/world/InteractionHand;", "handleItemUsage", "(Lnet/minecraft/world/entity/player/Player;)[Lnet/minecraft/world/InteractionHand;", "Lnet/minecraft/world/entity/player/Inventory;", "inventory", "", "slotToSelect", "", "handleSegmentedHotbarSlotSelection", "(Lnet/minecraft/world/entity/player/Inventory;I)Z", "", "scrollAmount", "scrollInHotbar", "(Lnet/minecraft/world/entity/player/Player;D)Z", "", "tick", "inventorio-mc1.20.1-forge"})
public final class InventorioKeyHandler {
    @NotNull
    public static final InventorioKeyHandler INSTANCE = new InventorioKeyHandler();

    private InventorioKeyHandler() {
    }

    @NotNull
    public final InteractionHand[] handleItemUsage(@NotNull Player player) {
        InteractionHand[] interactionHandArray;
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        ItemStack itemStack = player.m_21120_(InteractionHand.MAIN_HAND);
        Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"player.getStackInHand(Hand.MAIN_HAND)");
        boolean useMainHand = RandomStuff.canRMBItem(itemStack);
        ItemStack itemStack2 = player.m_21120_(InteractionHand.OFF_HAND);
        Intrinsics.checkNotNullExpressionValue((Object)itemStack2, (String)"player.getStackInHand(Hand.OFF_HAND)");
        boolean useOffHand = RandomStuff.canRMBItem(itemStack2);
        if (PlayerInventoryAddon.Client.triesToUseUtility) {
            useMainHand = false;
        } else if (!PlayerSettings.useItemAppliesToOffhand.getBoolValue() && !InventorioControls.keyUseUtility.m_90862_()) {
            useOffHand = false;
        }
        if (useMainHand) {
            PlayerInventoryAddon playerInventoryAddon = PlayerInventoryAddon.Companion.getInventoryAddon(player);
            if (playerInventoryAddon != null) {
                ItemStack itemStack3 = ItemStack.f_41583_;
                Intrinsics.checkNotNullExpressionValue((Object)itemStack3, (String)"EMPTY");
                playerInventoryAddon.setDisplayTool(itemStack3);
            }
        }
        if (useMainHand && useOffHand) {
            InteractionHand[] interactionHandArray2 = new InteractionHand[]{InteractionHand.MAIN_HAND, InteractionHand.OFF_HAND};
            interactionHandArray = interactionHandArray2;
        } else if (useMainHand) {
            InteractionHand[] interactionHandArray3 = new InteractionHand[]{InteractionHand.MAIN_HAND};
            interactionHandArray = interactionHandArray3;
        } else if (useOffHand) {
            InteractionHand[] interactionHandArray4 = new InteractionHand[]{InteractionHand.OFF_HAND};
            interactionHandArray = interactionHandArray4;
        } else {
            interactionHandArray = new InteractionHand[]{};
        }
        return interactionHandArray;
    }

    public final boolean handleSegmentedHotbarSlotSelection(@NotNull Inventory inventory, int slotToSelect) {
        Intrinsics.checkNotNullParameter((Object)inventory, (String)"inventory");
        if (PlayerSettings.segmentedHotbar.getValue() == SegmentedHotbar.OFF || PlayerSettings.segmentedHotbar.getValue() == SegmentedHotbar.ONLY_VISUAL) {
            return false;
        }
        if (slotToSelect > 2) {
            return true;
        }
        PlayerInventoryAddon.Client addon = PlayerInventoryAddon.Client.INSTANCE;
        if (PlayerInventoryAddon.Client.selectedHotbarSection == -1) {
            PlayerInventoryAddon.Client.selectedHotbarSection = slotToSelect;
        } else {
            inventory.f_35977_ = slotToSelect + 3 * PlayerInventoryAddon.Client.selectedHotbarSection;
            PlayerInventoryAddon.Client.selectedHotbarSection = -1;
        }
        return true;
    }

    public final boolean scrollInHotbar(@NotNull Player player, double scrollAmount) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Object object = PlayerSettings.scrollWheelUtilityBelt.getValue();
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type de.rubixdev.inventorio.util.ScrollWheelUtilityBeltMode");
        ScrollWheelUtilityBeltMode scrollMode = (ScrollWheelUtilityBeltMode)((Object)object);
        if (scrollMode != ScrollWheelUtilityBeltMode.OFF) {
            int realScrollAmount = scrollMode == ScrollWheelUtilityBeltMode.REGULAR ? -((int)scrollAmount) : (int)scrollAmount;
            PlayerInventoryAddon playerInventoryAddon = PlayerInventoryAddon.Companion.getInventoryAddon(player);
            if (playerInventoryAddon != null) {
                playerInventoryAddon.switchToNextUtility(realScrollAmount, PlayerSettings.skipEmptyUtilitySlots.getBoolValue());
            }
            return true;
        }
        PlayerInventoryAddon.Client.selectedHotbarSection = -1;
        return false;
    }

    public final void tick() {
        Minecraft client = Minecraft.m_91087_();
        LocalPlayer localPlayer = client.f_91074_;
        if (localPlayer == null) {
            return;
        }
        LocalPlayer player = localPlayer;
        PlayerInventoryAddon playerInventoryAddon = PlayerInventoryAddon.Companion.getInventoryAddon((Player)player);
        if (playerInventoryAddon == null) {
            return;
        }
        PlayerInventoryAddon inventoryAddon = playerInventoryAddon;
        Intrinsics.checkNotNull((Object)client, (String)"null cannot be cast to non-null type de.rubixdev.inventorio.mixin.client.accessor.MinecraftClientAccessor");
        if (((MinecraftClientAccessor)client).getItemUseCooldown() <= 0) {
            if (InventorioControls.keyUseUtility.m_90857_() && !player.m_6117_()) {
                PlayerInventoryAddon.Client.INSTANCE.activateSelectedUtility();
            }
            if (player.m_21255_() && InventorioControls.keyFireBoostRocket.isThisOrVanillaPressed()) {
                inventoryAddon.fireRocketFromInventory();
            }
        }
        if (!InventorioControls.keyUseUtility.m_90857_() && PlayerInventoryAddon.Client.isUsingUtility) {
            MultiPlayerGameMode multiPlayerGameMode = client.f_91072_;
            if (multiPlayerGameMode != null) {
                multiPlayerGameMode.m_105277_((Player)player);
            }
        }
        if (InventorioControls.keyNextUtility.m_90859_()) {
            inventoryAddon.switchToNextUtility(1, PlayerSettings.skipEmptyUtilitySlots.getBoolValue());
        }
        if (InventorioControls.keyPrevUtility.m_90859_()) {
            inventoryAddon.switchToNextUtility(-1, PlayerSettings.skipEmptyUtilitySlots.getBoolValue());
        }
        if (InventorioControls.keyEmptyUtility.m_90859_()) {
            inventoryAddon.switchToEmptyUtility(1);
        }
        if (InventorioControls.keyOpenPlayerSettingsMenu.m_90859_()) {
            client.m_91152_(PlayerSettingsScreen.INSTANCE.get(client.f_91080_));
        }
        if (InventorioControls.keyOpenGlobalSettingsMenu.m_90859_()) {
            client.m_91152_(GlobalSettingsScreen.INSTANCE.get(client.f_91080_));
        }
    }
}

