/*
 * Decompiled with CFR 0.152.
 */
package de.rubixdev.inventorio.api;

import com.google.common.collect.ImmutableList;
import de.rubixdev.inventorio.api.InventorioTickHandler;
import de.rubixdev.inventorio.api.ToolBeltSlotTemplate;
import de.rubixdev.inventorio.client.ui.InventorioScreen;
import de.rubixdev.inventorio.config.GlobalSettings;
import de.rubixdev.inventorio.player.InventorioScreenHandler;
import de.rubixdev.inventorio.player.PlayerInventoryAddon;
import de.rubixdev.inventorio.util.ToolBeltMode;
import java.util.function.Consumer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.HoeItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.PickaxeItem;
import net.minecraft.world.item.ShearsItem;
import net.minecraft.world.item.ShovelItem;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.TridentItem;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class InventorioAPI {
    public static final String SLOT_PICKAXE = "pickaxe";
    public static final String SLOT_SWORD = "sword";
    public static final String SLOT_AXE = "axe";
    public static final String SLOT_SHOVEL = "shovel";
    public static final String SLOT_HOE = "hoe";

    private InventorioAPI() {
    }

    public static void registerInventoryTickHandler(@NotNull ResourceLocation customIdentifier, @NotNull InventorioTickHandler tickHandler) {
        PlayerInventoryAddon.registerTickHandler(customIdentifier, tickHandler);
    }

    public static void registerScreenHandlerOpenConsumer(@NotNull ResourceLocation customIdentifier, Consumer<InventorioScreenHandler> screenHandlerConsumer) {
        InventorioScreenHandler.registerOpenConsumer(customIdentifier, screenHandlerConsumer);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void registerInventoryUIInitConsumer(@NotNull ResourceLocation customIdentifier, Consumer<InventorioScreen> uiConsumer) {
        InventorioScreen.registerInitConsumer(customIdentifier, uiConsumer);
    }

    @Nullable
    public static ToolBeltSlotTemplate registerToolBeltSlotIfNotExists(@NotNull String slotName, @NotNull ResourceLocation emptyIcon) {
        return PlayerInventoryAddon.registerToolBeltTemplateIfNotExists(slotName, new ToolBeltSlotTemplate(slotName, emptyIcon));
    }

    @Nullable
    public static ToolBeltSlotTemplate getToolBeltSlotTemplate(@NotNull String slotName) {
        return PlayerInventoryAddon.getToolBeltTemplate(slotName);
    }

    @NotNull
    public static ItemStack findFittingToolBeltStack(@NotNull PlayerInventoryAddon playerInventoryAddon, @NotNull ItemStack sampleStack) {
        return playerInventoryAddon.findFittingToolBeltStack(sampleStack);
    }

    public static int findFittingToolBeltIndex(@NotNull PlayerInventoryAddon playerInventoryAddon, @NotNull ItemStack sampleStack) {
        return playerInventoryAddon.findFittingToolBeltIndex(sampleStack);
    }

    @NotNull
    public static ImmutableList<ToolBeltSlotTemplate> getToolBeltTemplates() {
        return PlayerInventoryAddon.getToolBeltTemplates();
    }

    @Nullable
    public static PlayerInventoryAddon getInventoryAddon(@NotNull Player playerEntity) {
        return PlayerInventoryAddon.getInventoryAddon(playerEntity);
    }

    static {
        if (GlobalSettings.toolBeltMode.getValue() == ToolBeltMode.ENABLED) {
            InventorioAPI.registerToolBeltSlotIfNotExists(SLOT_PICKAXE, new ResourceLocation("inventorio", "textures/gui/empty/pickaxe.png")).addAllowingCondition((itemStack, addon) -> itemStack.m_41720_() instanceof PickaxeItem).addAllowingTag(new ResourceLocation("inventorio", "pickaxes")).addDenyingTag(new ResourceLocation("inventorio", "pickaxes_blacklist"));
            InventorioAPI.registerToolBeltSlotIfNotExists(SLOT_SWORD, new ResourceLocation("inventorio", "textures/gui/empty/sword.png")).addAllowingCondition((itemStack, addon) -> itemStack.m_41720_() instanceof SwordItem || itemStack.m_41720_() instanceof TridentItem).addAllowingTag(new ResourceLocation("inventorio", "swords")).addDenyingTag(new ResourceLocation("inventorio", "swords_blacklist"));
            InventorioAPI.registerToolBeltSlotIfNotExists(SLOT_AXE, new ResourceLocation("inventorio", "textures/gui/empty/axe.png")).addAllowingCondition((itemStack, addon) -> itemStack.m_41720_() instanceof AxeItem).addAllowingTag(new ResourceLocation("inventorio", "axes")).addDenyingTag(new ResourceLocation("inventorio", "axes_blacklist"));
            InventorioAPI.registerToolBeltSlotIfNotExists(SLOT_SHOVEL, new ResourceLocation("inventorio", "textures/gui/empty/shovel.png")).addAllowingCondition((itemStack, addon) -> itemStack.m_41720_() instanceof ShovelItem).addAllowingTag(new ResourceLocation("inventorio", "shovels")).addDenyingTag(new ResourceLocation("inventorio", "shovels_blacklist"));
            InventorioAPI.registerToolBeltSlotIfNotExists(SLOT_HOE, new ResourceLocation("inventorio", "textures/gui/empty/hoe.png")).addAllowingCondition((itemStack, addon) -> itemStack.m_41720_() instanceof HoeItem || itemStack.m_41720_() instanceof ShearsItem).addAllowingTag(new ResourceLocation("inventorio", "hoes")).addDenyingTag(new ResourceLocation("inventorio", "hoes_blacklist"));
        }
    }
}

