/*
 * Decompiled with CFR 0.152.
 */
package com.leclowndu93150.particular.utils;

import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.ChatFormatting;
import net.minecraft.util.Mth;
import org.antlr.v4.runtime.misc.NotNull;

public record OwOColor(float red, float green, float blue, float alpha) {
    public static final OwOColor BLACK = OwOColor.ofRgb(0);
    public static final OwOColor WHITE = OwOColor.ofRgb(0xFFFFFF);
    public static final OwOColor RED = OwOColor.ofRgb(0xFF0000);
    public static final OwOColor GREEN = OwOColor.ofRgb(65280);
    public static final OwOColor BLUE = OwOColor.ofRgb(255);
    private static final Map<String, OwOColor> NAMED_TEXT_COLORS = Stream.of(ChatFormatting.values()).filter(ChatFormatting::m_126664_).collect(Collectors.toMap(formatting -> formatting.m_126666_().toLowerCase(Locale.ROOT).replace("_", "-"), OwOColor::ofFormatting));

    public OwOColor(float red, float green, float blue) {
        this(red, green, blue, 1.0f);
    }

    public static OwOColor ofArgb(int argb) {
        return new OwOColor((float)(argb >> 16 & 0xFF) / 255.0f, (float)(argb >> 8 & 0xFF) / 255.0f, (float)(argb & 0xFF) / 255.0f, (float)(argb >>> 24) / 255.0f);
    }

    public static OwOColor ofRgb(int rgb) {
        return new OwOColor((float)(rgb >> 16 & 0xFF) / 255.0f, (float)(rgb >> 8 & 0xFF) / 255.0f, (float)(rgb & 0xFF) / 255.0f, 1.0f);
    }

    public static OwOColor ofHsv(float hue, float saturation, float value) {
        return OwOColor.ofRgb(Mth.m_14169_((float)(hue - 5.0E-8f), (float)saturation, (float)value));
    }

    public static OwOColor ofHsv(float hue, float saturation, float value, float alpha) {
        return OwOColor.ofArgb((int)(alpha * 255.0f) << 24 | Mth.m_14169_((float)(hue - 5.0E-8f), (float)saturation, (float)value));
    }

    public static OwOColor ofFormatting(@NotNull ChatFormatting formatting) {
        Integer colorValue = formatting.m_126665_();
        return OwOColor.ofRgb(colorValue == null ? 0 : colorValue);
    }

    public static OwOColor random() {
        return OwOColor.ofArgb((int)(Math.random() * 1.6777215E7) | 0xFF000000);
    }

    public int rgb() {
        return (int)(this.red * 255.0f) << 16 | (int)(this.green * 255.0f) << 8 | (int)(this.blue * 255.0f);
    }

    public int argb() {
        return (int)(this.alpha * 255.0f) << 24 | (int)(this.red * 255.0f) << 16 | (int)(this.green * 255.0f) << 8 | (int)(this.blue * 255.0f);
    }

    public float[] hsv() {
        float hue;
        float cmax = Math.max(Math.max(this.red, this.green), this.blue);
        float cmin = Math.min(Math.min(this.red, this.green), this.blue);
        float saturation = cmax != 0.0f ? (cmax - cmin) / cmax : 0.0f;
        if (saturation == 0.0f) {
            hue = 0.0f;
        } else {
            float redc = (cmax - this.red) / (cmax - cmin);
            float greenc = (cmax - this.green) / (cmax - cmin);
            float bluec = (cmax - this.blue) / (cmax - cmin);
            hue = this.red == cmax ? bluec - greenc : (this.green == cmax ? 2.0f + redc - bluec : 4.0f + greenc - redc);
            if ((hue /= 6.0f) < 0.0f) {
                hue += 1.0f;
            }
        }
        return new float[]{hue, saturation, cmax, this.alpha};
    }

    public String asHexString(boolean includeAlpha) {
        return includeAlpha ? String.format("#%08X", this.argb()) : String.format("#%06X", this.rgb());
    }

    public OwOColor interpolate(OwOColor next, float delta) {
        return new OwOColor(Mth.m_14179_((float)delta, (float)this.red, (float)next.red), Mth.m_14179_((float)delta, (float)this.green, (float)next.green), Mth.m_14179_((float)delta, (float)this.blue, (float)next.blue), Mth.m_14179_((float)delta, (float)this.alpha, (float)next.alpha));
    }

    public static OwOColor fromHexString(String hexString) {
        if (!hexString.startsWith("#")) {
            OwOColor color = NAMED_TEXT_COLORS.get(hexString);
            if (color != null) {
                return color;
            }
            throw new IllegalArgumentException("Invalid color value '" + hexString + "', expected hex color of format #RRGGBB or #AARRGGBB or named text color");
        }
        if (hexString.matches("#([A-Fa-f\\d]{2}){3,4}")) {
            return hexString.length() == 7 ? OwOColor.ofRgb(Integer.parseUnsignedInt(hexString.substring(1), 16)) : OwOColor.ofArgb(Integer.parseUnsignedInt(hexString.substring(1), 16));
        }
        throw new IllegalArgumentException("Invalid color value '" + hexString + "', expected hex color of format #RRGGBB or #AARRGGBB or named text color");
    }
}

