/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.voicechat.gui.group;

import de.maxhenkel.voicechat.gui.GameProfileUtils;
import de.maxhenkel.voicechat.gui.volume.AdjustVolumeSlider;
import de.maxhenkel.voicechat.gui.volume.PlayerVolumeEntry;
import de.maxhenkel.voicechat.gui.widgets.ListScreenBase;
import de.maxhenkel.voicechat.gui.widgets.ListScreenEntryBase;
import de.maxhenkel.voicechat.voice.client.ClientManager;
import de.maxhenkel.voicechat.voice.client.ClientVoicechat;
import de.maxhenkel.voicechat.voice.common.PlayerState;
import java.util.Objects;
import net.minecraft.class_10799;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_8685;
import net.minecraft.class_9848;

public class GroupEntry
extends ListScreenEntryBase<GroupEntry> {
    protected static final class_2960 TALK_OUTLINE = class_2960.method_60655((String)"voicechat", (String)"textures/icons/talk_outline.png");
    protected static final class_2960 SPEAKER_OFF = class_2960.method_60655((String)"voicechat", (String)"textures/icons/speaker_small_off.png");
    protected static final int PADDING = 4;
    protected static final int BG_FILL = class_9848.method_61324((int)255, (int)74, (int)74, (int)74);
    protected static final int PLAYER_NAME_COLOR = class_9848.method_61324((int)255, (int)255, (int)255, (int)255);
    protected final ListScreenBase parent;
    protected final class_310 minecraft;
    protected PlayerState state;
    protected final AdjustVolumeSlider volumeSlider;

    public GroupEntry(ListScreenBase parent, PlayerState state) {
        this.parent = parent;
        this.minecraft = class_310.method_1551();
        this.state = state;
        this.volumeSlider = new AdjustVolumeSlider(0, 0, 100, 20, new PlayerVolumeEntry.AdjustPlayerVolumeEntry(state.getUuid(), state.getName()));
        this.children.add(this.volumeSlider);
    }

    public void method_25343(class_332 guiGraphics, int index, int top, int left, int width, int height, int mouseX, int mouseY, boolean hovered, float delta) {
        ClientVoicechat client;
        guiGraphics.method_25294(left, top, left + width, top + height, BG_FILL);
        guiGraphics.method_51448().pushMatrix();
        int outlineSize = height - 8;
        guiGraphics.method_51448().translate((float)(left + 4), (float)(top + 4));
        float scale = (float)outlineSize / 10.0f;
        guiGraphics.method_51448().scale(scale, scale);
        if (!this.state.isDisabled() && (client = ClientManager.getClient()) != null && client.getTalkCache().isTalking(this.state.getUuid())) {
            guiGraphics.method_25290(class_10799.field_56883, TALK_OUTLINE, 0, 0, 0.0f, 0.0f, 10, 10, 16, 16);
        }
        class_8685 skin = GameProfileUtils.getSkin(this.state.getUuid());
        guiGraphics.method_25290(class_10799.field_56883, skin.comp_1626(), 1, 1, 8.0f, 8.0f, 8, 8, 64, 64);
        guiGraphics.method_25290(class_10799.field_56883, skin.comp_1626(), 1, 1, 40.0f, 8.0f, 8, 8, 64, 64);
        if (this.state.isDisabled()) {
            guiGraphics.method_51448().pushMatrix();
            guiGraphics.method_51448().translate(1.0f, 1.0f);
            guiGraphics.method_51448().scale(0.5f, 0.5f);
            guiGraphics.method_25290(class_10799.field_56883, SPEAKER_OFF, 0, 0, 0.0f, 0.0f, 16, 16, 16, 16);
            guiGraphics.method_51448().popMatrix();
        }
        guiGraphics.method_51448().popMatrix();
        class_5250 name = class_2561.method_43470((String)this.state.getName());
        class_327 class_3272 = this.minecraft.field_1772;
        int n = top + height / 2;
        Objects.requireNonNull(this.minecraft.field_1772);
        guiGraphics.method_51439(class_3272, (class_2561)name, left + 4 + outlineSize + 4, n - 9 / 2, PLAYER_NAME_COLOR, false);
        if (hovered && !ClientManager.getPlayerStateManager().getOwnID().equals(this.state.getUuid())) {
            this.volumeSlider.method_25358(Math.min(width - (4 + outlineSize + 4 + this.minecraft.field_1772.method_27525((class_5348)name) + 4 + 4), 100));
            this.volumeSlider.method_48229(left + (width - this.volumeSlider.method_25368() - 4), top + (height - this.volumeSlider.method_25364()) / 2);
            this.volumeSlider.method_25394(guiGraphics, mouseX, mouseY, delta);
        }
    }

    public PlayerState getState() {
        return this.state;
    }

    public void setState(PlayerState state) {
        this.state = state;
    }
}

