/*
 * Decompiled with CFR 0.152.
 */
package info.journeymap.shaded.earcut4j;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;

public final class Earcut {
    private Earcut() {
    }

    public static List<Integer> earcut(double[] data) {
        return Earcut.earcut(data, null, 2);
    }

    public static List<Integer> earcut(double[] data, int[] holeIndices, int dim) {
        boolean hasHoles = holeIndices != null && holeIndices.length > 0;
        int outerLen = hasHoles ? holeIndices[0] * dim : data.length;
        Node outerNode = Earcut.linkedList(data, 0, outerLen, dim, true);
        ArrayList<Integer> triangles = new ArrayList<Integer>();
        if (outerNode == null || outerNode.next == outerNode.prev) {
            return triangles;
        }
        double minX = 0.0;
        double minY = 0.0;
        double maxX = 0.0;
        double maxY = 0.0;
        double invSize = Double.MIN_VALUE;
        if (hasHoles) {
            outerNode = Earcut.eliminateHoles(data, holeIndices, outerNode, dim);
        }
        if (data.length > 80 * dim) {
            minX = maxX = data[0];
            minY = maxY = data[1];
            for (int i = dim; i < outerLen; i += dim) {
                double x = data[i];
                double y = data[i + 1];
                if (x < minX) {
                    minX = x;
                }
                if (y < minY) {
                    minY = y;
                }
                if (x > maxX) {
                    maxX = x;
                }
                if (!(y > maxY)) continue;
                maxY = y;
            }
            invSize = Math.max(maxX - minX, maxY - minY);
            invSize = invSize != 0.0 ? 1.0 / invSize : 0.0;
        }
        Earcut.earcutLinked(outerNode, triangles, dim, minX, minY, invSize, Integer.MIN_VALUE);
        return triangles;
    }

    private static void earcutLinked(Node ear, List<Integer> triangles, int dim, double minX, double minY, double invSize, int pass) {
        if (ear == null) {
            return;
        }
        if (pass == Integer.MIN_VALUE && invSize != Double.MIN_VALUE) {
            Earcut.indexCurve(ear, minX, minY, invSize);
        }
        Node stop = ear;
        while (ear.prev != ear.next) {
            Node prev = ear.prev;
            Node next = ear.next;
            if (invSize != Double.MIN_VALUE ? Earcut.isEarHashed(ear, minX, minY, invSize) : Earcut.isEar(ear)) {
                triangles.add(prev.i / dim);
                triangles.add(ear.i / dim);
                triangles.add(next.i / dim);
                Earcut.removeNode(ear);
                ear = next.next;
                stop = next.next;
                continue;
            }
            ear = next;
            if (ear != stop) continue;
            if (pass == Integer.MIN_VALUE) {
                Earcut.earcutLinked(Earcut.filterPoints(ear, null), triangles, dim, minX, minY, invSize, 1);
                break;
            }
            if (pass == 1) {
                ear = Earcut.cureLocalIntersections(Earcut.filterPoints(ear, null), triangles, dim);
                Earcut.earcutLinked(ear, triangles, dim, minX, minY, invSize, 2);
                break;
            }
            if (pass != 2) break;
            Earcut.splitEarcut(ear, triangles, dim, minX, minY, invSize);
            break;
        }
    }

    private static void splitEarcut(Node start, List<Integer> triangles, int dim, double minX, double minY, double size) {
        Node a = start;
        do {
            Node b = a.next.next;
            while (b != a.prev) {
                if (a.i != b.i && Earcut.isValidDiagonal(a, b)) {
                    Node c = Earcut.splitPolygon(a, b);
                    a = Earcut.filterPoints(a, a.next);
                    c = Earcut.filterPoints(c, c.next);
                    Earcut.earcutLinked(a, triangles, dim, minX, minY, size, Integer.MIN_VALUE);
                    Earcut.earcutLinked(c, triangles, dim, minX, minY, size, Integer.MIN_VALUE);
                    return;
                }
                b = b.next;
            }
        } while ((a = a.next) != start);
    }

    private static boolean isValidDiagonal(Node a, Node b) {
        return a.next.i != b.i && a.prev.i != b.i && !Earcut.intersectsPolygon(a, b) && (Earcut.locallyInside(a, b) && Earcut.locallyInside(b, a) && Earcut.middleInside(a, b) && (Earcut.area(a.prev, a, b.prev) != 0.0 || Earcut.area(a, b.prev, b) != 0.0) || Earcut.equals(a, b) && Earcut.area(a.prev, a, a.next) > 0.0 && Earcut.area(b.prev, b, b.next) > 0.0);
    }

    private static boolean middleInside(Node a, Node b) {
        Node p = a;
        boolean inside = false;
        double px = (a.x + b.x) / 2.0;
        double py = (a.y + b.y) / 2.0;
        do {
            if (p.y > py == p.next.y > py || !(px < (p.next.x - p.x) * (py - p.y) / (p.next.y - p.y) + p.x)) continue;
            boolean bl = inside = !inside;
        } while ((p = p.next) != a);
        return inside;
    }

    private static boolean intersectsPolygon(Node a, Node b) {
        Node p = a;
        do {
            if (p.i == a.i || p.next.i == a.i || p.i == b.i || p.next.i == b.i || !Earcut.intersects(p, p.next, a, b)) continue;
            return true;
        } while ((p = p.next) != a);
        return false;
    }

    private static boolean intersects(Node p1, Node q1, Node p2, Node q2) {
        if (Earcut.equals(p1, p2) && Earcut.equals(q1, q2) || Earcut.equals(p1, q2) && Earcut.equals(p2, q1)) {
            return true;
        }
        double o1 = Earcut.sign(Earcut.area(p1, q1, p2));
        double o2 = Earcut.sign(Earcut.area(p1, q1, q2));
        double o3 = Earcut.sign(Earcut.area(p2, q2, p1));
        double o4 = Earcut.sign(Earcut.area(p2, q2, q1));
        if (o1 != o2 && o3 != o4) {
            return true;
        }
        if (o1 == 0.0 && Earcut.onSegment(p1, p2, q1)) {
            return true;
        }
        if (o2 == 0.0 && Earcut.onSegment(p1, q2, q1)) {
            return true;
        }
        if (o3 == 0.0 && Earcut.onSegment(p2, p1, q2)) {
            return true;
        }
        return o4 == 0.0 && Earcut.onSegment(p2, q1, q2);
    }

    private static boolean onSegment(Node p, Node q, Node r) {
        return q.x <= Math.max(p.x, r.x) && q.x >= Math.min(p.x, r.x) && q.y <= Math.max(p.y, r.y) && q.y >= Math.min(p.y, r.y);
    }

    private static double sign(double num) {
        return num > 0.0 ? 1.0 : (num < 0.0 ? -1.0 : 0.0);
    }

    private static Node cureLocalIntersections(Node start, List<Integer> triangles, int dim) {
        Node p = start;
        do {
            Node b;
            Node a;
            if (Earcut.equals(a = p.prev, b = p.next.next) || !Earcut.intersects(a, p, p.next, b) || !Earcut.locallyInside(a, b) || !Earcut.locallyInside(b, a)) continue;
            triangles.add(a.i / dim);
            triangles.add(p.i / dim);
            triangles.add(b.i / dim);
            Earcut.removeNode(p);
            Earcut.removeNode(p.next);
            p = start = b;
        } while ((p = p.next) != start);
        return Earcut.filterPoints(p, null);
    }

    private static boolean isEar(Node ear) {
        Node a = ear.prev;
        Node b = ear;
        Node c = ear.next;
        if (Earcut.area(a, b, c) >= 0.0) {
            return false;
        }
        Node p = ear.next.next;
        while (p != ear.prev) {
            if (Earcut.pointInTriangle(a.x, a.y, b.x, b.y, c.x, c.y, p.x, p.y) && Earcut.area(p.prev, p, p.next) >= 0.0) {
                return false;
            }
            p = p.next;
        }
        return true;
    }

    private static boolean isEarHashed(Node ear, double minX, double minY, double invSize) {
        double maxTX;
        double minTY;
        double minTX;
        Node a = ear.prev;
        Node b = ear;
        Node c = ear.next;
        if (Earcut.area(a, b, c) >= 0.0) {
            return false;
        }
        double d = a.x < b.x ? (a.x < c.x ? a.x : c.x) : (minTX = b.x < c.x ? b.x : c.x);
        double d2 = a.y < b.y ? (a.y < c.y ? a.y : c.y) : (minTY = b.y < c.y ? b.y : c.y);
        double d3 = a.x > b.x ? (a.x > c.x ? a.x : c.x) : (maxTX = b.x > c.x ? b.x : c.x);
        double maxTY = a.y > b.y ? (a.y > c.y ? a.y : c.y) : (b.y > c.y ? b.y : c.y);
        double minZ = Earcut.zOrder(minTX, minTY, minX, minY, invSize);
        double maxZ = Earcut.zOrder(maxTX, maxTY, minX, minY, invSize);
        Node p = ear.prevZ;
        Node n = ear.nextZ;
        while (p != null && p.z >= minZ && n != null && n.z <= maxZ) {
            if (p != ear.prev && p != ear.next && Earcut.pointInTriangle(a.x, a.y, b.x, b.y, c.x, c.y, p.x, p.y) && Earcut.area(p.prev, p, p.next) >= 0.0) {
                return false;
            }
            p = p.prevZ;
            if (n != ear.prev && n != ear.next && Earcut.pointInTriangle(a.x, a.y, b.x, b.y, c.x, c.y, n.x, n.y) && Earcut.area(n.prev, n, n.next) >= 0.0) {
                return false;
            }
            n = n.nextZ;
        }
        while (p != null && p.z >= minZ) {
            if (p != ear.prev && p != ear.next && Earcut.pointInTriangle(a.x, a.y, b.x, b.y, c.x, c.y, p.x, p.y) && Earcut.area(p.prev, p, p.next) >= 0.0) {
                return false;
            }
            p = p.prevZ;
        }
        while (n != null && n.z <= maxZ) {
            if (n != ear.prev && n != ear.next && Earcut.pointInTriangle(a.x, a.y, b.x, b.y, c.x, c.y, n.x, n.y) && Earcut.area(n.prev, n, n.next) >= 0.0) {
                return false;
            }
            n = n.nextZ;
        }
        return true;
    }

    private static double zOrder(double x, double y, double minX, double minY, double invSize) {
        int lx = Double.valueOf(32767.0 * (x - minX) * invSize).intValue();
        int ly = Double.valueOf(32767.0 * (y - minY) * invSize).intValue();
        lx = (lx | lx << 8) & 0xFF00FF;
        lx = (lx | lx << 4) & 0xF0F0F0F;
        lx = (lx | lx << 2) & 0x33333333;
        lx = (lx | lx << 1) & 0x55555555;
        ly = (ly | ly << 8) & 0xFF00FF;
        ly = (ly | ly << 4) & 0xF0F0F0F;
        ly = (ly | ly << 2) & 0x33333333;
        ly = (ly | ly << 1) & 0x55555555;
        return lx | ly << 1;
    }

    private static void indexCurve(Node start, double minX, double minY, double invSize) {
        Node p = start;
        do {
            if (p.z == Double.MIN_VALUE) {
                p.z = Earcut.zOrder(p.x, p.y, minX, minY, invSize);
            }
            p.prevZ = p.prev;
            p.nextZ = p.next;
        } while ((p = p.next) != start);
        p.prevZ.nextZ = null;
        p.prevZ = null;
        Earcut.sortLinked(p);
    }

    private static Node sortLinked(Node list) {
        int numMerges;
        int inSize = 1;
        do {
            Node p = list;
            list = null;
            Node tail = null;
            numMerges = 0;
            while (p != null) {
                ++numMerges;
                Node q = p;
                int pSize = 0;
                for (int i = 0; i < inSize; ++i) {
                    ++pSize;
                    q = q.nextZ;
                    if (q == null) break;
                }
                int qSize = inSize;
                while (pSize > 0 || qSize > 0 && q != null) {
                    Node e;
                    if (pSize == 0) {
                        e = q;
                        q = q.nextZ;
                        --qSize;
                    } else if (qSize == 0 || q == null) {
                        e = p;
                        p = p.nextZ;
                        --pSize;
                    } else if (p.z <= q.z) {
                        e = p;
                        p = p.nextZ;
                        --pSize;
                    } else {
                        e = q;
                        q = q.nextZ;
                        --qSize;
                    }
                    if (tail != null) {
                        tail.nextZ = e;
                    } else {
                        list = e;
                    }
                    e.prevZ = tail;
                    tail = e;
                }
                p = q;
            }
            tail.nextZ = null;
            inSize *= 2;
        } while (numMerges > 1);
        return list;
    }

    private static Node eliminateHoles(double[] data, int[] holeIndices, Node outerNode, int dim) {
        ArrayList<Node> queue = new ArrayList<Node>();
        int len = holeIndices.length;
        for (int i = 0; i < len; ++i) {
            int start = holeIndices[i] * dim;
            int end = i < len - 1 ? holeIndices[i + 1] * dim : data.length;
            Node list = Earcut.linkedList(data, start, end, dim, false);
            if (list == list.next) {
                list.steiner = true;
            }
            queue.add(Earcut.getLeftmost(list));
        }
        queue.sort(new Comparator<Node>(){

            @Override
            public int compare(Node o1, Node o2) {
                if (o1.x - o2.x > 0.0) {
                    return 1;
                }
                if (o1.x - o2.x < 0.0) {
                    return -2;
                }
                return 0;
            }
        });
        for (Node node : queue) {
            Earcut.eliminateHole(node, outerNode);
            outerNode = Earcut.filterPoints(outerNode, outerNode.next);
        }
        return outerNode;
    }

    private static Node filterPoints(Node start, Node end) {
        boolean again;
        if (start == null) {
            return start;
        }
        if (end == null) {
            end = start;
        }
        Node p = start;
        do {
            again = false;
            if (!p.steiner && Earcut.equals(p, p.next) || Earcut.area(p.prev, p, p.next) == 0.0) {
                Earcut.removeNode(p);
                p = end = p.prev;
                if (p == p.next) break;
                again = true;
                continue;
            }
            p = p.next;
        } while (again || p != end);
        return end;
    }

    private static boolean equals(Node p1, Node p2) {
        return p1.x == p2.x && p1.y == p2.y;
    }

    private static double area(Node p, Node q, Node r) {
        return (q.y - p.y) * (r.x - q.x) - (q.x - p.x) * (r.y - q.y);
    }

    private static void eliminateHole(Node hole, Node outerNode) {
        if ((outerNode = Earcut.findHoleBridge(hole, outerNode)) != null) {
            Node b = Earcut.splitPolygon(outerNode, hole);
            Earcut.filterPoints(outerNode, outerNode.next);
            Earcut.filterPoints(b, b.next);
        }
    }

    private static Node splitPolygon(Node a, Node b) {
        Node a2 = new Node(a.i, a.x, a.y);
        Node b2 = new Node(b.i, b.x, b.y);
        Node an = a.next;
        Node bp = b.prev;
        a.next = b;
        b.prev = a;
        a2.next = an;
        an.prev = a2;
        b2.next = a2;
        a2.prev = b2;
        bp.next = b2;
        b2.prev = bp;
        return b2;
    }

    private static Node findHoleBridge(Node hole, Node outerNode) {
        Node p = outerNode;
        double hx = hole.x;
        double hy = hole.y;
        double qx = -1.7976931348623157E308;
        Node m = null;
        do {
            double x;
            if (!(hy <= p.y) || !(hy >= p.next.y) || !((x = p.x + (hy - p.y) * (p.next.x - p.x) / (p.next.y - p.y)) <= hx) || !(x > qx)) continue;
            qx = x;
            if (x == hx) {
                if (hy == p.y) {
                    return p;
                }
                if (hy == p.next.y) {
                    return p.next;
                }
            }
            Node node = m = p.x < p.next.x ? p : p.next;
        } while ((p = p.next) != outerNode);
        if (m == null) {
            return null;
        }
        if (hx == qx) {
            return m;
        }
        Node stop = m;
        double mx = m.x;
        double my = m.y;
        double tanMin = Double.MAX_VALUE;
        p = m;
        while (p != stop) {
            if (hx >= p.x && p.x >= mx && Earcut.pointInTriangle(hy < my ? hx : qx, hy, mx, my, hy < my ? qx : hx, hy, p.x, p.y)) {
                double tan = Math.abs(hy - p.y) / (hx - p.x);
                if (Earcut.locallyInside(p, hole) && (tan < tanMin || tan == tanMin && (p.x > m.x || p.x == m.x && Earcut.sectorContainsSector(m, p)))) {
                    m = p;
                    tanMin = tan;
                }
            }
            p = p.next;
        }
        return m;
    }

    private static boolean locallyInside(Node a, Node b) {
        return Earcut.area(a.prev, a, a.next) < 0.0 ? Earcut.area(a, b, a.next) >= 0.0 && Earcut.area(a, a.prev, b) >= 0.0 : Earcut.area(a, b, a.prev) < 0.0 || Earcut.area(a, a.next, b) < 0.0;
    }

    private static boolean sectorContainsSector(Node m, Node p) {
        return Earcut.area(m.prev, m, p.prev) < 0.0 && Earcut.area(p.next, m, m.next) < 0.0;
    }

    private static boolean pointInTriangle(double ax, double ay, double bx, double by, double cx, double cy, double px, double py) {
        return (cx - px) * (ay - py) - (ax - px) * (cy - py) >= 0.0 && (ax - px) * (by - py) - (bx - px) * (ay - py) >= 0.0 && (bx - px) * (cy - py) - (cx - px) * (by - py) >= 0.0;
    }

    private static Node getLeftmost(Node start) {
        Node p = start;
        Node leftmost = start;
        do {
            if (!(p.x < leftmost.x) && (p.x != leftmost.x || !(p.y < leftmost.y))) continue;
            leftmost = p;
        } while ((p = p.next) != start);
        return leftmost;
    }

    private static Node linkedList(double[] data, int start, int end, int dim, boolean clockwise) {
        Node last = null;
        if (clockwise == Earcut.signedArea(data, start, end, dim) > 0.0) {
            for (int i = start; i < end; i += dim) {
                last = Earcut.insertNode(i, data[i], data[i + 1], last);
            }
        } else {
            for (int i = end - dim; i >= start; i -= dim) {
                last = Earcut.insertNode(i, data[i], data[i + 1], last);
            }
        }
        if (last != null && Earcut.equals(last, last.next)) {
            Earcut.removeNode(last);
            last = last.next;
        }
        return last;
    }

    private static void removeNode(Node p) {
        p.next.prev = p.prev;
        p.prev.next = p.next;
        if (p.prevZ != null) {
            p.prevZ.nextZ = p.nextZ;
        }
        if (p.nextZ != null) {
            p.nextZ.prevZ = p.prevZ;
        }
    }

    private static Node insertNode(int i, double x, double y, Node last) {
        Node p = new Node(i, x, y);
        if (last == null) {
            p.prev = p;
            p.next = p;
        } else {
            p.next = last.next;
            p.prev = last;
            last.next.prev = p;
            last.next = p;
        }
        return p;
    }

    private static double signedArea(double[] data, int start, int end, int dim) {
        double sum = 0.0;
        int j = end - dim;
        for (int i = start; i < end; i += dim) {
            sum += (data[j] - data[i]) * (data[i + 1] + data[j + 1]);
            j = i;
        }
        return sum;
    }

    private static class Node {
        int i;
        double x;
        double y;
        double z;
        boolean steiner;
        Node prev;
        Node next;
        Node prevZ;
        Node nextZ;

        Node(int i, double x, double y) {
            this.i = i;
            this.x = x;
            this.y = y;
            this.prev = null;
            this.next = null;
            this.z = Double.MIN_VALUE;
            this.prevZ = null;
            this.nextZ = null;
            this.steiner = false;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("{i: ").append(this.i).append(", x: ").append(this.x).append(", y: ").append(this.y).append(", prev: ").append(this.prev).append(", next: ").append(this.next);
            return sb.toString();
        }
    }
}

