/*
 * Decompiled with CFR 0.152.
 */
package com.cgessinger.creaturesandbeasts.util;

import java.util.LinkedHashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import org.apache.commons.lang3.tuple.Pair;

public class SporelingType {
    private static final Map<ResourceLocation, SporelingType> SPORELING_TYPES = new LinkedHashMap<ResourceLocation, SporelingType>();
    private ResourceLocation id;
    private Pair<ResourceLocation, ResourceLocation> modelAndTexture;
    private SporelingHostility hostility;

    public SporelingType(ResourceLocation id, ResourceLocation model, ResourceLocation texture, SporelingHostility hostility) {
        this(id, (Pair<ResourceLocation, ResourceLocation>)Pair.of((Object)model, (Object)texture), hostility);
    }

    public SporelingType(ResourceLocation id, Pair<ResourceLocation, ResourceLocation> modelAndTexture, SporelingHostility hostility) {
        this.id = id;
        this.modelAndTexture = modelAndTexture;
        this.hostility = hostility;
    }

    public ResourceLocation getId() {
        return this.id;
    }

    public void setId(ResourceLocation id) {
        this.id = id;
    }

    public ResourceLocation getTextureLocation() {
        return (ResourceLocation)this.modelAndTexture.getRight();
    }

    public void setTextureLocation(ResourceLocation textureLocation) {
        this.modelAndTexture = Pair.of((Object)((ResourceLocation)this.modelAndTexture.getLeft()), (Object)textureLocation);
    }

    public ResourceLocation getModelLocation() {
        return (ResourceLocation)this.modelAndTexture.getLeft();
    }

    public void setModelLocation(ResourceLocation modelLocation) {
        this.modelAndTexture = Pair.of((Object)modelLocation, (Object)((ResourceLocation)this.modelAndTexture.getRight()));
    }

    public SporelingHostility getHostility() {
        return this.hostility;
    }

    public void setHostility(SporelingHostility hostility) {
        this.hostility = hostility;
    }

    public static SporelingType registerSporelingType(SporelingType sporelingType) {
        ResourceLocation id = sporelingType.getId();
        if (SPORELING_TYPES.containsKey(id)) {
            throw new IllegalStateException(String.format("%s already exists in the SporelingType registry.", id.toString()));
        }
        SPORELING_TYPES.put(id, sporelingType);
        return sporelingType;
    }

    @Nullable
    public static SporelingType getById(@Nullable String id) {
        if (id == null) {
            return null;
        }
        return SporelingType.getById(ResourceLocation.m_135820_((String)id));
    }

    @Nullable
    public static SporelingType getById(@Nullable ResourceLocation id) {
        return SPORELING_TYPES.get(id);
    }

    public boolean equals(Object obj) {
        if (obj instanceof SporelingType) {
            SporelingType type = (SporelingType)obj;
            return type.getId().equals((Object)this.getId()) && type.getModelLocation().equals((Object)this.getModelLocation()) && type.getTextureLocation().equals((Object)this.getTextureLocation());
        }
        return false;
    }

    public static enum SporelingHostility {
        HOSTILE,
        NEUTRAL,
        FRIENDLY;

    }
}

