/*
 * Decompiled with CFR 0.152.
 */
package com.cgessinger.creaturesandbeasts.util;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Supplier;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;

public class LilytadType {
    private static final Map<ResourceLocation, LilytadType> LILYTAD_TYPES = new LinkedHashMap<ResourceLocation, LilytadType>();
    private ResourceLocation id;
    private ResourceLocation texture;
    private Supplier<Item> shearItem;

    public LilytadType(@Nullable Item shearItem, ResourceLocation id, ResourceLocation texture) {
        this(() -> shearItem, id, texture);
    }

    public LilytadType(@Nullable Supplier<Item> shearItem, ResourceLocation id, ResourceLocation texture) {
        this.id = id;
        this.texture = texture;
        this.shearItem = shearItem;
    }

    @CheckForNull
    public Item getShearItem() {
        Item item = this.shearItem.get();
        if (item == null || item.equals(Items.f_41852_)) {
            return null;
        }
        return item;
    }

    public void setShearItem(@Nullable Item shearItem) {
        this.shearItem = () -> shearItem;
    }

    public ResourceLocation getId() {
        return this.id;
    }

    public void setId(ResourceLocation id) {
        this.id = id;
    }

    public ResourceLocation getTextureLocation() {
        return this.texture;
    }

    public void setTextureLocation(ResourceLocation textureLocation) {
        this.texture = textureLocation;
    }

    public static LilytadType registerLilytadType(LilytadType minipadType) {
        ResourceLocation id = minipadType.getId();
        if (LILYTAD_TYPES.containsKey(id)) {
            throw new IllegalStateException(String.format("%s already exists in the LilytadType registry.", id.toString()));
        }
        LILYTAD_TYPES.put(id, minipadType);
        return minipadType;
    }

    @Nullable
    public static LilytadType getById(@Nullable String id) {
        if (id == null) {
            return null;
        }
        return LilytadType.getById(ResourceLocation.m_135820_((String)id));
    }

    @Nullable
    public static LilytadType getById(@Nullable ResourceLocation id) {
        return LILYTAD_TYPES.get(id);
    }

    public boolean equals(Object obj) {
        if (obj instanceof LilytadType) {
            LilytadType type = (LilytadType)obj;
            return type.getId().equals((Object)this.getId()) && type.getTextureLocation().equals((Object)this.getTextureLocation());
        }
        return false;
    }
}

