/*
 * Decompiled with CFR 0.152.
 */
package com.cgessinger.creaturesandbeasts.items;

import com.cgessinger.creaturesandbeasts.capabilities.CinderSwordCapability;
import com.cgessinger.creaturesandbeasts.capabilities.CinderSwordWrapper;
import com.cgessinger.creaturesandbeasts.capabilities.ICinderSwordUpdate;
import com.cgessinger.creaturesandbeasts.init.CNBItems;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.registries.RegistryObject;

public class CinderSwordItem
extends SwordItem {
    private static final List<RegistryObject<CinderSwordItem>> IMBUE_TIERS = List.of(CNBItems.CINDER_SWORD, CNBItems.CINDER_SWORD_1, CNBItems.CINDER_SWORD_2, CNBItems.CINDER_SWORD_3, CNBItems.CINDER_SWORD_4);
    private final int imbueLevel;

    public CinderSwordItem(Tier tier, int imbueLevel, int attackDamageModifier, float attackSpeedModifier, Item.Properties properties) {
        super(tier, attackDamageModifier, attackSpeedModifier, properties);
        this.imbueLevel = imbueLevel;
    }

    public boolean m_7579_(ItemStack stack, LivingEntity targetEntity, LivingEntity attackingEntity) {
        if (this.imbueLevel > 0) {
            targetEntity.m_20254_(2 * this.imbueLevel);
        }
        return super.m_7579_(stack, targetEntity, attackingEntity);
    }

    public void m_6883_(ItemStack stack, Level level, Entity entity, int slotNumber, boolean isSelected) {
        LazyOptional capability = stack.getCapability(CinderSwordCapability.CINDER_SWORD_CAPABILITY);
        int imbuedTicks = (Integer)capability.map(ICinderSwordUpdate::getImbuedTicks).get();
        if (imbuedTicks > 0) {
            capability.map(handler -> handler.setImbuedTicks(imbuedTicks - 1));
        } else if (this.imbueLevel > 0 && entity instanceof Player) {
            Player player = (Player)entity;
            ItemStack sword = new ItemStack((ItemLike)IMBUE_TIERS.get(this.imbueLevel - 1).get());
            if (this.imbueLevel == 1) {
                player.m_5496_(SoundEvents.f_11937_, 1.0f, 1.0f);
            }
            sword.m_41751_(stack.m_41784_());
            sword.getCapability(CinderSwordCapability.CINDER_SWORD_CAPABILITY).map(handler -> handler.setImbuedTicks(400));
            player.m_150109_().m_6836_(slotNumber, sword);
        }
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        ItemStack itemstack = player.m_21120_(hand);
        BlockHitResult blockhitresult = CinderSwordItem.m_41435_((Level)level, (Player)player, (ClipContext.Fluid)ClipContext.Fluid.SOURCE_ONLY);
        BlockPos pos = blockhitresult.m_82425_();
        if (level.m_6425_(pos).m_192917_((Fluid)Fluids.f_76195_)) {
            ItemStack imbuedSword = new ItemStack((ItemLike)IMBUE_TIERS.get(IMBUE_TIERS.size() - 1).get());
            imbuedSword.m_41751_(itemstack.m_41784_());
            imbuedSword.getCapability(CinderSwordCapability.CINDER_SWORD_CAPABILITY).map(handler -> handler.setImbuedTicks(400));
            player.m_21008_(hand, imbuedSword);
            player.m_5496_(SoundEvents.f_11783_, 1.0f, 1.0f);
            return InteractionResultHolder.m_19090_((Object)itemstack);
        }
        return super.m_7203_(level, player, hand);
    }

    public boolean onDroppedByPlayer(ItemStack item, Player player) {
        return super.onDroppedByPlayer(item, player);
    }

    @Nullable
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundTag nbt) {
        if (((Object)((Object)this)).getClass() == CinderSwordItem.class) {
            return new CinderSwordWrapper();
        }
        return super.initCapabilities(stack, nbt);
    }
}

