/*
 * Decompiled with CFR 0.152.
 */
package com.cgessinger.creaturesandbeasts.items;

import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.animal.Bucketable;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.material.FlowingFluid;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;

public class CNBEntityBucketItem
extends BucketItem {
    private final Supplier<? extends EntityType<?>> entityTypeSupplier;
    private final Supplier<SoundEvent> emptyingSoundSupplier;

    public CNBEntityBucketItem(Supplier<EntityType<?>> entityType, Fluid fluid, Supplier<SoundEvent> emptyingSound, Item.Properties builder) {
        super(() -> fluid, builder);
        this.entityTypeSupplier = entityType;
        this.emptyingSoundSupplier = emptyingSound;
    }

    public void m_142131_(@Nullable Player player, Level worldIn, ItemStack stack, BlockPos pos) {
        if (worldIn instanceof ServerLevel) {
            this.placeEntity((ServerLevel)worldIn, stack, pos);
        }
    }

    protected void m_7718_(@Nullable Player player, LevelAccessor worldIn, BlockPos pos) {
        worldIn.m_5594_(player, pos, this.emptyingSoundSupplier.get(), SoundSource.NEUTRAL, 1.0f, 1.0f);
    }

    private void placeEntity(ServerLevel worldIn, ItemStack stack, BlockPos pos) {
        Entity entity = this.entityTypeSupplier.get().m_20592_(worldIn, stack, null, pos, MobSpawnType.BUCKET, true, true);
        if (entity instanceof Bucketable) {
            Bucketable bucketable = (Bucketable)entity;
            bucketable.m_142278_(stack.m_41784_());
            bucketable.m_27497_(true);
        }
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level worldIn, Player playerIn, InteractionHand handIn) {
        InteractionResultHolder actionResult = super.m_7203_(worldIn, playerIn, handIn);
        ItemStack heldItem = playerIn.m_21120_(handIn);
        BlockHitResult rayTraceResult = CNBEntityBucketItem.m_41435_((Level)worldIn, (Player)playerIn, (ClipContext.Fluid)ClipContext.Fluid.SOURCE_ONLY);
        if (rayTraceResult.m_6662_() != HitResult.Type.BLOCK) {
            return InteractionResultHolder.m_19098_((Object)heldItem);
        }
        if (!(worldIn instanceof ServerLevel)) {
            return InteractionResultHolder.m_19090_((Object)heldItem);
        }
        BlockPos pos = rayTraceResult.m_82425_();
        if (!(worldIn.m_6425_(pos).m_76152_() instanceof FlowingFluid)) {
            return InteractionResultHolder.m_19098_((Object)heldItem);
        }
        return actionResult;
    }
}

