/*
 * Decompiled with CFR 0.152.
 */
package com.cgessinger.creaturesandbeasts.init;

import com.cgessinger.creaturesandbeasts.init.CNBItems;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraftforge.common.loot.IGlobalLootModifier;
import net.minecraftforge.common.loot.LootModifier;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegistryObject;

public class CNBLootModifiers {
    public static final DeferredRegister<Codec<? extends IGlobalLootModifier>> LOOT_MODIFIERS = DeferredRegister.create((ResourceKey)ForgeRegistries.Keys.GLOBAL_LOOT_MODIFIER_SERIALIZERS, (String)"cnb");
    public static final RegistryObject<Codec<NetherBridgeLootModifier>> NETHER_BRIDGE_LOOT_MODIFIER = LOOT_MODIFIERS.register("nether_bridge_loot_modifier", () -> NetherBridgeLootModifier.CODEC);

    protected static class NetherBridgeLootModifier
    extends LootModifier {
        public static final Codec<NetherBridgeLootModifier> CODEC = RecordCodecBuilder.create(inst -> NetherBridgeLootModifier.codecStart((RecordCodecBuilder.Instance)inst).apply((Applicative)inst, NetherBridgeLootModifier::new));
        private final Random rand = new Random();

        protected NetherBridgeLootModifier(LootItemCondition[] conditionsIn) {
            super(conditionsIn);
        }

        @Nonnull
        protected ObjectArrayList<ItemStack> doApply(ObjectArrayList<ItemStack> generatedLoot, LootContext context) {
            if (this.rand.nextInt(73) < 5) {
                generatedLoot.add((Object)new ItemStack((ItemLike)CNBItems.CINDERSHELL_SHELL_SHARD.get(), this.rand.nextInt(3) + 1));
            }
            return generatedLoot;
        }

        public Codec<? extends IGlobalLootModifier> codec() {
            return CODEC;
        }
    }
}

