/*
 * Decompiled with CFR 0.152.
 */
package com.cgessinger.creaturesandbeasts.entities;

import com.cgessinger.creaturesandbeasts.init.CNBEntityTypes;
import com.cgessinger.creaturesandbeasts.init.CNBItems;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;

public class ThrownCactemSpearEntity
extends AbstractArrow {
    private static final EntityDataAccessor<Byte> ID_LOYALTY = SynchedEntityData.m_135353_(ThrownCactemSpearEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    private static final EntityDataAccessor<Boolean> IS_FOIL = SynchedEntityData.m_135353_(ThrownCactemSpearEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<ItemStack> SPEAR = SynchedEntityData.m_135353_(ThrownCactemSpearEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135033_);
    private boolean dealtDamage;
    public int clientSideReturnSpearTickCount;

    public ThrownCactemSpearEntity(EntityType<? extends ThrownCactemSpearEntity> entityType, Level level) {
        super(entityType, level);
    }

    public ThrownCactemSpearEntity(Level level, LivingEntity entity, ItemStack itemStack) {
        super((EntityType)CNBEntityTypes.THROWN_CACTEM_SPEAR.get(), entity, level);
        this.f_19804_.m_135381_(IS_FOIL, (Object)itemStack.m_41790_());
        this.f_19804_.m_135381_(ID_LOYALTY, (Object)((byte)EnchantmentHelper.m_44928_((ItemStack)itemStack)));
        this.f_19804_.m_135381_(SPEAR, (Object)itemStack);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(ID_LOYALTY, (Object)0);
        this.f_19804_.m_135372_(IS_FOIL, (Object)false);
        this.f_19804_.m_135372_(SPEAR, (Object)new ItemStack((ItemLike)CNBItems.CACTEM_SPEAR.get()));
    }

    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        if (tag.m_128425_("CactemSpear", 10)) {
            this.f_19804_.m_135381_(SPEAR, (Object)ItemStack.m_41712_((CompoundTag)tag.m_128469_("CactemSpear")));
        }
        this.dealtDamage = tag.m_128471_("DealtDamage");
        this.f_19804_.m_135381_(ID_LOYALTY, (Object)((byte)EnchantmentHelper.m_44928_((ItemStack)this.getSpear())));
    }

    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128365_("CactemSpear", (Tag)this.getSpear().m_41739_(new CompoundTag()));
        tag.m_128379_("DealtDamage", this.dealtDamage);
    }

    public void m_8119_() {
        if (this.f_36704_ > 4) {
            this.dealtDamage = true;
        }
        Entity entity = this.m_37282_();
        byte i = (Byte)this.f_19804_.m_135370_(ID_LOYALTY);
        if (i > 0 && (this.dealtDamage || this.m_36797_()) && entity != null) {
            if (!this.isAcceptibleReturnOwner()) {
                if (!this.f_19853_.f_46443_ && this.f_36705_ == AbstractArrow.Pickup.ALLOWED) {
                    this.m_5552_(this.m_7941_(), 0.1f);
                }
                this.m_146870_();
            } else {
                this.m_36790_(true);
                Vec3 vec3 = entity.m_146892_().m_82546_(this.m_20182_());
                this.m_20343_(this.m_20185_(), this.m_20186_() + vec3.f_82480_ * 0.015 * (double)i, this.m_20189_());
                if (this.f_19853_.f_46443_) {
                    this.f_19791_ = this.m_20186_();
                }
                double d0 = 0.05 * (double)i;
                this.m_20256_(this.m_20184_().m_82490_(0.95).m_82549_(vec3.m_82541_().m_82490_(d0)));
                if (this.clientSideReturnSpearTickCount == 0) {
                    this.m_5496_(SoundEvents.f_12516_, 10.0f, 1.0f);
                }
                ++this.clientSideReturnSpearTickCount;
            }
        }
        super.m_8119_();
    }

    protected ItemStack m_7941_() {
        return this.getSpear().m_41777_();
    }

    public boolean isFoil() {
        return (Boolean)this.f_19804_.m_135370_(IS_FOIL);
    }

    public ItemStack getSpear() {
        return (ItemStack)this.f_19804_.m_135370_(SPEAR);
    }

    @Nullable
    protected EntityHitResult m_6351_(Vec3 vec1, Vec3 vec2) {
        return this.dealtDamage ? null : super.m_6351_(vec1, vec2);
    }

    private boolean isAcceptibleReturnOwner() {
        Entity entity = this.m_37282_();
        if (entity != null && entity.m_6084_()) {
            return !(entity instanceof ServerPlayer) || !entity.m_5833_();
        }
        return false;
    }

    protected void m_5790_(EntityHitResult hitResult) {
        Entity projectileThrower;
        Entity hitEntity = hitResult.m_82443_();
        float f = 5.0f;
        float bonusDamage = 0.0f;
        if (hitEntity instanceof LivingEntity) {
            LivingEntity livingentity = (LivingEntity)hitEntity;
            bonusDamage = EnchantmentHelper.m_44833_((ItemStack)this.getSpear(), (MobType)livingentity.m_6336_());
            f += bonusDamage;
        }
        DamageSource damagesource = DamageSource.m_19361_((Entity)this, (Entity)((projectileThrower = this.m_37282_()) == null ? this : projectileThrower));
        this.dealtDamage = true;
        SoundEvent soundevent = SoundEvents.f_12514_;
        if (hitEntity.m_6469_(damagesource, f)) {
            if (hitEntity.m_6095_() == EntityType.f_20566_) {
                return;
            }
            if (hitEntity instanceof LivingEntity) {
                Vec3 vec3;
                double knockback;
                int fireAspectLevel;
                LivingEntity hitLivingEntity = (LivingEntity)hitEntity;
                if (projectileThrower instanceof LivingEntity) {
                    EnchantmentHelper.m_44823_((LivingEntity)hitLivingEntity, (Entity)projectileThrower);
                    EnchantmentHelper.m_44896_((LivingEntity)((LivingEntity)projectileThrower), (Entity)hitLivingEntity);
                }
                if ((fireAspectLevel = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44981_, (ItemStack)this.getSpear())) > 0) {
                    hitEntity.m_20254_(fireAspectLevel * 4);
                }
                if ((knockback = (double)EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44980_, (ItemStack)this.getSpear())) > 0.0 && (vec3 = this.m_20184_().m_82542_(1.0, 0.0, 1.0).m_82541_().m_82490_(knockback * 0.6)).m_82556_() > 0.0) {
                    hitEntity.m_5997_(vec3.f_82479_, 0.1, vec3.f_82481_);
                }
                this.m_7761_(hitLivingEntity);
            }
        }
        this.m_20256_(this.m_20184_().m_82542_(-0.01, -0.1, -0.01));
        float f1 = 1.0f;
        this.m_5496_(soundevent, f1, 1.0f);
    }

    protected boolean m_142470_(Player player) {
        return super.m_142470_(player) || this.m_36797_() && this.m_150171_((Entity)player) && player.m_150109_().m_36054_(this.m_7941_());
    }

    protected SoundEvent m_7239_() {
        return SoundEvents.f_12515_;
    }

    public void m_6123_(Player player) {
        if (this.m_150171_((Entity)player) || this.m_37282_() == null) {
            super.m_6123_(player);
        }
    }

    public void m_6901_() {
        byte i = (Byte)this.f_19804_.m_135370_(ID_LOYALTY);
        if (this.f_36705_ != AbstractArrow.Pickup.ALLOWED || i <= 0) {
            super.m_6901_();
        }
    }

    public boolean m_6000_(double p_37588_, double p_37589_, double p_37590_) {
        return true;
    }
}

