/*
 * Decompiled with CFR 0.152.
 */
package com.cgessinger.creaturesandbeasts.config.library.element;

import com.cgessinger.creaturesandbeasts.config.library.annotation.Configurable;
import com.cgessinger.creaturesandbeasts.config.library.element.IConfigElement;
import com.cgessinger.creaturesandbeasts.config.library.element.handler.IConfigElementHandler;
import com.cgessinger.creaturesandbeasts.config.library.util.Util;
import com.cgessinger.creaturesandbeasts.config.library.util.annotation.Nullable;
import java.lang.reflect.Field;

public class ConfigElement<T>
implements IConfigElement<T> {
    private final Field field;
    private final IConfigElementHandler<T, ?> handler;
    private final T defaultValue;
    private String translationKey;
    private String comment;
    private T value;
    private final String category;
    private String[] tags;

    public ConfigElement(Field field, IConfigElementHandler<T, ?> handler) {
        Configurable configurable = field.getAnnotation(Configurable.class);
        String description = configurable.description();
        String translationKey = configurable.translationKey();
        this.field = field;
        this.handler = handler;
        this.value = null;
        this.comment = "";
        if (!description.isEmpty()) {
            this.comment = description;
        }
        this.translationKey = translationKey.isEmpty() ? field.getName() : translationKey;
        this.category = Util.getCategory(field);
        try {
            this.defaultValue = this.field.get(field.getDeclaringClass());
        }
        catch (IllegalArgumentException e) {
            throw new IllegalStateException(String.format("Field is not static\n\tat: %s", field.toGenericString()), e);
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException(String.format("Field is not public\n\tat: %s", field.toGenericString()), e);
        }
        catch (ClassCastException e) {
            throw new IllegalStateException(String.format("Field is not of type \"%s\"\n\tat: %s", field.getType().getName(), field.toGenericString()), e);
        }
        if (this.defaultValue == null) {
            throw new IllegalStateException(String.format("Default value is null for field \"%s\"\n\tat: %s", this.field.getName(), this.field.toGenericString()));
        }
    }

    @Override
    @Nullable
    public String getTranslationKey() {
        return this.translationKey;
    }

    @Override
    @Nullable
    public T get() {
        return this.value;
    }

    @Override
    @Nullable
    public T getFromField() {
        try {
            this.set(this.field.get(this.field.getDeclaringClass()));
        }
        catch (IllegalArgumentException e) {
            throw new IllegalStateException(String.format("Field is not static\n\tat: %s", this.field.toGenericString()), e);
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException(String.format("Field is not public\n\tat: %s", this.field.toGenericString()), e);
        }
        catch (ClassCastException e) {
            throw new IllegalStateException(String.format("Field is not of type \"%s\"\n\tat: %s", this.field.getType().getName(), this.field.toGenericString()), e);
        }
        return this.get();
    }

    @Override
    public void set(@Nullable T value) {
        this.value = value;
        try {
            this.field.set(this, value == null ? this.getDefault() : this.get());
        }
        catch (IllegalArgumentException e) {
            throw new IllegalStateException(String.format("Field is not static\n\tat: %s", this.field.toGenericString()), e);
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException(String.format("Field is not public\n\tat: %s", this.field.toGenericString()), e);
        }
    }

    @Override
    public T getDefault() {
        return this.defaultValue;
    }

    @Override
    public String getComment() {
        StringBuilder s = new StringBuilder();
        if (this.comment != null && !this.comment.isEmpty()) {
            s.append(' ').append(this.comment).append('\n');
        }
        s.append(' ').append("Default: ").append(this.defaultValue.toString());
        return s.toString();
    }

    @Override
    public boolean hasTag(String tag) {
        for (int i = 0; i < this.tags.length; ++i) {
            if (!this.tags[i].equals(tag)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Field getField() {
        return this.field;
    }

    @Override
    public IConfigElementHandler<T, ?> getTypeHandler() {
        return this.handler;
    }

    @Override
    public String getCategory() {
        return this.category;
    }

    public String toString() {
        String typeName = this.getType().toGenericString();
        typeName = typeName.substring(typeName.lastIndexOf(32) + 1);
        String name = this.getName();
        String value = this.get().toString();
        return String.format("%s: %s = %s", typeName, name, value);
    }
}

