/*
 * Decompiled with CFR 0.152.
 */
package com.cgessinger.creaturesandbeasts.config.library;

import com.cgessinger.creaturesandbeasts.config.library.Config;
import com.cgessinger.creaturesandbeasts.config.library.annotation.Configurable;
import com.cgessinger.creaturesandbeasts.config.library.element.handler.IConfigElementHandler;
import com.cgessinger.creaturesandbeasts.config.library.util.Pair;
import com.cgessinger.creaturesandbeasts.config.library.util.Util;
import com.electronwill.nightconfig.core.ConfigFormat;
import com.electronwill.nightconfig.core.file.CommentedFileConfig;
import com.electronwill.nightconfig.toml.TomlFormat;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

public final class ConfigBuilder {
    private final Path path;
    private final List<Pair<Field, IConfigElementHandler<?, ?>>> elements = new LinkedList();
    private final Set<String> loadedElementNames = new HashSet<String>();

    protected ConfigBuilder(Path path) throws IOException {
        this.path = path;
        File file = path.toFile();
        if (file.exists()) {
            ConfigBuilder.throwIfInvalidFile(file);
        }
    }

    public ConfigBuilder loadField(Field field) throws IllegalStateException, IllegalArgumentException {
        if (field.isAnnotationPresent(Configurable.class)) {
            Class<?> fieldType;
            String category = Util.getCategory(field) + "." + field.getName();
            if (this.loadedElementNames.contains(category)) {
                throw new IllegalArgumentException(String.format("Field with name \"%s\" is already loaded", category));
            }
            this.loadedElementNames.add(category);
            Configurable configurable = field.getAnnotation(Configurable.class);
            IConfigElementHandler handler = null;
            if (!configurable.handler().equals("")) {
                try {
                    String fieldPath = configurable.handler();
                    String classPath = fieldPath.substring(0, fieldPath.lastIndexOf(46));
                    String fieldName = fieldPath.substring(fieldPath.lastIndexOf(46) + 1);
                    Field INSTANCE = Class.forName(classPath).getDeclaredField(fieldName);
                    Class<?> clazz = INSTANCE.getType();
                    Object h = INSTANCE.get(null);
                    if (!IConfigElementHandler.class.isInstance(h)) {
                        throw new IllegalStateException(String.format("%s is not an instance of %s\n\tat: %s", clazz.toGenericString(), IConfigElementHandler.class.toGenericString(), field.toGenericString()));
                    }
                    handler = (IConfigElementHandler)h;
                    if (!handler.canHandle(field.getType())) {
                        throw new IllegalStateException(String.format("%s cannot handle %s\n\tat: %s", handler.getClass().toGenericString(), field.getType().toGenericString(), field.toGenericString()));
                    }
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
            }
            if (handler == null && (handler = Config.getHandler(fieldType = field.getType())) == null) {
                throw new IllegalStateException(String.format("No handler of type %s\n\tat: %s", fieldType.getName(), field.toGenericString()));
            }
            this.elements.add(Pair.of(field, handler));
        }
        return this;
    }

    public ConfigBuilder loadClass(Class<?> clazz) throws IllegalStateException, IllegalArgumentException {
        return this.loadClass(clazz, false);
    }

    public ConfigBuilder loadClass(Class<?> clazz, boolean addInherited) throws IllegalStateException, IllegalArgumentException {
        for (Field field : addInherited ? clazz.getFields() : clazz.getDeclaredFields()) {
            if (!Modifier.isStatic(field.getModifiers()) || !Modifier.isPublic(field.getModifiers()) || !field.isAnnotationPresent(Configurable.class)) continue;
            this.loadField(field);
        }
        return this;
    }

    public Config build() throws IOException {
        ArrayList elements = new ArrayList(this.elements.size());
        for (Pair<Field, IConfigElementHandler<?, ?>> pair : this.elements) {
            pair.getLeft().setAccessible(true);
            elements.add(pair.getRight().create(pair.getLeft()));
        }
        CommentedFileConfig config = (CommentedFileConfig)CommentedFileConfig.builder((Path)this.path, (ConfigFormat)TomlFormat.instance()).concurrent().sync().build();
        File file = this.path.toFile();
        if (!file.exists()) {
            try {
                file.createNewFile();
            }
            catch (IOException e) {
                throw new IOException(String.format("Could not create file \"%s\"", this.path), e);
            }
        }
        ConfigBuilder.throwIfInvalidFile(file);
        return new Config(config, elements);
    }

    private static void throwIfInvalidFile(File file) throws IOException {
        if (!file.isFile()) {
            throw new IOException(String.format("\"%s\" is not a file!", file.getAbsolutePath().toString()));
        }
        if (!file.canRead()) {
            throw new IOException(String.format("File \"%s\" is not readable!", file.getAbsolutePath().toString()));
        }
        if (!file.canWrite()) {
            throw new IOException(String.format("File \"%s\" is not writable!", file.getAbsolutePath().toString()));
        }
        if (file.isHidden()) {
            System.out.println(String.format("WARNING: File \"%s\" is hidden", file.getAbsolutePath().toString()));
        }
    }
}

