/*
 * Decompiled with CFR 0.152.
 */
package com.cgessinger.creaturesandbeasts.client.entity.model;

import com.cgessinger.creaturesandbeasts.entities.YetiEntity;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.processor.IBone;
import software.bernie.geckolib3.model.AnimatedGeoModel;
import software.bernie.geckolib3.model.provider.data.EntityModelData;

@OnlyIn(value=Dist.CLIENT)
public class YetiModel
extends AnimatedGeoModel<YetiEntity> {
    private static final ResourceLocation YETI_MODEL = new ResourceLocation("cnb", "geo/entity/yeti/yeti.geo.json");
    private static final ResourceLocation BABY_YETI_MODEL = new ResourceLocation("cnb", "geo/entity/yeti/baby_yeti.geo.json");
    private static final ResourceLocation YETI_TEXTURE = new ResourceLocation("cnb", "textures/entity/yeti/yeti.png");
    private static final ResourceLocation BABY_YETI_TEXTURE = new ResourceLocation("cnb", "textures/entity/yeti/baby_yeti.png");
    private static final ResourceLocation YETI_ANIMATIONS = new ResourceLocation("cnb", "animations/yeti.json");

    public ResourceLocation getModelResource(YetiEntity entity) {
        return entity.m_6162_() ? BABY_YETI_MODEL : YETI_MODEL;
    }

    public ResourceLocation getTextureResource(YetiEntity entity) {
        return entity.m_6162_() ? BABY_YETI_TEXTURE : YETI_TEXTURE;
    }

    public ResourceLocation getAnimationResource(YetiEntity entity) {
        return YETI_ANIMATIONS;
    }

    public void setCustomAnimations(YetiEntity animatable, int instanceId, AnimationEvent animationEvent) {
        super.setCustomAnimations((IAnimatable)animatable, instanceId, animationEvent);
        IBone head_rotation = this.getAnimationProcessor().getBone("head_rotation");
        EntityModelData extraData = (EntityModelData)animationEvent.getExtraDataOfType(EntityModelData.class).get(0);
        head_rotation.setRotationX(extraData.headPitch * ((float)Math.PI / 180));
        if (animatable.m_6162_()) {
            head_rotation.setRotationZ(extraData.netHeadYaw * ((float)Math.PI / 180));
        } else {
            head_rotation.setRotationY(extraData.netHeadYaw * ((float)Math.PI / 180));
        }
    }
}

