/*
 * Decompiled with CFR 0.152.
 */
package com.barion.dungeons_enhanced.world.structures.prefabs;

import com.barion.dungeons_enhanced.DEUtil;
import com.barion.dungeons_enhanced.world.structures.prefabs.utils.DEPieceAssembler;
import com.barion.dungeons_enhanced.world.structures.prefabs.utils.DEStructurePiece;
import com.legacy.structure_gel.api.registry.registrar.Registrar;
import com.legacy.structure_gel.api.structure.GelTemplateStructurePiece;
import com.legacy.structure_gel.api.structure.processor.RemoveGelStructureProcessor;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.QuartPos;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeSource;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.RandomState;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureStart;
import net.minecraft.world.level.levelgen.structure.StructureType;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceSerializationContext;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceType;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePiecesBuilder;
import net.minecraft.world.level.levelgen.structure.templatesystem.BlockIgnoreProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;

public abstract class DEBaseStructure
extends Structure {
    private final DEStructurePiece[] variants;
    private final int maxWeight;
    private final DEPieceAssembler assembler;
    private final Supplier<StructureType<?>> type;

    public DEBaseStructure(Structure.StructureSettings settings, DEStructurePiece[] variants, DEPieceAssembler assembler, Supplier<StructureType<?>> type) {
        super(settings);
        this.variants = variants;
        this.maxWeight = DEUtil.getMaxWeight(variants);
        this.assembler = assembler;
        this.type = type;
    }

    @Nonnull
    public Optional<Structure.GenerationStub> m_214086_(@Nonnull Structure.GenerationContext context) {
        return DEBaseStructure.m_226585_((Structure.GenerationContext)context, (Heightmap.Types)Heightmap.Types.WORLD_SURFACE_WG, builder -> DEBaseStructure.generatePieces(builder, context, this.variants, this.maxWeight, this.assembler, this.getGenPos(context)));
    }

    @Nonnull
    @ParametersAreNonnullByDefault
    public StructureStart m_226596_(RegistryAccess registryAccess, ChunkGenerator generator, BiomeSource biomeSource, RandomState randomState, StructureTemplateManager templateManager, long seed, ChunkPos chunkPos, int references, LevelHeightAccessor heightAccessor, Predicate<Holder<Biome>> biomePredicate) {
        StructurePiecesBuilder structurepiecesbuilder;
        StructureStart structurestart;
        Structure.GenerationContext context = new Structure.GenerationContext(registryAccess, generator, biomeSource, randomState, templateManager, seed, chunkPos, heightAccessor, biomePredicate);
        Optional<Structure.GenerationStub> optional = this.m_214086_(context);
        if (optional.isPresent() && DEBaseStructure.isValidBiome(optional.get(), generator, randomState, biomePredicate) && this.checkLocation(context) && (structurestart = new StructureStart((Structure)this, chunkPos, references, (structurepiecesbuilder = optional.get().m_226677_()).m_192780_())).m_73603_()) {
            return structurestart;
        }
        return StructureStart.f_73561_;
    }

    protected static boolean isValidBiome(Structure.GenerationStub stub, ChunkGenerator generator, RandomState state, Predicate<Holder<Biome>> biomePredicate) {
        BlockPos blockpos = stub.f_226669_();
        return biomePredicate.test((Holder<Biome>)generator.m_62218_().m_203407_(QuartPos.m_175400_((int)blockpos.m_123341_()), QuartPos.m_175400_((int)blockpos.m_123342_()), QuartPos.m_175400_((int)blockpos.m_123343_()), state.m_224579_()));
    }

    @Nonnull
    public StructureType<?> m_213658_() {
        return this.type.get();
    }

    protected abstract boolean checkLocation(Structure.GenerationContext var1);

    protected abstract BlockPos getGenPos(Structure.GenerationContext var1);

    private static void generatePieces(StructurePiecesBuilder piecesBuilder, Structure.GenerationContext context, DEStructurePiece[] variants, int maxWeight, DEPieceAssembler assembler, BlockPos rawPos) {
        int piece = DEUtil.getRandomPiece(variants, maxWeight, (RandomSource)context.f_226626_());
        assembler.assemble(new DEPieceAssembler.Context(context.f_226625_(), variants[piece].Resource, rawPos.m_121955_((Vec3i)variants[piece].Offset), Rotation.m_221990_((RandomSource)context.f_226626_()), piecesBuilder));
    }

    public static class Piece
    extends GelTemplateStructurePiece {
        public Piece(Registrar.Static<StructurePieceType> pieceType, StructureTemplateManager structureManager, ResourceLocation templateName, BlockPos pos, Rotation rotation) {
            super((StructurePieceType)pieceType.get(), 0, structureManager, templateName, pos);
            this.f_73379_ = rotation;
            this.setupPlaceSettings(structureManager);
        }

        public Piece(Registrar.Static<StructurePieceType> pieceType, StructurePieceSerializationContext context, CompoundTag nbt) {
            super((StructurePieceType)pieceType.get(), nbt, context.f_226956_());
            this.setupPlaceSettings(context.f_226956_());
        }

        protected StructurePlaceSettings getPlaceSettings(StructureTemplateManager structureManager) {
            Vec3i size = ((StructureTemplate)structureManager.m_230407_(this.m_142415_()).get()).m_163801_();
            BlockPos pivot = new BlockPos(size.m_123341_() / 2, 0, size.m_123343_() / 2);
            StructurePlaceSettings settings = new StructurePlaceSettings().m_163782_(false).m_74385_(pivot);
            settings.m_74383_((StructureProcessor)BlockIgnoreProcessor.f_74048_).m_74383_((StructureProcessor)RemoveGelStructureProcessor.INSTANCE);
            this.addProcessors(settings);
            return settings;
        }

        protected void addProcessors(StructurePlaceSettings settings) {
        }

        @ParametersAreNonnullByDefault
        protected void m_213704_(String key, BlockPos pos, ServerLevelAccessor level, RandomSource random, BoundingBox box) {
        }
    }
}

