/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.blockentity;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.minecraft.MinecraftProfileTexture;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.SkullModel;
import net.minecraft.client.model.SkullModelBase;
import net.minecraft.client.model.dragon.DragonHeadModel;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.DefaultPlayerSkin;
import net.minecraft.core.Direction;
import net.minecraft.core.UUIDUtil;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.AbstractSkullBlock;
import net.minecraft.world.level.block.SkullBlock;
import net.minecraft.world.level.block.WallSkullBlock;
import net.minecraft.world.level.block.entity.SkullBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fml.ModLoader;

@OnlyIn(value=Dist.CLIENT)
public class SkullBlockRenderer
implements BlockEntityRenderer<SkullBlockEntity> {
    private final Map<SkullBlock.Type, SkullModelBase> f_173658_;
    public static final Map<SkullBlock.Type, ResourceLocation> f_112519_ = Util.m_137469_(Maps.newHashMap(), p_112552_ -> {
        p_112552_.put(SkullBlock.Types.SKELETON, new ResourceLocation("textures/entity/skeleton/skeleton.png"));
        p_112552_.put(SkullBlock.Types.WITHER_SKELETON, new ResourceLocation("textures/entity/skeleton/wither_skeleton.png"));
        p_112552_.put(SkullBlock.Types.ZOMBIE, new ResourceLocation("textures/entity/zombie/zombie.png"));
        p_112552_.put(SkullBlock.Types.CREEPER, new ResourceLocation("textures/entity/creeper/creeper.png"));
        p_112552_.put(SkullBlock.Types.DRAGON, new ResourceLocation("textures/entity/enderdragon/dragon.png"));
        p_112552_.put(SkullBlock.Types.PLAYER, DefaultPlayerSkin.m_118626_());
    });

    public static Map<SkullBlock.Type, SkullModelBase> m_173661_(EntityModelSet p_173662_) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        builder.put((Object)SkullBlock.Types.SKELETON, (Object)new SkullModel(p_173662_.m_171103_(ModelLayers.f_171240_)));
        builder.put((Object)SkullBlock.Types.WITHER_SKELETON, (Object)new SkullModel(p_173662_.m_171103_(ModelLayers.f_171219_)));
        builder.put((Object)SkullBlock.Types.PLAYER, (Object)new SkullModel(p_173662_.m_171103_(ModelLayers.f_171163_)));
        builder.put((Object)SkullBlock.Types.ZOMBIE, (Object)new SkullModel(p_173662_.m_171103_(ModelLayers.f_171224_)));
        builder.put((Object)SkullBlock.Types.CREEPER, (Object)new SkullModel(p_173662_.m_171103_(ModelLayers.f_171130_)));
        builder.put((Object)SkullBlock.Types.DRAGON, (Object)new DragonHeadModel(p_173662_.m_171103_(ModelLayers.f_171135_)));
        ModLoader.get().postEvent((Event)new EntityRenderersEvent.CreateSkullModels(builder, p_173662_));
        return builder.build();
    }

    public SkullBlockRenderer(BlockEntityRendererProvider.Context p_173660_) {
        this.f_173658_ = SkullBlockRenderer.m_173661_(p_173660_.m_173585_());
    }

    public void m_6922_(SkullBlockEntity p_112534_, float p_112535_, PoseStack p_112536_, MultiBufferSource p_112537_, int p_112538_, int p_112539_) {
        float f = p_112534_.m_59762_(p_112535_);
        BlockState blockstate = p_112534_.m_58900_();
        boolean flag = blockstate.m_60734_() instanceof WallSkullBlock;
        Direction direction = flag ? (Direction)blockstate.m_61143_((Property)WallSkullBlock.f_58097_) : null;
        float f1 = 22.5f * (float)(flag ? (2 + direction.m_122416_()) * 4 : (Integer)blockstate.m_61143_((Property)SkullBlock.f_56314_));
        SkullBlock.Type skullblock$type = ((AbstractSkullBlock)blockstate.m_60734_()).m_48754_();
        SkullModelBase skullmodelbase = this.f_173658_.get(skullblock$type);
        RenderType rendertype = SkullBlockRenderer.m_112523_(skullblock$type, p_112534_.m_59779_());
        SkullBlockRenderer.m_173663_(direction, f1, f, p_112536_, p_112537_, p_112538_, skullmodelbase, rendertype);
    }

    public static void m_173663_(@Nullable Direction p_173664_, float p_173665_, float p_173666_, PoseStack p_173667_, MultiBufferSource p_173668_, int p_173669_, SkullModelBase p_173670_, RenderType p_173671_) {
        p_173667_.m_85836_();
        if (p_173664_ == null) {
            p_173667_.m_85837_(0.5, 0.0, 0.5);
        } else {
            float f = 0.25f;
            p_173667_.m_85837_(0.5f - (float)p_173664_.m_122429_() * 0.25f, 0.25, 0.5f - (float)p_173664_.m_122431_() * 0.25f);
        }
        p_173667_.m_85841_(-1.0f, -1.0f, 1.0f);
        VertexConsumer vertexconsumer = p_173668_.m_6299_(p_173671_);
        p_173670_.m_6251_(p_173666_, p_173665_, 0.0f);
        p_173670_.m_7695_(p_173667_, vertexconsumer, p_173669_, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
        p_173667_.m_85849_();
    }

    public static RenderType m_112523_(SkullBlock.Type p_112524_, @Nullable GameProfile p_112525_) {
        ResourceLocation resourcelocation = f_112519_.get(p_112524_);
        if (p_112524_ == SkullBlock.Types.PLAYER && p_112525_ != null) {
            Minecraft minecraft = Minecraft.m_91087_();
            Map map = minecraft.m_91109_().m_118815_(p_112525_);
            return map.containsKey(MinecraftProfileTexture.Type.SKIN) ? RenderType.m_110473_(minecraft.m_91109_().m_118825_((MinecraftProfileTexture)map.get(MinecraftProfileTexture.Type.SKIN), MinecraftProfileTexture.Type.SKIN)) : RenderType.m_110458_(DefaultPlayerSkin.m_118627_((UUID)UUIDUtil.m_235875_((GameProfile)p_112525_)));
        }
        return RenderType.m_110464_(resourcelocation);
    }
}

