/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.theonewhowatches.network;

import java.util.function.Supplier;
import net.mcreator.theonewhowatches.TheOneWhoWatchesMod;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.PacketDistributor;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class TheOneWhoWatchesModVariables {
    @SubscribeEvent
    public static void init(FMLCommonSetupEvent event) {
        TheOneWhoWatchesMod.addNetworkMessage(SavedDataSyncMessage.class, SavedDataSyncMessage::buffer, SavedDataSyncMessage::new, SavedDataSyncMessage::handler);
    }

    public static class SavedDataSyncMessage {
        public int type;
        public SavedData data;

        public SavedDataSyncMessage(FriendlyByteBuf buffer) {
            this.type = buffer.readInt();
            SavedData savedData = this.data = this.type == 0 ? new MapVariables() : new WorldVariables();
            if (savedData instanceof MapVariables) {
                MapVariables _mapvars = (MapVariables)savedData;
                _mapvars.read(buffer.m_130260_());
            } else {
                savedData = this.data;
                if (savedData instanceof WorldVariables) {
                    WorldVariables _worldvars = (WorldVariables)savedData;
                    _worldvars.read(buffer.m_130260_());
                }
            }
        }

        public SavedDataSyncMessage(int type, SavedData data) {
            this.type = type;
            this.data = data;
        }

        public static void buffer(SavedDataSyncMessage message, FriendlyByteBuf buffer) {
            buffer.writeInt(message.type);
            buffer.m_130079_(message.data.m_7176_(new CompoundTag()));
        }

        public static void handler(SavedDataSyncMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
            NetworkEvent.Context context = contextSupplier.get();
            context.enqueueWork(() -> {
                if (!context.getDirection().getReceptionSide().isServer()) {
                    if (message.type == 0) {
                        MapVariables.clientSide = (MapVariables)message.data;
                    } else {
                        WorldVariables.clientSide = (WorldVariables)message.data;
                    }
                }
            });
            context.setPacketHandled(true);
        }
    }

    public static class MapVariables
    extends SavedData {
        public static final String DATA_NAME = "the_one_who_watches_mapvars";
        static MapVariables clientSide = new MapVariables();

        public static MapVariables load(CompoundTag tag) {
            MapVariables data = new MapVariables();
            data.read(tag);
            return data;
        }

        public void read(CompoundTag nbt) {
        }

        public CompoundTag m_7176_(CompoundTag nbt) {
            return nbt;
        }

        public void syncData(LevelAccessor world) {
            this.m_77762_();
            if (world instanceof Level && !world.m_5776_()) {
                TheOneWhoWatchesMod.PACKET_HANDLER.send(PacketDistributor.ALL.noArg(), (Object)new SavedDataSyncMessage(0, this));
            }
        }

        public static MapVariables get(LevelAccessor world) {
            if (world instanceof ServerLevelAccessor) {
                ServerLevelAccessor serverLevelAcc = (ServerLevelAccessor)world;
                return (MapVariables)serverLevelAcc.m_6018_().m_7654_().m_129880_(Level.f_46428_).m_8895_().m_164861_(e -> MapVariables.load(e), MapVariables::new, DATA_NAME);
            }
            return clientSide;
        }
    }

    public static class WorldVariables
    extends SavedData {
        public static final String DATA_NAME = "the_one_who_watches_worldvars";
        public boolean stage0 = true;
        public boolean stage1 = false;
        public boolean stage2 = false;
        public boolean stage3 = false;
        public boolean stage4 = false;
        public double WorldTime = 0.0;
        public boolean stage5 = false;
        public double stageRandomizer = 0.0;
        public double TOWWstage = 0.0;
        public boolean TOWWexists = false;
        public double poseRandomizer = 0.0;
        public boolean freezePlayerMovement = false;
        public boolean TOWWHunting = false;
        public boolean blindPlayer = false;
        public double TOWWHuntingTimer = 0.0;
        public boolean RemoveAllLight = false;
        public boolean universalAngerVariable = false;
        public boolean hasLookedAt = false;
        public double Fear = 0.0;
        public boolean CanHallucinate = true;
        public boolean TOWWCanSpawn = false;
        static WorldVariables clientSide = new WorldVariables();

        public static WorldVariables load(CompoundTag tag) {
            WorldVariables data = new WorldVariables();
            data.read(tag);
            return data;
        }

        public void read(CompoundTag nbt) {
            this.stage0 = nbt.m_128471_("stage0");
            this.stage1 = nbt.m_128471_("stage1");
            this.stage2 = nbt.m_128471_("stage2");
            this.stage3 = nbt.m_128471_("stage3");
            this.stage4 = nbt.m_128471_("stage4");
            this.WorldTime = nbt.m_128459_("WorldTime");
            this.stage5 = nbt.m_128471_("stage5");
            this.stageRandomizer = nbt.m_128459_("stageRandomizer");
            this.TOWWstage = nbt.m_128459_("TOWWstage");
            this.TOWWexists = nbt.m_128471_("TOWWexists");
            this.poseRandomizer = nbt.m_128459_("poseRandomizer");
            this.freezePlayerMovement = nbt.m_128471_("freezePlayerMovement");
            this.TOWWHunting = nbt.m_128471_("TOWWHunting");
            this.blindPlayer = nbt.m_128471_("blindPlayer");
            this.TOWWHuntingTimer = nbt.m_128459_("TOWWHuntingTimer");
            this.RemoveAllLight = nbt.m_128471_("RemoveAllLight");
            this.universalAngerVariable = nbt.m_128471_("universalAngerVariable");
            this.hasLookedAt = nbt.m_128471_("hasLookedAt");
            this.Fear = nbt.m_128459_("Fear");
            this.CanHallucinate = nbt.m_128471_("CanHallucinate");
            this.TOWWCanSpawn = nbt.m_128471_("TOWWCanSpawn");
        }

        public CompoundTag m_7176_(CompoundTag nbt) {
            nbt.m_128379_("stage0", this.stage0);
            nbt.m_128379_("stage1", this.stage1);
            nbt.m_128379_("stage2", this.stage2);
            nbt.m_128379_("stage3", this.stage3);
            nbt.m_128379_("stage4", this.stage4);
            nbt.m_128347_("WorldTime", this.WorldTime);
            nbt.m_128379_("stage5", this.stage5);
            nbt.m_128347_("stageRandomizer", this.stageRandomizer);
            nbt.m_128347_("TOWWstage", this.TOWWstage);
            nbt.m_128379_("TOWWexists", this.TOWWexists);
            nbt.m_128347_("poseRandomizer", this.poseRandomizer);
            nbt.m_128379_("freezePlayerMovement", this.freezePlayerMovement);
            nbt.m_128379_("TOWWHunting", this.TOWWHunting);
            nbt.m_128379_("blindPlayer", this.blindPlayer);
            nbt.m_128347_("TOWWHuntingTimer", this.TOWWHuntingTimer);
            nbt.m_128379_("RemoveAllLight", this.RemoveAllLight);
            nbt.m_128379_("universalAngerVariable", this.universalAngerVariable);
            nbt.m_128379_("hasLookedAt", this.hasLookedAt);
            nbt.m_128347_("Fear", this.Fear);
            nbt.m_128379_("CanHallucinate", this.CanHallucinate);
            nbt.m_128379_("TOWWCanSpawn", this.TOWWCanSpawn);
            return nbt;
        }

        public void syncData(LevelAccessor world) {
            Level level;
            this.m_77762_();
            if (world instanceof Level && !(level = (Level)world).m_5776_()) {
                TheOneWhoWatchesMod.PACKET_HANDLER.send(PacketDistributor.DIMENSION.with(() -> ((Level)level).m_46472_()), (Object)new SavedDataSyncMessage(1, this));
            }
        }

        public static WorldVariables get(LevelAccessor world) {
            if (world instanceof ServerLevel) {
                ServerLevel level = (ServerLevel)world;
                return (WorldVariables)level.m_8895_().m_164861_(e -> WorldVariables.load(e), WorldVariables::new, DATA_NAME);
            }
            return clientSide;
        }
    }

    @Mod.EventBusSubscriber
    public static class EventBusVariableHandlers {
        @SubscribeEvent
        public static void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
            if (!event.getEntity().f_19853_.m_5776_()) {
                MapVariables mapdata = MapVariables.get((LevelAccessor)event.getEntity().f_19853_);
                WorldVariables worlddata = WorldVariables.get((LevelAccessor)event.getEntity().f_19853_);
                if (mapdata != null) {
                    TheOneWhoWatchesMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)event.getEntity()), (Object)new SavedDataSyncMessage(0, mapdata));
                }
                if (worlddata != null) {
                    TheOneWhoWatchesMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)event.getEntity()), (Object)new SavedDataSyncMessage(1, worlddata));
                }
            }
        }

        @SubscribeEvent
        public static void onPlayerChangedDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
            WorldVariables worlddata;
            if (!event.getEntity().f_19853_.m_5776_() && (worlddata = WorldVariables.get((LevelAccessor)event.getEntity().f_19853_)) != null) {
                TheOneWhoWatchesMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)event.getEntity()), (Object)new SavedDataSyncMessage(1, worlddata));
            }
        }
    }
}

