/*
 * Decompiled with CFR 0.152.
 */
package net.arphex.procedures;

import com.google.common.collect.ImmutableMap;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexBuffer;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Matrix4f;
import com.mojang.math.Vector3f;
import java.lang.reflect.Field;
import java.util.Set;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.DimensionSpecialEffects;
import net.minecraft.client.renderer.FogRenderer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.DimensionSpecialEffectsManager;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;

@Mod.EventBusSubscriber(value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.MOD)
public class RenderTest9SkyProcedure {
    private static int ticks = 0;
    private static float partialTick = 0.0f;
    private static PoseStack poseStack = null;
    private static Matrix4f projectionMatrix = null;
    private static Runnable setupFog = null;
    private static VertexBuffer abyssBuffer = null;
    private static VertexBuffer deepSkyBuffer = null;
    private static VertexBuffer skyboxBuffer = null;
    private static VertexBuffer starBuffer = null;
    private static int amount = 0;
    private static int seed = 0;
    private static final Predicate<Object[]> PREDICATE = params -> {
        ticks = (Integer)params[1];
        partialTick = ((Float)params[2]).floatValue();
        poseStack = (PoseStack)params[3];
        projectionMatrix = (Matrix4f)params[5];
        setupFog = (Runnable)params[7];
        FogRenderer.m_109036_();
        setupFog.run();
        Minecraft minecraft = Minecraft.m_91087_();
        Entity entity = minecraft.f_91063_.m_109153_().m_90592_();
        if (entity != null) {
            ClientLevel level = minecraft.f_91073_;
            Vec3 pos = entity.m_20318_(partialTick);
            RenderSystem.m_69472_();
            RenderSystem.m_69458_((boolean)false);
            RenderSystem.m_69478_();
            RenderSystem.m_69453_();
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderTest9SkyProcedure.execute(null);
            return true;
        }
        return false;
    };

    public static void renderAbyss(int color, boolean constant) {
        boolean visible;
        Minecraft minecraft = Minecraft.m_91087_();
        boolean bl = visible = minecraft.f_91074_.m_20299_(partialTick).m_7098_() - minecraft.f_91073_.m_6106_().m_171687_((LevelHeightAccessor)minecraft.f_91073_) < 0.0;
        if (visible || constant) {
            if (abyssBuffer == null) {
                RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                RenderSystem.m_157427_(GameRenderer::m_172808_);
                BufferBuilder bufferBuilder = Tesselator.m_85913_().m_85915_();
                bufferBuilder.m_166779_(VertexFormat.Mode.TRIANGLE_FAN, DefaultVertexFormat.f_85814_);
                bufferBuilder.m_5483_(0.0, -16.0, 0.0).m_5752_();
                for (int i = 0; i <= 8; ++i) {
                    bufferBuilder.m_5483_((double)(-512.0f * Mth.m_14089_((float)((float)i * 45.0f * ((float)Math.PI / 180)))), -16.0, (double)(512.0f * Mth.m_14031_((float)((float)i * 45.0f * ((float)Math.PI / 180))))).m_5752_();
                }
                abyssBuffer = new VertexBuffer();
                abyssBuffer.m_85921_();
                abyssBuffer.m_231221_(bufferBuilder.m_231175_());
            } else {
                abyssBuffer.m_85921_();
            }
            poseStack.m_85836_();
            poseStack.m_85837_(0.0, 12.0, 0.0);
            RenderSystem.m_69472_();
            RenderSystem.m_157429_((float)((float)(color >> 16 & 0xFF) / 255.0f), (float)((float)(color >> 8 & 0xFF) / 255.0f), (float)((float)(color & 0xFF) / 255.0f), (float)((float)(color >>> 24) / 255.0f));
            abyssBuffer.m_166867_(poseStack.m_85850_().m_85861_(), projectionMatrix, GameRenderer.m_172808_());
            VertexBuffer.m_85931_();
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            poseStack.m_85849_();
        }
    }

    public static void renderDeepSky(int color) {
        if (deepSkyBuffer == null) {
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.m_157427_(GameRenderer::m_172808_);
            BufferBuilder bufferBuilder = Tesselator.m_85913_().m_85915_();
            bufferBuilder.m_166779_(VertexFormat.Mode.TRIANGLE_FAN, DefaultVertexFormat.f_85814_);
            bufferBuilder.m_5483_(0.0, 16.0, 0.0).m_5752_();
            for (int i = 0; i <= 8; ++i) {
                bufferBuilder.m_5483_((double)(512.0f * Mth.m_14089_((float)(45.0f * (float)i * ((float)Math.PI / 180)))), 16.0, (double)(512.0f * Mth.m_14031_((float)(45.0f * (float)i * ((float)Math.PI / 180))))).m_5752_();
            }
            deepSkyBuffer = new VertexBuffer();
            deepSkyBuffer.m_85921_();
            deepSkyBuffer.m_231221_(bufferBuilder.m_231175_());
        } else {
            deepSkyBuffer.m_85921_();
        }
        RenderSystem.m_69472_();
        RenderSystem.m_157429_((float)((float)(color >> 16 & 0xFF) / 255.0f), (float)((float)(color >> 8 & 0xFF) / 255.0f), (float)((float)(color & 0xFF) / 255.0f), (float)((float)(color >>> 24) / 255.0f));
        deepSkyBuffer.m_166867_(poseStack.m_85850_().m_85861_(), projectionMatrix, GameRenderer.m_172808_());
        VertexBuffer.m_85931_();
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public static void renderEndSky(float yaw, float pitch, float roll, int color, boolean constant) {
        boolean invisible;
        Minecraft minecraft = Minecraft.m_91087_();
        Vec3 pos = minecraft.f_91063_.m_109153_().m_90583_();
        boolean bl = invisible = minecraft.f_91073_.m_104583_().m_5781_(Mth.m_14107_((double)pos.m_7096_()), Mth.m_14107_((double)pos.m_7098_())) || minecraft.f_91065_.m_93090_().m_93715_();
        if (!invisible || constant) {
            poseStack.m_85836_();
            poseStack.m_85845_(Vector3f.f_122224_.m_122240_(yaw));
            poseStack.m_85845_(Vector3f.f_122223_.m_122240_(pitch));
            poseStack.m_85845_(Vector3f.f_122226_.m_122240_(roll));
            Matrix4f matrix4f = poseStack.m_85850_().m_85861_();
            RenderSystem.m_69493_();
            RenderSystem.m_157429_((float)((float)(color >> 16 & 0xFF) / 255.0f), (float)((float)(color >> 8 & 0xFF) / 255.0f), (float)((float)(color & 0xFF) / 255.0f), (float)((float)(color >>> 24) / 255.0f));
            RenderSystem.m_157427_(GameRenderer::m_172817_);
            BufferBuilder bufferBuilder = Tesselator.m_85913_().m_85915_();
            bufferBuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
            block8: for (int i = 0; i < 6; ++i) {
                switch (i) {
                    case 0: {
                        bufferBuilder.m_85982_(matrix4f, -100.0f, -100.0f, -100.0f).m_7421_(0.0f, 0.0f).m_5752_();
                        bufferBuilder.m_85982_(matrix4f, -100.0f, -100.0f, 100.0f).m_7421_(0.0f, 16.0f).m_5752_();
                        bufferBuilder.m_85982_(matrix4f, 100.0f, -100.0f, 100.0f).m_7421_(16.0f, 16.0f).m_5752_();
                        bufferBuilder.m_85982_(matrix4f, 100.0f, -100.0f, -100.0f).m_7421_(16.0f, 0.0f).m_5752_();
                        continue block8;
                    }
                    case 1: {
                        bufferBuilder.m_85982_(matrix4f, -100.0f, -100.0f, 100.0f).m_7421_(0.0f, 0.0f).m_5752_();
                        bufferBuilder.m_85982_(matrix4f, -100.0f, 100.0f, 100.0f).m_7421_(0.0f, 16.0f).m_5752_();
                        bufferBuilder.m_85982_(matrix4f, 100.0f, 100.0f, 100.0f).m_7421_(16.0f, 16.0f).m_5752_();
                        bufferBuilder.m_85982_(matrix4f, 100.0f, -100.0f, 100.0f).m_7421_(16.0f, 0.0f).m_5752_();
                        continue block8;
                    }
                    case 2: {
                        bufferBuilder.m_85982_(matrix4f, -100.0f, 100.0f, -100.0f).m_7421_(0.0f, 0.0f).m_5752_();
                        bufferBuilder.m_85982_(matrix4f, -100.0f, -100.0f, -100.0f).m_7421_(0.0f, 16.0f).m_5752_();
                        bufferBuilder.m_85982_(matrix4f, 100.0f, -100.0f, -100.0f).m_7421_(16.0f, 16.0f).m_5752_();
                        bufferBuilder.m_85982_(matrix4f, 100.0f, 100.0f, -100.0f).m_7421_(16.0f, 0.0f).m_5752_();
                        continue block8;
                    }
                    case 3: {
                        bufferBuilder.m_85982_(matrix4f, -100.0f, 100.0f, 100.0f).m_7421_(0.0f, 0.0f).m_5752_();
                        bufferBuilder.m_85982_(matrix4f, -100.0f, 100.0f, -100.0f).m_7421_(0.0f, 16.0f).m_5752_();
                        bufferBuilder.m_85982_(matrix4f, 100.0f, 100.0f, -100.0f).m_7421_(16.0f, 16.0f).m_5752_();
                        bufferBuilder.m_85982_(matrix4f, 100.0f, 100.0f, 100.0f).m_7421_(16.0f, 0.0f).m_5752_();
                        continue block8;
                    }
                    case 4: {
                        bufferBuilder.m_85982_(matrix4f, -100.0f, 100.0f, -100.0f).m_7421_(0.0f, 0.0f).m_5752_();
                        bufferBuilder.m_85982_(matrix4f, -100.0f, 100.0f, 100.0f).m_7421_(0.0f, 16.0f).m_5752_();
                        bufferBuilder.m_85982_(matrix4f, -100.0f, -100.0f, 100.0f).m_7421_(16.0f, 16.0f).m_5752_();
                        bufferBuilder.m_85982_(matrix4f, -100.0f, -100.0f, -100.0f).m_7421_(16.0f, 0.0f).m_5752_();
                        continue block8;
                    }
                    case 5: {
                        bufferBuilder.m_85982_(matrix4f, 100.0f, -100.0f, -100.0f).m_7421_(0.0f, 0.0f).m_5752_();
                        bufferBuilder.m_85982_(matrix4f, 100.0f, -100.0f, 100.0f).m_7421_(0.0f, 16.0f).m_5752_();
                        bufferBuilder.m_85982_(matrix4f, 100.0f, 100.0f, 100.0f).m_7421_(16.0f, 16.0f).m_5752_();
                        bufferBuilder.m_85982_(matrix4f, 100.0f, 100.0f, -100.0f).m_7421_(16.0f, 0.0f).m_5752_();
                    }
                }
            }
            BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)bufferBuilder.m_231175_());
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            poseStack.m_85849_();
        }
    }

    public static void renderMoon(float size, int color, boolean phase, boolean constant) {
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        float r = size / 2.0f;
        float u0 = 0.0f;
        float v0 = 0.0f;
        float u1 = 1.0f;
        float v1 = 1.0f;
        if (phase) {
            int i0 = level.m_46941_();
            int i1 = i0 & 3;
            int i2 = i0 >> 2 & 1;
            u0 = (float)i1 / 4.0f;
            v0 = (float)i2 / 2.0f;
            u1 = (float)(i1 + 1) / 4.0f;
            v1 = (float)(i2 + 1) / 2.0f;
        }
        float alpha = (float)(color >>> 24) / 255.0f;
        if (!constant) {
            alpha *= 1.0f - level.m_46722_(partialTick);
        }
        poseStack.m_85836_();
        poseStack.m_85845_(Vector3f.f_122227_.m_122240_(level.m_46942_(partialTick) * 360.0f));
        Matrix4f matrix4f = poseStack.m_85850_().m_85861_();
        RenderSystem.m_69493_();
        RenderSystem.m_157429_((float)((float)(color >> 16 & 0xFF) / 255.0f), (float)((float)(color >> 8 & 0xFF) / 255.0f), (float)((float)(color & 0xFF) / 255.0f), (float)alpha);
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        BufferBuilder bufferBuilder = Tesselator.m_85913_().m_85915_();
        bufferBuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
        bufferBuilder.m_85982_(matrix4f, -r, -100.0f, -r).m_7421_(u1, v1).m_5752_();
        bufferBuilder.m_85982_(matrix4f, -r, -100.0f, r).m_7421_(u0, v1).m_5752_();
        bufferBuilder.m_85982_(matrix4f, r, -100.0f, r).m_7421_(u0, v0).m_5752_();
        bufferBuilder.m_85982_(matrix4f, r, -100.0f, -r).m_7421_(u1, v0).m_5752_();
        BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)bufferBuilder.m_231175_());
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        poseStack.m_85849_();
    }

    public static void renderSky(boolean deepSky, boolean sunlights, boolean sun, boolean moon, boolean stars, boolean abyss) {
        Object color;
        Minecraft minecraft = Minecraft.m_91087_();
        ClientLevel level = minecraft.f_91073_;
        if (deepSky) {
            color = level.m_171660_(minecraft.f_91063_.m_109153_().m_90583_(), partialTick);
            RenderSystem.m_69453_();
            RenderTest9SkyProcedure.renderDeepSky(0xFF000000 | (int)(color.m_7096_() * 255.0) << 16 | (int)(color.m_7098_() * 255.0) << 8 | (int)(color.m_7094_() * 255.0));
        }
        if (sunlights && (color = (Object)level.m_104583_().m_7518_(level.m_46942_(partialTick), partialTick)) != null) {
            RenderSystem.m_69453_();
            RenderTest9SkyProcedure.renderSunlights((int)(color[3] * 255.0f) << 24 | (int)(color[0] * 255.0f) << 16 | (int)(color[1] * 255.0f) << 8 | (int)(color[2] * 255.0f));
        }
        if (sun) {
            RenderSystem.m_157456_((int)0, (ResourceLocation)new ResourceLocation("minecraft:textures/environment/sun.png"));
            RenderSystem.m_69416_((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
            RenderTest9SkyProcedure.renderSun(60.0f, -1, false);
        }
        if (moon) {
            RenderSystem.m_157456_((int)0, (ResourceLocation)new ResourceLocation("minecraft:textures/environment/moon_phases.png"));
            RenderSystem.m_69416_((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
            RenderTest9SkyProcedure.renderMoon(40.0f, -1, true, false);
        }
        if (stars) {
            int color2 = (int)(level.m_104811_(partialTick) * 255.0f);
            RenderSystem.m_69416_((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
            RenderTest9SkyProcedure.renderStars(1500, 10842, 90.0f, level.m_46942_(partialTick) * 360.0f, 0.0f, color2 << 24 | color2 << 16 | color2 << 8 | color2, false);
        }
        if (abyss) {
            RenderSystem.m_69453_();
            RenderTest9SkyProcedure.renderAbyss(-16777216, false);
        }
    }

    public static void renderSkybox(float yaw, float pitch, float roll, int color, boolean constant) {
        boolean invisible;
        Minecraft minecraft = Minecraft.m_91087_();
        Vec3 pos = minecraft.f_91063_.m_109153_().m_90583_();
        boolean bl = invisible = minecraft.f_91073_.m_104583_().m_5781_(Mth.m_14107_((double)pos.m_7096_()), Mth.m_14107_((double)pos.m_7098_())) || minecraft.f_91065_.m_93090_().m_93715_();
        if (!invisible || constant) {
            if (skyboxBuffer == null) {
                RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                RenderSystem.m_157427_(GameRenderer::m_172817_);
                BufferBuilder bufferBuilder = Tesselator.m_85913_().m_85915_();
                bufferBuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
                block8: for (int i = 0; i < 6; ++i) {
                    switch (i) {
                        case 0: {
                            bufferBuilder.m_5483_(-0.5, -0.5, -0.5).m_7421_(0.0f, 0.0f).m_5752_();
                            bufferBuilder.m_5483_(-0.5, -0.5, 0.5).m_7421_(0.0f, 0.5f).m_5752_();
                            bufferBuilder.m_5483_(0.5, -0.5, 0.5).m_7421_(0.33333334f, 0.5f).m_5752_();
                            bufferBuilder.m_5483_(0.5, -0.5, -0.5).m_7421_(0.33333334f, 0.0f).m_5752_();
                            continue block8;
                        }
                        case 1: {
                            bufferBuilder.m_5483_(-0.5, 0.5, 0.5).m_7421_(0.33333334f, 0.0f).m_5752_();
                            bufferBuilder.m_5483_(-0.5, 0.5, -0.5).m_7421_(0.33333334f, 0.5f).m_5752_();
                            bufferBuilder.m_5483_(0.5, 0.5, -0.5).m_7421_(0.6666667f, 0.5f).m_5752_();
                            bufferBuilder.m_5483_(0.5, 0.5, 0.5).m_7421_(0.6666667f, 0.0f).m_5752_();
                            continue block8;
                        }
                        case 2: {
                            bufferBuilder.m_5483_(0.5, 0.5, 0.5).m_7421_(0.6666667f, 0.0f).m_5752_();
                            bufferBuilder.m_5483_(0.5, -0.5, 0.5).m_7421_(0.6666667f, 0.5f).m_5752_();
                            bufferBuilder.m_5483_(-0.5, -0.5, 0.5).m_7421_(1.0f, 0.5f).m_5752_();
                            bufferBuilder.m_5483_(-0.5, 0.5, 0.5).m_7421_(1.0f, 0.0f).m_5752_();
                            continue block8;
                        }
                        case 3: {
                            bufferBuilder.m_5483_(-0.5, 0.5, 0.5).m_7421_(0.0f, 0.5f).m_5752_();
                            bufferBuilder.m_5483_(-0.5, -0.5, 0.5).m_7421_(0.0f, 1.0f).m_5752_();
                            bufferBuilder.m_5483_(-0.5, -0.5, -0.5).m_7421_(0.33333334f, 1.0f).m_5752_();
                            bufferBuilder.m_5483_(-0.5, 0.5, -0.5).m_7421_(0.33333334f, 0.5f).m_5752_();
                            continue block8;
                        }
                        case 4: {
                            bufferBuilder.m_5483_(-0.5, 0.5, -0.5).m_7421_(0.33333334f, 0.5f).m_5752_();
                            bufferBuilder.m_5483_(-0.5, -0.5, -0.5).m_7421_(0.33333334f, 1.0f).m_5752_();
                            bufferBuilder.m_5483_(0.5, -0.5, -0.5).m_7421_(0.6666667f, 1.0f).m_5752_();
                            bufferBuilder.m_5483_(0.5, 0.5, -0.5).m_7421_(0.6666667f, 0.5f).m_5752_();
                            continue block8;
                        }
                        case 5: {
                            bufferBuilder.m_5483_(0.5, 0.5, -0.5).m_7421_(0.6666667f, 0.5f).m_5752_();
                            bufferBuilder.m_5483_(0.5, -0.5, -0.5).m_7421_(0.6666667f, 1.0f).m_5752_();
                            bufferBuilder.m_5483_(0.5, -0.5, 0.5).m_7421_(1.0f, 1.0f).m_5752_();
                            bufferBuilder.m_5483_(0.5, 0.5, 0.5).m_7421_(1.0f, 0.5f).m_5752_();
                        }
                    }
                }
                skyboxBuffer = new VertexBuffer();
                skyboxBuffer.m_85921_();
                skyboxBuffer.m_231221_(bufferBuilder.m_231175_());
            } else {
                skyboxBuffer.m_85921_();
            }
            float size = minecraft.f_91066_.m_193772_() << 6;
            poseStack.m_85836_();
            poseStack.m_85845_(Vector3f.f_122224_.m_122240_(yaw));
            poseStack.m_85845_(Vector3f.f_122223_.m_122240_(pitch));
            poseStack.m_85845_(Vector3f.f_122226_.m_122240_(roll));
            poseStack.m_85841_(size, size, size);
            RenderSystem.m_69493_();
            RenderSystem.m_157429_((float)((float)(color >> 16 & 0xFF) / 255.0f), (float)((float)(color >> 8 & 0xFF) / 255.0f), (float)((float)(color & 0xFF) / 255.0f), (float)((float)(color >>> 24) / 255.0f));
            skyboxBuffer.m_166867_(poseStack.m_85850_().m_85861_(), projectionMatrix, GameRenderer.m_172817_());
            VertexBuffer.m_85931_();
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            poseStack.m_85849_();
        }
    }

    public static void renderStars(int amount, int seed, float yaw, float pitch, float roll, int color, boolean constant) {
        if (starBuffer == null || amount != RenderTest9SkyProcedure.amount || seed != RenderTest9SkyProcedure.seed) {
            RenderTest9SkyProcedure.amount = amount;
            RenderTest9SkyProcedure.seed = seed;
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.m_157427_(GameRenderer::m_172808_);
            BufferBuilder bufferBuilder = Tesselator.m_85913_().m_85915_();
            bufferBuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85814_);
            RandomSource randomsource = RandomSource.m_216335_((long)seed);
            for (int i = 0; i < amount; ++i) {
                float f0 = randomsource.m_188501_() * 2.0f - 1.0f;
                float f1 = randomsource.m_188501_() * 2.0f - 1.0f;
                float f2 = randomsource.m_188501_() * 2.0f - 1.0f;
                float f3 = 0.15f + 0.1f * randomsource.m_188501_();
                float f4 = f0 * f0 + f1 * f1 + f2 * f2;
                if (!(f4 < 1.0f) || !(f4 > 0.01f)) continue;
                f4 = 1.0f / Mth.m_14116_((float)f4);
                float f5 = (f0 *= f4) * 100.0f;
                float f6 = (f1 *= f4) * 100.0f;
                float f7 = (f2 *= f4) * 100.0f;
                float f8 = (float)Math.atan2(f0, f2);
                float f9 = Mth.m_14031_((float)f8);
                float f10 = Mth.m_14089_((float)f8);
                float f11 = (float)Math.atan2(Mth.m_14116_((float)(f0 * f0 + f2 * f2)), f1);
                float f12 = Mth.m_14031_((float)f11);
                float f13 = Mth.m_14089_((float)f11);
                float f14 = (float)randomsource.m_188500_() * (float)Math.PI * 2.0f;
                float f15 = Mth.m_14031_((float)f14);
                float f16 = Mth.m_14089_((float)f14);
                for (int j = 0; j < 4; ++j) {
                    float f17 = (float)((j & 2) - 1) * f3;
                    float f18 = (float)((j + 1 & 2) - 1) * f3;
                    float f20 = f17 * f16 - f18 * f15;
                    float f21 = f18 * f16 + f17 * f15;
                    float f22 = -f20 * f13;
                    float f23 = f22 * f9 - f21 * f10;
                    float f24 = f20 * f12;
                    float f25 = f21 * f9 + f22 * f10;
                    bufferBuilder.m_5483_((double)(f5 + f23), (double)(f6 + f24), (double)(f7 + f25)).m_5752_();
                }
            }
            if (starBuffer != null) {
                starBuffer.close();
            }
            starBuffer = new VertexBuffer();
            starBuffer.m_85921_();
            starBuffer.m_231221_(bufferBuilder.m_231175_());
        } else {
            starBuffer.m_85921_();
        }
        float alpha = (float)(color >>> 24) / 255.0f;
        if (!constant) {
            alpha *= 1.0f - Minecraft.m_91087_().f_91073_.m_46722_(partialTick);
        }
        poseStack.m_85836_();
        poseStack.m_85845_(Vector3f.f_122224_.m_122240_(yaw));
        poseStack.m_85845_(Vector3f.f_122223_.m_122240_(pitch));
        poseStack.m_85845_(Vector3f.f_122226_.m_122240_(roll));
        FogRenderer.m_109017_();
        RenderSystem.m_69472_();
        RenderSystem.m_157429_((float)((float)(color >> 16 & 0xFF) / 255.0f), (float)((float)(color >> 8 & 0xFF) / 255.0f), (float)((float)(color & 0xFF) / 255.0f), (float)alpha);
        starBuffer.m_166867_(poseStack.m_85850_().m_85861_(), projectionMatrix, GameRenderer.m_172808_());
        VertexBuffer.m_85931_();
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        setupFog.run();
        poseStack.m_85849_();
    }

    public static void renderSun(float size, int color, boolean constant) {
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        float r = size / 2.0f;
        float alpha = (float)(color >>> 24) / 255.0f;
        if (!constant) {
            alpha *= 1.0f - level.m_46722_(partialTick);
        }
        poseStack.m_85836_();
        poseStack.m_85845_(Vector3f.f_122227_.m_122240_(level.m_46942_(partialTick) * 360.0f));
        Matrix4f matrix4f = poseStack.m_85850_().m_85861_();
        RenderSystem.m_69493_();
        RenderSystem.m_157429_((float)((float)(color >> 16 & 0xFF) / 255.0f), (float)((float)(color >> 8 & 0xFF) / 255.0f), (float)((float)(color & 0xFF) / 255.0f), (float)alpha);
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        BufferBuilder bufferBuilder = Tesselator.m_85913_().m_85915_();
        bufferBuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
        bufferBuilder.m_85982_(matrix4f, r, 100.0f, -r).m_7421_(0.0f, 0.0f).m_5752_();
        bufferBuilder.m_85982_(matrix4f, r, 100.0f, r).m_7421_(1.0f, 0.0f).m_5752_();
        bufferBuilder.m_85982_(matrix4f, -r, 100.0f, r).m_7421_(1.0f, 1.0f).m_5752_();
        bufferBuilder.m_85982_(matrix4f, -r, 100.0f, -r).m_7421_(0.0f, 1.0f).m_5752_();
        BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)bufferBuilder.m_231175_());
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        poseStack.m_85849_();
    }

    public static void renderSunlights(int color) {
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        float[] rawColor = level.m_104583_().m_7518_(level.m_46942_(partialTick), partialTick);
        if (rawColor != null) {
            boolean flag;
            int red = color >> 16 & 0xFF;
            int green = color >> 8 & 0xFF;
            int blue = color & 0xFF;
            int alpha = (int)((float)(color >>> 24) * rawColor[3]);
            Matrix4f matrix4f = poseStack.m_85850_().m_85861_();
            RenderSystem.m_69472_();
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.m_157427_(GameRenderer::m_172811_);
            BufferBuilder bufferBuilder = Tesselator.m_85913_().m_85915_();
            bufferBuilder.m_166779_(VertexFormat.Mode.TRIANGLE_FAN, DefaultVertexFormat.f_85815_);
            boolean bl = flag = Mth.m_14031_((float)level.m_46490_(partialTick)) < 0.0f;
            if (flag) {
                bufferBuilder.m_85982_(matrix4f, 100.0f, 0.0f, 0.0f).m_6122_(red, green, blue, alpha).m_5752_();
            } else {
                bufferBuilder.m_85982_(matrix4f, -100.0f, 0.0f, 0.0f).m_6122_(red, green, blue, alpha).m_5752_();
            }
            for (int i = 0; i <= 16; ++i) {
                float deg = (float)i * ((float)Math.PI * 2) / 16.0f;
                float sin = Mth.m_14031_((float)deg);
                float cos = Mth.m_14089_((float)deg);
                if (flag) {
                    bufferBuilder.m_85982_(matrix4f, cos * 120.0f, cos * 40.0f * rawColor[3], -sin * 120.0f).m_6122_(red, green, blue, 0).m_5752_();
                    continue;
                }
                bufferBuilder.m_85982_(matrix4f, -cos * 120.0f, cos * 40.0f * rawColor[3], sin * 120.0f).m_6122_(red, green, blue, 0).m_5752_();
            }
            BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)bufferBuilder.m_231175_());
        }
    }

    public static void renderTexture(float size, float yaw, float pitch, float roll, int color, boolean constant) {
        float r = size / 2.0f;
        float alpha = (float)(color >>> 24) / 255.0f;
        if (!constant) {
            alpha *= 1.0f - Minecraft.m_91087_().f_91073_.m_46722_(partialTick);
        }
        poseStack.m_85836_();
        poseStack.m_85845_(Vector3f.f_122224_.m_122240_(yaw));
        poseStack.m_85845_(Vector3f.f_122223_.m_122240_(pitch));
        poseStack.m_85845_(Vector3f.f_122226_.m_122240_(roll));
        Matrix4f matrix4f = poseStack.m_85850_().m_85861_();
        RenderSystem.m_69493_();
        RenderSystem.m_157429_((float)((float)(color >> 16 & 0xFF) / 255.0f), (float)((float)(color >> 8 & 0xFF) / 255.0f), (float)((float)(color & 0xFF) / 255.0f), (float)alpha);
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        BufferBuilder bufferBuilder = Tesselator.m_85913_().m_85915_();
        bufferBuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
        bufferBuilder.m_85982_(matrix4f, r, r, 100.0f).m_7421_(0.0f, 0.0f).m_5752_();
        bufferBuilder.m_85982_(matrix4f, r, -r, 100.0f).m_7421_(0.0f, 1.0f).m_5752_();
        bufferBuilder.m_85982_(matrix4f, -r, -r, 100.0f).m_7421_(1.0f, 1.0f).m_5752_();
        bufferBuilder.m_85982_(matrix4f, -r, r, 100.0f).m_7421_(1.0f, 0.0f).m_5752_();
        BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)bufferBuilder.m_231175_());
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        poseStack.m_85849_();
    }

    @SubscribeEvent
    public static void skySetup(FMLClientSetupEvent event) {
        try {
            Field field = DimensionSpecialEffectsManager.class.getDeclaredField("EFFECTS");
            field.setAccessible(true);
            for (DimensionSpecialEffects dimensionSpecialEffects : ((ImmutableMap)field.get(null)).values()) {
                Class<?> effects = dimensionSpecialEffects.getClass();
                ((Set)effects.getField("CUSTOM_SKY").get(null)).add(PREDICATE);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void execute() {
        RenderTest9SkyProcedure.execute(null);
    }

    private static void execute(@Nullable Event event) {
        boolean entity_found = false;
        boolean disabled = false;
        double i = 0.0;
        double j = 0.0;
        double k = 0.0;
        double l = 0.0;
        double spheresize = 0.0;
        double col_r = 0.0;
        double col_g = 0.0;
        double col_b = 0.0;
        double negx = 0.0;
        double posx = 0.0;
        double negz = 0.0;
        double posz = 0.0;
        double stretch1 = 0.0;
        double stretch2 = 0.0;
        double pitch_variance = 0.0;
        double distance_scaling_factor = 0.0;
        double yaw_variance = 0.0;
        double convert_yaw = 0.0;
        double ringspan = 0.0;
        double raytrace_distance = 0.0;
        double newpositionz = 0.0;
        double newpositiony = 0.0;
        double ringspin = 0.0;
        double newpositionx = 0.0;
        double pitch_distance_variance = 0.0;
        double distance = 0.0;
        double yaw_distance_variance = 0.0;
        double expand = 0.0;
        double y_offset = 0.0;
        double xfind = 0.0;
        double yfind = 0.0;
        double zfind = 0.0;
        double opacity = 0.0;
        double expandsearch = 0.0;
        double distance_level = 0.0;
        double save_alpha = 0.0;
    }
}

