/*
 * Decompiled with CFR 0.152.
 */
package net.arphex.item;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import net.arphex.client.model.Modelinfernal;
import net.arphex.init.ArphexModTabs;
import net.arphex.procedures.InfernalBootsTickEventProcedure;
import net.arphex.procedures.InfernalChestplateTickEventProcedure;
import net.arphex.procedures.InfernalHelmetTickEventProcedure;
import net.arphex.procedures.InfernalLeggingsTickEventProcedure;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import net.minecraftforge.registries.ForgeRegistries;

public abstract class InfernalItem
extends ArmorItem {
    public InfernalItem(EquipmentSlot slot, Item.Properties properties) {
        super(new ArmorMaterial(){

            public int m_7366_(EquipmentSlot slot) {
                return (new int[]{13, 15, 16, 11})[slot.m_20749_()] * 1024;
            }

            public int m_7365_(EquipmentSlot slot) {
                return (new int[]{5, 10, 13, 5})[slot.m_20749_()];
            }

            public int m_6646_() {
                return 50;
            }

            public SoundEvent m_7344_() {
                return (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("item.armor.equip_netherite"));
            }

            public Ingredient m_6230_() {
                return Ingredient.m_151265_();
            }

            public String m_6082_() {
                return "infernal";
            }

            public float m_6651_() {
                return 6.0f;
            }

            public float m_6649_() {
                return 0.3f;
            }
        }, slot, properties);
    }

    public static class Boots
    extends InfernalItem {
        public Boots() {
            super(EquipmentSlot.FEET, new Item.Properties().m_41491_(ArphexModTabs.TAB_AR_PH_EX).m_41486_());
        }

        public void initializeClient(Consumer<IClientItemExtensions> consumer) {
            consumer.accept(new IClientItemExtensions(){

                @OnlyIn(value=Dist.CLIENT)
                public HumanoidModel getHumanoidArmorModel(LivingEntity living, ItemStack stack, EquipmentSlot slot, HumanoidModel defaultModel) {
                    HumanoidModel armorModel = new HumanoidModel(new ModelPart(Collections.emptyList(), Map.of("left_leg", new Modelinfernal<T>((ModelPart)Minecraft.m_91087_().m_167973_().m_171103_((ModelLayerLocation)Modelinfernal.LAYER_LOCATION)).LeftBoot, "right_leg", new Modelinfernal<T>((ModelPart)Minecraft.m_91087_().m_167973_().m_171103_((ModelLayerLocation)Modelinfernal.LAYER_LOCATION)).RightBoot, "head", new ModelPart(Collections.emptyList(), Collections.emptyMap()), "hat", new ModelPart(Collections.emptyList(), Collections.emptyMap()), "body", new ModelPart(Collections.emptyList(), Collections.emptyMap()), "right_arm", new ModelPart(Collections.emptyList(), Collections.emptyMap()), "left_arm", new ModelPart(Collections.emptyList(), Collections.emptyMap()))));
                    armorModel.f_102817_ = living.m_6144_();
                    armorModel.f_102609_ = defaultModel.f_102609_;
                    armorModel.f_102610_ = living.m_6162_();
                    return armorModel;
                }
            });
        }

        public void m_7373_(ItemStack itemstack, Level level, List<Component> list, TooltipFlag flag) {
            super.m_7373_(itemstack, level, list, flag);
            list.add((Component)Component.m_237113_((String)"\u00a74Infernal boots capable of withstanding the depths of hell, providing slow falling while crouching, plus total immunity to fall damage"));
            list.add((Component)Component.m_237113_((String)"Set bonuses: The more armor pieces, the more fire resistance and knockback/damage dealt to attackers, complete immunity to weak attacks"));
            list.add((Component)Component.m_237113_((String)"\u00a77Created by smithing netherite boots with an infernal ingot"));
            list.add((Component)Component.m_237113_((String)"\u00a77Enchantable"));
        }

        public String getArmorTexture(ItemStack stack, Entity entity, EquipmentSlot slot, String type) {
            return "arphex:textures/entities/infernalarmor.png";
        }

        public boolean makesPiglinsNeutral(ItemStack itemstack, LivingEntity entity) {
            return true;
        }

        public void onArmorTick(ItemStack itemstack, Level world, Player entity) {
            InfernalBootsTickEventProcedure.execute((Entity)entity, itemstack);
        }
    }

    public static class Leggings
    extends InfernalItem {
        public Leggings() {
            super(EquipmentSlot.LEGS, new Item.Properties().m_41491_(ArphexModTabs.TAB_AR_PH_EX).m_41486_());
        }

        public void initializeClient(Consumer<IClientItemExtensions> consumer) {
            consumer.accept(new IClientItemExtensions(){

                @OnlyIn(value=Dist.CLIENT)
                public HumanoidModel getHumanoidArmorModel(LivingEntity living, ItemStack stack, EquipmentSlot slot, HumanoidModel defaultModel) {
                    HumanoidModel armorModel = new HumanoidModel(new ModelPart(Collections.emptyList(), Map.of("left_leg", new Modelinfernal<T>((ModelPart)Minecraft.m_91087_().m_167973_().m_171103_((ModelLayerLocation)Modelinfernal.LAYER_LOCATION)).LeftLegging, "right_leg", new Modelinfernal<T>((ModelPart)Minecraft.m_91087_().m_167973_().m_171103_((ModelLayerLocation)Modelinfernal.LAYER_LOCATION)).RightLegging, "head", new ModelPart(Collections.emptyList(), Collections.emptyMap()), "hat", new ModelPart(Collections.emptyList(), Collections.emptyMap()), "body", new ModelPart(Collections.emptyList(), Collections.emptyMap()), "right_arm", new ModelPart(Collections.emptyList(), Collections.emptyMap()), "left_arm", new ModelPart(Collections.emptyList(), Collections.emptyMap()))));
                    armorModel.f_102817_ = living.m_6144_();
                    armorModel.f_102609_ = defaultModel.f_102609_;
                    armorModel.f_102610_ = living.m_6162_();
                    return armorModel;
                }
            });
        }

        public void m_7373_(ItemStack itemstack, Level level, List<Component> list, TooltipFlag flag) {
            super.m_7373_(itemstack, level, list, flag);
            list.add((Component)Component.m_237113_((String)"\u00a74Infernal leggings capable of withstanding the depths of hell, providing speed boosts "));
            list.add((Component)Component.m_237113_((String)"Set bonuses: The more armor pieces, the more fire resistance and knockback/damage dealt to attackers, complete immunity to weak attacks"));
            list.add((Component)Component.m_237113_((String)"\u00a77Created by smithing netherite leggings with an infernal ingot"));
            list.add((Component)Component.m_237113_((String)"\u00a77Enchantable"));
        }

        public String getArmorTexture(ItemStack stack, Entity entity, EquipmentSlot slot, String type) {
            return "arphex:textures/entities/infernalarmor.png";
        }

        public boolean makesPiglinsNeutral(ItemStack itemstack, LivingEntity entity) {
            return true;
        }

        public void onArmorTick(ItemStack itemstack, Level world, Player entity) {
            InfernalLeggingsTickEventProcedure.execute((Entity)entity, itemstack);
        }
    }

    public static class Chestplate
    extends InfernalItem {
        public Chestplate() {
            super(EquipmentSlot.CHEST, new Item.Properties().m_41491_(ArphexModTabs.TAB_AR_PH_EX).m_41486_());
        }

        public void initializeClient(Consumer<IClientItemExtensions> consumer) {
            consumer.accept(new IClientItemExtensions(){

                @OnlyIn(value=Dist.CLIENT)
                public HumanoidModel getHumanoidArmorModel(LivingEntity living, ItemStack stack, EquipmentSlot slot, HumanoidModel defaultModel) {
                    HumanoidModel armorModel = new HumanoidModel(new ModelPart(Collections.emptyList(), Map.of("body", new Modelinfernal<T>((ModelPart)Minecraft.m_91087_().m_167973_().m_171103_((ModelLayerLocation)Modelinfernal.LAYER_LOCATION)).Chestplate, "left_arm", new Modelinfernal<T>((ModelPart)Minecraft.m_91087_().m_167973_().m_171103_((ModelLayerLocation)Modelinfernal.LAYER_LOCATION)).LeftPlate, "right_arm", new Modelinfernal<T>((ModelPart)Minecraft.m_91087_().m_167973_().m_171103_((ModelLayerLocation)Modelinfernal.LAYER_LOCATION)).RightPlate, "head", new ModelPart(Collections.emptyList(), Collections.emptyMap()), "hat", new ModelPart(Collections.emptyList(), Collections.emptyMap()), "right_leg", new ModelPart(Collections.emptyList(), Collections.emptyMap()), "left_leg", new ModelPart(Collections.emptyList(), Collections.emptyMap()))));
                    armorModel.f_102817_ = living.m_6144_();
                    armorModel.f_102609_ = defaultModel.f_102609_;
                    armorModel.f_102610_ = living.m_6162_();
                    return armorModel;
                }
            });
        }

        public void m_7373_(ItemStack itemstack, Level level, List<Component> list, TooltipFlag flag) {
            super.m_7373_(itemstack, level, list, flag);
            list.add((Component)Component.m_237113_((String)"\u00a74Infernal chestplate capable of withstanding the depths of hell, providing strength and unlimited respiration in any liquid"));
            list.add((Component)Component.m_237113_((String)"Set bonuses: The more armor pieces, the more fire resistance and knockback/damage dealt to attackers, complete immunity to weak attacks"));
            list.add((Component)Component.m_237113_((String)"\u00a77Created by smithing a netherite chestplate with an infernal ingot"));
            list.add((Component)Component.m_237113_((String)"\u00a77Enchantable"));
        }

        public String getArmorTexture(ItemStack stack, Entity entity, EquipmentSlot slot, String type) {
            return "arphex:textures/entities/infernalarmor.png";
        }

        public boolean makesPiglinsNeutral(ItemStack itemstack, LivingEntity entity) {
            return true;
        }

        public void onArmorTick(ItemStack itemstack, Level world, Player entity) {
            InfernalChestplateTickEventProcedure.execute((Entity)entity, itemstack);
        }
    }

    public static class Helmet
    extends InfernalItem {
        public Helmet() {
            super(EquipmentSlot.HEAD, new Item.Properties().m_41491_(ArphexModTabs.TAB_AR_PH_EX).m_41486_());
        }

        public void initializeClient(Consumer<IClientItemExtensions> consumer) {
            consumer.accept(new IClientItemExtensions(){

                public HumanoidModel getHumanoidArmorModel(LivingEntity living, ItemStack stack, EquipmentSlot slot, HumanoidModel defaultModel) {
                    HumanoidModel armorModel = new HumanoidModel(new ModelPart(Collections.emptyList(), Map.of("head", new Modelinfernal<T>((ModelPart)Minecraft.m_91087_().m_167973_().m_171103_((ModelLayerLocation)Modelinfernal.LAYER_LOCATION)).Helmet, "hat", new ModelPart(Collections.emptyList(), Collections.emptyMap()), "body", new ModelPart(Collections.emptyList(), Collections.emptyMap()), "right_arm", new ModelPart(Collections.emptyList(), Collections.emptyMap()), "left_arm", new ModelPart(Collections.emptyList(), Collections.emptyMap()), "right_leg", new ModelPart(Collections.emptyList(), Collections.emptyMap()), "left_leg", new ModelPart(Collections.emptyList(), Collections.emptyMap()))));
                    armorModel.f_102817_ = living.m_6144_();
                    armorModel.f_102609_ = defaultModel.f_102609_;
                    armorModel.f_102610_ = living.m_6162_();
                    return armorModel;
                }
            });
        }

        public void m_7373_(ItemStack itemstack, Level level, List<Component> list, TooltipFlag flag) {
            super.m_7373_(itemstack, level, list, flag);
            list.add((Component)Component.m_237113_((String)"\u00a74Infernal helmet capable of withstanding the depths of hell - provides immunity to weakness and slowness "));
            list.add((Component)Component.m_237113_((String)"Set bonuses: The more armor pieces, the more fire resistance and knockback/damage dealt to attackers, complete immunity to weak attacks"));
            list.add((Component)Component.m_237113_((String)"\u00a77Created by smithing a netherite helmet with an infernal ingot"));
            list.add((Component)Component.m_237113_((String)"\u00a77Enchantable"));
        }

        public String getArmorTexture(ItemStack stack, Entity entity, EquipmentSlot slot, String type) {
            return "arphex:textures/entities/infernalarmor.png";
        }

        public boolean makesPiglinsNeutral(ItemStack itemstack, LivingEntity entity) {
            return true;
        }

        public void onArmorTick(ItemStack itemstack, Level world, Player entity) {
            InfernalHelmetTickEventProcedure.execute((Entity)entity, itemstack);
        }
    }
}

