/*
 * Decompiled with CFR 0.152.
 */
package net.arphex.item;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import net.arphex.client.model.Modelimmortal;
import net.arphex.init.ArphexModTabs;
import net.arphex.procedures.ImmortalBootsTickProcedure;
import net.arphex.procedures.ImmortalChestplateTickProcedure;
import net.arphex.procedures.ImmortalHelmetTickProcedure;
import net.arphex.procedures.ImmortalLeggingsTickProcedure;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import net.minecraftforge.registries.ForgeRegistries;

public abstract class ImmortalItem
extends ArmorItem {
    public ImmortalItem(EquipmentSlot slot, Item.Properties properties) {
        super(new ArmorMaterial(){

            public int m_7366_(EquipmentSlot slot) {
                return (new int[]{13, 15, 16, 11})[slot.m_20749_()] * 1024;
            }

            public int m_7365_(EquipmentSlot slot) {
                return (new int[]{10, 16, 20, 10})[slot.m_20749_()];
            }

            public int m_6646_() {
                return 100;
            }

            public SoundEvent m_7344_() {
                return (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("item.armor.equip_netherite"));
            }

            public Ingredient m_6230_() {
                return Ingredient.m_151265_();
            }

            public String m_6082_() {
                return "immortal";
            }

            public float m_6651_() {
                return 6.0f;
            }

            public float m_6649_() {
                return 0.9f;
            }
        }, slot, properties);
    }

    public static class Boots
    extends ImmortalItem {
        public Boots() {
            super(EquipmentSlot.FEET, new Item.Properties().m_41491_(ArphexModTabs.TAB_AR_PH_EX).m_41486_());
        }

        public void initializeClient(Consumer<IClientItemExtensions> consumer) {
            consumer.accept(new IClientItemExtensions(){

                @OnlyIn(value=Dist.CLIENT)
                public HumanoidModel getHumanoidArmorModel(LivingEntity living, ItemStack stack, EquipmentSlot slot, HumanoidModel defaultModel) {
                    HumanoidModel armorModel = new HumanoidModel(new ModelPart(Collections.emptyList(), Map.of("left_leg", new Modelimmortal<T>((ModelPart)Minecraft.m_91087_().m_167973_().m_171103_((ModelLayerLocation)Modelimmortal.LAYER_LOCATION)).LeftBoot, "right_leg", new Modelimmortal<T>((ModelPart)Minecraft.m_91087_().m_167973_().m_171103_((ModelLayerLocation)Modelimmortal.LAYER_LOCATION)).RightBoot, "head", new ModelPart(Collections.emptyList(), Collections.emptyMap()), "hat", new ModelPart(Collections.emptyList(), Collections.emptyMap()), "body", new ModelPart(Collections.emptyList(), Collections.emptyMap()), "right_arm", new ModelPart(Collections.emptyList(), Collections.emptyMap()), "left_arm", new ModelPart(Collections.emptyList(), Collections.emptyMap()))));
                    armorModel.f_102817_ = living.m_6144_();
                    armorModel.f_102609_ = defaultModel.f_102609_;
                    armorModel.f_102610_ = living.m_6162_();
                    return armorModel;
                }
            });
        }

        public void m_7373_(ItemStack itemstack, Level level, List<Component> list, TooltipFlag flag) {
            super.m_7373_(itemstack, level, list, flag);
            list.add((Component)Component.m_237113_((String)"\u00a7eOmnipotent boots providing an powerful \"immortal impact\" ability, increasing downwards acceleration as you crouch while midair for a devastating explosive landing, plus combined abilities of the Eternal, Spacetime, and Juggernaut boots "));
            list.add((Component)Component.m_237113_((String)"Set bonuses: Other three armour set bonuses, plus Immortal Image power usable every 10 minutes (default keybind is C, doubles all your output damage), and total immunity to moderately weak attacks"));
            list.add((Component)Component.m_237113_((String)"\u00a77Enchantable"));
        }

        public String getArmorTexture(ItemStack stack, Entity entity, EquipmentSlot slot, String type) {
            LivingEntity living;
            if (entity instanceof LivingEntity && (living = (LivingEntity)entity).m_21023_(MobEffects.f_19609_)) {
                return "arphex:textures/entities/blank.png";
            }
            return "arphex:textures/entities/immortalarmour.png";
        }

        public boolean makesPiglinsNeutral(ItemStack itemstack, LivingEntity entity) {
            return true;
        }

        public void onArmorTick(ItemStack itemstack, Level world, Player entity) {
            ImmortalBootsTickProcedure.execute((LevelAccessor)world, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), (Entity)entity, itemstack);
        }
    }

    public static class Leggings
    extends ImmortalItem {
        public Leggings() {
            super(EquipmentSlot.LEGS, new Item.Properties().m_41491_(ArphexModTabs.TAB_AR_PH_EX).m_41486_());
        }

        public void initializeClient(Consumer<IClientItemExtensions> consumer) {
            consumer.accept(new IClientItemExtensions(){

                @OnlyIn(value=Dist.CLIENT)
                public HumanoidModel getHumanoidArmorModel(LivingEntity living, ItemStack stack, EquipmentSlot slot, HumanoidModel defaultModel) {
                    HumanoidModel armorModel = new HumanoidModel(new ModelPart(Collections.emptyList(), Map.of("left_leg", new Modelimmortal<T>((ModelPart)Minecraft.m_91087_().m_167973_().m_171103_((ModelLayerLocation)Modelimmortal.LAYER_LOCATION)).LeftLegging, "right_leg", new Modelimmortal<T>((ModelPart)Minecraft.m_91087_().m_167973_().m_171103_((ModelLayerLocation)Modelimmortal.LAYER_LOCATION)).RightLegging, "head", new ModelPart(Collections.emptyList(), Collections.emptyMap()), "hat", new ModelPart(Collections.emptyList(), Collections.emptyMap()), "body", new ModelPart(Collections.emptyList(), Collections.emptyMap()), "right_arm", new ModelPart(Collections.emptyList(), Collections.emptyMap()), "left_arm", new ModelPart(Collections.emptyList(), Collections.emptyMap()))));
                    armorModel.f_102817_ = living.m_6144_();
                    armorModel.f_102609_ = defaultModel.f_102609_;
                    armorModel.f_102610_ = living.m_6162_();
                    return armorModel;
                }
            });
        }

        public void m_7373_(ItemStack itemstack, Level level, List<Component> list, TooltipFlag flag) {
            super.m_7373_(itemstack, level, list, flag);
            list.add((Component)Component.m_237113_((String)"\u00a7eOmnipotent leggings providing an extreme speed boost on crouch, and combined abilities of the Eternal, Spacetime, and Juggernaut leggings"));
            list.add((Component)Component.m_237113_((String)"Set bonuses: Other three armour set bonuses, plus Immortal Image power usable every 10 minutes (default keybind is C, doubles all your output damage), and total immunity to moderately weak attacks"));
            list.add((Component)Component.m_237113_((String)"\u00a77Enchantable"));
        }

        public String getArmorTexture(ItemStack stack, Entity entity, EquipmentSlot slot, String type) {
            LivingEntity living;
            if (entity instanceof LivingEntity && (living = (LivingEntity)entity).m_21023_(MobEffects.f_19609_)) {
                return "arphex:textures/entities/blank.png";
            }
            return "arphex:textures/entities/immortalarmour.png";
        }

        public boolean makesPiglinsNeutral(ItemStack itemstack, LivingEntity entity) {
            return true;
        }

        public void onArmorTick(ItemStack itemstack, Level world, Player entity) {
            ImmortalLeggingsTickProcedure.execute((LevelAccessor)world, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), (Entity)entity, itemstack);
        }
    }

    public static class Chestplate
    extends ImmortalItem {
        public Chestplate() {
            super(EquipmentSlot.CHEST, new Item.Properties().m_41491_(ArphexModTabs.TAB_AR_PH_EX).m_41486_());
        }

        public void initializeClient(Consumer<IClientItemExtensions> consumer) {
            consumer.accept(new IClientItemExtensions(){

                @OnlyIn(value=Dist.CLIENT)
                public HumanoidModel getHumanoidArmorModel(LivingEntity living, ItemStack stack, EquipmentSlot slot, HumanoidModel defaultModel) {
                    HumanoidModel armorModel = new HumanoidModel(new ModelPart(Collections.emptyList(), Map.of("body", new Modelimmortal<T>((ModelPart)Minecraft.m_91087_().m_167973_().m_171103_((ModelLayerLocation)Modelimmortal.LAYER_LOCATION)).Chestplate, "left_arm", new Modelimmortal<T>((ModelPart)Minecraft.m_91087_().m_167973_().m_171103_((ModelLayerLocation)Modelimmortal.LAYER_LOCATION)).LeftPlate, "right_arm", new Modelimmortal<T>((ModelPart)Minecraft.m_91087_().m_167973_().m_171103_((ModelLayerLocation)Modelimmortal.LAYER_LOCATION)).RightPlate, "head", new ModelPart(Collections.emptyList(), Collections.emptyMap()), "hat", new ModelPart(Collections.emptyList(), Collections.emptyMap()), "right_leg", new ModelPart(Collections.emptyList(), Collections.emptyMap()), "left_leg", new ModelPart(Collections.emptyList(), Collections.emptyMap()))));
                    armorModel.f_102817_ = living.m_6144_();
                    armorModel.f_102609_ = defaultModel.f_102609_;
                    armorModel.f_102610_ = living.m_6162_();
                    return armorModel;
                }
            });
        }

        public void m_7373_(ItemStack itemstack, Level level, List<Component> list, TooltipFlag flag) {
            super.m_7373_(itemstack, level, list, flag);
            list.add((Component)Component.m_237113_((String)"\u00a7eOmnipotent chestplate providing resistance 2 and virtually all combined abilities of the Eternal, Spacetime, and Juggernaut chestplates"));
            list.add((Component)Component.m_237113_((String)"Set bonuses: Other three armour set bonuses, plus Immortal Image power usable every 10 minutes (default keybind is C, doubles all your output damage), and total immunity to moderately weak attacks"));
            list.add((Component)Component.m_237113_((String)"\u00a77Enchantable"));
        }

        public String getArmorTexture(ItemStack stack, Entity entity, EquipmentSlot slot, String type) {
            LivingEntity living;
            if (entity instanceof LivingEntity && (living = (LivingEntity)entity).m_21023_(MobEffects.f_19609_)) {
                return "arphex:textures/entities/blank.png";
            }
            return "arphex:textures/entities/immortalarmour.png";
        }

        public boolean makesPiglinsNeutral(ItemStack itemstack, LivingEntity entity) {
            return true;
        }

        public void onArmorTick(ItemStack itemstack, Level world, Player entity) {
            ImmortalChestplateTickProcedure.execute((LevelAccessor)world, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), (Entity)entity, itemstack);
        }
    }

    public static class Helmet
    extends ImmortalItem {
        public Helmet() {
            super(EquipmentSlot.HEAD, new Item.Properties().m_41491_(ArphexModTabs.TAB_AR_PH_EX).m_41486_());
        }

        public void initializeClient(Consumer<IClientItemExtensions> consumer) {
            consumer.accept(new IClientItemExtensions(){

                public HumanoidModel getHumanoidArmorModel(LivingEntity living, ItemStack stack, EquipmentSlot slot, HumanoidModel defaultModel) {
                    HumanoidModel armorModel = new HumanoidModel(new ModelPart(Collections.emptyList(), Map.of("head", new Modelimmortal<T>((ModelPart)Minecraft.m_91087_().m_167973_().m_171103_((ModelLayerLocation)Modelimmortal.LAYER_LOCATION)).Helmet, "hat", new ModelPart(Collections.emptyList(), Collections.emptyMap()), "body", new ModelPart(Collections.emptyList(), Collections.emptyMap()), "right_arm", new ModelPart(Collections.emptyList(), Collections.emptyMap()), "left_arm", new ModelPart(Collections.emptyList(), Collections.emptyMap()), "right_leg", new ModelPart(Collections.emptyList(), Collections.emptyMap()), "left_leg", new ModelPart(Collections.emptyList(), Collections.emptyMap()))));
                    armorModel.f_102817_ = living.m_6144_();
                    armorModel.f_102609_ = defaultModel.f_102609_;
                    armorModel.f_102610_ = living.m_6162_();
                    return armorModel;
                }
            });
        }

        public void m_7373_(ItemStack itemstack, Level level, List<Component> list, TooltipFlag flag) {
            super.m_7373_(itemstack, level, list, flag);
            list.add((Component)Component.m_237113_((String)"\u00a7eOmnipotent helmet providing total immunity to tormenting and combining virtually all abilities of the Eternal, Spacetime, and Juggernaut helmets "));
            list.add((Component)Component.m_237113_((String)"Set bonuses: Other three armour set bonuses, plus Immortal Image power usable every 10 minutes (default keybind is C, doubles all your output damage), and total immunity to moderately weak attacks"));
            list.add((Component)Component.m_237113_((String)"\u00a77Enchantable"));
        }

        public String getArmorTexture(ItemStack stack, Entity entity, EquipmentSlot slot, String type) {
            LivingEntity living;
            if (entity instanceof LivingEntity && (living = (LivingEntity)entity).m_21023_(MobEffects.f_19609_)) {
                return "arphex:textures/entities/blank.png";
            }
            return "arphex:textures/entities/immortalarmour.png";
        }

        public boolean makesPiglinsNeutral(ItemStack itemstack, LivingEntity entity) {
            return true;
        }

        public void onArmorTick(ItemStack itemstack, Level world, Player entity) {
            ImmortalHelmetTickProcedure.execute((LevelAccessor)world, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), (Entity)entity, itemstack);
        }
    }
}

